/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.workspace;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.sina.weibo.agent.core.PluginContext;
import com.sina.weibo.agent.core.ServiceProxyRegistry;
import com.sina.weibo.agent.core.WorkspaceManager;
import com.sina.weibo.agent.events.FileChangeType;
import com.sina.weibo.agent.events.ProjectEventBus;
import com.sina.weibo.agent.events.WorkspaceDirectoriesChangeEvent;
import com.sina.weibo.agent.events.WorkspaceDirectoryChangeEvent;
import com.sina.weibo.agent.events.WorkspaceFileChangeData;
import com.sina.weibo.agent.events.WorkspaceFileChangeEvent;
import com.sina.weibo.agent.events.WorkspaceFilesChangeData;
import com.sina.weibo.agent.events.WorkspaceFilesChangeEvent;
import com.sina.weibo.agent.events.WorkspaceRootChangeData;
import com.sina.weibo.agent.events.WorkspaceRootChangeEvent;
import com.sina.weibo.agent.ipc.proxy.IRPCProtocol;
import com.sina.weibo.agent.ipc.proxy.interfaces.ExtHostFileSystemEventServiceProxy;
import com.sina.weibo.agent.ipc.proxy.interfaces.ExtHostWorkspaceProxy;
import com.sina.weibo.agent.ipc.proxy.interfaces.FileSystemEvents;
import com.sina.weibo.agent.model.WorkspaceData;
import com.sina.weibo.agent.workspace.WorkspaceFileChangeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000i\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002*\u0001\u0012\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001e\u0010\u001a\u001a\u00020\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020 H\u0002J\u001e\u0010#\u001a\u00020\u00152\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0\u001c2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001e\u0010%\u001a\u00020\u00152\f\u0010&\u001a\b\u0012\u0004\u0012\u00020 0\u001c2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001e\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010)0(2\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u0010,\u001a\u00020-2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010.\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006/"}, d2={"Lcom/sina/weibo/agent/workspace/WorkspaceFileChangeManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "vfsConnections", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/util/messages/MessageBusConnection;", "projectWorkspacePaths", "", "projectConnection", "projectListener", "com/sina/weibo/agent/workspace/WorkspaceFileChangeManager$projectListener$1", "Lcom/sina/weibo/agent/workspace/WorkspaceFileChangeManager$projectListener$1;", "triggerWorkspaceRootChangeEvent", "", "oldPath", "newPath", "registerFileListener", "unregisterFileListener", "processBulkFileEvents", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "triggerFileChangeEvent", "fileChangeData", "Lcom/sina/weibo/agent/events/WorkspaceFileChangeData;", "triggerDirectoryChangeEvent", "directoryChangeData", "triggerBulkFileChangeEvent", "fileChanges", "triggerBulkDirectoryChangeEvent", "directoryChanges", "fileToUriComponents", "", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isRelevantFileSystemItem", "", "dispose", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nWorkspaceFileChangeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceFileChangeManager.kt\ncom/sina/weibo/agent/workspace/WorkspaceFileChangeManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,382:1\n1#2:383\n1869#3,2:384\n1869#3,2:386\n1869#3,2:388\n216#4,2:390\n*S KotlinDebug\n*F\n+ 1 WorkspaceFileChangeManager.kt\ncom/sina/weibo/agent/workspace/WorkspaceFileChangeManager\n*L\n168#1:384,2\n253#1:386,2\n294#1:388,2\n365#1:390,2\n*E\n"})
public final class WorkspaceFileChangeManager
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConcurrentHashMap<Project, MessageBusConnection> vfsConnections;
    @NotNull
    private final ConcurrentHashMap<Project, String> projectWorkspacePaths;
    @Nullable
    private MessageBusConnection projectConnection;
    @NotNull
    private final projectListener.1 projectListener;

    public WorkspaceFileChangeManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Logger logger = Logger.getInstance(WorkspaceFileChangeManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.vfsConnections = new ConcurrentHashMap();
        this.projectWorkspacePaths = new ConcurrentHashMap();
        this.projectListener = new ProjectManagerListener(this){
            final /* synthetic */ WorkspaceFileChangeManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void projectOpened(Project project) {
                String string;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                WorkspaceFileChangeManager.access$registerFileListener(this.this$0, project);
                String string2 = project.getBasePath();
                if (string2 != null) {
                    String string3 = string2;
                    WorkspaceFileChangeManager workspaceFileChangeManager = this.this$0;
                    String it = string3;
                    boolean bl = false;
                    ((Map)WorkspaceFileChangeManager.access$getProjectWorkspacePaths$p(workspaceFileChangeManager)).put(project, it);
                }
                if ((string = project.getBasePath()) == null) {
                    string = "";
                }
                WorkspaceFileChangeManager.access$triggerWorkspaceRootChangeEvent(this.this$0, project, null, string);
            }

            public void projectClosed(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                WorkspaceFileChangeManager.access$unregisterFileListener(this.this$0, project);
                WorkspaceFileChangeManager.access$getProjectWorkspacePaths$p(this.this$0).remove(project);
            }
        };
        this.logger.info("Initialize workspace file change manager");
        MessageBusConnection messageBusConnection = this.projectConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        if (messageBusConnection != null) {
            Topic topic = ProjectManager.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)this.projectListener);
        }
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        for (Project project2 : projectArray) {
            String it;
            Intrinsics.checkNotNull((Object)project2);
            Project project3 = project2;
            this.registerFileListener(project3);
            if (project3.getBasePath() == null) continue;
            boolean bl = false;
            ((Map)this.projectWorkspacePaths).put(project3, it);
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final void triggerWorkspaceRootChangeEvent(Project project, String oldPath, String newPath) {
        block1: {
            this.logger.debug("Trigger workspace root change event: " + project.getName() + ", old path: " + oldPath + ", new path: " + newPath);
            WorkspaceRootChangeData workspaceChangeData = new WorkspaceRootChangeData(project, oldPath, newPath);
            ((ProjectEventBus)project.getService(ProjectEventBus.class)).emitInApplication(WorkspaceRootChangeEvent.INSTANCE, workspaceChangeData);
            IRPCProtocol iRPCProtocol = PluginContext.Companion.getInstance(project).getRPCProtocol();
            ExtHostWorkspaceProxy extHostWorkspace = iRPCProtocol != null ? iRPCProtocol.getProxy(ServiceProxyRegistry.ExtHostContext.INSTANCE.getExtHostWorkspace()) : null;
            WorkspaceData workspaceData = ((WorkspaceManager)project.getService(WorkspaceManager.class)).getProjectWorkspaceData(project);
            ExtHostWorkspaceProxy extHostWorkspaceProxy = extHostWorkspace;
            if (extHostWorkspaceProxy == null) break block1;
            ExtHostWorkspaceProxy it = extHostWorkspaceProxy;
            boolean bl = false;
            if (workspaceData != null) {
                this.logger.debug("Send workspace root change to extension process: " + workspaceData.getName() + ", folders: " + workspaceData.getFolders().size());
                it.acceptWorkspaceData(workspaceData);
            }
        }
    }

    private final void registerFileListener(Project project) {
        if (this.vfsConnections.containsKey(project)) {
            this.logger.info("File listener for project " + project.getName() + " already exists, skip registration");
            return;
        }
        this.logger.info("Register file listener for project " + project.getName());
        try {
            MessageBusConnection connection = project.getMessageBus().connect();
            Topic topic = VirtualFileManager.VFS_CHANGES;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
            connection.subscribe(topic, (Object)new BulkFileListener(this, project){
                final /* synthetic */ WorkspaceFileChangeManager this$0;
                final /* synthetic */ Project $project;
                {
                    this.this$0 = $receiver;
                    this.$project = $project;
                }

                public void after(List<? extends VFileEvent> events) {
                    Intrinsics.checkNotNullParameter(events, (String)"events");
                    WorkspaceFileChangeManager.access$processBulkFileEvents(this.this$0, events, this.$project);
                }
            });
            ((Map)this.vfsConnections).put(project, connection);
        }
        catch (Exception e) {
            this.logger.error("Failed to register file listener for project " + project.getName(), (Throwable)e);
        }
    }

    private final void unregisterFileListener(Project project) {
        MessageBusConnection connection = this.vfsConnections.remove(project);
        if (connection != null) {
            this.logger.info("Unregister file listener for project " + project.getName());
            try {
                connection.disconnect();
            }
            catch (Exception e) {
                this.logger.error("Failed to unregister file listener for project " + project.getName(), (Throwable)e);
            }
        }
    }

    private final void processBulkFileEvents(List<? extends VFileEvent> events, Project project) {
        if (events.isEmpty()) {
            return;
        }
        List fileChanges = new ArrayList();
        List directoryChanges = new ArrayList();
        Iterable $this$forEach$iv = events;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileChangeType changeType;
            VFileEvent event2 = (VFileEvent)element$iv;
            boolean bl = false;
            VFileEvent vFileEvent = event2;
            Object file = vFileEvent instanceof VFileCreateEvent ? ((VFileCreateEvent)event2).getFile() : (vFileEvent instanceof VFileDeleteEvent ? ((VFileDeleteEvent)event2).getFile() : (vFileEvent instanceof VFileMoveEvent ? ((VFileMoveEvent)event2).getFile() : (vFileEvent instanceof VFileCopyEvent ? ((VFileCopyEvent)event2).getFile() : (vFileEvent instanceof VFilePropertyChangeEvent ? ((VFilePropertyChangeEvent)event2).getFile() : (vFileEvent instanceof VFileContentChangeEvent ? ((VFileContentChangeEvent)event2).getFile() : null)))));
            if (file == null) continue;
            VFileEvent vFileEvent2 = event2;
            FileChangeType fileChangeType = vFileEvent2 instanceof VFileCreateEvent ? FileChangeType.CREATED : (changeType = vFileEvent2 instanceof VFileDeleteEvent ? FileChangeType.DELETED : FileChangeType.UPDATED);
            if (!this.isRelevantFileSystemItem((VirtualFile)file, project)) continue;
            WorkspaceFileChangeData changeData = new WorkspaceFileChangeData((VirtualFile)file, changeType, 0L, null, 12, null);
            if (file.isDirectory()) {
                directoryChanges.add(changeData);
                this.triggerDirectoryChangeEvent(changeData);
                continue;
            }
            fileChanges.add(changeData);
            this.triggerFileChangeEvent(changeData);
        }
        if (!((Collection)fileChanges).isEmpty()) {
            this.triggerBulkFileChangeEvent(fileChanges, project);
        }
        if (!((Collection)directoryChanges).isEmpty()) {
            this.triggerBulkDirectoryChangeEvent(directoryChanges, project);
        }
    }

    private final void triggerFileChangeEvent(WorkspaceFileChangeData fileChangeData) {
        this.logger.debug("File changed: " + fileChangeData.getFile().getPath() + ", type: " + fileChangeData.getChangeType());
        ((ProjectEventBus)this.project.getService(ProjectEventBus.class)).emitInApplication(WorkspaceFileChangeEvent.INSTANCE, fileChangeData);
    }

    private final void triggerDirectoryChangeEvent(WorkspaceFileChangeData directoryChangeData) {
        this.logger.debug("Directory changed: " + directoryChangeData.getFile().getPath() + ", type: " + directoryChangeData.getChangeType());
        ((ProjectEventBus)this.project.getService(ProjectEventBus.class)).emitInApplication(WorkspaceDirectoryChangeEvent.INSTANCE, directoryChangeData);
    }

    private final void triggerBulkFileChangeEvent(List<WorkspaceFileChangeData> fileChanges, Project project) {
        ExtHostFileSystemEventServiceProxy proxy;
        this.logger.debug("Bulk file change, total " + fileChanges.size() + " files");
        IRPCProtocol iRPCProtocol = PluginContext.Companion.getInstance(project).getRPCProtocol();
        ExtHostFileSystemEventServiceProxy extHostFileSystemEventServiceProxy = proxy = iRPCProtocol != null ? iRPCProtocol.getProxy(ServiceProxyRegistry.ExtHostContext.INSTANCE.getExtHostFileSystemEventService()) : null;
        if (extHostFileSystemEventServiceProxy != null) {
            ExtHostFileSystemEventServiceProxy it = extHostFileSystemEventServiceProxy;
            boolean bl = false;
            List createdFiles = new ArrayList();
            List changedFiles = new ArrayList();
            List deletedFiles = new ArrayList();
            Iterable $this$forEach$iv = fileChanges;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WorkspaceFileChangeData fileChange = (WorkspaceFileChangeData)element$iv;
                boolean bl2 = false;
                Map<String, Object> uriComponents2 = this.fileToUriComponents(fileChange.getFile());
                switch (WhenMappings.$EnumSwitchMapping$0[fileChange.getChangeType().ordinal()]) {
                    case 1: {
                        boolean bl3 = createdFiles.add(uriComponents2);
                        break;
                    }
                    case 2: {
                        boolean bl3 = changedFiles.add(uriComponents2);
                        break;
                    }
                    case 3: {
                        boolean bl3 = deletedFiles.add(uriComponents2);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            FileSystemEvents fileSystemEvents = new FileSystemEvents(String.valueOf(fileChanges.get(0).getTimestamp()), createdFiles, changedFiles, deletedFiles);
            it.onFileEvent(fileSystemEvents);
        }
        WorkspaceFilesChangeData bulkChangeData = new WorkspaceFilesChangeData(fileChanges);
        ((ProjectEventBus)project.getService(ProjectEventBus.class)).emitInApplication(WorkspaceFilesChangeEvent.INSTANCE, bulkChangeData);
    }

    private final void triggerBulkDirectoryChangeEvent(List<WorkspaceFileChangeData> directoryChanges, Project project) {
        ExtHostFileSystemEventServiceProxy proxy;
        this.logger.debug("Bulk directory change, total " + directoryChanges.size() + " directories");
        IRPCProtocol iRPCProtocol = PluginContext.Companion.getInstance(project).getRPCProtocol();
        ExtHostFileSystemEventServiceProxy extHostFileSystemEventServiceProxy = proxy = iRPCProtocol != null ? iRPCProtocol.getProxy(ServiceProxyRegistry.ExtHostContext.INSTANCE.getExtHostFileSystemEventService()) : null;
        if (extHostFileSystemEventServiceProxy != null) {
            ExtHostFileSystemEventServiceProxy it = extHostFileSystemEventServiceProxy;
            boolean bl = false;
            List createdDirs = new ArrayList();
            List changedDirs = new ArrayList();
            List deletedDirs = new ArrayList();
            Iterable $this$forEach$iv = directoryChanges;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WorkspaceFileChangeData dirChange = (WorkspaceFileChangeData)element$iv;
                boolean bl2 = false;
                Map<String, Object> uriComponents2 = this.fileToUriComponents(dirChange.getFile());
                switch (WhenMappings.$EnumSwitchMapping$0[dirChange.getChangeType().ordinal()]) {
                    case 1: {
                        boolean bl3 = createdDirs.add(uriComponents2);
                        break;
                    }
                    case 2: {
                        boolean bl3 = changedDirs.add(uriComponents2);
                        break;
                    }
                    case 3: {
                        boolean bl3 = deletedDirs.add(uriComponents2);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            FileSystemEvents fileSystemEvents = new FileSystemEvents(String.valueOf(directoryChanges.get(0).getTimestamp()), createdDirs, changedDirs, deletedDirs);
            it.onFileEvent(fileSystemEvents);
        }
        WorkspaceFilesChangeData bulkChangeData = new WorkspaceFilesChangeData(directoryChanges);
        ((ProjectEventBus)project.getService(ProjectEventBus.class)).emitInApplication(WorkspaceDirectoriesChangeEvent.INSTANCE, bulkChangeData);
    }

    private final Map<String, Object> fileToUriComponents(VirtualFile file) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"scheme", (Object)"file"), TuplesKt.to((Object)"path", (Object)file.getPath()), TuplesKt.to((Object)"authority", (Object)""), TuplesKt.to((Object)"query", (Object)""), TuplesKt.to((Object)"fragment", (Object)"")};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final boolean isRelevantFileSystemItem(VirtualFile file, Project project) {
        block6: {
            block7: {
                block5: {
                    block4: {
                        String string = file.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        if (StringsKt.startsWith$default((String)string, (String)".", (boolean)false, (int)2, null)) break block4;
                        String string2 = file.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"/.", (boolean)false, (int)2, null)) break block5;
                    }
                    return false;
                }
                if (file.isDirectory()) break block6;
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (StringsKt.endsWith$default((String)string, (String)"~", (boolean)false, (int)2, null)) break block7;
                String string3 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                if (!StringsKt.endsWith$default((String)string3, (String)".tmp", (boolean)false, (int)2, null)) break block6;
            }
            return false;
        }
        return true;
    }

    public void dispose() {
        this.logger.info("Release workspace file change manager resources");
        try {
            MessageBusConnection messageBusConnection = this.projectConnection;
            if (messageBusConnection != null) {
                messageBusConnection.disconnect();
            }
            this.projectConnection = null;
            Map $this$forEach$iv = this.vfsConnections;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                Project project = (Project)entry.getKey();
                MessageBusConnection connection = (MessageBusConnection)entry.getValue();
                try {
                    this.logger.info("Unregister file listener for project " + project.getName());
                    connection.disconnect();
                }
                catch (Exception e) {
                    this.logger.error("Failed to unregister file listener for project " + project.getName(), (Throwable)e);
                }
            }
            this.vfsConnections.clear();
        }
        catch (Exception e) {
            this.logger.error("Failed to release workspace file change manager resources", (Throwable)e);
        }
    }

    public static final /* synthetic */ void access$processBulkFileEvents(WorkspaceFileChangeManager $this, List events, Project project) {
        $this.processBulkFileEvents(events, project);
    }

    public static final /* synthetic */ void access$registerFileListener(WorkspaceFileChangeManager $this, Project project) {
        $this.registerFileListener(project);
    }

    public static final /* synthetic */ void access$triggerWorkspaceRootChangeEvent(WorkspaceFileChangeManager $this, Project project, String oldPath, String newPath) {
        $this.triggerWorkspaceRootChangeEvent(project, oldPath, newPath);
    }

    public static final /* synthetic */ void access$unregisterFileListener(WorkspaceFileChangeManager $this, Project project) {
        $this.unregisterFileListener(project);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getProjectWorkspacePaths$p(WorkspaceFileChangeManager $this) {
        return $this.projectWorkspacePaths;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FileChangeType.values().length];
            try {
                nArray[FileChangeType.CREATED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileChangeType.UPDATED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileChangeType.DELETED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

