/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.util;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.sina.weibo.agent.plugin.DEBUG_MODE;
import com.sina.weibo.agent.plugin.WecoderPluginService;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bJ\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/sina/weibo/agent/util/PluginResourceUtil;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getResourcePath", "", "pluginId", "resourceName", "loadDevResource", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "loadProdResource", "checkDevMode", "", "extractResourceToTempFile", "resourceUrl", "Ljava/net/URL;", "filename", "coderider-kilo-jetbrains"})
public final class PluginResourceUtil {
    @NotNull
    public static final PluginResourceUtil INSTANCE = new PluginResourceUtil();
    @NotNull
    private static final Logger LOG;

    private PluginResourceUtil() {
    }

    @Nullable
    public final String getResourcePath(@NotNull String pluginId, @NotNull String resourceName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        try {
            if (WecoderPluginService.Companion.getDebugMode() == DEBUG_MODE.IDEA) {
                return WecoderPluginService.Companion.getDebugResource() + "/" + resourceName;
            }
            IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)pluginId));
            if (ideaPluginDescriptor == null) {
                throw new IllegalStateException("Cannot find plugin: " + pluginId);
            }
            IdeaPluginDescriptor plugin = ideaPluginDescriptor;
            boolean isDevMode = this.checkDevMode(plugin);
            string = isDevMode ? this.loadDevResource(resourceName, plugin) : this.loadProdResource(resourceName, plugin);
        }
        catch (Exception e) {
            LOG.info("Failed to get plugin resource path: " + resourceName, (Throwable)e);
            string = null;
        }
        return string;
    }

    private final String loadDevResource(String resourceName, IdeaPluginDescriptor plugin) {
        Path path = plugin.getPluginPath().getParent().getParent().getParent().getParent().getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        String[] stringArray = new String[]{"debug-resources/" + resourceName};
        Path resourcePath = Paths.get(((Object)path).toString(), stringArray);
        return ((Object)resourcePath).toString();
    }

    private final String loadProdResource(String resourceName, IdeaPluginDescriptor plugin) {
        File pluginDir = plugin.getPluginPath().toFile();
        Intrinsics.checkNotNull((Object)pluginDir);
        File resourceDir = FilesKt.resolve((File)pluginDir, (String)resourceName);
        if (resourceDir.exists()) {
            return resourceDir.getAbsolutePath();
        }
        return null;
    }

    private final boolean checkDevMode(IdeaPluginDescriptor plugin) {
        boolean bl;
        try {
            bl = WecoderPluginService.Companion.getDebugMode() != DEBUG_MODE.NONE;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String extractResourceToTempFile(@NotNull URL resourceUrl, @NotNull String filename) {
        String string;
        Intrinsics.checkNotNullParameter((Object)resourceUrl, (String)"resourceUrl");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        try {
            File tempFile = File.createTempFile("roo-cline-", "-" + filename);
            tempFile.deleteOnExit();
            Closeable closeable = resourceUrl.openStream();
            Throwable throwable = null;
            try {
                long l;
                InputStream input = (InputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)tempFile);
                Closeable closeable2 = new FileOutputStream(tempFile);
                Throwable throwable2 = null;
                try {
                    FileOutputStream output = (FileOutputStream)closeable2;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)input);
                    l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            LOG.info("Resource extracted to temporary file: " + tempFile.getAbsolutePath());
            string = tempFile.getAbsolutePath();
        }
        catch (Exception e) {
            LOG.info("Failed to extract resource to temporary file: " + filename, (Throwable)e);
            string = null;
        }
        return string;
    }

    static {
        Logger logger = Logger.getInstance(PluginResourceUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

