/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.terminal;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0002JG\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J5\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0018H\u0002\u00a2\u0006\u0002\u0010\u001bJ=\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00182\u0006\u0010\u001d\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u001eJ=\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00182\u0006\u0010\u001d\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u001eJ=\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00182\u0006\u0010\u001d\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u001eJ\b\u0010!\u001a\u00020\nH\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010#\u001a\u00020\nH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006$"}, d2={"Lcom/sina/weibo/agent/terminal/WeCoderTerminalCustomizer;", "Lorg/jetbrains/plugins/terminal/LocalTerminalCustomizer;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "filesCopied", "Ljava/util/concurrent/atomic/AtomicBoolean;", "shellIntegrationBaseDir", "", "getShellIntegrationBaseDir", "()Ljava/lang/String;", "shellIntegrationBaseDir$delegate", "Lkotlin/Lazy;", "copyShellIntegrationFiles", "", "customizeCommandAndEnvironment", "", "project", "Lcom/intellij/openapi/project/Project;", "workingDirectory", "command", "envs", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;[Ljava/lang/String;Ljava/util/Map;)[Ljava/lang/String;", "injectVSCodeScript", "([Ljava/lang/String;Ljava/util/Map;)[Ljava/lang/String;", "injectBashScript", "scriptPath", "([Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;)[Ljava/lang/String;", "injectZshScript", "injectPowerShellScript", "generateNonce", "getVSCodeScript", "shellName", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nWeCoderTerminalCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WeCoderTerminalCustomizer.kt\ncom/sina/weibo/agent/terminal/WeCoderTerminalCustomizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,295:1\n1869#2,2:296\n1563#2:302\n1634#2,3:303\n1869#2,2:307\n37#3:298\n36#3,3:299\n216#4:306\n217#4:309\n*S KotlinDebug\n*F\n+ 1 WeCoderTerminalCustomizer.kt\ncom/sina/weibo/agent/terminal/WeCoderTerminalCustomizer\n*L\n260#1:296,2\n275#1:302\n275#1:303,3\n70#1:307,2\n266#1:298\n266#1:299,3\n58#1:306\n58#1:309\n*E\n"})
public final class WeCoderTerminalCustomizer
extends LocalTerminalCustomizer {
    @NotNull
    private final Logger logger;
    @NotNull
    private final AtomicBoolean filesCopied;
    @NotNull
    private final Lazy shellIntegrationBaseDir$delegate;

    public WeCoderTerminalCustomizer() {
        Logger logger = Logger.getInstance(WeCoderTerminalCustomizer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.filesCopied = new AtomicBoolean(false);
        this.shellIntegrationBaseDir$delegate = LazyKt.lazy(WeCoderTerminalCustomizer::shellIntegrationBaseDir_delegate$lambda$0);
        this.copyShellIntegrationFiles();
    }

    private final String getShellIntegrationBaseDir() {
        Lazy lazy = this.shellIntegrationBaseDir$delegate;
        return (String)lazy.getValue();
    }

    private final void copyShellIntegrationFiles() {
        if (this.filesCopied.get()) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> WeCoderTerminalCustomizer.copyShellIntegrationFiles$lambda$4(this));
    }

    @NotNull
    public String[] customizeCommandAndEnvironment(@NotNull Project project, @Nullable String workingDirectory, @NotNull String[] command, @NotNull Map<String, String> envs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        this.logger.info("\ud83d\udd27 WeCodeTerminalCustomizer - customize terminal command and environment");
        this.logger.info("\ud83d\udcc2 Working directory: " + workingDirectory);
        this.logger.info("\ud83d\udd28 Command: " + ArraysKt.joinToString$default((Object[])command, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        this.logger.info("\ud83c\udf0d Environment variables: " + CollectionsKt.joinToString$default((Iterable)envs.entrySet(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        return this.injectVSCodeScript(command, envs);
    }

    private final String[] injectVSCodeScript(String[] command, Map<String, String> envs) {
        String shellName = new File(command[0]).getName();
        Intrinsics.checkNotNull((Object)shellName);
        String string = this.getVSCodeScript(shellName);
        if (string == null) {
            WeCoderTerminalCustomizer $this$injectVSCodeScript_u24lambda_u245 = this;
            boolean bl = false;
            $this$injectVSCodeScript_u24lambda_u245.logger.warn("\ud83d\udeab No integration script found for Shell(" + shellName + ")");
            return command;
        }
        String scriptPath = string;
        this.logger.info("\ud83d\udd27 Injecting Shell Integration script: " + scriptPath);
        this.logger.info("\ud83d\udc1a Shell type: " + shellName);
        envs.put("VSCODE_INJECTION", "1");
        return switch (shellName) {
            case "sh", "bash" -> this.injectBashScript(command, envs, scriptPath);
            case "zsh" -> this.injectZshScript(command, envs, scriptPath);
            case "powershell.exe", "powershell", "pwsh" -> this.injectPowerShellScript(command, envs, scriptPath);
            default -> {
                this.logger.warn("\u26a0\ufe0f Unsupported shell type: " + shellName);
                yield command;
            }
        };
    }

    private final String[] injectBashScript(String[] command, Map<String, String> envs, String scriptPath) {
        String[] stringArray;
        int rcfileIndex = ArraysKt.indexOf((Object[])command, (Object)"--rcfile");
        if (rcfileIndex != -1 && rcfileIndex + 1 < command.length) {
            String originalRcfile = command[rcfileIndex + 1];
            this.logger.info("\ud83d\udd27 Detected existing --rcfile parameter: " + originalRcfile);
            envs.put("ORIGINAL_BASH_RCFILE", originalRcfile);
            String[] newCommand = (String[])command.clone();
            newCommand[rcfileIndex + 1] = scriptPath;
            this.logger.info("\ud83d\udd27 Replaced --rcfile parameter with: " + scriptPath);
            stringArray = newCommand;
        } else {
            this.logger.info("\ud83d\udd27 Added new --rcfile parameter: " + scriptPath);
            Object[] objectArray = new String[]{command[0], "--rcfile", scriptPath};
            stringArray = (String[])ArraysKt.plus((Object[])objectArray, (Collection)ArraysKt.drop((Object[])command, (int)1));
        }
        return stringArray;
    }

    private final String[] injectZshScript(String[] command, Map<String, String> envs, String scriptPath) {
        String string = envs.get("JETBRAINS_INTELLIJ_ZSH_DIR");
        if (string == null) {
            string = System.getenv("JETBRAINS_INTELLIJ_ZSH_DIR");
        }
        String jetbrainsZshDir = string;
        String shellExeName = new File(command[0]).getName();
        boolean looksLikeJbZsh = StringsKt.contains$default((CharSequence)command[0], (CharSequence)"/plugins/terminal/shell-integrations/zsh", (boolean)false, (int)2, null);
        if (jetbrainsZshDir != null || looksLikeJbZsh) {
            this.logger.info("\ud83d\udd12 Detected JetBrains Zsh integration (JETBRAINS_INTELLIJ_ZSH_DIR=" + jetbrainsZshDir + ", looksLikeJbZsh=" + looksLikeJbZsh + "). Skip overriding ZDOTDIR.");
            String string2 = envs.get("ZDOTDIR");
            if (string2 == null && (string2 = System.getenv("ZDOTDIR")) == null) {
                string2 = System.getProperty("user.home");
            }
            String userZdotdir = string2;
            envs.put("USER_ZDOTDIR", userZdotdir);
            return command;
        }
        File dir = new File(scriptPath);
        boolean hasZshrc = new File(dir, ".zshrc").exists();
        if (!dir.isDirectory() || !hasZshrc) {
            this.logger.warn("\ud83d\udeab Zsh script dir '" + scriptPath + "' is invalid (dir=" + dir + ", hasZshrc=" + hasZshrc + "). Skip overriding ZDOTDIR.");
            return command;
        }
        String string3 = envs.get("ZDOTDIR");
        if (string3 == null && (string3 = System.getenv("ZDOTDIR")) == null) {
            string3 = System.getProperty("user.home");
        }
        String userZdotdir = string3;
        envs.put("USER_ZDOTDIR", userZdotdir);
        envs.put("ZDOTDIR", scriptPath);
        this.logger.info("\ud83d\udd27 Set ZDOTDIR to '" + scriptPath + "' (saved original as USER_ZDOTDIR='" + userZdotdir + "'), shell=" + shellExeName);
        return command;
    }

    private final String[] injectPowerShellScript(String[] command, Map<String, String> envs, String scriptPath) {
        String[] stringArray;
        this.logger.info("\ud83d\udd27 Inject PowerShell script: " + scriptPath);
        envs.put("VSCODE_NONCE", this.generateNonce());
        envs.put("VSCODE_SHELL_ENV_REPORTING", "1");
        envs.put("VSCODE_STABLE", "1");
        this.logger.info("\ud83d\udd27 Set PowerShell environment variables: VSCODE_NONCE=" + envs.get("VSCODE_NONCE"));
        int fileIndex = ArraysKt.indexOf((Object[])command, (Object)"-File");
        if (fileIndex != -1 && fileIndex + 1 < command.length) {
            String originalScript = command[fileIndex + 1];
            this.logger.info("\ud83d\udd27 Detected existing -File parameter: " + originalScript);
            envs.put("ORIGINAL_POWERSHELL_SCRIPT", originalScript);
            String[] newCommand = (String[])command.clone();
            newCommand[fileIndex + 1] = scriptPath;
            this.logger.info("\ud83d\udd27 Replace -File parameter with: " + scriptPath);
            stringArray = newCommand;
        } else {
            int execPolicyIndex;
            this.logger.info("\ud83d\udd27 Add new -File parameter: " + scriptPath);
            List newCommand = new ArrayList();
            newCommand.add(command[0]);
            if (!ArraysKt.contains((Object[])command, (Object)"-NoExit")) {
                newCommand.add("-NoExit");
            }
            if ((execPolicyIndex = ArraysKt.indexOf((Object[])command, (Object)"-ExecutionPolicy")) == -1) {
                newCommand.add("-ExecutionPolicy");
                newCommand.add("Bypass");
            }
            newCommand.add("-File");
            newCommand.add(scriptPath);
            Iterable $this$forEach$iv = ArraysKt.drop((Object[])command, (int)1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String arg = (String)element$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)arg, (Object)"-NoExit") || Intrinsics.areEqual((Object)arg, (Object)"-ExecutionPolicy") || Intrinsics.areEqual((Object)arg, (Object)"Bypass")) continue;
                newCommand.add(arg);
            }
            Collection $this$toTypedArray$iv = newCommand;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
        }
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    private final String generateNonce() {
        void $this$mapTo$iv$iv;
        String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Iterable $this$map$iv = (Iterable)new IntRange(1, 16);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Character.valueOf(StringsKt.random((CharSequence)chars, (Random)((Random)Random.Default))));
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    private final String getVSCodeScript(String shellName) {
        return switch (shellName) {
            case "sh", "bash" -> {
                String[] var3_3 = new String[]{"vscode-bash", "bashrc"};
                yield ((Object)Paths.get(this.getShellIntegrationBaseDir(), var3_3)).toString();
            }
            case "zsh" -> {
                String[] var3_4 = new String[]{"vscode-zsh"};
                yield ((Object)Paths.get(this.getShellIntegrationBaseDir(), var3_4)).toString();
            }
            case "powershell.exe", "powershell", "pwsh" -> {
                String[] var3_5 = new String[]{"vscode-powershell", "profile.ps1"};
                yield ((Object)Paths.get(this.getShellIntegrationBaseDir(), var3_5)).toString();
            }
            default -> null;
        };
    }

    private static final String shellIntegrationBaseDir_delegate$lambda$0() {
        String userHome = System.getProperty("user.home");
        String[] stringArray = new String[]{".run-vs-agent-shell-integrations"};
        return ((Object)Paths.get(userHome, stringArray)).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void copyShellIntegrationFiles$lambda$4(WeCoderTerminalCustomizer this$0) {
        if (!this$0.filesCopied.compareAndSet(false, true)) {
            return;
        }
        try {
            Map shellConfigs;
            this$0.logger.info("\ud83d\ude80 Start async copy of shell integration files to user home...");
            Pair[] pairArray = new Pair[3];
            Object[] objectArray = new String[]{".zshrc", ".zshenv"};
            pairArray[0] = TuplesKt.to((Object)"vscode-zsh", (Object)CollectionsKt.listOf((Object[])objectArray));
            pairArray[1] = TuplesKt.to((Object)"vscode-bash", (Object)CollectionsKt.listOf((Object)"bashrc"));
            objectArray = new String[]{"profile.ps1", "diagnose.ps1"};
            pairArray[2] = TuplesKt.to((Object)"vscode-powershell", (Object)CollectionsKt.listOf((Object[])objectArray));
            Map $this$forEach$iv = shellConfigs = MapsKt.mapOf((Pair[])pairArray);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String shellType = (String)entry.getKey();
                List files = (List)entry.getValue();
                String sourceDir = "run-vs-agent-shell-integrations/" + shellType;
                String[] stringArray = new String[]{shellType};
                String targetDir = ((Object)Paths.get(this$0.getShellIntegrationBaseDir(), stringArray)).toString();
                File targetDirFile = new File(targetDir);
                if (!targetDirFile.exists()) {
                    targetDirFile.mkdirs();
                    this$0.logger.info("\ud83d\udcc1 Created " + shellType + " target directory: " + targetDir);
                }
                Iterable $this$forEach$iv2 = files;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String fileName = (String)element$iv2;
                    boolean bl2 = false;
                    InputStream inputStream = ((Object)((Object)this$0)).getClass().getClassLoader().getResourceAsStream(sourceDir + "/" + fileName);
                    if (inputStream != null) {
                        File targetFile = new File(targetDir + "/" + fileName);
                        Closeable closeable = new FileOutputStream(targetFile);
                        Throwable throwable = null;
                        try {
                            FileOutputStream outputStream = (FileOutputStream)closeable;
                            boolean bl3 = false;
                            long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)outputStream, (int)0, (int)2, null);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        targetFile.setExecutable(true, true);
                        this$0.logger.info("\u2705 Successfully copied " + shellType + " file: " + fileName);
                        continue;
                    }
                    this$0.logger.warn("\u26a0\ufe0f Cannot find " + shellType + " source file: " + fileName);
                }
            }
            this$0.logger.info("\u2705 Shell integration files async copy complete");
        }
        catch (Exception e) {
            this$0.logger.error("\u274c Failed to async copy shell integration files", (Throwable)e);
            this$0.filesCopied.set(false);
        }
    }
}

