/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.terminal;

import com.intellij.openapi.diagnostic.Logger;
import com.sina.weibo.agent.core.ServiceProxyRegistry;
import com.sina.weibo.agent.ipc.proxy.IRPCProtocol;
import com.sina.weibo.agent.ipc.proxy.interfaces.ExtHostTerminalShellIntegrationProxy;
import com.sina.weibo.agent.terminal.ShellEventListener;
import com.sina.weibo.agent.terminal.ShellIntegrationOutputState;
import com.sina.weibo.agent.util.URI;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0002\"#B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0018J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0003J\b\u0010\u001c\u001a\u00020\u0018H\u0002J\b\u0010\u001d\u001a\u00020\u0018H\u0002J\u001f\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00032\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180!H\u0082\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006$"}, d2={"Lcom/sina/weibo/agent/terminal/TerminalShellIntegration;", "", "extHostTerminalId", "", "numericId", "", "rpcProtocol", "Lcom/sina/weibo/agent/ipc/proxy/IRPCProtocol;", "<init>", "(Ljava/lang/String;ILcom/sina/weibo/agent/ipc/proxy/IRPCProtocol;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "shellIntegrationState", "Lcom/sina/weibo/agent/terminal/ShellIntegrationOutputState;", "shellEventListener", "Lcom/sina/weibo/agent/terminal/ShellEventListener;", "extHostProxy", "Lcom/sina/weibo/agent/ipc/proxy/interfaces/ExtHostTerminalShellIntegrationProxy;", "getExtHostProxy", "()Lcom/sina/weibo/agent/ipc/proxy/interfaces/ExtHostTerminalShellIntegrationProxy;", "extHostProxy$delegate", "Lkotlin/Lazy;", "setupShellIntegration", "", "dispose", "appendRawOutput", "data", "initializeShellEventListener", "initializeShellIntegrationState", "safeRpcCall", "operation", "action", "Lkotlin/Function0;", "Companion", "TerminalShellEventListener", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nTerminalShellIntegration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalShellIntegration.kt\ncom/sina/weibo/agent/terminal/TerminalShellIntegration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n1#2:183\n*E\n"})
public final class TerminalShellIntegration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String extHostTerminalId;
    private final int numericId;
    @NotNull
    private final IRPCProtocol rpcProtocol;
    @NotNull
    private final Logger logger;
    @Nullable
    private ShellIntegrationOutputState shellIntegrationState;
    @Nullable
    private ShellEventListener shellEventListener;
    @NotNull
    private final Lazy extHostProxy$delegate;
    private static final int HIGH_CONFIDENCE = 2;
    private static final int DEFAULT_EXIT_CODE = 0;
    @NotNull
    private static final String LOG_PREFIX_SETUP = "\ud83d\udd27";
    @NotNull
    private static final String LOG_PREFIX_START = "\ud83d\ude80";
    @NotNull
    private static final String LOG_PREFIX_END = "\ud83c\udfc1";
    @NotNull
    private static final String LOG_PREFIX_DATA = "\u2728";
    @NotNull
    private static final String LOG_PREFIX_CWD = "\ud83d\udcc1";
    @NotNull
    private static final String LOG_PREFIX_SUCCESS = "\u2705";
    @NotNull
    private static final String LOG_PREFIX_ERROR = "\u274c";
    @NotNull
    private static final String LOG_PREFIX_DISPOSE = "\ud83e\uddf9";

    public TerminalShellIntegration(@NotNull String extHostTerminalId, int numericId, @NotNull IRPCProtocol rpcProtocol) {
        Intrinsics.checkNotNullParameter((Object)extHostTerminalId, (String)"extHostTerminalId");
        Intrinsics.checkNotNullParameter((Object)rpcProtocol, (String)"rpcProtocol");
        this.extHostTerminalId = extHostTerminalId;
        this.numericId = numericId;
        this.rpcProtocol = rpcProtocol;
        Logger logger = Logger.getInstance(TerminalShellIntegration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.extHostProxy$delegate = LazyKt.lazy(() -> TerminalShellIntegration.extHostProxy_delegate$lambda$0(this));
    }

    private final ExtHostTerminalShellIntegrationProxy getExtHostProxy() {
        Lazy lazy = this.extHostProxy$delegate;
        return (ExtHostTerminalShellIntegrationProxy)lazy.getValue();
    }

    public final void setupShellIntegration() {
        block2: {
            Object object;
            Object object2 = this;
            try {
                TerminalShellIntegration $this$setupShellIntegration_u24lambda_u241 = object2;
                boolean bl = false;
                $this$setupShellIntegration_u24lambda_u241.logger.info("\ud83d\udd27 Setting up shell integration (terminal: " + $this$setupShellIntegration_u24lambda_u241.extHostTerminalId + ")...");
                $this$setupShellIntegration_u24lambda_u241.initializeShellEventListener();
                $this$setupShellIntegration_u24lambda_u241.initializeShellIntegrationState();
                $this$setupShellIntegration_u24lambda_u241.logger.info("\u2705 Shell integration setup complete (terminal: " + $this$setupShellIntegration_u24lambda_u241.extHostTerminalId + ")");
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object exception = object = throwable;
            boolean bl = false;
            this.logger.error("\u274c Failed to setup shell integration (terminal: " + this.extHostTerminalId + ")", (Throwable)exception);
        }
    }

    public final void dispose() {
        block3: {
            Object object;
            this.logger.info("\ud83e\uddf9 Disposing shell integration: " + this.extHostTerminalId);
            Object object2 = this;
            try {
                TerminalShellIntegration $this$dispose_u24lambda_u244 = object2;
                boolean bl = false;
                ShellIntegrationOutputState shellIntegrationOutputState = $this$dispose_u24lambda_u244.shellIntegrationState;
                if (shellIntegrationOutputState != null) {
                    ShellIntegrationOutputState shellIntegrationOutputState2;
                    ShellIntegrationOutputState $this$dispose_u24lambda_u244_u24lambda_u243 = shellIntegrationOutputState2 = shellIntegrationOutputState;
                    boolean bl2 = false;
                    $this$dispose_u24lambda_u244_u24lambda_u243.terminate();
                    $this$dispose_u24lambda_u244_u24lambda_u243.dispose();
                }
                $this$dispose_u24lambda_u244.shellEventListener = null;
                $this$dispose_u24lambda_u244.shellIntegrationState = null;
                $this$dispose_u24lambda_u244.logger.info("\u2705 Shell integration disposed: " + $this$dispose_u24lambda_u244.extHostTerminalId);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block3;
            Object exception = object = throwable;
            boolean bl = false;
            this.logger.error("\u274c Failed to dispose shell integration: " + this.extHostTerminalId, (Throwable)exception);
        }
    }

    public final void appendRawOutput(@NotNull String data) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            ShellIntegrationOutputState shellIntegrationOutputState = this.shellIntegrationState;
            if (shellIntegrationOutputState == null) break block0;
            shellIntegrationOutputState.appendRawOutput(data);
        }
    }

    private final void initializeShellEventListener() {
        this.shellEventListener = new TerminalShellEventListener();
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeShellIntegrationState() {
        ShellIntegrationOutputState shellIntegrationOutputState;
        ShellIntegrationOutputState shellIntegrationOutputState2 = shellIntegrationOutputState = new ShellIntegrationOutputState();
        TerminalShellIntegration terminalShellIntegration = this;
        boolean bl = false;
        ShellEventListener shellEventListener = this.shellEventListener;
        if (shellEventListener != null) {
            void $this$initializeShellIntegrationState_u24lambda_u247;
            ShellEventListener it = shellEventListener;
            boolean bl2 = false;
            $this$initializeShellIntegrationState_u24lambda_u247.addListener(it);
        }
        terminalShellIntegration.shellIntegrationState = shellIntegrationOutputState;
    }

    private final void safeRpcCall(String operation, Function0<Unit> action2) {
        block2: {
            Object object;
            boolean $i$f$safeRpcCall = false;
            Object object2 = this;
            try {
                TerminalShellIntegration $this$safeRpcCall_u24lambda_u248 = object2;
                boolean bl = false;
                action2.invoke();
                $this$safeRpcCall_u24lambda_u248.logger.debug("\u2705 " + operation + " succeeded (terminal: " + $this$safeRpcCall_u24lambda_u248.extHostTerminalId + ")");
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object exception = object = throwable;
            boolean bl = false;
            this.logger.error("\u274c " + operation + " failed (terminal: " + this.extHostTerminalId + ")", (Throwable)exception);
        }
    }

    private static final ExtHostTerminalShellIntegrationProxy extHostProxy_delegate$lambda$0(TerminalShellIntegration this$0) {
        return this$0.rpcProtocol.getProxy(ServiceProxyRegistry.ExtHostContext.INSTANCE.getExtHostTerminalShellIntegration());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/sina/weibo/agent/terminal/TerminalShellIntegration$Companion;", "", "<init>", "()V", "HIGH_CONFIDENCE", "", "DEFAULT_EXIT_CODE", "LOG_PREFIX_SETUP", "", "LOG_PREFIX_START", "LOG_PREFIX_END", "LOG_PREFIX_DATA", "LOG_PREFIX_CWD", "LOG_PREFIX_SUCCESS", "LOG_PREFIX_ERROR", "LOG_PREFIX_DISPOSE", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u001f\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/sina/weibo/agent/terminal/TerminalShellIntegration$TerminalShellEventListener;", "Lcom/sina/weibo/agent/terminal/ShellEventListener;", "<init>", "(Lcom/sina/weibo/agent/terminal/TerminalShellIntegration;)V", "onShellExecutionStart", "", "commandLine", "", "cwd", "onShellExecutionEnd", "exitCode", "", "(Ljava/lang/String;Ljava/lang/Integer;)V", "onShellExecutionData", "data", "onCwdChange", "coderider-kilo-jetbrains"})
    @SourceDebugExtension(value={"SMAP\nTerminalShellIntegration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalShellIntegration.kt\ncom/sina/weibo/agent/terminal/TerminalShellIntegration$TerminalShellEventListener\n+ 2 TerminalShellIntegration.kt\ncom/sina/weibo/agent/terminal/TerminalShellIntegration\n*L\n1#1,182:1\n117#2,7:183\n117#2,7:190\n117#2,7:197\n117#2,7:204\n*S KotlinDebug\n*F\n+ 1 TerminalShellIntegration.kt\ncom/sina/weibo/agent/terminal/TerminalShellIntegration$TerminalShellEventListener\n*L\n134#1:183,7\n149#1:190,7\n163#1:197,7\n174#1:204,7\n*E\n"})
    private final class TerminalShellEventListener
    implements ShellEventListener {
        /*
         * WARNING - void declaration
         */
        @Override
        public void onShellExecutionStart(@NotNull String commandLine, @NotNull String cwd) {
            block2: {
                Object object;
                void operation$iv;
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
                Intrinsics.checkNotNullParameter((Object)cwd, (String)"cwd");
                TerminalShellIntegration.this.logger.info("\ud83d\ude80 Command execution started: '" + commandLine + "' in directory '" + cwd + "' (terminal: " + TerminalShellIntegration.this.extHostTerminalId + ")");
                TerminalShellIntegration terminalShellIntegration = TerminalShellIntegration.this;
                String string = "Notify ExtHost command start";
                TerminalShellIntegration terminalShellIntegration2 = TerminalShellIntegration.this;
                boolean $i$f$safeRpcCall = false;
                Object object2 = this_$iv;
                try {
                    void $this$safeRpcCall_u24lambda_u248$iv = object2;
                    boolean bl = false;
                    boolean bl2 = false;
                    terminalShellIntegration2.getExtHostProxy().shellExecutionStart(terminalShellIntegration2.numericId, commandLine, 2, true, URI.Companion.file(cwd));
                    ((TerminalShellIntegration)$this$safeRpcCall_u24lambda_u248$iv).logger.debug("\u2705 " + (String)operation$iv + " succeeded (terminal: " + ((TerminalShellIntegration)$this$safeRpcCall_u24lambda_u248$iv).extHostTerminalId + ")");
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object2 = object;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable == null) break block2;
                Object exception$iv = object = throwable;
                boolean bl = false;
                ((TerminalShellIntegration)this_$iv).logger.error("\u274c " + (String)operation$iv + " failed (terminal: " + ((TerminalShellIntegration)this_$iv).extHostTerminalId + ")", (Throwable)exception$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onShellExecutionEnd(@NotNull String commandLine, @Nullable Integer exitCode) {
            block2: {
                Object object;
                void operation$iv;
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
                Integer n = exitCode;
                int actualExitCode = n != null ? n : 0;
                TerminalShellIntegration.this.logger.info("\ud83c\udfc1 Command execution finished: '" + commandLine + "' (exit code: " + actualExitCode + ") (terminal: " + TerminalShellIntegration.this.extHostTerminalId + ")");
                TerminalShellIntegration terminalShellIntegration = TerminalShellIntegration.this;
                String string = "Notify ExtHost command end";
                TerminalShellIntegration terminalShellIntegration2 = TerminalShellIntegration.this;
                boolean $i$f$safeRpcCall = false;
                Object object2 = this_$iv;
                try {
                    void $this$safeRpcCall_u24lambda_u248$iv = object2;
                    boolean bl = false;
                    boolean bl2 = false;
                    terminalShellIntegration2.getExtHostProxy().shellExecutionEnd(terminalShellIntegration2.numericId, commandLine, 2, true, actualExitCode);
                    ((TerminalShellIntegration)$this$safeRpcCall_u24lambda_u248$iv).logger.debug("\u2705 " + (String)operation$iv + " succeeded (terminal: " + ((TerminalShellIntegration)$this$safeRpcCall_u24lambda_u248$iv).extHostTerminalId + ")");
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object2 = object;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable == null) break block2;
                Object exception$iv = object = throwable;
                boolean bl = false;
                ((TerminalShellIntegration)this_$iv).logger.error("\u274c " + (String)operation$iv + " failed (terminal: " + ((TerminalShellIntegration)this_$iv).extHostTerminalId + ")", (Throwable)exception$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onShellExecutionData(@NotNull String data) {
            block2: {
                Object object;
                void operation$iv;
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                TerminalShellIntegration.this.logger.debug("\u2728 Clean output data: " + data.length() + " chars (terminal: " + TerminalShellIntegration.this.extHostTerminalId + ")");
                TerminalShellIntegration terminalShellIntegration = TerminalShellIntegration.this;
                String string = "Send shellExecutionData";
                TerminalShellIntegration terminalShellIntegration2 = TerminalShellIntegration.this;
                boolean $i$f$safeRpcCall = false;
                Object object2 = this_$iv;
                try {
                    void $this$safeRpcCall_u24lambda_u248$iv = object2;
                    boolean bl = false;
                    boolean bl2 = false;
                    terminalShellIntegration2.getExtHostProxy().shellExecutionData(terminalShellIntegration2.numericId, data);
                    ((TerminalShellIntegration)$this$safeRpcCall_u24lambda_u248$iv).logger.debug("\u2705 " + (String)operation$iv + " succeeded (terminal: " + ((TerminalShellIntegration)$this$safeRpcCall_u24lambda_u248$iv).extHostTerminalId + ")");
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object2 = object;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable == null) break block2;
                Object exception$iv = object = throwable;
                boolean bl = false;
                ((TerminalShellIntegration)this_$iv).logger.error("\u274c " + (String)operation$iv + " failed (terminal: " + ((TerminalShellIntegration)this_$iv).extHostTerminalId + ")", (Throwable)exception$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onCwdChange(@NotNull String cwd) {
            block2: {
                Object object;
                void operation$iv;
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)cwd, (String)"cwd");
                TerminalShellIntegration.this.logger.info("\ud83d\udcc1 Working directory changed to: '" + cwd + "' (terminal: " + TerminalShellIntegration.this.extHostTerminalId + ")");
                TerminalShellIntegration terminalShellIntegration = TerminalShellIntegration.this;
                String string = "Notify ExtHost directory change";
                TerminalShellIntegration terminalShellIntegration2 = TerminalShellIntegration.this;
                boolean $i$f$safeRpcCall = false;
                Object object2 = this_$iv;
                try {
                    void $this$safeRpcCall_u24lambda_u248$iv = object2;
                    boolean bl = false;
                    boolean bl2 = false;
                    terminalShellIntegration2.getExtHostProxy().cwdChange(terminalShellIntegration2.numericId, URI.Companion.file(cwd));
                    ((TerminalShellIntegration)$this$safeRpcCall_u24lambda_u248$iv).logger.debug("\u2705 " + (String)operation$iv + " succeeded (terminal: " + ((TerminalShellIntegration)$this$safeRpcCall_u24lambda_u248$iv).extHostTerminalId + ")");
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object2 = object;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable == null) break block2;
                Object exception$iv = object = throwable;
                boolean bl = false;
                ((TerminalShellIntegration)this_$iv).logger.error("\u274c " + (String)operation$iv + " failed (terminal: " + ((TerminalShellIntegration)this_$iv).extHostTerminalId + ")", (Throwable)exception$iv);
            }
        }
    }
}

