/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.terminal;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.content.Content;
import com.sina.weibo.agent.actors.MainThreadClipboard;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0086@\u00a2\u0006\u0002\u0010\u000eJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/sina/weibo/agent/terminal/TerminalAPICommands;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "clipboard", "Lcom/sina/weibo/agent/actors/MainThreadClipboard;", "workbench_action_terminal_copySelection", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getTerminalText", "", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nTerminalCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCommands.kt\ncom/sina/weibo/agent/terminal/TerminalAPICommands\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public final class TerminalAPICommands {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @NotNull
    private final MainThreadClipboard clipboard;

    public TerminalAPICommands(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Logger logger = Logger.getInstance(TerminalAPICommands.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.clipboard = new MainThreadClipboard();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Object workbench_action_terminal_copySelection(@NotNull Continuation<Object> $completion) {
        String string;
        this.logger.info("Copying terminal output to clipboard");
        try {
            String string2 = this.getTerminalText();
            if (string2 == null) {
                string2 = "";
            }
            string = string2;
        }
        catch (Exception e) {
            this.logger.error("Failed to copy terminal output to clipboard", (Throwable)e);
            string = "";
        }
        String textToCopy = string;
        this.clipboard.writeText(textToCopy);
        if (((CharSequence)textToCopy).length() > 0) {
            this.logger.info("Successfully copied terminal output to clipboard");
        } else {
            this.logger.info("Copied empty terminal output to clipboard");
        }
        return null;
    }

    private final String getTerminalText() {
        String string;
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow("Terminal");
        if (toolWindow == null) {
            return null;
        }
        ToolWindow window = toolWindow;
        Content content = window.getContentManager().getSelectedContent();
        if (content == null) {
            return null;
        }
        Content selected = content;
        JBTerminalWidget jBTerminalWidget = TerminalToolWindowManager.getWidgetByContent((Content)selected);
        if (jBTerminalWidget == null) {
            return null;
        }
        JBTerminalWidget widget = jBTerminalWidget;
        String it = string = widget.getText();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return ((CharSequence)it).length() > 0 ? string : null;
    }
}

