/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.terminal;

import com.sina.weibo.agent.terminal.ProxyPtyProcessCallback;
import java.io.InputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\nH\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/sina/weibo/agent/terminal/ProxyInputStream;", "Ljava/io/InputStream;", "originalStream", "streamType", "", "callback", "Lcom/sina/weibo/agent/terminal/ProxyPtyProcessCallback;", "<init>", "(Ljava/io/InputStream;Ljava/lang/String;Lcom/sina/weibo/agent/terminal/ProxyPtyProcessCallback;)V", "read", "", "b", "", "off", "len", "available", "close", "", "mark", "readlimit", "reset", "markSupported", "", "coderider-kilo-jetbrains"})
public final class ProxyInputStream
extends InputStream {
    @NotNull
    private final InputStream originalStream;
    @NotNull
    private final String streamType;
    @Nullable
    private final ProxyPtyProcessCallback callback;

    public ProxyInputStream(@NotNull InputStream originalStream, @NotNull String streamType, @Nullable ProxyPtyProcessCallback callback) {
        Intrinsics.checkNotNullParameter((Object)originalStream, (String)"originalStream");
        Intrinsics.checkNotNullParameter((Object)streamType, (String)"streamType");
        this.originalStream = originalStream;
        this.streamType = streamType;
        this.callback = callback;
    }

    @Override
    public int read() {
        int result = this.originalStream.read();
        if (result != -1 && this.callback != null) {
            byte[] byArray = new byte[]{(byte)result};
            Charset charset = Charsets.UTF_8;
            String dataString = new String(byArray, charset);
            this.callback.onRawData(dataString, this.streamType);
        }
        return result;
    }

    @Override
    public int read(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int result = this.originalStream.read(b);
        if (result > 0 && this.callback != null) {
            String dataString = new String(b, 0, result, Charsets.UTF_8);
            this.callback.onRawData(dataString, this.streamType);
        }
        return result;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int result = this.originalStream.read(b, off, len);
        if (result > 0 && this.callback != null) {
            String dataString = new String(b, off, result, Charsets.UTF_8);
            this.callback.onRawData(dataString, this.streamType);
        }
        return result;
    }

    @Override
    public int available() {
        return this.originalStream.available();
    }

    @Override
    public void close() {
        this.originalStream.close();
    }

    @Override
    public void mark(int readlimit) {
        this.originalStream.mark(readlimit);
    }

    @Override
    public void reset() {
        this.originalStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.originalStream.markSupported();
    }
}

