/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.service;

import com.google.gson.Gson;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@State(name="com.sina.weibo.agent.service.ExtensionStorageService", storages={@Storage(value="roo-cline-extension-storage.xml")})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u0000H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\bJ\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\bJ\u0006\u0010\u0017\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/sina/weibo/agent/service/ExtensionStorageService;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "<init>", "()V", "gson", "Lcom/google/gson/Gson;", "storageMap", "", "", "getStorageMap", "()Ljava/util/Map;", "setStorageMap", "(Ljava/util/Map;)V", "getState", "loadState", "", "state", "setValue", "key", "value", "", "getValue", "removeValue", "clear", "coderider-kilo-jetbrains"})
public final class ExtensionStorageService
implements PersistentStateComponent<ExtensionStorageService> {
    @NotNull
    private final Gson gson = new Gson();
    @NotNull
    private Map<String, String> storageMap = new LinkedHashMap();

    @NotNull
    public final Map<String, String> getStorageMap() {
        return this.storageMap;
    }

    public final void setStorageMap(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.storageMap = map;
    }

    @NotNull
    public ExtensionStorageService getState() {
        return this;
    }

    public void loadState(@NotNull ExtensionStorageService state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public final void setValue(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Map<String, String> map = this.storageMap;
        String string = value instanceof String ? (String)value : this.gson.toJson(value);
        map.put(key, string);
    }

    @Nullable
    public final String getValue(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.storageMap.get(key);
    }

    public final void removeValue(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.storageMap.remove(key);
    }

    public final void clear() {
        this.storageMap.clear();
    }
}

