/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.plugin;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.jcef.JBCefApp;
import com.sina.weibo.agent.core.PluginContext;
import com.sina.weibo.agent.extensions.core.ExtensionConfigurationManager;
import com.sina.weibo.agent.extensions.core.ExtensionManager;
import com.sina.weibo.agent.plugin.SystemObjectProvider;
import com.sina.weibo.agent.plugin.WecoderPluginService;
import com.sina.weibo.agent.webview.WebViewManager;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/sina/weibo/agent/plugin/WecoderPlugin;", "Lcom/intellij/openapi/startup/StartupActivity$DumbAware;", "<init>", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "canProceedWithInitialization", "", "configManager", "Lcom/sina/weibo/agent/extensions/core/ExtensionConfigurationManager;", "startConfigurationMonitoring", "Companion", "coderider-kilo-jetbrains"})
public final class WecoderPlugin
implements StartupActivity.DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runActivity(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        long tRunStart = System.nanoTime();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        int n = 0;
        int n2 = 8;
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String traceId = string3;
        PluginContext.Companion.getInstance(project).startTraceSession(traceId, tRunStart);
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)"com.gitlab.coderider-kilo"));
        Object object = plugin;
        if (object == null || (object = object.getVersion()) == null) {
            object = "unknown";
        }
        Object object2 = object;
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        LOG.info("Initializing RunVSAgent plugin for project: " + project.getName() + ", OS: " + osName + " " + osVersion + " (" + osArch + "), IDE: " + appInfo.getFullApplicationName() + " (build " + appInfo.getBuild() + "), Plugin version: " + (String)object2 + ", JCEF supported: " + JBCefApp.isSupported());
        try {
            String configuredExtensionId;
            int retryCount;
            long tCfgInit = System.nanoTime();
            ExtensionConfigurationManager configManager = ExtensionConfigurationManager.Companion.getInstance(project);
            configManager.initialize();
            LOG.info("[Perf][traceId=" + traceId + "] configManager.initialize took " + (System.nanoTime() - tCfgInit) / (long)1000000 + " ms");
            long tCfgWait = System.nanoTime();
            int maxRetries = 10;
            for (retryCount = 0; !configManager.isConfigurationLoaded() && retryCount < maxRetries; ++retryCount) {
                Thread.sleep(100L);
            }
            LOG.info("[Perf][traceId=" + traceId + "] wait config loaded took " + (System.nanoTime() - tCfgWait) / (long)1000000 + " ms (retries=" + retryCount + ")");
            if (!this.canProceedWithInitialization(configManager)) {
                boolean allowAutoCreate = Boolean.parseBoolean(System.getProperty("runvsagent.auto.create.config", "true"));
                if (!allowAutoCreate) {
                    LOG.warn("Plugin initialization paused due to invalid configuration");
                    LOG.warn("To enable auto-creation of default configuration, set system property: -Drunvsagent.auto.create.config=true");
                    LOG.warn("Or manually create/fix .vscode-agent file");
                    LOG.warn("Then restart the IDE or reload the project to continue");
                    return;
                }
                LOG.info("Auto-creation of default configuration is enabled, attempting to create...");
                configManager.createDefaultConfiguration();
                if (!this.canProceedWithInitialization(configManager)) {
                    LOG.warn("Failed to create valid configuration, plugin initialization paused");
                    LOG.warn("Please manually create or fix .vscode-agent file");
                    LOG.warn("Then restart the IDE or reload the project to continue");
                    return;
                }
                LOG.info("Default configuration created successfully, continuing initialization");
            }
            if ((configuredExtensionId = configManager.getCurrentExtensionId()) != null) {
                long tExtMgrInit = System.nanoTime();
                ExtensionManager extensionManager = ExtensionManager.Companion.getInstance(project);
                extensionManager.initialize(configuredExtensionId);
                extensionManager.initializeCurrentProvider();
                LOG.info("[Perf][traceId=" + traceId + "] ExtensionManager initialize took " + (System.nanoTime() - tExtMgrInit) / (long)1000000 + " ms");
                WecoderPluginService pluginService = Companion.getInstance(project);
                long tSvcInitCall = System.nanoTime();
                pluginService.initialize(project);
                LOG.info("[Perf][traceId=" + traceId + "] WecoderPluginService.initialize() call returned in " + (System.nanoTime() - tSvcInitCall) / (long)1000000 + " ms (async init continues)");
                WebViewManager webViewManager = (WebViewManager)project.getService(WebViewManager.class);
                Disposer.register((Disposable)((Disposable)project), (Disposable)webViewManager);
                this.startConfigurationMonitoring(project, configManager);
                Disposer.register((Disposable)((Disposable)project), () -> WecoderPlugin.runActivity$lambda$0(project, pluginService, extensionManager));
                LOG.info("RunVSAgent plugin initialized successfully for project: " + project.getName());
                LOG.info("[Perf][traceId=" + traceId + "] runActivity completed in " + (System.nanoTime() - tRunStart) / (long)1000000 + " ms (not including async steps)");
                return;
            }
            LOG.info("Configuration is valid but no extension ID found, plugin initialization paused");
            return;
        }
        catch (Exception e) {
            LOG.info("Failed to initialize RunVSAgent plugin", (Throwable)e);
        }
    }

    private final boolean canProceedWithInitialization(ExtensionConfigurationManager configManager) {
        if (!configManager.isConfigurationLoaded()) {
            LOG.warn("Configuration not yet loaded, cannot proceed with initialization");
            return false;
        }
        if (!configManager.isConfigurationValid()) {
            LOG.warn("Configuration is invalid, cannot proceed with initialization");
            return false;
        }
        String extensionId = configManager.getCurrentExtensionId();
        CharSequence charSequence = extensionId;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            LOG.warn("No valid extension ID found in configuration");
            return false;
        }
        LOG.info("Configuration validation passed, extension ID: " + extensionId);
        return true;
    }

    private final void startConfigurationMonitoring(Project project, ExtensionConfigurationManager configManager) {
        Thread thread;
        Thread $this$startConfigurationMonitoring_u24lambda_u242 = thread = new Thread(() -> WecoderPlugin.startConfigurationMonitoring$lambda$1(project, configManager));
        boolean bl = false;
        $this$startConfigurationMonitoring_u24lambda_u242.setDaemon(true);
        $this$startConfigurationMonitoring_u24lambda_u242.setName("RunVSAgent-ConfigMonitor");
        $this$startConfigurationMonitoring_u24lambda_u242.start();
    }

    private static final void runActivity$lambda$0(Project $project, WecoderPluginService $pluginService, ExtensionManager $extensionManager) {
        LOG.info("Disposing RunVSAgent plugin for project: " + $project.getName());
        $pluginService.dispose();
        $extensionManager.dispose();
        SystemObjectProvider.INSTANCE.dispose();
    }

    private static final void startConfigurationMonitoring$lambda$1(Project $project, ExtensionConfigurationManager $configManager) {
        try {
            while (!$project.isDisposed()) {
                Thread.sleep(5000L);
                if ($project.isDisposed()) continue;
                $configManager.checkConfigurationChange();
                if (!$configManager.isConfigurationValid()) {
                    String string = $configManager.getConfigurationError();
                    if (string == null) {
                        string = "Unknown configuration error";
                    }
                    String errorMsg = string;
                    LOG.warn("Configuration still invalid: " + errorMsg);
                    LOG.warn("Configuration file: " + $configManager.getConfigurationFilePath());
                    LOG.warn("Plugin functionality is paused due to invalid configuration");
                    LOG.warn("Please fix the configuration and restart the IDE to continue");
                    continue;
                }
                if (System.currentTimeMillis() % (long)60000 >= 5000L) continue;
                LOG.info("Configuration status: Valid (" + $configManager.getCurrentExtensionId() + ")");
            }
        }
        catch (InterruptedException e) {
            LOG.info("Configuration monitoring interrupted");
        }
        catch (Exception e) {
            LOG.info("Error in configuration monitoring", (Throwable)e);
        }
    }

    @JvmStatic
    @Nullable
    public static final String getProjectBasePath(@NotNull Project project) {
        return Companion.getProjectBasePath(project);
    }

    static {
        Logger logger = Logger.getInstance(WecoderPlugin.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/sina/weibo/agent/plugin/WecoderPlugin$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/sina/weibo/agent/plugin/WecoderPluginService;", "project", "Lcom/intellij/openapi/project/Project;", "getProjectBasePath", "", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WecoderPluginService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            WecoderPluginService wecoderPluginService = (WecoderPluginService)project.getService(WecoderPluginService.class);
            if (wecoderPluginService == null) {
                throw new IllegalStateException("WecoderPluginService not found".toString());
            }
            return wecoderPluginService;
        }

        @JvmStatic
        @Nullable
        public final String getProjectBasePath(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return project.getBasePath();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

