/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.model;

import com.sina.weibo.agent.model.PositionTranslationChange;
import com.sina.weibo.agent.model.PositionWithChange;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0000J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0000J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0000J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0000J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0000J\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0000J\u001a\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0013\u001a\u00020\u00032\b\b\u0002\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016J#\u0010\u0017\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0019J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\""}, d2={"Lcom/sina/weibo/agent/model/Position;", "", "line", "", "character", "<init>", "(II)V", "getLine", "()I", "getCharacter", "isBefore", "", "other", "isBeforeOrEqual", "isAfter", "isAfterOrEqual", "isEqual", "compareTo", "translate", "lineDelta", "characterDelta", "change", "Lcom/sina/weibo/agent/model/PositionTranslationChange;", "with", "(Ljava/lang/Integer;Ljava/lang/Integer;)Lcom/sina/weibo/agent/model/Position;", "Lcom/sina/weibo/agent/model/PositionWithChange;", "component1", "component2", "copy", "equals", "hashCode", "toString", "", "Companion", "coderider-kilo-jetbrains"})
public final class Position {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int line;
    private final int character;
    @NotNull
    private static final Position ZERO = new Position(0, 0);

    public Position(int line, int character) {
        this.line = line;
        this.character = character;
    }

    public final int getLine() {
        return this.line;
    }

    public final int getCharacter() {
        return this.character;
    }

    public final boolean isBefore(@NotNull Position other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.line < other.line || this.line == other.line && this.character < other.character;
    }

    public final boolean isBeforeOrEqual(@NotNull Position other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.line < other.line || this.line == other.line && this.character <= other.character;
    }

    public final boolean isAfter(@NotNull Position other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.line > other.line || this.line == other.line && this.character > other.character;
    }

    public final boolean isAfterOrEqual(@NotNull Position other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.line > other.line || this.line == other.line && this.character >= other.character;
    }

    public final boolean isEqual(@NotNull Position other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.line == other.line && this.character == other.character;
    }

    public final int compareTo(@NotNull Position other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int lineComparison = Intrinsics.compare((int)this.line, (int)other.line);
        return lineComparison != 0 ? lineComparison : Intrinsics.compare((int)this.character, (int)other.character);
    }

    @NotNull
    public final Position translate(int lineDelta, int characterDelta) {
        return new Position(this.line + lineDelta, this.character + characterDelta);
    }

    public static /* synthetic */ Position translate$default(Position position, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return position.translate(n, n2);
    }

    @NotNull
    public final Position translate(@NotNull PositionTranslationChange change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        Integer n = change.getLineDelta();
        int newLine = this.line + (n != null ? n : 0);
        Integer n2 = change.getCharacterDelta();
        int newCharacter = this.character + (n2 != null ? n2 : 0);
        return newLine == this.line && newCharacter == this.character ? this : new Position(newLine, newCharacter);
    }

    @NotNull
    public final Position with(@Nullable Integer line, @Nullable Integer character) {
        Integer n = line;
        int newLine = n != null ? n : this.line;
        Integer n2 = character;
        int newCharacter = n2 != null ? n2 : this.character;
        return newLine == this.line && newCharacter == this.character ? this : new Position(newLine, newCharacter);
    }

    public static /* synthetic */ Position with$default(Position position, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = null;
        }
        if ((n3 & 2) != 0) {
            n2 = null;
        }
        return position.with(n, n2);
    }

    @NotNull
    public final Position with(@NotNull PositionWithChange change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        Integer n = change.getLine();
        int newLine = n != null ? n : this.line;
        Integer n2 = change.getCharacter();
        int newCharacter = n2 != null ? n2 : this.character;
        return newLine == this.line && newCharacter == this.character ? this : new Position(newLine, newCharacter);
    }

    public final int component1() {
        return this.line;
    }

    public final int component2() {
        return this.character;
    }

    @NotNull
    public final Position copy(int line, int character) {
        return new Position(line, character);
    }

    public static /* synthetic */ Position copy$default(Position position, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = position.line;
        }
        if ((n3 & 2) != 0) {
            n2 = position.character;
        }
        return position.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "Position(line=" + this.line + ", character=" + this.character + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.line);
        result = result * 31 + Integer.hashCode(this.character);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Position)) {
            return false;
        }
        Position position = (Position)other;
        if (this.line != position.line) {
            return false;
        }
        return this.character == position.character;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/sina/weibo/agent/model/Position$Companion;", "", "<init>", "()V", "ZERO", "Lcom/sina/weibo/agent/model/Position;", "getZERO", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Position getZERO() {
            return ZERO;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

