/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.model;

import com.sina.weibo.agent.model.Position;
import com.sina.weibo.agent.model.Range;
import com.sina.weibo.agent.util.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/sina/weibo/agent/model/Location;", "", "uri", "Lcom/sina/weibo/agent/util/URI;", "range", "Lcom/sina/weibo/agent/model/Range;", "<init>", "(Lcom/sina/weibo/agent/util/URI;Lcom/sina/weibo/agent/model/Range;)V", "position", "Lcom/sina/weibo/agent/model/Position;", "(Lcom/sina/weibo/agent/util/URI;Lcom/sina/weibo/agent/model/Position;)V", "getUri", "()Lcom/sina/weibo/agent/util/URI;", "getRange", "()Lcom/sina/weibo/agent/model/Range;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "coderider-kilo-jetbrains"})
public final class Location {
    @NotNull
    private final URI uri;
    @NotNull
    private final Range range;

    public Location(@NotNull URI uri, @NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.uri = uri;
        this.range = range;
    }

    @NotNull
    public final URI getUri() {
        return this.uri;
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    public Location(@NotNull URI uri, @NotNull Position position) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this(uri, new Range(position, position));
    }

    @NotNull
    public final URI component1() {
        return this.uri;
    }

    @NotNull
    public final Range component2() {
        return this.range;
    }

    @NotNull
    public final Location copy(@NotNull URI uri, @NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return new Location(uri, range);
    }

    public static /* synthetic */ Location copy$default(Location location, URI uRI, Range range, int n, Object object) {
        if ((n & 1) != 0) {
            uRI = location.uri;
        }
        if ((n & 2) != 0) {
            range = location.range;
        }
        return location.copy(uRI, range);
    }

    @NotNull
    public String toString() {
        return "Location(uri=" + this.uri + ", range=" + this.range + ")";
    }

    public int hashCode() {
        int result = this.uri.hashCode();
        result = result * 31 + this.range.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Location)) {
            return false;
        }
        Location location = (Location)other;
        if (!Intrinsics.areEqual((Object)this.uri, (Object)location.uri)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.range, (Object)location.range);
    }
}

