/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.ipc.proxy.uri;

import com.intellij.openapi.diagnostic.Logger;
import com.sina.weibo.agent.ipc.ISocket;
import com.sina.weibo.agent.ipc.PersistentProtocol;
import com.sina.weibo.agent.ipc.proxy.RPCProtocol;
import com.sina.weibo.agent.ipc.proxy.uri.IURITransformer;
import com.sina.weibo.agent.ipc.proxy.uri.UriReplacer;
import com.sina.weibo.agent.ipc.proxy.uri.UriTransformerKt;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/sina/weibo/agent/ipc/proxy/uri/UriTransformerExample;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "uriTransformerExample", "", "rpcWithUriTransformerExample", "socket", "Lcom/sina/weibo/agent/ipc/ISocket;", "coderider-kilo-jetbrains"})
public final class UriTransformerExample {
    @NotNull
    public static final UriTransformerExample INSTANCE = new UriTransformerExample();
    @NotNull
    private static final Logger LOG;

    private UriTransformerExample() {
    }

    public final void uriTransformerExample() {
        String remoteAuthority = "your-remote-host.example.com";
        IURITransformer uriTransformer = UriTransformerKt.createURITransformer(remoteAuthority);
        URI localUri = new URI("file:///path/to/file.txt");
        URI remoteUri = uriTransformer.transformOutgoing(localUri);
        LOG.info("Transformed URI: " + remoteUri);
        URI convertedBackUri = uriTransformer.transformIncoming(remoteUri);
        LOG.info("Transformed back URI: " + convertedBackUri);
        UriReplacer uriReplacer = new UriReplacer(uriTransformer);
        Object result = uriReplacer.invoke("documentUri", (Object)"file:///path/to/document.txt");
        LOG.info("Replaced URI: " + result);
    }

    public final void rpcWithUriTransformerExample(@NotNull ISocket socket) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        String remoteAuthority = "your-remote-host.example.com";
        IURITransformer uriTransformer = UriTransformerKt.createURITransformer(remoteAuthority);
        PersistentProtocol persistentProtocol = new PersistentProtocol(new PersistentProtocol.PersistentProtocolOptions(socket, null, null, false, 14, null), null, 2, null);
        RPCProtocol rpcProtocol = new RPCProtocol(persistentProtocol, null, uriTransformer);
    }

    static {
        Logger logger = Logger.getInstance(UriTransformerExample.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

