/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.ipc.proxy.uri;

import com.sina.weibo.agent.ipc.proxy.uri.IRawURITransformer;
import com.sina.weibo.agent.ipc.proxy.uri.IURITransformer;
import com.sina.weibo.agent.ipc.proxy.uri.UriParts;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/sina/weibo/agent/ipc/proxy/uri/URITransformer;", "Lcom/sina/weibo/agent/ipc/proxy/uri/IURITransformer;", "transformer", "Lcom/sina/weibo/agent/ipc/proxy/uri/IRawURITransformer;", "<init>", "(Lcom/sina/weibo/agent/ipc/proxy/uri/IRawURITransformer;)V", "transformIncoming", "Ljava/net/URI;", "uri", "transformOutgoing", "transformOutgoingURI", "", "buildURI", "parts", "Lcom/sina/weibo/agent/ipc/proxy/uri/UriParts;", "coderider-kilo-jetbrains"})
public final class URITransformer
implements IURITransformer {
    @NotNull
    private final IRawURITransformer transformer;

    public URITransformer(@NotNull IRawURITransformer transformer) {
        Intrinsics.checkNotNullParameter((Object)transformer, (String)"transformer");
        this.transformer = transformer;
    }

    @Override
    @NotNull
    public URI transformIncoming(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = uri.getScheme();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScheme(...)");
        String string2 = uri.getAuthority();
        String string3 = uri.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
        UriParts uriParts = new UriParts(string, string2, string3, uri.getQuery(), uri.getFragment());
        UriParts transformedParts = this.transformer.transformIncoming(uriParts);
        return this.buildURI(transformedParts);
    }

    @Override
    @NotNull
    public URI transformOutgoing(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = uri.getScheme();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScheme(...)");
        String string2 = uri.getAuthority();
        String string3 = uri.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
        UriParts uriParts = new UriParts(string, string2, string3, uri.getQuery(), uri.getFragment());
        UriParts transformedParts = this.transformer.transformOutgoing(uriParts);
        return this.buildURI(transformedParts);
    }

    @Override
    @NotNull
    public String transformOutgoingURI(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        try {
            String string = this.transformOutgoing(new URI(uri)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        catch (Exception e) {
            int schemeEndIndex = StringsKt.indexOf$default((CharSequence)uri, (char)':', (int)0, (boolean)false, (int)6, null);
            if (schemeEndIndex > 0) {
                String string = uri.substring(0, schemeEndIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String scheme = string;
                String transformedScheme = this.transformer.transformOutgoingScheme(scheme);
                if (transformedScheme != scheme) {
                    String string2 = uri.substring(schemeEndIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    return transformedScheme + string2;
                }
            }
            return uri;
        }
    }

    private final URI buildURI(UriParts parts) {
        StringBuilder builder2 = new StringBuilder();
        builder2.append(parts.getScheme()).append(":");
        CharSequence charSequence = parts.getAuthority();
        if (!(charSequence == null || charSequence.length() == 0)) {
            builder2.append("//").append(parts.getAuthority());
        }
        builder2.append(parts.getPath());
        charSequence = parts.getQuery();
        if (!(charSequence == null || charSequence.length() == 0)) {
            builder2.append("?").append(parts.getQuery());
        }
        if (!((charSequence = (CharSequence)parts.getFragment()) == null || charSequence.length() == 0)) {
            builder2.append("#").append(parts.getFragment());
        }
        return new URI(builder2.toString());
    }
}

