/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.ipc.proxy.logger;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.sina.weibo.agent.ipc.proxy.IRPCProtocolLogger;
import com.sina.weibo.agent.ipc.proxy.RequestInitiator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u001d\u001a\u00020\u001eH\u0002J2\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00132\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J2\u0010'\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00132\b\u0010%\u001a\u0004\u0018\u00010&H\u0016JB\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\t2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00132\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0012\u0010+\u001a\u00020\u00132\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0010\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020\u001eH\u0016R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/sina/weibo/agent/ipc/proxy/logger/FileRPCProtocolLogger;", "Lcom/sina/weibo/agent/ipc/proxy/IRPCProtocolLogger;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "totalIncoming", "", "totalOutgoing", "logDir", "Ljava/nio/file/Path;", "logFile", "Ljava/io/File;", "writer", "Ljava/io/BufferedWriter;", "logQueue", "Ljava/util/concurrent/LinkedBlockingQueue;", "", "isInitialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isDisposed", "loggerThread", "Ljava/lang/Thread;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "isEnabled", "", "startLoggerThread", "", "logIncoming", "msgLength", "req", "initiator", "Lcom/sina/weibo/agent/ipc/proxy/RequestInitiator;", "str", "data", "", "logOutgoing", "logMessage", "direction", "totalLength", "stringify", "formatTimestampWithMilliseconds", "date", "Ljava/util/Date;", "dispose", "coderider-kilo-jetbrains"})
public final class FileRPCProtocolLogger
implements IRPCProtocolLogger,
Disposable {
    @NotNull
    private final Logger logger;
    private int totalIncoming;
    private int totalOutgoing;
    @Nullable
    private Path logDir;
    @Nullable
    private File logFile;
    @Nullable
    private BufferedWriter writer;
    @NotNull
    private final LinkedBlockingQueue<String> logQueue;
    @NotNull
    private final AtomicBoolean isInitialized;
    @NotNull
    private final AtomicBoolean isDisposed;
    @Nullable
    private Thread loggerThread;
    @NotNull
    private final CoroutineScope coroutineScope;
    private final boolean isEnabled;

    public FileRPCProtocolLogger() {
        Logger logger = Logger.getInstance(FileRPCProtocolLogger.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.logQueue = new LinkedBlockingQueue();
        this.isInitialized = new AtomicBoolean(false);
        this.isDisposed = new AtomicBoolean(false);
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getIO()));
        if (!this.isEnabled) {
            this.logger.warn("FileRPCProtocolLogger not enabled");
        } else {
            String userHome = System.getProperty("user.home");
            String[] stringArray = new String[]{".ext_host", "log"};
            this.logDir = Paths.get(userHome, stringArray);
            if (!Files.exists(this.logDir, new LinkOption[0])) {
                Files.createDirectories(this.logDir, new FileAttribute[0]);
            }
            String timestamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            Path path = this.logDir;
            this.logFile = path != null && (path = path.resolve("rpc_" + timestamp + "-idea.log")) != null ? path.toFile() : null;
            this.writer = new BufferedWriter(new FileWriter(this.logFile));
            this.startLoggerThread();
            String startTime = this.formatTimestampWithMilliseconds(new Date());
            File file = this.logFile;
            String header = StringsKt.trimMargin$default((String)("\n               |-------------------------------------------------------------\n               | IDEA RPC Protocol Logger\n               | Started at: " + startTime + "\n               | Log file: " + (file != null ? file.getAbsolutePath() : null) + "\n               |-------------------------------------------------------------\n           \n           "), null, (int)1, null);
            this.logQueue.add(header);
            this.isInitialized.set(true);
            File file2 = this.logFile;
            this.logger.info("FileRPCProtocolLogger initialized successfully, log file: " + (file2 != null ? file2.getAbsolutePath() : null));
        }
    }

    private final void startLoggerThread() {
        this.loggerThread = ThreadsKt.thread$default((boolean)true, (boolean)true, null, (String)"RPC-Logger", (int)0, () -> FileRPCProtocolLogger.startLoggerThread$lambda$0(this), (int)20, null);
    }

    @Override
    public void logIncoming(int msgLength, int req, @NotNull RequestInitiator initiator, @NotNull String str, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)((Object)initiator), (String)"initiator");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        if (!this.isInitialized.get()) {
            return;
        }
        this.totalIncoming += msgLength;
        this.logMessage("Ext \u2192 IDEA", this.totalIncoming, msgLength, req, initiator, str, data);
    }

    @Override
    public void logOutgoing(int msgLength, int req, @NotNull RequestInitiator initiator, @NotNull String str, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)((Object)initiator), (String)"initiator");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        if (!this.isInitialized.get()) {
            return;
        }
        this.totalOutgoing += msgLength;
        this.logMessage("IDEA \u2192 Ext", this.totalOutgoing, msgLength, req, initiator, str, data);
    }

    private final void logMessage(String direction, int totalLength, int msgLength, int req, RequestInitiator initiator, String str, Object data) {
        try {
            String timestamp = this.formatTimestampWithMilliseconds(new Date());
            String initiatorStr = switch (WhenMappings.$EnumSwitchMapping$0[initiator.ordinal()]) {
                case 1 -> "Local";
                case 2 -> "Other";
                default -> throw new NoWhenBranchMatchedException();
            };
            StringBuilder logEntry = new StringBuilder();
            logEntry.append("[" + timestamp + "] ");
            logEntry.append("[" + direction + "] ");
            logEntry.append("[Total: " + StringsKt.padStart$default((String)String.valueOf(totalLength), (int)7, (char)'\u0000', (int)2, null) + "] ");
            logEntry.append("[Len: " + StringsKt.padStart$default((String)String.valueOf(msgLength), (int)5, (char)'\u0000', (int)2, null) + "] ");
            logEntry.append("[" + StringsKt.padStart$default((String)String.valueOf(req), (int)5, (char)'\u0000', (int)2, null) + "] ");
            logEntry.append("[" + initiatorStr + "] ");
            logEntry.append(str);
            if (data != null) {
                Object dataStr = StringsKt.endsWith$default((String)str, (String)"(", (boolean)false, (int)2, null) ? data + ")" : data.toString();
                logEntry.append(" ").append((String)dataStr);
            }
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, logEntry, null){
                int label;
                final /* synthetic */ FileRPCProtocolLogger this$0;
                final /* synthetic */ StringBuilder $logEntry;
                {
                    this.this$0 = $receiver;
                    this.$logEntry = $logEntry;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            FileRPCProtocolLogger.access$getLogQueue$p(this.this$0).add(this.$logEntry.toString());
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        catch (Exception e) {
            this.logger.error("Failed to format log message", (Throwable)e);
        }
    }

    private final String stringify(Object data) {
        Object object;
        try {
            String string;
            object = data;
            if (object instanceof Map) {
                string = data.toString();
            } else if (object instanceof Collection) {
                string = data.toString();
            } else if (object instanceof Object[]) {
                String string2 = Arrays.toString((Object[])data);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            } else {
                string = String.valueOf(data);
            }
            object = string;
        }
        catch (Exception e) {
            object = "Unserializable data: " + e.getMessage();
        }
        return object;
    }

    private final String formatTimestampWithMilliseconds(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        String month = StringsKt.padStart((String)String.valueOf(calendar.get(2) + 1), (int)2, (char)'0');
        String day = StringsKt.padStart((String)String.valueOf(calendar.get(5)), (int)2, (char)'0');
        String hours = StringsKt.padStart((String)String.valueOf(calendar.get(11)), (int)2, (char)'0');
        String minutes = StringsKt.padStart((String)String.valueOf(calendar.get(12)), (int)2, (char)'0');
        String seconds = StringsKt.padStart((String)String.valueOf(calendar.get(13)), (int)2, (char)'0');
        String milliseconds = StringsKt.padStart((String)String.valueOf(calendar.get(14)), (int)3, (char)'0');
        return year + "-" + month + "-" + day + " " + hours + ":" + minutes + ":" + seconds + "." + milliseconds;
    }

    public void dispose() {
        if (this.isDisposed.getAndSet(true)) {
            return;
        }
        try {
            String endTime = this.formatTimestampWithMilliseconds(new Date());
            String footer = StringsKt.trimMargin$default((String)("\n               |-------------------------------------------------------------\n               | IDEA RPC Protocol Logger\n               | Ended at: " + endTime + "\n               | Total incoming: " + this.totalIncoming + " bytes\n               | Total outgoing: " + this.totalOutgoing + " bytes\n               |-------------------------------------------------------------\n           "), null, (int)1, null);
            this.logQueue.add(footer);
            for (int retries = 0; !((Collection)this.logQueue).isEmpty() && retries < 10; ++retries) {
                Thread.sleep(100L);
            }
            BufferedWriter bufferedWriter = this.writer;
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
            this.writer = null;
            Thread thread = this.loggerThread;
            if (thread != null) {
                thread.interrupt();
            }
            this.loggerThread = null;
            this.logger.info("FileRPCProtocolLogger released");
        }
        catch (Exception e) {
            this.logger.error("Failed to release FileRPCProtocolLogger", (Throwable)e);
        }
    }

    private static final Unit startLoggerThread$lambda$0(FileRPCProtocolLogger this$0) {
        try {
            while (!this$0.isDisposed.get()) {
                Unit unit;
                String logEntry = this$0.logQueue.take();
                try {
                    Unit unit2;
                    BufferedWriter bufferedWriter = this$0.writer;
                    if (bufferedWriter != null) {
                        bufferedWriter.write(logEntry);
                    }
                    BufferedWriter bufferedWriter2 = this$0.writer;
                    if (bufferedWriter2 != null) {
                        bufferedWriter2.newLine();
                    }
                    BufferedWriter bufferedWriter3 = this$0.writer;
                    if (bufferedWriter3 != null) {
                        bufferedWriter3.flush();
                        unit2 = Unit.INSTANCE;
                    } else {
                        unit2 = null;
                    }
                    unit = unit2;
                }
                catch (Exception e) {
                    this$0.logger.error("Failed to write log file", (Throwable)e);
                    unit = Unit.INSTANCE;
                }
            }
        }
        catch (InterruptedException logEntry) {
        }
        catch (Exception e) {
            this$0.logger.error("Logger thread exception", (Throwable)e);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ LinkedBlockingQueue access$getLogQueue$p(FileRPCProtocolLogger $this) {
        return $this.logQueue;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RequestInitiator.values().length];
            try {
                nArray[RequestInitiator.LocalSide.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestInitiator.OtherSide.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

