/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.ipc;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.sina.weibo.agent.ipc.BufferedEmitter;
import com.sina.weibo.agent.ipc.ILoadEstimator;
import com.sina.weibo.agent.ipc.IMessagePassingProtocol;
import com.sina.weibo.agent.ipc.ISocket;
import com.sina.weibo.agent.ipc.LoadEstimator;
import com.sina.weibo.agent.ipc.MessageListener;
import com.sina.weibo.agent.ipc.ProtocolMessage;
import com.sina.weibo.agent.ipc.ProtocolMessageType;
import com.sina.weibo.agent.ipc.ProtocolReader;
import com.sina.weibo.agent.ipc.ProtocolWriter;
import com.sina.weibo.agent.ipc.SocketCloseEvent;
import com.sina.weibo.agent.ipc.SocketTimeoutEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0010\u0018\u0000 \\2\u00020\u0001:\u0002\\]B6\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012%\b\u0002\u0010\u0004\u001a\u001f\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n\u0018\u00010\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010:\u001a\u00020,J\b\u0010;\u001a\u00020\nH\u0016J\u000e\u0010<\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010=J\u0010\u0010>\u001a\u00020\n2\u0006\u0010?\u001a\u00020\u0006H\u0016J\u0010\u0010@\u001a\u00020(2\u0006\u0010A\u001a\u00020BH\u0016J\u0016\u0010C\u001a\u00020(2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\n0DH\u0016J\u001a\u0010E\u001a\u00020(2\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\u0005J\u001a\u0010F\u001a\u00020(2\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\n0\u0005J\u001a\u0010G\u001a\u00020(2\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020\n0\u0005J\u0006\u0010H\u001a\u00020\nJ\u0006\u0010I\u001a\u00020\nJ\u0006\u0010J\u001a\u00020\nJ\u0006\u0010K\u001a\u00020\nJ\u0006\u0010L\u001a\u00020!J\u0006\u0010M\u001a\u00020NJ\u0018\u0010O\u001a\u00020\n2\u0006\u0010P\u001a\u00020!2\b\u0010Q\u001a\u0004\u0018\u00010\u0006J\u0006\u0010R\u001a\u00020\nJ\u0006\u0010S\u001a\u00020\nJ\u0010\u0010T\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0012H\u0002J\u0006\u0010U\u001a\u00020\u0006J\u0006\u0010V\u001a\u00020\nJ\u000e\u0010W\u001a\u00020\n2\u0006\u0010?\u001a\u00020\u0006J\b\u0010X\u001a\u00020\nH\u0002J\b\u0010Y\u001a\u00020\nH\u0002J\b\u0010Z\u001a\u00020\nH\u0002J\b\u0010[\u001a\u00020\nH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00060.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00120.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020\n0.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\b\u0012\u0004\u0012\u0002020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\b\u0012\u0004\u0012\u0002040.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00106\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\b8\u00109\u00a8\u0006^"}, d2={"Lcom/sina/weibo/agent/ipc/PersistentProtocol;", "Lcom/sina/weibo/agent/ipc/IMessagePassingProtocol;", "opts", "Lcom/sina/weibo/agent/ipc/PersistentProtocol$PersistentProtocolOptions;", "msgListener", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "msg", "", "<init>", "(Lcom/sina/weibo/agent/ipc/PersistentProtocol$PersistentProtocolOptions;Lkotlin/jvm/functions/Function1;)V", "_isReconnecting", "Ljava/util/concurrent/atomic/AtomicBoolean;", "_didSendDisconnect", "_outgoingUnackMsg", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lcom/sina/weibo/agent/ipc/ProtocolMessage;", "_outgoingMsgId", "Ljava/util/concurrent/atomic/AtomicInteger;", "_outgoingAckId", "_outgoingAckTimeout", "Ljava/util/Timer;", "_incomingMsgId", "_incomingAckId", "_incomingMsgLastTime", "Ljava/util/concurrent/atomic/AtomicLong;", "_incomingAckTimeout", "_keepAliveInterval", "_lastReplayRequestTime", "_lastSocketTimeoutTime", "_socket", "Lcom/sina/weibo/agent/ipc/ISocket;", "_socketWriter", "Lcom/sina/weibo/agent/ipc/ProtocolWriter;", "_socketReader", "Lcom/sina/weibo/agent/ipc/ProtocolReader;", "_socketDisposables", "", "Lcom/intellij/openapi/Disposable;", "_loadEstimator", "Lcom/sina/weibo/agent/ipc/ILoadEstimator;", "_shouldSendKeepAlive", "", "_onControlMessage", "Lcom/sina/weibo/agent/ipc/BufferedEmitter;", "_onMessage", "_onDidDispose", "_onSocketClose", "Lcom/sina/weibo/agent/ipc/SocketCloseEvent;", "_onSocketTimeout", "Lcom/sina/weibo/agent/ipc/SocketTimeoutEvent;", "_isDisposed", "unacknowledgedCount", "", "getUnacknowledgedCount", "()I", "isDisposed", "dispose", "drain", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "send", "buffer", "onMessage", "listener", "Lcom/sina/weibo/agent/ipc/MessageListener;", "onDidDispose", "Lkotlin/Function0;", "onControlMessage", "onSocketClose", "onSocketTimeout", "sendDisconnect", "sendPause", "sendResume", "pauseSocketWriting", "getSocket", "getMillisSinceLastIncomingData", "", "beginAcceptReconnection", "socket", "initialDataChunk", "endAcceptReconnection", "acceptDisconnect", "_receiveMessage", "readEntireBuffer", "flush", "sendControl", "_sendAckCheck", "_recvAckCheck", "_sendAck", "_sendKeepAlive", "Companion", "PersistentProtocolOptions", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nPersistentProtocol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentProtocol.kt\ncom/sina/weibo/agent/ipc/PersistentProtocol\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,445:1\n1869#2,2:446\n1869#2,2:448\n37#3:450\n36#3,3:451\n37#3:454\n36#3,3:455\n*S KotlinDebug\n*F\n+ 1 PersistentProtocol.kt\ncom/sina/weibo/agent/ipc/PersistentProtocol\n*L\n125#1:446,2\n203#1:448,2\n234#1:450\n234#1:451,3\n295#1:454\n295#1:455,3\n*E\n"})
public final class PersistentProtocol
implements IMessagePassingProtocol {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicBoolean _isReconnecting;
    @NotNull
    private final AtomicBoolean _didSendDisconnect;
    @NotNull
    private final LinkedBlockingQueue<ProtocolMessage> _outgoingUnackMsg;
    @NotNull
    private final AtomicInteger _outgoingMsgId;
    @NotNull
    private final AtomicInteger _outgoingAckId;
    @Nullable
    private Timer _outgoingAckTimeout;
    @NotNull
    private final AtomicInteger _incomingMsgId;
    @NotNull
    private final AtomicInteger _incomingAckId;
    @NotNull
    private final AtomicLong _incomingMsgLastTime;
    @Nullable
    private Timer _incomingAckTimeout;
    @Nullable
    private Timer _keepAliveInterval;
    @NotNull
    private final AtomicLong _lastReplayRequestTime;
    @NotNull
    private final AtomicLong _lastSocketTimeoutTime;
    @NotNull
    private ISocket _socket;
    @NotNull
    private ProtocolWriter _socketWriter;
    @NotNull
    private ProtocolReader _socketReader;
    @NotNull
    private final List<Disposable> _socketDisposables;
    @NotNull
    private final ILoadEstimator _loadEstimator;
    private final boolean _shouldSendKeepAlive;
    @NotNull
    private final BufferedEmitter<byte[]> _onControlMessage;
    @NotNull
    private final BufferedEmitter<ProtocolMessage> _onMessage;
    @NotNull
    private final BufferedEmitter<Unit> _onDidDispose;
    @NotNull
    private final BufferedEmitter<SocketCloseEvent> _onSocketClose;
    @NotNull
    private final BufferedEmitter<SocketTimeoutEvent> _onSocketTimeout;
    private boolean _isDisposed;
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    public PersistentProtocol(@NotNull PersistentProtocolOptions opts, @Nullable Function1<? super byte[], Unit> msgListener) {
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        this._isReconnecting = new AtomicBoolean(false);
        this._didSendDisconnect = new AtomicBoolean(false);
        this._outgoingUnackMsg = new LinkedBlockingQueue();
        this._outgoingMsgId = new AtomicInteger(0);
        this._outgoingAckId = new AtomicInteger(0);
        this._incomingMsgId = new AtomicInteger(0);
        this._incomingAckId = new AtomicInteger(0);
        this._incomingMsgLastTime = new AtomicLong(0L);
        this._lastReplayRequestTime = new AtomicLong(0L);
        this._lastSocketTimeoutTime = new AtomicLong(System.currentTimeMillis());
        this._socketDisposables = new ArrayList();
        this._onControlMessage = new BufferedEmitter();
        this._onMessage = new BufferedEmitter();
        this._onDidDispose = new BufferedEmitter();
        this._onSocketClose = new BufferedEmitter();
        this._onSocketTimeout = new BufferedEmitter();
        ILoadEstimator iLoadEstimator = opts.getLoadEstimator();
        if (iLoadEstimator == null) {
            iLoadEstimator = LoadEstimator.Companion.getInstance();
        }
        this._loadEstimator = iLoadEstimator;
        this._shouldSendKeepAlive = opts.getSendKeepAlive();
        this._socket = opts.getSocket();
        this._socketWriter = new ProtocolWriter(this._socket, false, 2, null);
        this._socketReader = new ProtocolReader(this._socket);
        this._socketDisposables.add(this._socketReader.onMessage((Function1<? super ProtocolMessage, Unit>)((Function1)new Function1<ProtocolMessage, Unit>((Object)this){

            public final void invoke(ProtocolMessage p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((PersistentProtocol)this.receiver)._receiveMessage(p0);
            }
        })));
        this._socketDisposables.add(this._socket.onClose(arg_0 -> PersistentProtocol._init_$lambda$0(this, arg_0)));
        if (opts.getInitialChunk() != null) {
            this._socketReader.acceptChunk(opts.getInitialChunk());
        }
        if (msgListener != null) {
            this._onMessage.getEvent().invoke(arg_0 -> PersistentProtocol._init_$lambda$1(msgListener, arg_0));
        }
        this._socket.startReceiving();
        if (this._shouldSendKeepAlive) {
            void $this$_init__u24lambda_u242;
            Timer timer;
            Timer timer2 = timer = new Timer();
            PersistentProtocol persistentProtocol = this;
            boolean bl = false;
            $this$_init__u24lambda_u242.scheduleAtFixedRate(new TimerTask(this){
                final /* synthetic */ PersistentProtocol this$0;
                {
                    this.this$0 = $receiver;
                }

                public void run() {
                    PersistentProtocol.access$_sendKeepAlive(this.this$0);
                }
            }, 5000L, 5000L);
            persistentProtocol._keepAliveInterval = timer;
        }
    }

    public /* synthetic */ PersistentProtocol(PersistentProtocolOptions persistentProtocolOptions, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        this(persistentProtocolOptions, (Function1<? super byte[], Unit>)function1);
    }

    public final int getUnacknowledgedCount() {
        return this._outgoingMsgId.get() - this._outgoingAckId.get();
    }

    public final boolean isDisposed() {
        return this._isDisposed;
    }

    public void dispose() {
        Timer timer = this._outgoingAckTimeout;
        if (timer != null) {
            timer.cancel();
        }
        this._outgoingAckTimeout = null;
        Timer timer2 = this._incomingAckTimeout;
        if (timer2 != null) {
            timer2.cancel();
        }
        this._incomingAckTimeout = null;
        Timer timer3 = this._keepAliveInterval;
        if (timer3 != null) {
            timer3.cancel();
        }
        this._keepAliveInterval = null;
        Iterable $this$forEach$iv = this._socketDisposables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Disposable it = (Disposable)element$iv;
            boolean bl = false;
            it.dispose();
        }
        this._socketDisposables.clear();
        this._isDisposed = true;
    }

    @Override
    @Nullable
    public Object drain(@NotNull Continuation<? super Unit> $completion) {
        Object object = this._socketWriter.drain($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void send(@NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int myId = this._outgoingMsgId.incrementAndGet();
        int currentIncomingAckId = this._incomingMsgId.get();
        this._incomingAckId.set(currentIncomingAckId);
        ProtocolMessage msg = new ProtocolMessage(ProtocolMessageType.REGULAR, myId, currentIncomingAckId, buffer);
        this._outgoingUnackMsg.add(msg);
        if (!this._isReconnecting.get()) {
            this._socketWriter.write(msg);
            this._recvAckCheck();
        }
    }

    @Override
    @NotNull
    public Disposable onMessage(@NotNull MessageListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        return (Disposable)this._onMessage.getEvent().invoke(arg_0 -> PersistentProtocol.onMessage$lambda$4(listener2, arg_0));
    }

    @Override
    @NotNull
    public Disposable onDidDispose(@NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        return (Disposable)this._onDidDispose.getEvent().invoke(arg_0 -> PersistentProtocol.onDidDispose$lambda$5(listener2, arg_0));
    }

    @NotNull
    public final Disposable onControlMessage(@NotNull Function1<? super byte[], Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        return (Disposable)this._onControlMessage.getEvent().invoke(listener2);
    }

    @NotNull
    public final Disposable onSocketClose(@NotNull Function1<? super SocketCloseEvent, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        return (Disposable)this._onSocketClose.getEvent().invoke(listener2);
    }

    @NotNull
    public final Disposable onSocketTimeout(@NotNull Function1<? super SocketTimeoutEvent, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        return (Disposable)this._onSocketTimeout.getEvent().invoke(listener2);
    }

    public final void sendDisconnect() {
        if (this._didSendDisconnect.compareAndSet(false, true)) {
            ProtocolMessage msg = new ProtocolMessage(ProtocolMessageType.DISCONNECT, 0, 0, new byte[0]);
            this._socketWriter.write(msg);
            this._socketWriter.flush();
        }
    }

    public final void sendPause() {
        ProtocolMessage msg = new ProtocolMessage(ProtocolMessageType.PAUSE, 0, 0, new byte[0]);
        this._socketWriter.write(msg);
    }

    public final void sendResume() {
        ProtocolMessage msg = new ProtocolMessage(ProtocolMessageType.RESUME, 0, 0, new byte[0]);
        this._socketWriter.write(msg);
    }

    public final void pauseSocketWriting() {
        this._socketWriter.pause();
    }

    @NotNull
    public final ISocket getSocket() {
        return this._socket;
    }

    public final long getMillisSinceLastIncomingData() {
        return System.currentTimeMillis() - this._socketReader.getLastReadTime();
    }

    public final void beginAcceptReconnection(@NotNull ISocket socket, @Nullable byte[] initialDataChunk) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        this._isReconnecting.set(true);
        Iterable $this$forEach$iv = this._socketDisposables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Disposable it = (Disposable)element$iv;
            boolean bl = false;
            it.dispose();
        }
        this._socketDisposables.clear();
        this._onControlMessage.flushBuffer();
        this._onSocketClose.flushBuffer();
        this._onSocketTimeout.flushBuffer();
        this._socket.dispose();
        this._lastReplayRequestTime.set(0L);
        this._lastSocketTimeoutTime.set(System.currentTimeMillis());
        this._socket = socket;
        this._socketWriter = new ProtocolWriter(this._socket, false, 2, null);
        this._socketReader = new ProtocolReader(this._socket);
        this._socketDisposables.add(this._socketReader.onMessage((Function1<? super ProtocolMessage, Unit>)((Function1)new Function1<ProtocolMessage, Unit>((Object)this){

            public final void invoke(ProtocolMessage p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                PersistentProtocol.access$_receiveMessage((PersistentProtocol)this.receiver, p0);
            }
        })));
        this._socketDisposables.add(this._socket.onClose(arg_0 -> PersistentProtocol.beginAcceptReconnection$lambda$7(this, arg_0)));
        if (initialDataChunk != null) {
            this._socketReader.acceptChunk(initialDataChunk);
        }
    }

    public final void endAcceptReconnection() {
        this._isReconnecting.set(false);
        int currentIncomingMsgId = this._incomingMsgId.get();
        this._incomingAckId.set(currentIncomingMsgId);
        ProtocolMessage msg = new ProtocolMessage(ProtocolMessageType.ACK, 0, currentIncomingMsgId, new byte[0]);
        this._socketWriter.write(msg);
        Collection $this$toTypedArray$iv = this._outgoingUnackMsg;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        for (ProtocolMessage message : thisCollection$iv.toArray(new ProtocolMessage[0])) {
            Intrinsics.checkNotNull((Object)message);
            this._socketWriter.write(message);
        }
        this._recvAckCheck();
    }

    public final void acceptDisconnect() {
        this._onDidDispose.fire(Unit.INSTANCE);
    }

    private final void _receiveMessage(ProtocolMessage msg) {
        int currentOutgoingAckId = this._outgoingAckId.get();
        if (msg.getAck() > currentOutgoingAckId) {
            ProtocolMessage first;
            this._outgoingAckId.set(msg.getAck());
            while (!((Collection)this._outgoingUnackMsg).isEmpty() && (first = this._outgoingUnackMsg.peek()) != null && first.getId() <= msg.getAck()) {
                this._outgoingUnackMsg.poll();
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$0[msg.getType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                int currentIncomingMsgId = this._incomingMsgId.get();
                if (msg.getId() <= currentIncomingMsgId) break;
                if (msg.getId() != currentIncomingMsgId + 1) {
                    long lastReplayTime;
                    long now = System.currentTimeMillis();
                    if (now - (lastReplayTime = this._lastReplayRequestTime.get()) <= 10000L) break;
                    this._lastReplayRequestTime.set(now);
                    this._socketWriter.write(new ProtocolMessage(ProtocolMessageType.REPLAY_REQUEST, 0, 0, new byte[0]));
                    break;
                }
                this._incomingMsgId.set(msg.getId());
                this._incomingMsgLastTime.set(System.currentTimeMillis());
                this._sendAckCheck();
                this._onMessage.fire(msg);
                break;
            }
            case 3: {
                this._onControlMessage.fire(msg.getData());
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this._onDidDispose.fire(Unit.INSTANCE);
                break;
            }
            case 6: {
                Collection $this$toTypedArray$iv = this._outgoingUnackMsg;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                for (ProtocolMessage message : thisCollection$iv.toArray(new ProtocolMessage[0])) {
                    Intrinsics.checkNotNull((Object)message);
                    this._socketWriter.write(message);
                }
                this._recvAckCheck();
                break;
            }
            case 7: {
                this._socketWriter.pause();
                break;
            }
            case 8: {
                this._socketWriter.resume();
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final byte[] readEntireBuffer() {
        return this._socketReader.readEntireBuffer();
    }

    public final void flush() {
        this._socketWriter.flush();
    }

    public final void sendControl(@NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ProtocolMessage msg = new ProtocolMessage(ProtocolMessageType.CONTROL, 0, 0, buffer);
        this._socketWriter.write(msg);
    }

    /*
     * WARNING - void declaration
     */
    private final void _sendAckCheck() {
        void $this$_sendAckCheck_u24lambda_u248;
        Timer timer;
        int currentIncomingAckId;
        int currentIncomingMsgId = this._incomingMsgId.get();
        if (currentIncomingMsgId <= (currentIncomingAckId = this._incomingAckId.get())) {
            return;
        }
        if (this._incomingAckTimeout != null) {
            return;
        }
        long timeSinceLastIncomingMsg = System.currentTimeMillis() - this._incomingMsgLastTime.get();
        if (timeSinceLastIncomingMsg >= 2000L) {
            this._sendAck();
            return;
        }
        Timer timer2 = timer = new Timer();
        PersistentProtocol persistentProtocol = this;
        boolean bl = false;
        $this$_sendAckCheck_u24lambda_u248.schedule(new TimerTask(this){
            final /* synthetic */ PersistentProtocol this$0;
            {
                this.this$0 = $receiver;
            }

            public void run() {
                PersistentProtocol.access$set_incomingAckTimeout$p(this.this$0, null);
                PersistentProtocol.access$_sendAckCheck(this.this$0);
            }
        }, (long)2000 - timeSinceLastIncomingMsg + (long)5);
        persistentProtocol._incomingAckTimeout = timer;
    }

    /*
     * WARNING - void declaration
     */
    private final void _recvAckCheck() {
        void $this$_recvAckCheck_u24lambda_u249;
        int currentOutgoingAckId;
        int currentOutgoingMsgId = this._outgoingMsgId.get();
        if (currentOutgoingMsgId <= (currentOutgoingAckId = this._outgoingAckId.get())) {
            return;
        }
        if (this._outgoingAckTimeout != null) {
            return;
        }
        if (this._isReconnecting.get()) {
            return;
        }
        ProtocolMessage protocolMessage = this._outgoingUnackMsg.peek();
        Intrinsics.checkNotNull((Object)protocolMessage);
        ProtocolMessage oldestUnacknowledgedMsg = protocolMessage;
        long timeSinceOldestUnacknowledgedMsg = System.currentTimeMillis() - oldestUnacknowledgedMsg.getWrittenTime();
        long timeSinceLastReceivedSomeData = System.currentTimeMillis() - this._socketReader.getLastReadTime();
        long timeSinceLastTimeout = System.currentTimeMillis() - this._lastSocketTimeoutTime.get();
        if (timeSinceOldestUnacknowledgedMsg >= 20000L && timeSinceLastReceivedSomeData >= 20000L && timeSinceLastTimeout >= 20000L && !this._loadEstimator.hasHighLoad()) {
            this._lastSocketTimeoutTime.set(System.currentTimeMillis());
            this._onSocketTimeout.fire(new SocketTimeoutEvent(this._outgoingUnackMsg.size(), timeSinceOldestUnacknowledgedMsg, timeSinceLastReceivedSomeData));
            return;
        }
        Object object = new long[]{(long)20000 - timeSinceLastReceivedSomeData, (long)20000 - timeSinceLastTimeout, 500L};
        long minimumTimeUntilTimeout = ComparisonsKt.maxOf((long)((long)20000 - timeSinceOldestUnacknowledgedMsg), (long[])object);
        Object object2 = object = (Object)new Timer();
        PersistentProtocol persistentProtocol = this;
        boolean bl = false;
        $this$_recvAckCheck_u24lambda_u249.schedule(new TimerTask(this){
            final /* synthetic */ PersistentProtocol this$0;
            {
                this.this$0 = $receiver;
            }

            public void run() {
                PersistentProtocol.access$set_outgoingAckTimeout$p(this.this$0, null);
                PersistentProtocol.access$_recvAckCheck(this.this$0);
            }
        }, minimumTimeUntilTimeout);
        persistentProtocol._outgoingAckTimeout = object;
    }

    private final void _sendAck() {
        int currentIncomingAckId;
        int currentIncomingMsgId = this._incomingMsgId.get();
        if (currentIncomingMsgId <= (currentIncomingAckId = this._incomingAckId.get())) {
            return;
        }
        this._incomingAckId.set(currentIncomingMsgId);
        ProtocolMessage msg = new ProtocolMessage(ProtocolMessageType.ACK, 0, currentIncomingMsgId, new byte[0]);
        this._socketWriter.write(msg);
    }

    private final void _sendKeepAlive() {
        int currentIncomingMsgId = this._incomingMsgId.get();
        this._incomingAckId.set(currentIncomingMsgId);
        ProtocolMessage msg = new ProtocolMessage(ProtocolMessageType.KEEP_ALIVE, 0, currentIncomingMsgId, new byte[0]);
        this._socketWriter.write(msg);
    }

    private static final void _init_$lambda$0(PersistentProtocol this$0, SocketCloseEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        this$0._onSocketClose.fire(event2);
    }

    private static final Unit _init_$lambda$1(Function1 $msgListener, ProtocolMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        $msgListener.invoke((Object)msg.getData());
        return Unit.INSTANCE;
    }

    private static final Unit onMessage$lambda$4(MessageListener $listener, ProtocolMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        $listener.onMessage(msg);
        return Unit.INSTANCE;
    }

    private static final Unit onDidDispose$lambda$5(Function0 $listener, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $listener.invoke();
        return Unit.INSTANCE;
    }

    private static final void beginAcceptReconnection$lambda$7(PersistentProtocol this$0, SocketCloseEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        this$0._onSocketClose.fire(event2);
    }

    public static final /* synthetic */ void access$set_incomingAckTimeout$p(PersistentProtocol $this, Timer timer) {
        $this._incomingAckTimeout = timer;
    }

    public static final /* synthetic */ void access$_sendAckCheck(PersistentProtocol $this) {
        $this._sendAckCheck();
    }

    public static final /* synthetic */ void access$set_outgoingAckTimeout$p(PersistentProtocol $this, Timer timer) {
        $this._outgoingAckTimeout = timer;
    }

    public static final /* synthetic */ void access$_recvAckCheck(PersistentProtocol $this) {
        $this._recvAckCheck();
    }

    public static final /* synthetic */ void access$_sendKeepAlive(PersistentProtocol $this) {
        $this._sendKeepAlive();
    }

    static {
        Logger logger = Logger.getInstance(PersistentProtocol.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/sina/weibo/agent/ipc/PersistentProtocol$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/sina/weibo/agent/ipc/PersistentProtocol$PersistentProtocolOptions;", "", "socket", "Lcom/sina/weibo/agent/ipc/ISocket;", "initialChunk", "", "loadEstimator", "Lcom/sina/weibo/agent/ipc/ILoadEstimator;", "sendKeepAlive", "", "<init>", "(Lcom/sina/weibo/agent/ipc/ISocket;[BLcom/sina/weibo/agent/ipc/ILoadEstimator;Z)V", "getSocket", "()Lcom/sina/weibo/agent/ipc/ISocket;", "getInitialChunk", "()[B", "getLoadEstimator", "()Lcom/sina/weibo/agent/ipc/ILoadEstimator;", "getSendKeepAlive", "()Z", "coderider-kilo-jetbrains"})
    public static final class PersistentProtocolOptions {
        @NotNull
        private final ISocket socket;
        @Nullable
        private final byte[] initialChunk;
        @Nullable
        private final ILoadEstimator loadEstimator;
        private final boolean sendKeepAlive;

        public PersistentProtocolOptions(@NotNull ISocket socket, @Nullable byte[] initialChunk, @Nullable ILoadEstimator loadEstimator, boolean sendKeepAlive) {
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            this.socket = socket;
            this.initialChunk = initialChunk;
            this.loadEstimator = loadEstimator;
            this.sendKeepAlive = sendKeepAlive;
        }

        public /* synthetic */ PersistentProtocolOptions(ISocket iSocket, byte[] byArray, ILoadEstimator iLoadEstimator, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                byArray = null;
            }
            if ((n & 4) != 0) {
                iLoadEstimator = null;
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            this(iSocket, byArray, iLoadEstimator, bl);
        }

        @NotNull
        public final ISocket getSocket() {
            return this.socket;
        }

        @Nullable
        public final byte[] getInitialChunk() {
            return this.initialChunk;
        }

        @Nullable
        public final ILoadEstimator getLoadEstimator() {
            return this.loadEstimator;
        }

        public final boolean getSendKeepAlive() {
            return this.sendKeepAlive;
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtocolMessageType.values().length];
            try {
                nArray[ProtocolMessageType.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtocolMessageType.REGULAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtocolMessageType.CONTROL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtocolMessageType.ACK.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtocolMessageType.DISCONNECT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtocolMessageType.REPLAY_REQUEST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtocolMessageType.PAUSE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtocolMessageType.RESUME.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtocolMessageType.KEEP_ALIVE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

