/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.extensions.ui.contextmenu;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sina.weibo.agent.extensions.config.ExtensionProvider;
import com.sina.weibo.agent.extensions.core.ExtensionManager;
import com.sina.weibo.agent.extensions.plugin.coderider.CodeRiderContextMenuProvider;
import com.sina.weibo.agent.extensions.ui.contextmenu.ContextMenuActionType;
import com.sina.weibo.agent.extensions.ui.contextmenu.ContextMenuConfiguration;
import com.sina.weibo.agent.extensions.ui.contextmenu.DefaultContextMenuConfiguration;
import com.sina.weibo.agent.extensions.ui.contextmenu.ExtensionContextMenuProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\fJ\b\u0010\u0011\u001a\u0004\u0018\u00010\fJ\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u000eH\u0002J\u0006\u0010\u001e\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/sina/weibo/agent/extensions/ui/contextmenu/DynamicContextMenuManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "extensionManager", "Lcom/sina/weibo/agent/extensions/core/ExtensionManager;", "currentExtensionId", "", "initialize", "", "setCurrentExtension", "extensionId", "getCurrentExtensionId", "getContextMenuConfiguration", "Lcom/sina/weibo/agent/extensions/ui/contextmenu/ContextMenuConfiguration;", "getContextMenuActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "getContextMenuProvider", "Lcom/sina/weibo/agent/extensions/ui/contextmenu/ExtensionContextMenuProvider;", "isActionVisible", "", "actionType", "Lcom/sina/weibo/agent/extensions/ui/contextmenu/ContextMenuActionType;", "refreshContextMenus", "dispose", "Companion", "coderider-kilo-jetbrains"})
public final class DynamicContextMenuManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ExtensionManager extensionManager;
    @Nullable
    private volatile String currentExtensionId;

    public DynamicContextMenuManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Logger logger = Logger.getInstance(DynamicContextMenuManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.extensionManager = ExtensionManager.Companion.getInstance(this.project);
    }

    public final void initialize() {
        this.logger.info("Initializing dynamic context menu manager");
        try {
            ExtensionProvider currentProvider;
            ExtensionProvider extensionProvider = currentProvider = this.extensionManager.getCurrentProvider();
            this.currentExtensionId = extensionProvider != null ? extensionProvider.getExtensionId() : null;
            this.logger.info("Dynamic context menu manager initialized with extension: " + this.currentExtensionId);
        }
        catch (Exception e) {
            this.logger.warn("Failed to initialize dynamic context menu manager", (Throwable)e);
        }
    }

    public final void setCurrentExtension(@NotNull String extensionId) {
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        this.logger.info("Setting current extension to: " + extensionId);
        this.currentExtensionId = extensionId;
        this.refreshContextMenus();
    }

    @Nullable
    public final String getCurrentExtensionId() {
        ExtensionProvider extensionProvider = this.extensionManager.getCurrentProvider();
        return extensionProvider != null ? extensionProvider.getExtensionId() : null;
    }

    @NotNull
    public final ContextMenuConfiguration getContextMenuConfiguration() {
        ExtensionContextMenuProvider contextMenuProvider = this.getContextMenuProvider(this.getCurrentExtensionId());
        Object object = contextMenuProvider;
        if (object == null || (object = object.getContextMenuConfiguration()) == null) {
            object = new DefaultContextMenuConfiguration();
        }
        return object;
    }

    @NotNull
    public final List<AnAction> getContextMenuActions() {
        ExtensionContextMenuProvider contextMenuProvider = this.getContextMenuProvider(this.getCurrentExtensionId());
        Object object = contextMenuProvider;
        if (object == null || (object = object.getContextMenuActions(this.project)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final ExtensionContextMenuProvider getContextMenuProvider(String extensionId) {
        if (extensionId == null) {
            return null;
        }
        return Intrinsics.areEqual((Object)extensionId, (Object)"coderider-kilo") ? (ExtensionContextMenuProvider)new CodeRiderContextMenuProvider() : null;
    }

    public final boolean isActionVisible(@NotNull ContextMenuActionType actionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
        ContextMenuConfiguration config = this.getContextMenuConfiguration();
        return config.isActionVisible(actionType);
    }

    private final void refreshContextMenus() {
        try {
            ApplicationManager.getApplication().invokeLater(() -> DynamicContextMenuManager.refreshContextMenus$lambda$1(this));
        }
        catch (Exception e) {
            this.logger.warn("Failed to refresh context menus", (Throwable)e);
        }
    }

    public final void dispose() {
        this.logger.info("Disposing dynamic context menu manager");
        this.currentExtensionId = null;
    }

    private static final void refreshContextMenus$lambda$1(DynamicContextMenuManager this$0) {
        try {
            AnAction dynamicGroup;
            ActionManager actionManager = ActionManager.getInstance();
            AnAction anAction = dynamicGroup = actionManager.getAction("RunVSAgent.DynamicExtensionContextMenu");
            if (anAction != null) {
                AnAction group = anAction;
                boolean bl = false;
                this$0.logger.debug("Triggering UI refresh for dynamic context menu group");
            }
            this$0.logger.debug("Context menus refresh scheduled for extension: " + this$0.currentExtensionId);
        }
        catch (Exception e) {
            this$0.logger.warn("Failed to schedule context menu refresh", (Throwable)e);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/sina/weibo/agent/extensions/ui/contextmenu/DynamicContextMenuManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/sina/weibo/agent/extensions/ui/contextmenu/DynamicContextMenuManager;", "project", "Lcom/intellij/openapi/project/Project;", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DynamicContextMenuManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            DynamicContextMenuManager dynamicContextMenuManager = (DynamicContextMenuManager)project.getService(DynamicContextMenuManager.class);
            if (dynamicContextMenuManager == null) {
                throw new IllegalStateException("DynamicContextMenuManager not found".toString());
            }
            return dynamicContextMenuManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

