/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.extensions.ui.buttons;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sina.weibo.agent.extensions.config.ExtensionProvider;
import com.sina.weibo.agent.extensions.core.ExtensionManager;
import com.sina.weibo.agent.extensions.plugin.coderider.CodeRiderButtonProvider;
import com.sina.weibo.agent.extensions.ui.buttons.ButtonConfiguration;
import com.sina.weibo.agent.extensions.ui.buttons.ButtonType;
import com.sina.weibo.agent.extensions.ui.buttons.DefaultButtonConfiguration;
import com.sina.weibo.agent.extensions.ui.buttons.ExtensionButtonProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\nJ\b\u0010\u000f\u001a\u0004\u0018\u00010\nJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\fH\u0002J\u0006\u0010\u0019\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/sina/weibo/agent/extensions/ui/buttons/DynamicButtonManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "currentExtensionId", "", "initialize", "", "setCurrentExtension", "extensionId", "getCurrentExtensionId", "getButtonConfiguration", "Lcom/sina/weibo/agent/extensions/ui/buttons/ButtonConfiguration;", "getButtonProvider", "Lcom/sina/weibo/agent/extensions/ui/buttons/ExtensionButtonProvider;", "isButtonVisible", "", "buttonType", "Lcom/sina/weibo/agent/extensions/ui/buttons/ButtonType;", "refreshActionToolbars", "dispose", "Companion", "coderider-kilo-jetbrains"})
public final class DynamicButtonManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @Nullable
    private volatile String currentExtensionId;

    public DynamicButtonManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Logger logger = Logger.getInstance(DynamicButtonManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    public final void initialize() {
        this.logger.info("Initializing dynamic button manager");
        try {
            ExtensionProvider currentProvider;
            ExtensionManager extensionManager = ExtensionManager.Companion.getInstance(this.project);
            ExtensionProvider extensionProvider = currentProvider = extensionManager.getCurrentProvider();
            this.currentExtensionId = extensionProvider != null ? extensionProvider.getExtensionId() : null;
            this.logger.info("Dynamic button manager initialized with extension: " + this.currentExtensionId);
        }
        catch (Exception e) {
            this.logger.warn("Failed to initialize dynamic button manager", (Throwable)e);
        }
    }

    public final void setCurrentExtension(@NotNull String extensionId) {
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        this.logger.info("Setting current extension to: " + extensionId);
        this.currentExtensionId = extensionId;
        this.refreshActionToolbars();
    }

    @Nullable
    public final String getCurrentExtensionId() {
        return this.currentExtensionId;
    }

    @NotNull
    public final ButtonConfiguration getButtonConfiguration() {
        ExtensionButtonProvider buttonProvider = this.getButtonProvider(this.currentExtensionId);
        Object object = buttonProvider;
        if (object == null || (object = object.getButtonConfiguration()) == null) {
            object = new DefaultButtonConfiguration();
        }
        return object;
    }

    private final ExtensionButtonProvider getButtonProvider(String extensionId) {
        if (extensionId == null) {
            return null;
        }
        return Intrinsics.areEqual((Object)extensionId, (Object)"coderider-kilo") ? (ExtensionButtonProvider)new CodeRiderButtonProvider() : null;
    }

    public final boolean isButtonVisible(@NotNull ButtonType buttonType) {
        Intrinsics.checkNotNullParameter((Object)((Object)buttonType), (String)"buttonType");
        ButtonConfiguration config = this.getButtonConfiguration();
        return config.isButtonVisible(buttonType);
    }

    private final void refreshActionToolbars() {
        try {
            ApplicationManager.getApplication().invokeLater(() -> DynamicButtonManager.refreshActionToolbars$lambda$1(this));
        }
        catch (Exception e) {
            this.logger.warn("Failed to refresh action toolbars", (Throwable)e);
        }
    }

    public final void dispose() {
        this.logger.info("Disposing dynamic button manager");
        this.currentExtensionId = null;
    }

    private static final void refreshActionToolbars$lambda$1(DynamicButtonManager this$0) {
        try {
            AnAction dynamicGroup;
            ActionManager actionManager = ActionManager.getInstance();
            AnAction anAction = dynamicGroup = actionManager.getAction("RunVSAgent.DynamicExtensionActions");
            if (anAction != null) {
                AnAction group = anAction;
                boolean bl = false;
                this$0.logger.debug("Triggering UI refresh for dynamic actions group");
            }
            this$0.logger.debug("Action toolbars refresh scheduled for extension: " + this$0.currentExtensionId);
        }
        catch (Exception e) {
            this$0.logger.warn("Failed to schedule action toolbar refresh", (Throwable)e);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/sina/weibo/agent/extensions/ui/buttons/DynamicButtonManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/sina/weibo/agent/extensions/ui/buttons/DynamicButtonManager;", "project", "Lcom/intellij/openapi/project/Project;", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DynamicButtonManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            DynamicButtonManager dynamicButtonManager = (DynamicButtonManager)project.getService(DynamicButtonManager.class);
            if (dynamicButtonManager == null) {
                throw new IllegalStateException("DynamicButtonManager not found".toString());
            }
            return dynamicButtonManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

