/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.extensions.ui.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.ActionUpdateThreadAware;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.sina.weibo.agent.extensions.common.ExtensionChangeListener;
import com.sina.weibo.agent.extensions.config.ExtensionProvider;
import com.sina.weibo.agent.extensions.core.ExtensionManager;
import com.sina.weibo.agent.extensions.plugin.coderider.CodeRiderButtonProvider;
import com.sina.weibo.agent.extensions.ui.buttons.ExtensionButtonProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\rH\u0016R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/sina/weibo/agent/extensions/ui/actions/DynamicExtensionActionsGroup;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/actionSystem/ActionUpdateThreadAware;", "Lcom/sina/weibo/agent/extensions/common/ExtensionChangeListener;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "cachedButtonProvider", "Lcom/sina/weibo/agent/extensions/ui/buttons/ExtensionButtonProvider;", "cachedExtensionId", "", "cachedActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "updateCachedActions", "provider", "Lcom/sina/weibo/agent/extensions/config/ExtensionProvider;", "project", "Lcom/intellij/openapi/project/Project;", "loadDynamicActions", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "onExtensionChanged", "newExtensionId", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nDynamicExtensionActionsGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamicExtensionActionsGroup.kt\ncom/sina/weibo/agent/extensions/ui/actions/DynamicExtensionActionsGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1869#2,2:142\n1869#2,2:144\n*S KotlinDebug\n*F\n+ 1 DynamicExtensionActionsGroup.kt\ncom/sina/weibo/agent/extensions/ui/actions/DynamicExtensionActionsGroup\n*L\n56#1:142,2\n111#1:144,2\n*E\n"})
public final class DynamicExtensionActionsGroup
extends DefaultActionGroup
implements DumbAware,
ActionUpdateThreadAware,
ExtensionChangeListener {
    @NotNull
    private final Logger logger;
    @Nullable
    private ExtensionButtonProvider cachedButtonProvider;
    @Nullable
    private String cachedExtensionId;
    @Nullable
    private List<? extends AnAction> cachedActions;

    public DynamicExtensionActionsGroup() {
        Logger logger = Logger.getInstance(DynamicExtensionActionsGroup.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            e.getPresentation().setVisible(false);
            return;
        }
        try {
            ExtensionManager extensionManager = ExtensionManager.Companion.getInstance(project);
            ExtensionProvider currentProvider = extensionManager.getCurrentProvider();
            if (currentProvider != null) {
                String extensionId = currentProvider.getExtensionId();
                if (!Intrinsics.areEqual((Object)this.cachedExtensionId, (Object)extensionId) || this.cachedActions == null) {
                    this.updateCachedActions(currentProvider, project);
                }
                if (this.cachedActions != null) {
                    this.removeAll();
                    List<? extends AnAction> list = this.cachedActions;
                    Intrinsics.checkNotNull(list);
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        AnAction action2 = (AnAction)element$iv;
                        boolean bl = false;
                        this.add(action2);
                    }
                    e.getPresentation().setVisible(true);
                    this.logger.debug("Using cached actions for extension: " + extensionId);
                }
            } else {
                e.getPresentation().setVisible(false);
                this.logger.debug("No current extension provider, hiding dynamic actions");
            }
        }
        catch (Exception exception) {
            this.logger.warn("Failed to load dynamic actions", (Throwable)exception);
            e.getPresentation().setVisible(false);
        }
    }

    private final void updateCachedActions(ExtensionProvider provider, Project project) {
        CodeRiderButtonProvider buttonProvider;
        String extensionId = provider.getExtensionId();
        CodeRiderButtonProvider codeRiderButtonProvider = buttonProvider = Intrinsics.areEqual((Object)extensionId, (Object)"coderider-kilo") ? new CodeRiderButtonProvider() : null;
        if (buttonProvider != null) {
            List<AnAction> actions = buttonProvider.getButtons(project);
            this.cachedButtonProvider = buttonProvider;
            this.cachedExtensionId = extensionId;
            this.cachedActions = actions;
            this.logger.debug("Updated cached actions for extension: " + extensionId + ", count: " + actions.size());
        }
    }

    private final void loadDynamicActions(ExtensionProvider provider, Project project) {
        String extensionId = provider.getExtensionId();
        CodeRiderButtonProvider buttonProvider = Intrinsics.areEqual((Object)extensionId, (Object)"coderider-kilo") ? new CodeRiderButtonProvider() : null;
        Object object = buttonProvider;
        if (object == null || (object = ((CodeRiderButtonProvider)object).getButtons(project)) == null) {
            object = CollectionsKt.emptyList();
        }
        List<AnAction> actions = object;
        Iterable $this$forEach$iv = actions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnAction action2 = (AnAction)element$iv;
            boolean bl = false;
            this.add(action2);
        }
        this.logger.debug("Added " + actions.size() + " actions for extension: " + extensionId);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Override
    public void onExtensionChanged(@NotNull String newExtensionId) {
        Intrinsics.checkNotNullParameter((Object)newExtensionId, (String)"newExtensionId");
        this.logger.info("Extension changed to: " + newExtensionId + ", refreshing dynamic actions");
    }
}

