/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.extensions.ui;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.sina.weibo.agent.extensions.core.VsixManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Locale;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/sina/weibo/agent/extensions/ui/VsixUploadDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "extensionId", "", "extensionName", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "selectedVsixFile", "Ljava/io/File;", "createCenterPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "selectVsixFile", "", "fileField", "Lcom/intellij/ui/components/JBTextField;", "doOKAction", "Companion", "coderider-kilo-jetbrains"})
public final class VsixUploadDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String extensionId;
    @NotNull
    private final String extensionName;
    @Nullable
    private File selectedVsixFile;

    public VsixUploadDialog(@NotNull Project project, @NotNull String extensionId, @NotNull String extensionName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        Intrinsics.checkNotNullParameter((Object)extensionName, (String)"extensionName");
        super(project);
        this.project = project;
        this.extensionId = extensionId;
        this.extensionName = extensionName;
        this.setTitle("Upload VSIX for " + this.extensionName);
        this.init();
        this.setSize(500, 150);
    }

    @NotNull
    protected DialogPanel createCenterPanel() {
        return BuilderKt.panel(arg_0 -> VsixUploadDialog.createCenterPanel$lambda$5(this, arg_0));
    }

    private final void selectVsixFile(JBTextField fileField) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false).withFileFilter(arg_0 -> VsixUploadDialog.selectVsixFile$lambda$7(VsixUploadDialog::selectVsixFile$lambda$6, arg_0)).withTitle("Select VSIX File");
        FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)this.project, null, arg_0 -> VsixUploadDialog.selectVsixFile$lambda$9(arg_0 -> VsixUploadDialog.selectVsixFile$lambda$8(this, fileField, arg_0), arg_0));
    }

    protected void doOKAction() {
        if (this.selectedVsixFile == null) {
            Messages.showErrorDialog((String)"Please select a VSIX file to upload.", (String)"No File Selected");
            return;
        }
        File file = this.selectedVsixFile;
        Intrinsics.checkNotNull((Object)file);
        if (!file.exists()) {
            Messages.showErrorDialog((String)"Selected file does not exist.", (String)"File Not Found");
            return;
        }
        try {
            VsixManager vsixManager = VsixManager.Companion.getInstance();
            File file2 = this.selectedVsixFile;
            Intrinsics.checkNotNull((Object)file2);
            boolean success = vsixManager.installVsix(file2, this.extensionId);
            if (success) {
                Messages.showInfoMessage((String)"VSIX file uploaded successfully!", (String)"Upload Complete");
                super.doOKAction();
            } else {
                Messages.showErrorDialog((String)"Failed to extract VSIX file. Please check the file format and try again.", (String)"Extraction Failed");
            }
        }
        catch (Exception e) {
            Messages.showErrorDialog((String)("Error during upload: " + e.getMessage()), (String)"Upload Error");
        }
    }

    private static final Unit createCenterPanel$lambda$5$lambda$0(VsixUploadDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label("Extension: " + this$0.extensionName);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$5$lambda$1(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label("Select VSIX File:");
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$5$lambda$4$lambda$3(VsixUploadDialog this$0, JBTextField $fileField, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.selectVsixFile($fileField);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$5$lambda$4(VsixUploadDialog this$0, Row $this$row) {
        JBTextField jBTextField;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JBTextField $this$createCenterPanel_u24lambda_u245_u24lambda_u244_u24lambda_u242 = jBTextField = new JBTextField();
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u245_u24lambda_u244_u24lambda_u242.setEditable(false);
        $this$createCenterPanel_u24lambda_u245_u24lambda_u244_u24lambda_u242.setColumns(50);
        JBTextField fileField = jBTextField;
        $this$row.cell((JComponent)fileField).resizableColumn();
        $this$row.button("Browse", arg_0 -> VsixUploadDialog.createCenterPanel$lambda$5$lambda$4$lambda$3(this$0, fileField, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$5(VsixUploadDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> VsixUploadDialog.createCenterPanel$lambda$5$lambda$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, VsixUploadDialog::createCenterPanel$lambda$5$lambda$1, (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> VsixUploadDialog.createCenterPanel$lambda$5$lambda$4(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final boolean selectVsixFile$lambda$6(VirtualFile file) {
        String string;
        String string2 = file.getExtension();
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        return Intrinsics.areEqual((Object)string, (Object)"vsix");
    }

    private static final boolean selectVsixFile$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit selectVsixFile$lambda$8(VsixUploadDialog this$0, JBTextField $fileField, VirtualFile file) {
        this$0.selectedVsixFile = file.toNioPath().toFile();
        $fileField.setText(file.getPath());
        return Unit.INSTANCE;
    }

    private static final void selectVsixFile$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lcom/sina/weibo/agent/extensions/ui/VsixUploadDialog$Companion;", "", "<init>", "()V", "show", "", "project", "Lcom/intellij/openapi/project/Project;", "extensionId", "", "extensionName", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean show(@NotNull Project project, @NotNull String extensionId, @NotNull String extensionName) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
            Intrinsics.checkNotNullParameter((Object)extensionName, (String)"extensionName");
            VsixUploadDialog dialog = new VsixUploadDialog(project, extensionId, extensionName);
            return dialog.showAndGet();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

