/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.extensions.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.sina.weibo.agent.extensions.config.ExtensionMetadata;
import com.sina.weibo.agent.extensions.config.ExtensionProvider;
import com.sina.weibo.agent.extensions.core.ExtensionConfigurationManager;
import com.sina.weibo.agent.extensions.core.ExtensionManager;
import com.sina.weibo.agent.extensions.core.ExtensionSwitcher;
import com.sina.weibo.agent.extensions.core.VsixManager;
import com.sina.weibo.agent.extensions.ui.VsixUploadDialog;
import com.sina.weibo.agent.util.PluginResourceUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003=>?B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020!H\u0002J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0#H\u0002J\b\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u000eH\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010'\u001a\u00020\u000eH\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010'\u001a\u00020\u000eH\u0002J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u001bH\u0002J\u0010\u0010.\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u001bH\u0002J\b\u0010/\u001a\u00020!H\u0002J\u0012\u00100\u001a\u00020!2\b\u0010'\u001a\u0004\u0018\u00010\u000eH\u0002J\b\u00101\u001a\u00020!H\u0002J\b\u00102\u001a\u00020!H\u0002J\u0010\u00103\u001a\u00020!2\u0006\u0010-\u001a\u00020\u001bH\u0002J\u0010\u00104\u001a\u00020!2\u0006\u00105\u001a\u00020\u001bH\u0002J\u0010\u00106\u001a\u00020!2\u0006\u00107\u001a\u00020\u001dH\u0002J\b\u00108\u001a\u00020!H\u0016J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/sina/weibo/agent/extensions/ui/ExtensionSwitcherDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "extensionManager", "Lcom/sina/weibo/agent/extensions/core/ExtensionManager;", "extensionSwitcher", "Lcom/sina/weibo/agent/extensions/core/ExtensionSwitcher;", "configManager", "Lcom/sina/weibo/agent/extensions/core/ExtensionConfigurationManager;", "extensionList", "Lcom/intellij/ui/components/JBList;", "Lcom/sina/weibo/agent/extensions/ui/ExtensionSwitcherDialog$ExtensionListItem;", "descriptionLabel", "Lcom/intellij/ui/components/JBLabel;", "statusLabel", "switchButton", "Ljavax/swing/JButton;", "setAsDefaultCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "installButton", "refreshButton", "extensionListItems", "", "selectedExtensionId", "", "isSwitching", "", "createCenterPanel", "Ljavax/swing/JComponent;", "setupUI", "", "listCellRenderer", "Ljavax/swing/ListCellRenderer;", "listSelectionListener", "Ljavax/swing/event/ListSelectionListener;", "statusText", "item", "statusColor", "Ljava/awt/Color;", "getExtensionStatus", "Lcom/sina/weibo/agent/extensions/ui/ExtensionSwitcherDialog$ExtensionStatus;", "isConfiguredForNextStartup", "extensionId", "isCurrentlyRunning", "loadExtensions", "updateUI", "uploadVsixFile", "performSwitch", "performReload", "doSwitch", "target", "setSwitchingUI", "switching", "doCancelAction", "checkResources", "Lcom/sina/weibo/agent/extensions/ui/ExtensionSwitcherDialog$ResourceStatus;", "provider", "Lcom/sina/weibo/agent/extensions/config/ExtensionProvider;", "ExtensionListItem", "ResourceStatus", "ExtensionStatus", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nExtensionSwitcherDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionSwitcherDialog.kt\ncom/sina/weibo/agent/extensions/ui/ExtensionSwitcherDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,499:1\n1#2:500\n1869#3,2:501\n1011#3,2:503\n360#3,7:509\n1869#3,2:516\n37#4:505\n36#4,3:506\n*S KotlinDebug\n*F\n+ 1 ExtensionSwitcherDialog.kt\ncom/sina/weibo/agent/extensions/ui/ExtensionSwitcherDialog\n*L\n264#1:501,2\n277#1:503,2\n281#1:509,7\n473#1:516,2\n278#1:505\n278#1:506,3\n*E\n"})
public final class ExtensionSwitcherDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final ExtensionManager extensionManager;
    @NotNull
    private final ExtensionSwitcher extensionSwitcher;
    @NotNull
    private final ExtensionConfigurationManager configManager;
    private JBList<ExtensionListItem> extensionList;
    private JBLabel descriptionLabel;
    private JBLabel statusLabel;
    private JButton switchButton;
    private JBCheckBox setAsDefaultCheckBox;
    private JButton installButton;
    private JButton refreshButton;
    @NotNull
    private final List<ExtensionListItem> extensionListItems;
    @Nullable
    private String selectedExtensionId;
    private boolean isSwitching;

    public ExtensionSwitcherDialog(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
        this.extensionManager = ExtensionManager.Companion.getInstance(this.project);
        this.extensionSwitcher = ExtensionSwitcher.Companion.getInstance(this.project);
        this.configManager = ExtensionConfigurationManager.Companion.getInstance(this.project);
        this.extensionListItems = new ArrayList();
        this.setTitle("Switch Extension Provider");
        this.init();
        this.loadExtensions();
        this.setupUI();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected JComponent createCenterPanel() {
        void $this$createCenterPanel_u24lambda_u2411;
        JButton $this$createCenterPanel_u24lambda_u249;
        JButton jButton;
        void $this$createCenterPanel_u24lambda_u247;
        JComponent $this$createCenterPanel_u24lambda_u246;
        JPanel $this$createCenterPanel_u24lambda_u242;
        JPanel jPanel;
        JPanel $this$createCenterPanel_u24lambda_u240 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u240.setPreferredSize(new Dimension(600, 400));
        $this$createCenterPanel_u24lambda_u240.setBorder(JBUI.Borders.empty((int)16));
        JPanel panel = jPanel;
        JPanel $this$createCenterPanel_u24lambda_u241 = $this$createCenterPanel_u24lambda_u240 = new JPanel(new BorderLayout());
        boolean bl2 = false;
        $this$createCenterPanel_u24lambda_u241.setPreferredSize(new Dimension(300, 0));
        $this$createCenterPanel_u24lambda_u241.setBorder(BorderFactory.createTitledBorder("Extensions"));
        JPanel leftPanel = $this$createCenterPanel_u24lambda_u240;
        $this$createCenterPanel_u24lambda_u241 = $this$createCenterPanel_u24lambda_u240 = new JBList();
        ExtensionSwitcherDialog extensionSwitcherDialog = this;
        boolean bl3 = false;
        $this$createCenterPanel_u24lambda_u242.setSelectionMode(0);
        $this$createCenterPanel_u24lambda_u242.setCellRenderer(this.listCellRenderer());
        $this$createCenterPanel_u24lambda_u242.addListSelectionListener(this.listSelectionListener());
        extensionSwitcherDialog.extensionList = $this$createCenterPanel_u24lambda_u240;
        JBList<ExtensionListItem> jBList = this.extensionList;
        if (jBList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extensionList");
            jBList = null;
        }
        leftPanel.add((Component)new JScrollPane((Component)jBList), "Center");
        JComponent $this$createCenterPanel_u24lambda_u243 = $this$createCenterPanel_u24lambda_u242 = new JPanel(new BorderLayout());
        boolean bl4 = false;
        $this$createCenterPanel_u24lambda_u243.setBorder(BorderFactory.createTitledBorder("Details"));
        $this$createCenterPanel_u24lambda_u243.setPreferredSize(new Dimension(270, 0));
        $this$createCenterPanel_u24lambda_u243.setMinimumSize(new Dimension(270, 0));
        $this$createCenterPanel_u24lambda_u243.setMaximumSize(new Dimension(270, Integer.MAX_VALUE));
        JPanel rightPanel = $this$createCenterPanel_u24lambda_u242;
        JPanel $this$createCenterPanel_u24lambda_u244 = $this$createCenterPanel_u24lambda_u243 = new JPanel();
        boolean bl5 = false;
        $this$createCenterPanel_u24lambda_u244.setLayout(new BoxLayout($this$createCenterPanel_u24lambda_u244, 1));
        $this$createCenterPanel_u24lambda_u244.setBorder(JBUI.Borders.empty((int)16));
        JPanel detailsPanel = $this$createCenterPanel_u24lambda_u243;
        this.descriptionLabel = new JBLabel("Select an extension to view details");
        this.statusLabel = new JBLabel("");
        $this$createCenterPanel_u24lambda_u244 = $this$createCenterPanel_u24lambda_u243 = new JButton("Switch");
        extensionSwitcherDialog = this;
        boolean bl6 = false;
        ((AbstractButton)$this$createCenterPanel_u24lambda_u246).setEnabled(false);
        ((AbstractButton)$this$createCenterPanel_u24lambda_u246).addActionListener(arg_0 -> ExtensionSwitcherDialog.createCenterPanel$lambda$6$lambda$5(this, arg_0));
        extensionSwitcherDialog.switchButton = $this$createCenterPanel_u24lambda_u243;
        $this$createCenterPanel_u24lambda_u246 = $this$createCenterPanel_u24lambda_u243 = new JBCheckBox("Set as default");
        extensionSwitcherDialog = this;
        boolean $i$a$-apply-ExtensionSwitcherDialog$createCenterPanel$62 = false;
        $this$createCenterPanel_u24lambda_u247.setEnabled(false);
        extensionSwitcherDialog.setAsDefaultCheckBox = $this$createCenterPanel_u24lambda_u243;
        JBLabel jBLabel = this.descriptionLabel;
        if (jBLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"descriptionLabel");
            jBLabel = null;
        }
        detailsPanel.add((Component)jBLabel);
        detailsPanel.add(Box.createVerticalStrut(8));
        JBLabel jBLabel2 = this.statusLabel;
        if (jBLabel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"statusLabel");
            jBLabel2 = null;
        }
        detailsPanel.add((Component)jBLabel2);
        detailsPanel.add(Box.createVerticalStrut(16));
        JButton jButton2 = this.switchButton;
        if (jButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"switchButton");
            jButton2 = null;
        }
        detailsPanel.add(jButton2);
        detailsPanel.add(Box.createVerticalStrut(8));
        rightPanel.add((Component)detailsPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        JButton $i$a$-apply-ExtensionSwitcherDialog$createCenterPanel$62 = jButton = new JButton("Install VSIX");
        extensionSwitcherDialog = this;
        boolean bl7 = false;
        $this$createCenterPanel_u24lambda_u249.addActionListener(arg_0 -> ExtensionSwitcherDialog.createCenterPanel$lambda$9$lambda$8(this, arg_0));
        extensionSwitcherDialog.installButton = jButton;
        $this$createCenterPanel_u24lambda_u249 = jButton = new JButton("Refresh");
        extensionSwitcherDialog = this;
        boolean bl8 = false;
        $this$createCenterPanel_u24lambda_u2411.addActionListener(arg_0 -> ExtensionSwitcherDialog.createCenterPanel$lambda$11$lambda$10(this, arg_0));
        extensionSwitcherDialog.refreshButton = jButton;
        JButton jButton3 = this.installButton;
        if (jButton3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"installButton");
            jButton3 = null;
        }
        buttonPanel.add(jButton3);
        JButton jButton4 = this.refreshButton;
        if (jButton4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"refreshButton");
            jButton4 = null;
        }
        buttonPanel.add(jButton4);
        rightPanel.add((Component)buttonPanel, "South");
        panel.add((Component)leftPanel, "West");
        panel.add(Box.createHorizontalStrut(16), "Center");
        panel.add((Component)rightPanel, "East");
        return panel;
    }

    private final void setupUI() {
        this.updateUI(null);
    }

    private final ListCellRenderer<ExtensionListItem> listCellRenderer() {
        return (arg_0, arg_1, arg_2, arg_3, arg_4) -> ExtensionSwitcherDialog.listCellRenderer$lambda$15(this, arg_0, arg_1, arg_2, arg_3, arg_4);
    }

    private final ListSelectionListener listSelectionListener() {
        return arg_0 -> ExtensionSwitcherDialog.listSelectionListener$lambda$16(this, arg_0);
    }

    private final String statusText(ExtensionListItem item) {
        return this.getExtensionStatus(item).getStatus();
    }

    /*
     * Unable to fully structure code
     */
    private final Color statusColor(ExtensionListItem item) {
        block10: {
            block8: {
                block9: {
                    var2_2 = this.getExtensionStatus(item).getStatus();
                    switch (var2_2.hashCode()) {
                        case -1240223152: {
                            if (var2_2.equals("Next Startup")) break;
                            ** break;
                        }
                        case 2033014618: {
                            if (!var2_2.equals("Installed")) {
                                ** break;
                            }
                            break block8;
                        }
                        case 1765354721: {
                            if (!var2_2.equals("Uninstalled")) {
                                ** break;
                            }
                            break block9;
                        }
                        case -1503373991: {
                            if (!var2_2.equals("Current")) ** break;
                            v0 = JBColor.GREEN;
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"GREEN");
                            v1 = (Color)v0;
                            break block10;
                        }
                    }
                    v2 = JBColor.BLUE;
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"BLUE");
                    v1 = (Color)v2;
                    break block10;
                }
                v3 = JBColor.RED;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"RED");
                v1 = (Color)v3;
                break block10;
            }
            v4 = JBColor.BLUE;
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"BLUE");
            v1 = (Color)v4;
            break block10;
lbl34:
            // 5 sources

            v5 = JBColor.ORANGE;
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"ORANGE");
            v1 = (Color)v5;
        }
        return v1;
    }

    private final ExtensionStatus getExtensionStatus(ExtensionListItem item) {
        return item.isCurrent() ? new ExtensionStatus("Current", "\ud83d\udd04 Currently Running", "\ud83d\udd04", "Reload") : (this.isConfiguredForNextStartup(item.getId()) ? new ExtensionStatus("Next Startup", "\u23ed\ufe0f  Next Startup", "\u23ed\ufe0f", "Will Activate Next Startup") : (!item.isAvailable() ? new ExtensionStatus("Uninstalled", "Uninstalled", "", "Switch") : (item.getResourceStatus().getProjectResourceExists() || item.getResourceStatus().getVsixResourceExists() ? new ExtensionStatus("Installed", "\u2705 Installed", "\u2705", "Switch") : new ExtensionStatus("Built-in", "\ud83d\udce6 Built-in", "\ud83d\udce6", "Switch"))));
    }

    private final boolean isConfiguredForNextStartup(String extensionId) {
        return Intrinsics.areEqual((Object)extensionId, (Object)this.configManager.getCurrentExtensionId());
    }

    private final boolean isCurrentlyRunning(String extensionId) {
        ExtensionProvider currentProvider;
        ExtensionProvider extensionProvider = currentProvider = this.extensionManager.getCurrentProvider();
        return Intrinsics.areEqual((Object)(extensionProvider != null ? extensionProvider.getExtensionId() : null), (Object)extensionId);
    }

    private final void loadExtensions() {
        int currentIndex;
        block7: {
            int n;
            JBList<ExtensionListItem> jBList;
            this.extensionListItems.clear();
            ExtensionProvider current = this.extensionManager.getCurrentProvider();
            List<ExtensionProvider> providers = this.extensionManager.getAllProviders();
            Iterable $this$forEach$iv = providers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ExtensionProvider p = (ExtensionProvider)element$iv;
                boolean bl = false;
                ResourceStatus rs = this.checkResources(p);
                ExtensionListItem item = new ExtensionListItem(p.getExtensionId(), p.getDisplayName(), p.getDescription(), p.isAvailable(this.project), this.isCurrentlyRunning(p.getExtensionId()), rs);
                this.extensionListItems.add(item);
            }
            List<ExtensionListItem> $this$sortBy$iv = this.extensionListItems;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        ExtensionListItem it = (ExtensionListItem)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getDisplayName());
                        it = (ExtensionListItem)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getDisplayName())));
                    }
                });
            }
            if ((jBList = this.extensionList) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"extensionList");
                jBList = null;
            }
            Collection $this$toTypedArray$iv = this.extensionListItems;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            jBList.setListData((Object[])thisCollection$iv.toArray(new ExtensionListItem[0]));
            List<ExtensionListItem> $this$indexOfFirst$iv = this.extensionListItems;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<ExtensionListItem> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                ExtensionListItem item$iv;
                ExtensionListItem it = item$iv = iterator.next();
                boolean bl = false;
                if (it.isCurrent()) {
                    n = index$iv;
                    break block7;
                }
                ++index$iv;
            }
            n = currentIndex = -1;
        }
        if (currentIndex >= 0) {
            JBList<ExtensionListItem> jBList = this.extensionList;
            if (jBList == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"extensionList");
                jBList = null;
            }
            jBList.setSelectedIndex(currentIndex);
            this.selectedExtensionId = this.extensionListItems.get(currentIndex).getId();
            this.updateUI(this.extensionListItems.get(currentIndex));
        }
    }

    private final void updateUI(ExtensionListItem item) {
        if (item == null) {
            JBLabel jBLabel = this.descriptionLabel;
            if (jBLabel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"descriptionLabel");
                jBLabel = null;
            }
            jBLabel.setText("Select an extension to view details");
            JBLabel jBLabel2 = this.statusLabel;
            if (jBLabel2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"statusLabel");
                jBLabel2 = null;
            }
            jBLabel2.setText("");
            JButton jButton = this.switchButton;
            if (jButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"switchButton");
                jButton = null;
            }
            jButton.setEnabled(false);
            JBCheckBox jBCheckBox = this.setAsDefaultCheckBox;
            if (jBCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"setAsDefaultCheckBox");
                jBCheckBox = null;
            }
            jBCheckBox.setEnabled(false);
            return;
        }
        JBLabel jBLabel = this.descriptionLabel;
        if (jBLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"descriptionLabel");
            jBLabel = null;
        }
        jBLabel.setText(item.getDescription());
        ExtensionStatus extensionStatus = this.getExtensionStatus(item);
        JBLabel jBLabel3 = this.statusLabel;
        if (jBLabel3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"statusLabel");
            jBLabel3 = null;
        }
        jBLabel3.setText("Status: " + extensionStatus.getDisplayText());
        boolean canSwitch = item.isAvailable() && !item.isCurrent() && !this.isConfiguredForNextStartup(item.getId()) && !this.isSwitching;
        JButton jButton = this.switchButton;
        if (jButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"switchButton");
            jButton = null;
        }
        jButton.setEnabled(canSwitch);
        JButton jButton2 = this.switchButton;
        if (jButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"switchButton");
            jButton2 = null;
        }
        jButton2.setText(extensionStatus.getButtonText());
        JBCheckBox jBCheckBox = this.setAsDefaultCheckBox;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"setAsDefaultCheckBox");
            jBCheckBox = null;
        }
        jBCheckBox.setEnabled(item.isAvailable() && !item.isCurrent());
    }

    private final void uploadVsixFile() {
        Object object;
        block7: {
            block6: {
                Object v1;
                block5: {
                    object = this.selectedExtensionId;
                    if (object == null) break block6;
                    String id = object;
                    boolean bl = false;
                    Iterable iterable = this.extensionListItems;
                    for (Object t : iterable) {
                        ExtensionListItem it = (ExtensionListItem)t;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                        v1 = t;
                        break block5;
                    }
                    v1 = null;
                }
                ExtensionListItem extensionListItem = v1;
                object = extensionListItem;
                if (extensionListItem != null) break block7;
            }
            ExtensionSwitcherDialog $this$uploadVsixFile_u24lambda_u2422 = this;
            boolean bl = false;
            Messages.showWarningDialog((String)"Please select an extension first.", (String)"No Extension Selected");
            return;
        }
        Object selected = object;
        boolean success = VsixUploadDialog.Companion.show(this.project, ((ExtensionListItem)selected).getId(), ((ExtensionListItem)selected).getDisplayName());
        if (success) {
            this.loadExtensions();
            Messages.showInfoMessage((String)("VSIX file uploaded successfully: " + ((ExtensionListItem)selected).getDisplayName()), (String)"Upload Complete");
        }
    }

    private final void performSwitch() {
        String currentId;
        ExtensionProvider currentProvider;
        String string = this.selectedExtensionId;
        if (string == null) {
            return;
        }
        String target = string;
        ExtensionProvider extensionProvider = currentProvider = this.extensionManager.getCurrentProvider();
        String string2 = currentId = extensionProvider != null ? extensionProvider.getExtensionId() : null;
        if (this.isConfiguredForNextStartup(target)) {
            Messages.showInfoMessage((String)("Extension '" + target + "' is already configured to activate on next startup.\n\nNo action needed."), (String)"Already Configured");
            return;
        }
        if (Intrinsics.areEqual((Object)currentId, (Object)target)) {
            this.performReload(target);
            return;
        }
        int confirm = Messages.showYesNoDialog((String)("Are you sure you want to switch from '" + currentId + "' to '" + target + "'?\n\n\u26a0\ufe0f  IMPORTANT: The extension will take effect on the next startup of IntelliJ IDEA.\nThe current session will continue using the existing extension.\n\nDo you want to continue?"), (String)"Confirm Extension Switch", (String)"Switch", (String)"Cancel", (Icon)Messages.getQuestionIcon());
        if (confirm == 0) {
            JBCheckBox jBCheckBox = this.setAsDefaultCheckBox;
            if (jBCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"setAsDefaultCheckBox");
                jBCheckBox = null;
            }
            if (jBCheckBox.isSelected()) {
                // empty if block
            }
            this.doSwitch(target);
        }
    }

    private final void performReload(String extensionId) {
        if (this.isConfiguredForNextStartup(extensionId)) {
            Messages.showInfoMessage((String)("Extension '" + extensionId + "' is already configured to activate on next startup.\n\nNo reload action needed."), (String)"Already Configured");
            return;
        }
        this.isSwitching = true;
        this.setSwitchingUI(true);
        this.extensionSwitcher.switchExtension(extensionId, true).whenComplete((arg_0, arg_1) -> ExtensionSwitcherDialog.performReload$lambda$25((arg_0, arg_1) -> ExtensionSwitcherDialog.performReload$lambda$24(this, extensionId, arg_0, arg_1), arg_0, arg_1));
    }

    private final void doSwitch(String target) {
        this.isSwitching = true;
        this.setSwitchingUI(true);
        this.extensionSwitcher.switchExtension(target, true).whenComplete((arg_0, arg_1) -> ExtensionSwitcherDialog.doSwitch$lambda$28((arg_0, arg_1) -> ExtensionSwitcherDialog.doSwitch$lambda$27(this, target, arg_0, arg_1), arg_0, arg_1));
    }

    private final void setSwitchingUI(boolean switching) {
        JButton jButton = this.switchButton;
        if (jButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"switchButton");
            jButton = null;
        }
        jButton.setEnabled(!switching);
        JButton jButton2 = this.installButton;
        if (jButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"installButton");
            jButton2 = null;
        }
        jButton2.setEnabled(!switching);
        JButton jButton3 = this.refreshButton;
        if (jButton3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"refreshButton");
            jButton3 = null;
        }
        jButton3.setEnabled(!switching);
        if (switching) {
            JButton jButton4 = this.switchButton;
            if (jButton4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"switchButton");
                jButton4 = null;
            }
            jButton4.setText("Saving Configuration...");
        } else {
            ExtensionListItem selected;
            String string = this.selectedExtensionId;
            if (string != null) {
                Object v5;
                block13: {
                    String id = string;
                    boolean bl = false;
                    Iterable iterable = this.extensionListItems;
                    for (Object t : iterable) {
                        ExtensionListItem it = (ExtensionListItem)t;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                        v5 = t;
                        break block13;
                    }
                    v5 = null;
                }
                v6 = v5;
            } else {
                v6 = selected = null;
            }
            if (selected != null) {
                JButton jButton5 = this.switchButton;
                if (jButton5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"switchButton");
                    jButton5 = null;
                }
                jButton5.setText(this.getExtensionStatus(selected).getButtonText());
            } else {
                JButton jButton6 = this.switchButton;
                if (jButton6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"switchButton");
                    jButton6 = null;
                }
                jButton6.setText("Switch");
            }
        }
    }

    public void doCancelAction() {
        if (this.isSwitching) {
            int result = Messages.showYesNoDialog((String)"Configuration saving is in progress. Are you sure you want to cancel?", (String)"Cancel Configuration Save", (String)"Cancel Save", (String)"Continue Waiting", (Icon)Messages.getQuestionIcon());
            if (result == 0) {
                this.extensionSwitcher.cancelSwitching();
                super.doCancelAction();
            }
        } else {
            super.doCancelAction();
        }
    }

    private final ResourceStatus checkResources(ExtensionProvider provider) {
        ExtensionMetadata cfg = provider.getConfiguration(this.project);
        String base = this.project.getBasePath();
        boolean projExists = false;
        String projPath = null;
        if (base != null) {
            Object[] objectArray = new String[]{base + "/" + cfg.getCodeDir(), base + "/../" + cfg.getCodeDir(), base + "/../../" + cfg.getCodeDir()};
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String p = (String)element$iv;
                boolean bl = false;
                if (projExists || !new File(p).exists()) continue;
                projExists = true;
                projPath = p;
            }
        }
        boolean pluginExists = false;
        String pluginPath = null;
        try {
            String string = PluginResourceUtil.INSTANCE.getResourcePath("com.gitlab.coderider-kilo", cfg.getCodeDir());
            if (string != null) {
                String path = string;
                boolean bl = false;
                if (new File(path).exists()) {
                    pluginExists = true;
                    pluginPath = path;
                }
            }
        }
        catch (Exception element$iv) {
            // empty catch block
        }
        VsixManager vsixMgr = VsixManager.Companion.getInstance();
        String extId = provider.getExtensionId();
        boolean vsixExists = vsixMgr.hasVsixInstallation(extId);
        String vsixPath = vsixExists ? vsixMgr.getVsixInstallationPath(extId) : null;
        return new ResourceStatus(projExists, projPath, pluginExists, pluginPath, vsixExists, vsixPath);
    }

    private static final void createCenterPanel$lambda$6$lambda$5(ExtensionSwitcherDialog this$0, ActionEvent it) {
        this$0.performSwitch();
    }

    private static final void createCenterPanel$lambda$9$lambda$8(ExtensionSwitcherDialog this$0, ActionEvent it) {
        this$0.uploadVsixFile();
    }

    private static final void createCenterPanel$lambda$11$lambda$10(ExtensionSwitcherDialog this$0, ActionEvent it) {
        this$0.loadExtensions();
    }

    private static final Component listCellRenderer$lambda$15(ExtensionSwitcherDialog this$0, JList jList, ExtensionListItem value, int n, boolean isSelected, boolean bl) {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel;
        JPanel $this$listCellRenderer_u24lambda_u2415_u24lambda_u2414 = jPanel = new JPanel(new BorderLayout());
        boolean bl2 = false;
        $this$listCellRenderer_u24lambda_u2415_u24lambda_u2414.setOpaque(true);
        $this$listCellRenderer_u24lambda_u2415_u24lambda_u2414.setBackground(isSelected ? UIUtil.getListSelectionBackground((boolean)true) : UIUtil.getListBackground());
        $this$listCellRenderer_u24lambda_u2415_u24lambda_u2414.setBorder((Border)JBUI.Borders.empty((int)4, (int)8));
        JBLabel $this$listCellRenderer_u24lambda_u2415_u24lambda_u2414_u24lambda_u2412 = jBLabel2 = new JBLabel(value.getDisplayName());
        boolean bl3 = false;
        $this$listCellRenderer_u24lambda_u2415_u24lambda_u2414_u24lambda_u2412.setForeground(isSelected ? UIUtil.getListSelectionForeground((boolean)true) : UIUtil.getListForeground());
        if (value.isCurrent()) {
            $this$listCellRenderer_u24lambda_u2415_u24lambda_u2414_u24lambda_u2412.setFont($this$listCellRenderer_u24lambda_u2415_u24lambda_u2414_u24lambda_u2412.getFont().deriveFont(1));
        }
        JBLabel nameLabel = jBLabel2;
        Intrinsics.checkNotNull((Object)value);
        JBLabel $this$listCellRenderer_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413 = jBLabel = new JBLabel(this$0.statusText(value));
        boolean bl4 = false;
        $this$listCellRenderer_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.setForeground(Color.WHITE);
        $this$listCellRenderer_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.setBackground(this$0.statusColor(value));
        $this$listCellRenderer_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.setBorder((Border)JBUI.Borders.empty((int)2, (int)6));
        $this$listCellRenderer_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.setOpaque(true);
        JBLabel statusLabel = jBLabel;
        $this$listCellRenderer_u24lambda_u2415_u24lambda_u2414.add((Component)nameLabel, "West");
        $this$listCellRenderer_u24lambda_u2415_u24lambda_u2414.add((Component)statusLabel, "East");
        return jPanel;
    }

    private static final void listSelectionListener$lambda$16(ExtensionSwitcherDialog this$0, ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            int idx;
            JBList<ExtensionListItem> jBList = this$0.extensionList;
            if (jBList == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"extensionList");
                jBList = null;
            }
            if ((idx = jBList.getSelectedIndex()) >= 0) {
                JBList<ExtensionListItem> jBList2 = this$0.extensionList;
                if (jBList2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"extensionList");
                    jBList2 = null;
                }
                Object e2 = jBList2.getModel().getElementAt(idx);
                Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type com.sina.weibo.agent.extensions.ui.ExtensionSwitcherDialog.ExtensionListItem");
                ExtensionListItem item = (ExtensionListItem)e2;
                this$0.selectedExtensionId = item.getId();
                this$0.updateUI(item);
            } else {
                this$0.selectedExtensionId = null;
                this$0.updateUI(null);
            }
        }
    }

    private static final void performReload$lambda$24$lambda$23(ExtensionSwitcherDialog this$0, Boolean $success, String $extensionId, Throwable $err) {
        this$0.isSwitching = false;
        this$0.setSwitchingUI(false);
        if ($success.booleanValue()) {
            Messages.showInfoMessage((String)("Extension configuration updated successfully: " + $extensionId + "\n\nNote: The extension will take effect on the next startup of IntelliJ IDEA."), (String)"Configuration Updated");
            this$0.loadExtensions();
        } else {
            Object object = $err;
            if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                object = "Unknown error occurred";
            }
            Object errorMsg = object;
            Messages.showErrorDialog((String)("Failed to update extension configuration: " + (String)errorMsg), (String)"Update Failed");
        }
    }

    private static final Unit performReload$lambda$24(ExtensionSwitcherDialog this$0, String $extensionId, Boolean success, Throwable err) {
        SwingUtilities.invokeLater(() -> ExtensionSwitcherDialog.performReload$lambda$24$lambda$23(this$0, success, $extensionId, err));
        return Unit.INSTANCE;
    }

    private static final void performReload$lambda$25(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void doSwitch$lambda$27$lambda$26(ExtensionSwitcherDialog this$0, Boolean $success, String $target, Throwable $err) {
        this$0.isSwitching = false;
        this$0.setSwitchingUI(false);
        if ($success.booleanValue()) {
            Messages.showInfoMessage((String)("Extension switch configuration saved successfully!\n\n\u2705 Extension: " + $target + "\n\u26a0\ufe0f  The extension will take effect on the next startup of IntelliJ IDEA.\n\ud83d\udd04 Please restart IntelliJ IDEA to activate the new extension."), (String)"Extension Switch Complete");
            this$0.loadExtensions();
        } else {
            Object object = $err;
            if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                object = "Unknown error occurred";
            }
            Object errorMsg = object;
            Messages.showErrorDialog((String)("Failed to save extension switch configuration: " + (String)errorMsg), (String)"Configuration Save Failed");
            this$0.loadExtensions();
        }
    }

    private static final Unit doSwitch$lambda$27(ExtensionSwitcherDialog this$0, String $target, Boolean success, Throwable err) {
        SwingUtilities.invokeLater(() -> ExtensionSwitcherDialog.doSwitch$lambda$27$lambda$26(this$0, success, $target, err));
        return Unit.INSTANCE;
    }

    private static final void doSwitch$lambda$28(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\nH\u00c6\u0003JE\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/sina/weibo/agent/extensions/ui/ExtensionSwitcherDialog$ExtensionListItem;", "", "id", "", "displayName", "description", "isAvailable", "", "isCurrent", "resourceStatus", "Lcom/sina/weibo/agent/extensions/ui/ExtensionSwitcherDialog$ResourceStatus;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZLcom/sina/weibo/agent/extensions/ui/ExtensionSwitcherDialog$ResourceStatus;)V", "getId", "()Ljava/lang/String;", "getDisplayName", "getDescription", "()Z", "getResourceStatus", "()Lcom/sina/weibo/agent/extensions/ui/ExtensionSwitcherDialog$ResourceStatus;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "coderider-kilo-jetbrains"})
    private static final class ExtensionListItem {
        @NotNull
        private final String id;
        @NotNull
        private final String displayName;
        @NotNull
        private final String description;
        private final boolean isAvailable;
        private final boolean isCurrent;
        @NotNull
        private final ResourceStatus resourceStatus;

        public ExtensionListItem(@NotNull String id, @NotNull String displayName, @NotNull String description, boolean isAvailable, boolean isCurrent, @NotNull ResourceStatus resourceStatus) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)resourceStatus, (String)"resourceStatus");
            this.id = id;
            this.displayName = displayName;
            this.description = description;
            this.isAvailable = isAvailable;
            this.isCurrent = isCurrent;
            this.resourceStatus = resourceStatus;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public final boolean isAvailable() {
            return this.isAvailable;
        }

        public final boolean isCurrent() {
            return this.isCurrent;
        }

        @NotNull
        public final ResourceStatus getResourceStatus() {
            return this.resourceStatus;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.displayName;
        }

        @NotNull
        public final String component3() {
            return this.description;
        }

        public final boolean component4() {
            return this.isAvailable;
        }

        public final boolean component5() {
            return this.isCurrent;
        }

        @NotNull
        public final ResourceStatus component6() {
            return this.resourceStatus;
        }

        @NotNull
        public final ExtensionListItem copy(@NotNull String id, @NotNull String displayName, @NotNull String description, boolean isAvailable, boolean isCurrent, @NotNull ResourceStatus resourceStatus) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)resourceStatus, (String)"resourceStatus");
            return new ExtensionListItem(id, displayName, description, isAvailable, isCurrent, resourceStatus);
        }

        public static /* synthetic */ ExtensionListItem copy$default(ExtensionListItem extensionListItem, String string, String string2, String string3, boolean bl, boolean bl2, ResourceStatus resourceStatus, int n, Object object) {
            if ((n & 1) != 0) {
                string = extensionListItem.id;
            }
            if ((n & 2) != 0) {
                string2 = extensionListItem.displayName;
            }
            if ((n & 4) != 0) {
                string3 = extensionListItem.description;
            }
            if ((n & 8) != 0) {
                bl = extensionListItem.isAvailable;
            }
            if ((n & 0x10) != 0) {
                bl2 = extensionListItem.isCurrent;
            }
            if ((n & 0x20) != 0) {
                resourceStatus = extensionListItem.resourceStatus;
            }
            return extensionListItem.copy(string, string2, string3, bl, bl2, resourceStatus);
        }

        @NotNull
        public String toString() {
            return "ExtensionListItem(id=" + this.id + ", displayName=" + this.displayName + ", description=" + this.description + ", isAvailable=" + this.isAvailable + ", isCurrent=" + this.isCurrent + ", resourceStatus=" + this.resourceStatus + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.displayName.hashCode();
            result = result * 31 + this.description.hashCode();
            result = result * 31 + Boolean.hashCode(this.isAvailable);
            result = result * 31 + Boolean.hashCode(this.isCurrent);
            result = result * 31 + this.resourceStatus.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExtensionListItem)) {
                return false;
            }
            ExtensionListItem extensionListItem = (ExtensionListItem)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)extensionListItem.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.displayName, (Object)extensionListItem.displayName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)extensionListItem.description)) {
                return false;
            }
            if (this.isAvailable != extensionListItem.isAvailable) {
                return false;
            }
            if (this.isCurrent != extensionListItem.isCurrent) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.resourceStatus, (Object)extensionListItem.resourceStatus);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/sina/weibo/agent/extensions/ui/ExtensionSwitcherDialog$ExtensionStatus;", "", "status", "", "displayText", "icon", "buttonText", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getStatus", "()Ljava/lang/String;", "getDisplayText", "getIcon", "getButtonText", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "coderider-kilo-jetbrains"})
    private static final class ExtensionStatus {
        @NotNull
        private final String status;
        @NotNull
        private final String displayText;
        @NotNull
        private final String icon;
        @NotNull
        private final String buttonText;

        public ExtensionStatus(@NotNull String status, @NotNull String displayText, @NotNull String icon, @NotNull String buttonText) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Intrinsics.checkNotNullParameter((Object)displayText, (String)"displayText");
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)buttonText, (String)"buttonText");
            this.status = status;
            this.displayText = displayText;
            this.icon = icon;
            this.buttonText = buttonText;
        }

        @NotNull
        public final String getStatus() {
            return this.status;
        }

        @NotNull
        public final String getDisplayText() {
            return this.displayText;
        }

        @NotNull
        public final String getIcon() {
            return this.icon;
        }

        @NotNull
        public final String getButtonText() {
            return this.buttonText;
        }

        @NotNull
        public final String component1() {
            return this.status;
        }

        @NotNull
        public final String component2() {
            return this.displayText;
        }

        @NotNull
        public final String component3() {
            return this.icon;
        }

        @NotNull
        public final String component4() {
            return this.buttonText;
        }

        @NotNull
        public final ExtensionStatus copy(@NotNull String status, @NotNull String displayText, @NotNull String icon, @NotNull String buttonText) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Intrinsics.checkNotNullParameter((Object)displayText, (String)"displayText");
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)buttonText, (String)"buttonText");
            return new ExtensionStatus(status, displayText, icon, buttonText);
        }

        public static /* synthetic */ ExtensionStatus copy$default(ExtensionStatus extensionStatus, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = extensionStatus.status;
            }
            if ((n & 2) != 0) {
                string2 = extensionStatus.displayText;
            }
            if ((n & 4) != 0) {
                string3 = extensionStatus.icon;
            }
            if ((n & 8) != 0) {
                string4 = extensionStatus.buttonText;
            }
            return extensionStatus.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "ExtensionStatus(status=" + this.status + ", displayText=" + this.displayText + ", icon=" + this.icon + ", buttonText=" + this.buttonText + ")";
        }

        public int hashCode() {
            int result = this.status.hashCode();
            result = result * 31 + this.displayText.hashCode();
            result = result * 31 + this.icon.hashCode();
            result = result * 31 + this.buttonText.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExtensionStatus)) {
                return false;
            }
            ExtensionStatus extensionStatus = (ExtensionStatus)other;
            if (!Intrinsics.areEqual((Object)this.status, (Object)extensionStatus.status)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.displayText, (Object)extensionStatus.displayText)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.icon, (Object)extensionStatus.icon)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.buttonText, (Object)extensionStatus.buttonText);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0018\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003JK\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\b\u001a\u00020\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0013\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/sina/weibo/agent/extensions/ui/ExtensionSwitcherDialog$ResourceStatus;", "", "projectResourceExists", "", "projectResourcePath", "", "pluginResourceExists", "pluginResourcePath", "vsixResourceExists", "vsixResourcePath", "<init>", "(ZLjava/lang/String;ZLjava/lang/String;ZLjava/lang/String;)V", "getProjectResourceExists", "()Z", "getProjectResourcePath", "()Ljava/lang/String;", "getPluginResourceExists", "getPluginResourcePath", "getVsixResourceExists", "getVsixResourcePath", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "coderider-kilo-jetbrains"})
    private static final class ResourceStatus {
        private final boolean projectResourceExists;
        @Nullable
        private final String projectResourcePath;
        private final boolean pluginResourceExists;
        @Nullable
        private final String pluginResourcePath;
        private final boolean vsixResourceExists;
        @Nullable
        private final String vsixResourcePath;

        public ResourceStatus(boolean projectResourceExists, @Nullable String projectResourcePath, boolean pluginResourceExists, @Nullable String pluginResourcePath, boolean vsixResourceExists, @Nullable String vsixResourcePath) {
            this.projectResourceExists = projectResourceExists;
            this.projectResourcePath = projectResourcePath;
            this.pluginResourceExists = pluginResourceExists;
            this.pluginResourcePath = pluginResourcePath;
            this.vsixResourceExists = vsixResourceExists;
            this.vsixResourcePath = vsixResourcePath;
        }

        public final boolean getProjectResourceExists() {
            return this.projectResourceExists;
        }

        @Nullable
        public final String getProjectResourcePath() {
            return this.projectResourcePath;
        }

        public final boolean getPluginResourceExists() {
            return this.pluginResourceExists;
        }

        @Nullable
        public final String getPluginResourcePath() {
            return this.pluginResourcePath;
        }

        public final boolean getVsixResourceExists() {
            return this.vsixResourceExists;
        }

        @Nullable
        public final String getVsixResourcePath() {
            return this.vsixResourcePath;
        }

        public final boolean component1() {
            return this.projectResourceExists;
        }

        @Nullable
        public final String component2() {
            return this.projectResourcePath;
        }

        public final boolean component3() {
            return this.pluginResourceExists;
        }

        @Nullable
        public final String component4() {
            return this.pluginResourcePath;
        }

        public final boolean component5() {
            return this.vsixResourceExists;
        }

        @Nullable
        public final String component6() {
            return this.vsixResourcePath;
        }

        @NotNull
        public final ResourceStatus copy(boolean projectResourceExists, @Nullable String projectResourcePath, boolean pluginResourceExists, @Nullable String pluginResourcePath, boolean vsixResourceExists, @Nullable String vsixResourcePath) {
            return new ResourceStatus(projectResourceExists, projectResourcePath, pluginResourceExists, pluginResourcePath, vsixResourceExists, vsixResourcePath);
        }

        public static /* synthetic */ ResourceStatus copy$default(ResourceStatus resourceStatus, boolean bl, String string, boolean bl2, String string2, boolean bl3, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                bl = resourceStatus.projectResourceExists;
            }
            if ((n & 2) != 0) {
                string = resourceStatus.projectResourcePath;
            }
            if ((n & 4) != 0) {
                bl2 = resourceStatus.pluginResourceExists;
            }
            if ((n & 8) != 0) {
                string2 = resourceStatus.pluginResourcePath;
            }
            if ((n & 0x10) != 0) {
                bl3 = resourceStatus.vsixResourceExists;
            }
            if ((n & 0x20) != 0) {
                string3 = resourceStatus.vsixResourcePath;
            }
            return resourceStatus.copy(bl, string, bl2, string2, bl3, string3);
        }

        @NotNull
        public String toString() {
            return "ResourceStatus(projectResourceExists=" + this.projectResourceExists + ", projectResourcePath=" + this.projectResourcePath + ", pluginResourceExists=" + this.pluginResourceExists + ", pluginResourcePath=" + this.pluginResourcePath + ", vsixResourceExists=" + this.vsixResourceExists + ", vsixResourcePath=" + this.vsixResourcePath + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.projectResourceExists);
            result = result * 31 + (this.projectResourcePath == null ? 0 : this.projectResourcePath.hashCode());
            result = result * 31 + Boolean.hashCode(this.pluginResourceExists);
            result = result * 31 + (this.pluginResourcePath == null ? 0 : this.pluginResourcePath.hashCode());
            result = result * 31 + Boolean.hashCode(this.vsixResourceExists);
            result = result * 31 + (this.vsixResourcePath == null ? 0 : this.vsixResourcePath.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ResourceStatus)) {
                return false;
            }
            ResourceStatus resourceStatus = (ResourceStatus)other;
            if (this.projectResourceExists != resourceStatus.projectResourceExists) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.projectResourcePath, (Object)resourceStatus.projectResourcePath)) {
                return false;
            }
            if (this.pluginResourceExists != resourceStatus.pluginResourceExists) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pluginResourcePath, (Object)resourceStatus.pluginResourcePath)) {
                return false;
            }
            if (this.vsixResourceExists != resourceStatus.vsixResourceExists) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.vsixResourcePath, (Object)resourceStatus.vsixResourcePath);
        }
    }
}

