/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.extensions.plugin.coderider;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.sina.weibo.agent.actions.VSCodeCommandActionsKt;
import com.sina.weibo.agent.extensions.ui.buttons.ButtonConfiguration;
import com.sina.weibo.agent.extensions.ui.buttons.ButtonType;
import com.sina.weibo.agent.extensions.ui.buttons.ExtensionButtonProvider;
import com.sina.weibo.agent.webview.WebViewInstance;
import com.sina.weibo.agent.webview.WebViewManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0002J\b\u0010\u0014\u001a\u00020\u000eH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/sina/weibo/agent/extensions/plugin/coderider/CodeRiderButtonProvider;", "Lcom/sina/weibo/agent/extensions/ui/buttons/ExtensionButtonProvider;", "<init>", "()V", "getExtensionId", "", "getDisplayName", "getDescription", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "getButtons", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "createPlusButton", "createPromptsButton", "createMcpButton", "createHistoryButton", "createMarketplaceButton", "createSettingsButton", "getButtonConfiguration", "Lcom/sina/weibo/agent/extensions/ui/buttons/ButtonConfiguration;", "CodeRiderButtonConfiguration", "coderider-kilo-jetbrains"})
public final class CodeRiderButtonProvider
implements ExtensionButtonProvider {
    @Override
    @NotNull
    public String getExtensionId() {
        return "coderider-kilo";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "CodeRider-Kilo";
    }

    @Override
    @NotNull
    public String getDescription() {
        return "\u4e3a AI \u5954\u817e\uff0c\u9a6d\u7801\u5f53\u5148\u3002Most Fluent Agentic Coding.";
    }

    @Override
    public boolean isAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return true;
    }

    @Override
    @NotNull
    public List<AnAction> getButtons(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = new AnAction[]{this.createPlusButton(), this.createPromptsButton(), this.createMcpButton(), this.createHistoryButton(), this.createMarketplaceButton(), this.createSettingsButton()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final AnAction createPlusButton() {
        return new AnAction(){
            {
                this.getTemplatePresentation().setIcon(AllIcons.General.Add);
                this.getTemplatePresentation().setText("New Task");
                this.getTemplatePresentation().setDescription("New task");
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Logger logger = Logger.getInstance(((Object)((Object)this)).getClass());
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                Logger logger2 = logger;
                logger2.info("CodeRider Plus button clicked, command: coderider-kilo.plusButtonClicked");
                Project project = e.getProject();
                if (project == null) {
                    return;
                }
                Project project2 = project;
                try {
                    WebViewInstance latestWebView;
                    WebViewManager webViewManager;
                    WebViewManager webViewManager2 = webViewManager = (WebViewManager)project2.getService(WebViewManager.class);
                    WebViewInstance webViewInstance = latestWebView = webViewManager2 != null ? webViewManager2.getLatestWebView() : null;
                    if (latestWebView != null) {
                        VSCodeCommandActionsKt.executeCommand("coderider-kilo.plusButtonClicked", project2, new Object[0], false);
                    } else {
                        Messages.showWarningDialog((Project)project2, (String)"No active WebView found. Please ensure the CodeRider extension is properly initialized.", (String)"WebView Not Available");
                    }
                }
                catch (Exception ex) {
                    logger2.warn("Error executing Plus command", (Throwable)ex);
                }
            }
        };
    }

    private final AnAction createPromptsButton() {
        return new AnAction(){
            {
                this.getTemplatePresentation().setIcon(AllIcons.General.Information);
                this.getTemplatePresentation().setText("Prompts");
                this.getTemplatePresentation().setDescription("Prompts");
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Logger.getInstance(((Object)((Object)this)).getClass()).info("Prompts button clicked");
                VSCodeCommandActionsKt.executeCommand("coderider-kilo.promptsButtonClicked", e.getProject(), new Object[0], false);
            }
        };
    }

    private final AnAction createMcpButton() {
        return new AnAction(){
            {
                this.getTemplatePresentation().setIcon(AllIcons.Webreferences.Server);
                this.getTemplatePresentation().setText("MCP");
                this.getTemplatePresentation().setDescription("MCP");
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Logger.getInstance(((Object)((Object)this)).getClass()).info("MCP button clicked");
                VSCodeCommandActionsKt.executeCommand("coderider-kilo.mcpButtonClicked", e.getProject(), new Object[0], false);
            }
        };
    }

    private final AnAction createHistoryButton() {
        return new AnAction(){
            {
                this.getTemplatePresentation().setIcon(AllIcons.Vcs.History);
                this.getTemplatePresentation().setText("History");
                this.getTemplatePresentation().setDescription("History");
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Logger.getInstance(((Object)((Object)this)).getClass()).info("History button clicked");
                VSCodeCommandActionsKt.executeCommand("coderider-kilo.historyButtonClicked", e.getProject(), new Object[0], false);
            }
        };
    }

    private final AnAction createMarketplaceButton() {
        return new AnAction(){
            {
                this.getTemplatePresentation().setIcon(AllIcons.Nodes.ModuleGroup);
                this.getTemplatePresentation().setText("Marketplace");
                this.getTemplatePresentation().setDescription("Marketplace");
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Logger.getInstance(((Object)((Object)this)).getClass()).info("Marketplace button clicked");
                VSCodeCommandActionsKt.executeCommand("coderider-kilo.marketplaceButtonClicked", e.getProject(), new Object[0], false);
            }
        };
    }

    private final AnAction createSettingsButton() {
        return new AnAction(){
            {
                this.getTemplatePresentation().setIcon(AllIcons.General.Settings);
                this.getTemplatePresentation().setText("Settings");
                this.getTemplatePresentation().setDescription("Settings");
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Logger.getInstance(((Object)((Object)this)).getClass()).info("Settings button clicked");
                VSCodeCommandActionsKt.executeCommand("coderider-kilo.settingsButtonClicked", e.getProject(), new Object[0], false);
            }
        };
    }

    @Override
    @NotNull
    public ButtonConfiguration getButtonConfiguration() {
        return new CodeRiderButtonConfiguration();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/sina/weibo/agent/extensions/plugin/coderider/CodeRiderButtonProvider$CodeRiderButtonConfiguration;", "Lcom/sina/weibo/agent/extensions/ui/buttons/ButtonConfiguration;", "<init>", "()V", "isButtonVisible", "", "buttonType", "Lcom/sina/weibo/agent/extensions/ui/buttons/ButtonType;", "getVisibleButtons", "", "coderider-kilo-jetbrains"})
    private static final class CodeRiderButtonConfiguration
    implements ButtonConfiguration {
        @Override
        public boolean isButtonVisible(@NotNull ButtonType buttonType) {
            Intrinsics.checkNotNullParameter((Object)((Object)buttonType), (String)"buttonType");
            return true;
        }

        @Override
        @NotNull
        public List<ButtonType> getVisibleButtons() {
            return ArraysKt.toList((Object[])ButtonType.values());
        }
    }
}

