/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.extensions.core;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sina.weibo.agent.core.ExtensionManager;
import com.sina.weibo.agent.extensions.common.ExtensionType;
import com.sina.weibo.agent.extensions.config.ExtensionConfig;
import com.sina.weibo.agent.extensions.config.ExtensionConfiguration;
import com.sina.weibo.agent.util.PluginResourceUtil;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000bJ\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000bJ\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0019J\u0006\u0010\u001a\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/sina/weibo/agent/extensions/core/ExtensionManagerFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "extensionManagers", "", "Lcom/sina/weibo/agent/extensions/common/ExtensionType;", "Lcom/sina/weibo/agent/core/ExtensionManager;", "initialize", "", "getCurrentExtensionManager", "getExtensionManager", "extensionType", "createExtensionManager", "config", "Lcom/sina/weibo/agent/extensions/config/ExtensionConfig;", "getExtensionPath", "", "switchExtensionType", "getAvailableExtensionTypes", "", "dispose", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nExtensionManagerFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionManagerFactory.kt\ncom/sina/weibo/agent/extensions/core/ExtensionManagerFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1869#2,2:146\n1869#2,2:148\n*S KotlinDebug\n*F\n+ 1 ExtensionManagerFactory.kt\ncom/sina/weibo/agent/extensions/core/ExtensionManagerFactory\n*L\n45#1:146,2\n142#1:148,2\n*E\n"})
public final class ExtensionManagerFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Logger LOG;
    @NotNull
    private final Map<ExtensionType, ExtensionManager> extensionManagers;

    public ExtensionManagerFactory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Logger logger = Logger.getInstance(ExtensionManagerFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        this.extensionManagers = new LinkedHashMap();
    }

    public final void initialize() {
        this.LOG.info("Initializing extension manager factory");
        ExtensionConfiguration extensionConfig = ExtensionConfiguration.Companion.getInstance(this.project);
        Iterable $this$forEach$iv = ExtensionType.Companion.getAllTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExtensionType extensionType = (ExtensionType)((Object)element$iv);
            boolean bl = false;
            this.createExtensionManager(extensionType, extensionConfig.getConfig(extensionType));
        }
        this.LOG.info("Extension manager factory initialized");
    }

    @NotNull
    public final ExtensionManager getCurrentExtensionManager() {
        ExtensionConfiguration extensionConfig = ExtensionConfiguration.Companion.getInstance(this.project);
        ExtensionType currentType = extensionConfig.getCurrentExtensionType();
        return this.getExtensionManager(currentType);
    }

    @NotNull
    public final ExtensionManager getExtensionManager(@NotNull ExtensionType extensionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)extensionType), (String)"extensionType");
        ExtensionManager extensionManager = this.extensionManagers.get((Object)extensionType);
        if (extensionManager == null) {
            throw new IllegalStateException("Extension manager not found for type: " + extensionType.getCode());
        }
        return extensionManager;
    }

    private final void createExtensionManager(ExtensionType extensionType, ExtensionConfig config) {
        this.LOG.info("Creating extension manager for type: " + extensionType.getCode());
        ExtensionManager extensionManager = new ExtensionManager();
        String extensionPath = this.getExtensionPath(config);
        if (extensionPath != null && new File(extensionPath).exists()) {
            try {
                extensionManager.registerExtension(extensionPath, config);
                this.LOG.info("Extension registered for type: " + extensionType.getCode());
                this.extensionManagers.put(extensionType, extensionManager);
            }
            catch (Exception e) {
                this.LOG.warn("Failed to register extension for type: " + extensionType.getCode(), (Throwable)e);
            }
        } else {
            this.LOG.info("Extension path not found for type: " + extensionType.getCode() + ": " + extensionPath);
        }
    }

    private final String getExtensionPath(ExtensionConfig config) {
        try {
            String extensionPath = PluginResourceUtil.INSTANCE.getResourcePath("com.gitlab.coderider-kilo", config.getCodeDir());
            if (extensionPath != null && new File(extensionPath).exists()) {
                this.LOG.info("Found extension path via PluginResourceUtil: " + extensionPath);
                return extensionPath;
            }
        }
        catch (Exception e) {
            this.LOG.warn("Failed to get extension path via PluginResourceUtil for: " + config.getCodeDir(), (Throwable)e);
        }
        this.LOG.warn("Extension path not found for type: " + config.getExtensionType().getCode() + " (" + config.getCodeDir() + ")");
        return null;
    }

    public final void switchExtensionType(@NotNull ExtensionType extensionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)extensionType), (String)"extensionType");
        this.LOG.info("Switching to extension type: " + extensionType.getCode());
        ExtensionConfiguration extensionConfig = ExtensionConfiguration.Companion.getInstance(this.project);
        extensionConfig.setCurrentExtensionType(extensionType);
        ExtensionConfig config = extensionConfig.getConfig(extensionType);
        this.createExtensionManager(extensionType, config);
        this.LOG.info("Switched to extension type: " + extensionType.getCode());
    }

    @NotNull
    public final List<ExtensionType> getAvailableExtensionTypes() {
        return CollectionsKt.toList((Iterable)this.extensionManagers.keySet());
    }

    public final void dispose() {
        this.LOG.info("Disposing extension manager factory");
        Iterable $this$forEach$iv = this.extensionManagers.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExtensionManager it = (ExtensionManager)element$iv;
            boolean bl = false;
            it.dispose();
        }
        this.extensionManagers.clear();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/sina/weibo/agent/extensions/core/ExtensionManagerFactory$Companion;", "", "<init>", "()V", "getInstance", "Lcom/sina/weibo/agent/extensions/core/ExtensionManagerFactory;", "project", "Lcom/intellij/openapi/project/Project;", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionManagerFactory getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ExtensionManagerFactory extensionManagerFactory = (ExtensionManagerFactory)project.getService(ExtensionManagerFactory.class);
            if (extensionManagerFactory == null) {
                throw new IllegalStateException("ExtensionManagerFactory not found".toString());
            }
            return extensionManagerFactory;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

