/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.extensions.core;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sina.weibo.agent.extensions.common.ExtensionChangeListener;
import com.sina.weibo.agent.extensions.config.ExtensionProvider;
import com.sina.weibo.agent.extensions.core.ExtensionConfigurationManager;
import com.sina.weibo.agent.extensions.core.ExtensionSwitcher;
import com.sina.weibo.agent.extensions.plugin.coderider.CodeRiderExtensionProvider;
import com.sina.weibo.agent.extensions.ui.buttons.DynamicButtonManager;
import com.sina.weibo.agent.extensions.ui.contextmenu.DynamicContextMenuManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0012J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016J\b\u0010\u0017\u001a\u00020\u000fH\u0002J\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\fJ\b\u0010\u001a\u001a\u00020\u000fH\u0002J\b\u0010\u001b\u001a\u0004\u0018\u00010\fJ\u001f\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u000b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u001fJ\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120!2\u0006\u0010\u001d\u001a\u00020\u000b2\b\b\u0002\u0010\u001e\u001a\u00020\u0012J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u0016J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0\u0016J\u0010\u0010$\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001d\u001a\u00020\u000bJ\u0006\u0010%\u001a\u00020\u000fJ\u0006\u0010&\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/sina/weibo/agent/extensions/core/ExtensionManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "extensionProviders", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/sina/weibo/agent/extensions/config/ExtensionProvider;", "currentProvider", "initialize", "", "configuredExtensionId", "isConfigurationValid", "", "getConfigurationError", "isProperlyInitialized", "getAllExtensions", "", "registerExtensionProviders", "registerExtensionProvider", "provider", "setDefaultExtensionProvider", "getCurrentProvider", "setCurrentProvider", "extensionId", "forceRestart", "(Ljava/lang/String;Ljava/lang/Boolean;)Z", "switchExtensionProvider", "Ljava/util/concurrent/CompletableFuture;", "getAvailableProviders", "getAllProviders", "getProvider", "initializeCurrentProvider", "dispose", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nExtensionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionManager.kt\ncom/sina/weibo/agent/extensions/core/ExtensionManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,263:1\n1869#2,2:264\n774#2:266\n865#2,2:267\n774#2:270\n865#2,2:271\n1869#2,2:273\n1#3:269\n*S KotlinDebug\n*F\n+ 1 ExtensionManager.kt\ncom/sina/weibo/agent/extensions/core/ExtensionManager\n*L\n116#1:264,2\n132#1:266\n132#1:267,2\n229#1:270\n229#1:271,2\n258#1:273,2\n*E\n"})
public final class ExtensionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Logger LOG;
    @NotNull
    private final ConcurrentHashMap<String, ExtensionProvider> extensionProviders;
    @Nullable
    private volatile ExtensionProvider currentProvider;

    public ExtensionManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Logger logger = Logger.getInstance(ExtensionManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        this.extensionProviders = new ConcurrentHashMap();
    }

    public final void initialize(@Nullable String configuredExtensionId) {
        this.LOG.info("Initializing extension manager with configured extension: " + configuredExtensionId);
        this.registerExtensionProviders();
        if (configuredExtensionId != null) {
            ExtensionProvider provider = this.extensionProviders.get(configuredExtensionId);
            if (provider != null && provider.isAvailable(this.project)) {
                this.currentProvider = provider;
                this.LOG.info("Set configured extension provider: " + configuredExtensionId);
            } else {
                this.LOG.warn("Configured extension provider not available: " + configuredExtensionId);
                this.currentProvider = null;
            }
        } else {
            this.LOG.info("No extension configured, skipping default provider setup");
        }
        this.LOG.info("Extension manager initialized");
    }

    public static /* synthetic */ void initialize$default(ExtensionManager extensionManager, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        extensionManager.initialize(string);
    }

    public final void initialize() {
        this.initialize(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isConfigurationValid() {
        if (this.currentProvider == null) return false;
        ExtensionProvider extensionProvider = this.currentProvider;
        Intrinsics.checkNotNull((Object)extensionProvider);
        if (!extensionProvider.isAvailable(this.project)) return false;
        return true;
    }

    @Nullable
    public final String getConfigurationError() {
        Object object;
        if (this.currentProvider == null) {
            object = "No extension provider set";
        } else {
            ExtensionProvider extensionProvider = this.currentProvider;
            Intrinsics.checkNotNull((Object)extensionProvider);
            if (!extensionProvider.isAvailable(this.project)) {
                ExtensionProvider extensionProvider2 = this.currentProvider;
                Intrinsics.checkNotNull((Object)extensionProvider2);
                object = "Extension provider '" + extensionProvider2.getExtensionId() + "' is not available";
            } else {
                object = null;
            }
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isProperlyInitialized() {
        if (this.currentProvider == null) return false;
        ExtensionProvider extensionProvider = this.currentProvider;
        Intrinsics.checkNotNull((Object)extensionProvider);
        if (!extensionProvider.isAvailable(this.project)) return false;
        return true;
    }

    @NotNull
    public final List<ExtensionProvider> getAllExtensions() {
        ArrayList<CodeRiderExtensionProvider> arrayList;
        ArrayList<CodeRiderExtensionProvider> $this$getAllExtensions_u24lambda_u240 = arrayList = new ArrayList<CodeRiderExtensionProvider>();
        boolean bl = false;
        $this$getAllExtensions_u24lambda_u240.add(new CodeRiderExtensionProvider());
        return arrayList;
    }

    private final void registerExtensionProviders() {
        Iterable $this$forEach$iv = this.getAllExtensions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExtensionProvider it = (ExtensionProvider)element$iv;
            boolean bl = false;
            this.registerExtensionProvider(it);
        }
    }

    public final void registerExtensionProvider(@NotNull ExtensionProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        ((Map)this.extensionProviders).put(provider.getExtensionId(), provider);
        this.LOG.info("Registered extension provider: " + provider.getExtensionId());
    }

    /*
     * WARNING - void declaration
     */
    private final void setDefaultExtensionProvider() {
        void $this$filterTo$iv$iv;
        Collection<ExtensionProvider> collection = this.extensionProviders.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ExtensionProvider it = (ExtensionProvider)element$iv$iv;
            boolean bl = false;
            if (!it.isAvailable(this.project)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List availableProviders = (List)destination$iv$iv;
        if (!((Collection)availableProviders).isEmpty()) {
            Object v1;
            block6: {
                iterable = availableProviders;
                for (Object t : iterable) {
                    ExtensionProvider it = (ExtensionProvider)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getExtensionId(), (Object)"cline")) continue;
                    v1 = t;
                    break block6;
                }
                v1 = null;
            }
            ExtensionProvider rooProvider = v1;
            if (rooProvider != null) {
                this.currentProvider = rooProvider;
                this.LOG.info("Set default extension provider: roo-code (preferred)");
            } else {
                ExtensionProvider extensionProvider = this.currentProvider = (ExtensionProvider)CollectionsKt.first((List)availableProviders);
                this.LOG.info("Set default extension provider: " + (extensionProvider != null ? extensionProvider.getExtensionId() : null));
            }
        } else {
            this.LOG.warn("No available extension providers found");
        }
    }

    @Nullable
    public final ExtensionProvider getCurrentProvider() {
        return this.currentProvider;
    }

    public final boolean setCurrentProvider(@NotNull String extensionId, @Nullable Boolean forceRestart) {
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        ExtensionProvider provider = this.extensionProviders.get(extensionId);
        if (provider != null && provider.isAvailable(this.project)) {
            ExtensionProvider oldProvider = this.currentProvider;
            if (Intrinsics.areEqual((Object)forceRestart, (Object)false)) {
                this.currentProvider = provider;
            }
            provider.initialize(this.project);
            try {
                ExtensionConfigurationManager configManager = ExtensionConfigurationManager.Companion.getInstance(this.project);
                configManager.setCurrentExtensionId(extensionId);
            }
            catch (Exception e) {
                this.LOG.warn("Failed to update configuration manager", (Throwable)e);
            }
            try {
                if (Intrinsics.areEqual((Object)forceRestart, (Object)false)) {
                    DynamicButtonManager buttonManager = DynamicButtonManager.Companion.getInstance(this.project);
                    buttonManager.setCurrentExtension(extensionId);
                }
            }
            catch (Exception e) {
                this.LOG.warn("Failed to update button configuration", (Throwable)e);
            }
            try {
                if (Intrinsics.areEqual((Object)forceRestart, (Object)false)) {
                    DynamicContextMenuManager contextMenuManager = DynamicContextMenuManager.Companion.getInstance(this.project);
                    contextMenuManager.setCurrentExtension(extensionId);
                }
            }
            catch (Exception e) {
                this.LOG.warn("Failed to update context menu configuration", (Throwable)e);
            }
            try {
                ((ExtensionChangeListener)this.project.getMessageBus().syncPublisher(ExtensionChangeListener.Companion.getEXTENSION_CHANGE_TOPIC())).onExtensionChanged(extensionId);
            }
            catch (Exception e) {
                this.LOG.warn("Failed to notify extension change listeners", (Throwable)e);
            }
            ExtensionProvider extensionProvider = oldProvider;
            this.LOG.info("Configuration updated to extension provider: " + extensionId + " (was: " + (extensionProvider != null ? extensionProvider.getExtensionId() : null) + ") - will take effect on next startup");
            return true;
        }
        this.LOG.warn("Extension provider not found or not available: " + extensionId);
        return false;
    }

    public static /* synthetic */ boolean setCurrentProvider$default(ExtensionManager extensionManager, String string, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return extensionManager.setCurrentProvider(string, bl);
    }

    @NotNull
    public final CompletableFuture<Boolean> switchExtensionProvider(@NotNull String extensionId, boolean forceRestart) {
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        ExtensionSwitcher extensionSwitcher = ExtensionSwitcher.Companion.getInstance(this.project);
        return extensionSwitcher.switchExtension(extensionId, forceRestart);
    }

    public static /* synthetic */ CompletableFuture switchExtensionProvider$default(ExtensionManager extensionManager, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return extensionManager.switchExtensionProvider(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ExtensionProvider> getAvailableProviders() {
        void $this$filterTo$iv$iv;
        Collection<ExtensionProvider> collection = this.extensionProviders.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ExtensionProvider it = (ExtensionProvider)element$iv$iv;
            boolean bl = false;
            if (!it.isAvailable(this.project)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<ExtensionProvider> getAllProviders() {
        Collection<ExtensionProvider> collection = this.extensionProviders.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    @Nullable
    public final ExtensionProvider getProvider(@NotNull String extensionId) {
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        return this.extensionProviders.get(extensionId);
    }

    public final void initializeCurrentProvider() {
        block0: {
            ExtensionProvider extensionProvider = this.currentProvider;
            if (extensionProvider == null) break block0;
            extensionProvider.initialize(this.project);
        }
    }

    public final void dispose() {
        this.LOG.info("Disposing extension manager");
        Collection<ExtensionProvider> collection = this.extensionProviders.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExtensionProvider it = (ExtensionProvider)element$iv;
            boolean bl = false;
            it.dispose();
        }
        this.extensionProviders.clear();
        this.currentProvider = null;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/sina/weibo/agent/extensions/core/ExtensionManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/sina/weibo/agent/extensions/core/ExtensionManager;", "project", "Lcom/intellij/openapi/project/Project;", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ExtensionManager extensionManager = (ExtensionManager)project.getService(ExtensionManager.class);
            if (extensionManager == null) {
                throw new IllegalStateException("ExtensionManager not found".toString());
            }
            return extensionManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

