/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.editor;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sina.weibo.agent.editor.EditorTabDto;
import com.sina.weibo.agent.editor.EditorTabGroupDto;
import com.sina.weibo.agent.editor.EditorTabInput;
import com.sina.weibo.agent.editor.TabGroupHandle;
import com.sina.weibo.agent.editor.TabHandle;
import com.sina.weibo.agent.editor.TabInputBase;
import com.sina.weibo.agent.editor.TabModelOperationKind;
import com.sina.weibo.agent.editor.TabOperation;
import com.sina.weibo.agent.editor.TabOptions;
import com.sina.weibo.agent.editor.TabStateService;
import com.sina.weibo.agent.editor.TabsState;
import com.sina.weibo.agent.editor.TextDiffTabInput;
import com.sina.weibo.agent.util.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00132\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0013J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001e\u001a\u00020\u0013J(\u0010 \u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0080@\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010'\u001a\u0004\u0018\u00010\u00112\u0006\u0010(\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b)J,\u0010*\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u00102\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020-0,H\u0080@\u00a2\u0006\u0004\b.\u0010/J(\u00100\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u00102\u0006\u00101\u001a\u00020\u00132\u0006\u00102\u001a\u00020\u0013H\u0080@\u00a2\u0006\u0004\b3\u00104J<\u0010*\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u00102\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u00105\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u00106\u001a\u0004\u0018\u00010\u001bH\u0080@\u00a2\u0006\u0004\b.\u00107J\u000e\u00108\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0013J\u0010\u00109\u001a\u0004\u0018\u00010\u00112\u0006\u0010(\u001a\u00020\u0010J\u0017\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010\u001e\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b<J\f\u0010=\u001a\b\u0012\u0004\u0012\u00020;0>J\u000e\u0010?\u001a\u00020\u001dH\u0086@\u00a2\u0006\u0002\u0010@R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/sina/weibo/agent/editor/TabStateManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "state", "Lcom/sina/weibo/agent/editor/TabsState;", "tabHandles", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/sina/weibo/agent/editor/TabHandle;", "groupHandles", "", "Lcom/sina/weibo/agent/editor/TabGroupHandle;", "tabStateService", "Lcom/sina/weibo/agent/editor/TabStateService;", "nextGroupId", "createTabGroup", "viewColumn", "isActive", "", "removeGroup", "", "groupId", "getTabGroupHandle", "createTab", "input", "Lcom/sina/weibo/agent/editor/TabInputBase;", "options", "Lcom/sina/weibo/agent/editor/TabOptions;", "createTab$coderider_kilo_jetbrains", "(ILcom/sina/weibo/agent/editor/TabInputBase;Lcom/sina/weibo/agent/editor/TabOptions;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeTab", "id", "removeTab$coderider_kilo_jetbrains", "updateTab", "update", "Lkotlin/Function1;", "Lcom/sina/weibo/agent/editor/EditorTabDto;", "updateTab$coderider_kilo_jetbrains", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "moveTab", "toGroupId", "toIndex", "moveTab$coderider_kilo_jetbrains", "(Ljava/lang/String;IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isDirty", "isPinned", "(Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setActiveGroup", "getTabHandle", "getTabGroup", "Lcom/sina/weibo/agent/editor/EditorTabGroupDto;", "getTabGroup$coderider_kilo_jetbrains", "getAllGroups", "", "close", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nTabStateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TabStateManager.kt\ncom/sina/weibo/agent/editor/TabStateManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,485:1\n216#2,2:486\n216#2,2:510\n360#3,7:488\n360#3,7:496\n360#3,7:503\n1#4:495\n*S KotlinDebug\n*F\n+ 1 TabStateManager.kt\ncom/sina/weibo/agent/editor/TabStateManager\n*L\n56#1:486,2\n311#1:510,2\n165#1:488,7\n206#1:496,7\n237#1:503,7\n*E\n"})
public final class TabStateManager {
    @NotNull
    private Project project;
    @NotNull
    private final Logger logger;
    @NotNull
    private TabsState state;
    @NotNull
    private final ConcurrentHashMap<String, TabHandle> tabHandles;
    @NotNull
    private final ConcurrentHashMap<Integer, TabGroupHandle> groupHandles;
    @NotNull
    private final TabStateService tabStateService;
    private int nextGroupId;

    public TabStateManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Logger logger = Logger.getInstance(TabStateManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.state = new TabsState(null, 1, null);
        this.tabHandles = new ConcurrentHashMap();
        this.groupHandles = new ConcurrentHashMap();
        this.tabStateService = new TabStateService(this.project);
        this.nextGroupId = 1;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void setProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<set-?>");
        this.project = project;
    }

    @NotNull
    public final TabGroupHandle createTabGroup(int viewColumn, boolean isActive) {
        Object object;
        int n = this.nextGroupId;
        this.nextGroupId = n + 1;
        int groupId = n;
        EditorTabGroupDto group = new EditorTabGroupDto(groupId, isActive, viewColumn, CollectionsKt.emptyList());
        Integer n2 = groupId;
        this.state.getGroups().put(n2, group);
        if (isActive) {
            Map<Integer, EditorTabGroupDto> $this$forEach$iv = this.state.getGroups();
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = (Map.Entry)object.next();
                boolean bl = false;
                int id = ((Number)entry.getKey()).intValue();
                EditorTabGroupDto otherGroup = (EditorTabGroupDto)entry.getValue();
                if (id == groupId) continue;
                Integer n3 = id;
                this.state.getGroups().put(n3, EditorTabGroupDto.copy$default(otherGroup, 0, false, 0, null, 13, null));
            }
        }
        TabGroupHandle handle2 = new TabGroupHandle(groupId, this);
        object = groupId;
        ((Map)this.groupHandles).put(object, handle2);
        this.tabStateService.acceptEditorTabModel(CollectionsKt.toList((Iterable)this.state.getGroups().values()));
        return handle2;
    }

    public static /* synthetic */ TabGroupHandle createTabGroup$default(TabStateManager tabStateManager, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return tabStateManager.createTabGroup(n, bl);
    }

    public final void removeGroup(int groupId) {
        this.state.getGroups().remove(groupId);
        this.groupHandles.remove(groupId);
        Set<Map.Entry<String, TabHandle>> set2 = this.tabHandles.entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-entries>(...)");
        CollectionsKt.removeAll((Iterable)set2, arg_0 -> TabStateManager.removeGroup$lambda$1(groupId, arg_0));
    }

    @Nullable
    public final TabGroupHandle getTabGroupHandle(int groupId) {
        return this.groupHandles.get(groupId);
    }

    @Nullable
    public final Object createTab$coderider_kilo_jetbrains(int groupId, @NotNull TabInputBase input, @NotNull TabOptions options, @NotNull Continuation<? super TabHandle> $completion) {
        if (input instanceof EditorTabInput) {
            URI uRI = ((EditorTabInput)input).getUri();
            this.logger.info("create tab s" + (uRI != null ? uRI.getPath() : null));
        }
        if (input instanceof TextDiffTabInput) {
            this.logger.info("create tab d" + ((TextDiffTabInput)input).getModified().getPath());
        }
        EditorTabGroupDto editorTabGroupDto = this.state.getGroups().get(Boxing.boxInt((int)groupId));
        if (editorTabGroupDto == null) {
            throw new IllegalStateException(("Group not found: " + groupId).toString());
        }
        EditorTabGroupDto group = editorTabGroupDto;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        EditorTabDto tab = new EditorTabDto(string, "", input, options.isActive(), options.isPinned(), !options.isPinned(), false);
        List newTabs = CollectionsKt.plus((Collection)group.getTabs(), (Object)tab);
        EditorTabGroupDto newGroup = EditorTabGroupDto.copy$default(group, 0, false, 0, newTabs, 7, null);
        Integer n = Boxing.boxInt((int)groupId);
        this.state.getGroups().put(n, newGroup);
        TabHandle handle2 = new TabHandle(tab.getId(), groupId, this);
        ((Map)this.tabHandles).put(tab.getId(), handle2);
        this.tabStateService.acceptTabOperation(new TabOperation(groupId, newTabs.size() - 1, tab, TabModelOperationKind.TAB_OPEN.getValue(), null));
        this.tabStateService.acceptTabGroupUpdate(newGroup);
        return handle2;
    }

    @Nullable
    public final TabHandle removeTab$coderider_kilo_jetbrains(@NotNull String id) {
        int index;
        EditorTabGroupDto group;
        TabHandle handle2;
        block8: {
            int n;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            TabHandle tabHandle = this.tabHandles.get(id);
            if (tabHandle == null) {
                return null;
            }
            handle2 = tabHandle;
            EditorTabGroupDto editorTabGroupDto = this.state.getGroups().get(handle2.getGroupId());
            if (editorTabGroupDto == null) {
                return null;
            }
            group = editorTabGroupDto;
            List<EditorTabDto> $this$indexOfFirst$iv = group.getTabs();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<EditorTabDto> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                EditorTabDto item$iv;
                EditorTabDto it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getId(), (Object)id)) {
                    n = index$iv;
                    break block8;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (index != -1) {
            List index$iv;
            EditorTabDto tab = group.getTabs().get(index);
            if (tab.getInput() instanceof EditorTabInput) {
                URI uRI = ((EditorTabInput)tab.getInput()).getUri();
                this.logger.info("remove tab s" + (uRI != null ? uRI.getPath() : null));
            }
            if (tab.getInput() instanceof TextDiffTabInput) {
                this.logger.info("remove tab d" + ((TextDiffTabInput)tab.getInput()).getModified().getPath());
            }
            List $this$removeTab_u24lambda_u243 = index$iv = CollectionsKt.toMutableList((Collection)group.getTabs());
            boolean bl = false;
            $this$removeTab_u24lambda_u243.remove(index);
            List newTabs = index$iv;
            EditorTabGroupDto newGroup = EditorTabGroupDto.copy$default(group, 0, false, 0, newTabs, 7, null);
            this.state.getGroups().put(handle2.getGroupId(), newGroup);
            EditorTabGroupDto editorTabGroupDto = this.state.getGroups().get(handle2.getGroupId());
            if (editorTabGroupDto != null) {
                editorTabGroupDto.setActive(false);
            }
            this.tabHandles.remove(id);
            this.tabStateService.acceptTabOperation(new TabOperation(handle2.getGroupId(), index, tab, TabModelOperationKind.TAB_CLOSE.getValue(), null));
            this.tabStateService.acceptTabGroupUpdate(newGroup);
        }
        return handle2;
    }

    @Nullable
    public final Object updateTab$coderider_kilo_jetbrains(@NotNull String id, @NotNull Function1<? super EditorTabDto, EditorTabDto> update, @NotNull Continuation<? super Unit> $completion) {
        int index;
        EditorTabGroupDto group;
        TabHandle handle2;
        block5: {
            int n;
            TabHandle tabHandle = this.tabHandles.get(id);
            if (tabHandle == null) {
                return Unit.INSTANCE;
            }
            handle2 = tabHandle;
            EditorTabGroupDto editorTabGroupDto = this.state.getGroups().get(Boxing.boxInt((int)handle2.getGroupId()));
            if (editorTabGroupDto == null) {
                return Unit.INSTANCE;
            }
            group = editorTabGroupDto;
            List<EditorTabDto> $this$indexOfFirst$iv = group.getTabs();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<EditorTabDto> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                EditorTabDto item$iv;
                EditorTabDto it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getId(), (Object)id)) {
                    n = index$iv;
                    break block5;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (index != -1) {
            List list;
            EditorTabDto tab = (EditorTabDto)update.invoke((Object)group.getTabs().get(index));
            List $this$updateTab_u24lambda_u245 = list = CollectionsKt.toMutableList((Collection)group.getTabs());
            boolean bl = false;
            $this$updateTab_u24lambda_u245.set(index, tab);
            List newTabs = list;
            this.state.getGroups().put(Boxing.boxInt((int)handle2.getGroupId()), EditorTabGroupDto.copy$default(group, 0, false, 0, newTabs, 7, null));
            this.tabStateService.acceptTabOperation(new TabOperation(handle2.getGroupId(), index, tab, TabModelOperationKind.TAB_UPDATE.getValue(), null));
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object moveTab$coderider_kilo_jetbrains(@NotNull String id, int toGroupId, int toIndex, @NotNull Continuation<? super Unit> $completion) {
        int fromIndex;
        Object object;
        EditorTabGroupDto toGroup;
        EditorTabGroupDto fromGroup;
        TabHandle handle2;
        block8: {
            int n;
            TabHandle tabHandle = this.tabHandles.get(id);
            if (tabHandle == null) {
                return Unit.INSTANCE;
            }
            handle2 = tabHandle;
            EditorTabGroupDto editorTabGroupDto = this.state.getGroups().get(Boxing.boxInt((int)handle2.getGroupId()));
            if (editorTabGroupDto == null) {
                return Unit.INSTANCE;
            }
            fromGroup = editorTabGroupDto;
            EditorTabGroupDto editorTabGroupDto2 = this.state.getGroups().get(Boxing.boxInt((int)toGroupId));
            if (editorTabGroupDto2 == null) {
                return Unit.INSTANCE;
            }
            toGroup = editorTabGroupDto2;
            List<EditorTabDto> $this$indexOfFirst$iv = fromGroup.getTabs();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            object = $this$indexOfFirst$iv.iterator();
            while (object.hasNext()) {
                EditorTabDto item$iv;
                EditorTabDto it = item$iv = object.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getId(), (Object)id)) {
                    n = index$iv;
                    break block8;
                }
                ++index$iv;
            }
            n = fromIndex = -1;
        }
        if (fromIndex != -1) {
            EditorTabDto tab = fromGroup.getTabs().get(fromIndex);
            if (handle2.getGroupId() == toGroupId) {
                List index$iv;
                List $this$moveTab_u24lambda_u247 = index$iv = CollectionsKt.toMutableList((Collection)fromGroup.getTabs());
                boolean bl = false;
                $this$moveTab_u24lambda_u247.remove(fromIndex);
                $this$moveTab_u24lambda_u247.add(toIndex, tab);
                List newTabs = index$iv;
                this.state.getGroups().put(Boxing.boxInt((int)handle2.getGroupId()), EditorTabGroupDto.copy$default(fromGroup, 0, false, 0, newTabs, 7, null));
                this.tabStateService.acceptTabOperation(new TabOperation(handle2.getGroupId(), toIndex, tab, TabModelOperationKind.TAB_MOVE.getValue(), Boxing.boxInt((int)fromIndex)));
            } else {
                List index$iv;
                List $this$moveTab_u24lambda_u248 = index$iv = CollectionsKt.toMutableList((Collection)fromGroup.getTabs());
                boolean bl = false;
                $this$moveTab_u24lambda_u248.remove(fromIndex);
                List newFromTabs = index$iv;
                Object $this$moveTab_u24lambda_u249 = object = CollectionsKt.toMutableList((Collection)toGroup.getTabs());
                boolean bl2 = false;
                $this$moveTab_u24lambda_u249.add(toIndex, tab);
                Object newToTabs = object;
                this.state.getGroups().put(Boxing.boxInt((int)handle2.getGroupId()), EditorTabGroupDto.copy$default(fromGroup, 0, false, 0, newFromTabs, 7, null));
                Integer n = Boxing.boxInt((int)toGroupId);
                this.state.getGroups().put(n, EditorTabGroupDto.copy$default(toGroup, 0, false, 0, (List)newToTabs, 7, null));
                handle2.setGroupId(toGroupId);
                this.tabStateService.acceptTabOperation(new TabOperation(toGroupId, toIndex, tab, TabModelOperationKind.TAB_MOVE.getValue(), Boxing.boxInt((int)fromIndex)));
            }
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object updateTab$coderider_kilo_jetbrains(@NotNull String id, @Nullable Boolean isActive, @Nullable Boolean isDirty, @Nullable Boolean isPinned, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.updateTab$coderider_kilo_jetbrains(id, (Function1<? super EditorTabDto, EditorTabDto>)((Function1)arg_0 -> TabStateManager.updateTab$lambda$10(isActive, isDirty, isPinned, arg_0)), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object updateTab$coderider_kilo_jetbrains$default(TabStateManager tabStateManager, String string, Boolean bl, Boolean bl2, Boolean bl3, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = null;
        }
        if ((n & 4) != 0) {
            bl2 = null;
        }
        if ((n & 8) != 0) {
            bl3 = null;
        }
        return tabStateManager.updateTab$coderider_kilo_jetbrains(string, bl, bl2, bl3, (Continuation<? super Unit>)continuation);
    }

    public final void setActiveGroup(int groupId) {
        Map<Integer, EditorTabGroupDto> $this$forEach$iv = this.state.getGroups();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Integer, EditorTabGroupDto>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, EditorTabGroupDto> element$iv;
            Map.Entry<Integer, EditorTabGroupDto> entry = element$iv = iterator.next();
            boolean bl = false;
            int id = ((Number)entry.getKey()).intValue();
            EditorTabGroupDto group = entry.getValue();
            Integer n = id;
            this.state.getGroups().put(n, EditorTabGroupDto.copy$default(group, 0, id == groupId, 0, null, 13, null));
        }
        this.tabStateService.acceptEditorTabModel(CollectionsKt.toList((Iterable)this.state.getGroups().values()));
    }

    @Nullable
    public final TabHandle getTabHandle(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.tabHandles.get(id);
    }

    @Nullable
    public final EditorTabGroupDto getTabGroup$coderider_kilo_jetbrains(int groupId) {
        return this.state.getGroups().get(groupId);
    }

    @NotNull
    public final List<EditorTabGroupDto> getAllGroups() {
        return CollectionsKt.toList((Iterable)this.state.getGroups().values());
    }

    @Nullable
    public final Object close(@NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    private static final boolean removeGroup$lambda$1(int $groupId, Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((TabHandle)it.getValue()).getGroupId() == $groupId;
    }

    private static final EditorTabDto updateTab$lambda$10(Boolean $isActive, Boolean $isDirty, Boolean $isPinned, EditorTabDto tab) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        Boolean bl = $isActive;
        boolean bl2 = bl != null ? bl.booleanValue() : tab.isActive();
        Boolean bl3 = $isDirty;
        boolean bl4 = bl3 != null ? bl3.booleanValue() : tab.isDirty();
        Boolean bl5 = $isPinned;
        boolean bl6 = bl5 != null ? bl5.booleanValue() : tab.isPinned();
        Boolean bl7 = $isPinned;
        boolean bl8 = bl7 != null ? !bl7.booleanValue() : tab.isPreview();
        return EditorTabDto.copy$default(tab, null, null, null, bl2, bl6, bl8, bl4, 7, null);
    }
}

