/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.editor;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.editor.ChainDiffVirtualFile;
import com.intellij.diff.editor.DiffEditorTabFilesManager;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.sina.weibo.agent.editor.EditorCommandsKt;
import com.sina.weibo.agent.util.URI;
import java.io.File;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J:\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\r2 \u0010\u000e\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00100\u000f0\u000fH\u0086@\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000fH\u0002J&\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/sina/weibo/agent/editor/MultiDiffCommands;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "vscode_changes", "title", "", "changes", "", "", "(Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "showMultiDiffView", "", "diffRequests", "Lcom/intellij/diff/requests/SimpleDiffRequest;", "createContent", "Lcom/intellij/diff/contents/DiffContent;", "uri", "Lcom/sina/weibo/agent/util/URI;", "preferredFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "coderider-kilo-jetbrains"})
public final class MultiDiffCommands {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;

    public MultiDiffCommands(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Logger logger = Logger.getInstance(MultiDiffCommands.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Object vscode_changes(@NotNull String title, @NotNull List<? extends List<? extends Map<String, ? extends Object>>> changes, @NotNull Continuation<Object> $completion) {
        this.logger.info("Opening multi-file diff view: " + title + " with " + changes.size() + " changes");
        if (changes.isEmpty()) {
            this.logger.warn("No changes provided for multi-diff view");
            return null;
        }
        try {
            List diffRequests = new ArrayList();
            Iterator iterator = ((Iterable)changes).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                DiffContent beforeContent;
                int index = n++;
                List changeTriplet = (List)iterator.next();
                if (changeTriplet.size() != 3) {
                    this.logger.warn("Invalid change triplet at index " + index + ": expected 3 elements, got " + changeTriplet.size());
                    continue;
                }
                URI originalFileUri = EditorCommandsKt.createURI((Map)changeTriplet.get(0));
                URI beforeContentUri = EditorCommandsKt.createURI((Map)changeTriplet.get(1));
                URI afterContentUri = EditorCommandsKt.createURI((Map)changeTriplet.get(2));
                this.logger.info("Processing change for file: " + originalFileUri.getPath());
                DiffContent diffContent = beforeContent = MultiDiffCommands.createContent$default(this, beforeContentUri, this.project, null, 4, null);
                DiffContent afterContent = this.createContent(afterContentUri, this.project, (FileType)(diffContent != null ? diffContent.getContentType() : null));
                if (beforeContent != null && afterContent != null) {
                    String fileName = new File(originalFileUri.getPath()).getName();
                    String diffTitle = fileName + ": Changes";
                    SimpleDiffRequest diffRequest = new SimpleDiffRequest(diffTitle, beforeContent, afterContent, "Original", "Modified");
                    Boxing.boxBoolean((boolean)diffRequests.add(diffRequest));
                    continue;
                }
                this.logger.warn("Failed to create diff content for file: " + originalFileUri.getPath());
            }
            if (!((Collection)diffRequests).isEmpty()) {
                ApplicationManager.getApplication().invokeAndWait(() -> MultiDiffCommands.vscode_changes$lambda$0(this, title, diffRequests));
            } else {
                this.logger.warn("No valid diff requests created");
            }
        }
        catch (Exception e) {
            this.logger.error("Error creating multi-file diff view", (Throwable)e);
        }
        this.logger.info("Multi-file diff view operation completed");
        return null;
    }

    private final void showMultiDiffView(String title, List<? extends SimpleDiffRequest> diffRequests) {
        DiffEditorTabFilesManager diffEditorTabFilesManager = DiffEditorTabFilesManager.Companion.getInstance(this.project);
        try {
            if (diffRequests.size() == 1) {
                DiffRequestChain requestChain = (DiffRequestChain)new SimpleDiffRequestChain((DiffRequest)diffRequests.get(0));
                ChainDiffVirtualFile diffFile = new ChainDiffVirtualFile(requestChain, title);
                diffEditorTabFilesManager.showDiffFile((VirtualFile)diffFile, true);
                this.logger.info("Opened single-file diff view: " + title);
            } else {
                DiffRequestChain requestChain = (DiffRequestChain)new SimpleDiffRequestChain(diffRequests);
                ChainDiffVirtualFile diffFile = new ChainDiffVirtualFile(requestChain, title);
                diffEditorTabFilesManager.showDiffFile((VirtualFile)diffFile, true);
                this.logger.info("Opened multi-file diff view: " + title + " with " + diffRequests.size() + " files");
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to show diff view: " + title, (Throwable)e);
            throw e;
        }
    }

    private final DiffContent createContent(URI uri, Project project, FileType preferredFileType) {
        String string;
        String path = uri.getPath();
        String scheme = uri.getScheme();
        String query = uri.getQuery();
        CharSequence charSequence = scheme;
        if (charSequence == null || charSequence.length() == 0) {
            this.logger.warn("URI scheme is null or empty for path: " + path);
            return null;
        }
        DiffContentFactory diffContentFactory = DiffContentFactory.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)diffContentFactory, (String)"getInstance(...)");
        DiffContentFactory contentFactory = diffContentFactory;
        try {
            DiffContent diffContent;
            string = scheme;
            if (Intrinsics.areEqual((Object)string, (Object)"file")) {
                LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
                LocalFileSystem vfs = localFileSystem;
                fileIO = new File(path);
                if (!((File)fileIO).exists()) {
                    this.logger.debug("File does not exist, creating empty content: " + path);
                    return (DiffContent)contentFactory.create(project, "", preferredFileType);
                }
                VirtualFile file = vfs.refreshAndFindFileByPath(path);
                if (file == null) {
                    this.logger.warn("Virtual file not found: " + path);
                    return (DiffContent)contentFactory.create(project, "", preferredFileType);
                }
                diffContent = contentFactory.create(project, file);
            } else if (Intrinsics.areEqual((Object)string, (Object)"cline-diff")) {
                String string2;
                fileIO = query;
                if (!(fileIO == null || fileIO.length() == 0)) {
                    String string3;
                    try {
                        byte[] bytes = Base64.getDecoder().decode(query);
                        Intrinsics.checkNotNull((Object)bytes);
                        string3 = new String(bytes, Charsets.UTF_8);
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.warn("Failed to decode base64 content for path: " + path, (Throwable)e);
                        string3 = "";
                    }
                    string2 = string3;
                } else {
                    string2 = "";
                }
                String content = string2;
                diffContent = (DiffContent)contentFactory.create(project, content, preferredFileType);
            } else {
                this.logger.warn("Unsupported URI scheme: " + scheme + " for path: " + path);
                diffContent = null;
            }
            string = diffContent;
        }
        catch (Exception e) {
            this.logger.error("Error creating diff content for URI: " + uri, (Throwable)e);
            string = null;
        }
        return string;
    }

    static /* synthetic */ DiffContent createContent$default(MultiDiffCommands multiDiffCommands, URI uRI, Project project, FileType fileType, int n, Object object) {
        if ((n & 4) != 0) {
            fileType = null;
        }
        return multiDiffCommands.createContent(uRI, project, fileType);
    }

    private static final void vscode_changes$lambda$0(MultiDiffCommands this$0, String $title, List $diffRequests) {
        this$0.showMultiDiffView($title, $diffRequests);
    }
}

