/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.editor;

import com.sina.weibo.agent.editor.Delta;
import com.sina.weibo.agent.editor.DocumentsAndEditorsDelta;
import com.sina.weibo.agent.editor.EditorPropertiesChangeData;
import com.sina.weibo.agent.editor.ModelAddedData;
import com.sina.weibo.agent.editor.ModelChangedEvent;
import com.sina.weibo.agent.editor.ModelContentChange;
import com.sina.weibo.agent.editor.Range;
import com.sina.weibo.agent.editor.SelectionChangeEvent;
import com.sina.weibo.agent.editor.TextEditorAddData;
import com.sina.weibo.agent.util.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000J\u0015\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u0015\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0003H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003JA\u0010\u001c\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0004H\u00d6\u0001R&\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR&\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR\u001c\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lcom/sina/weibo/agent/editor/DocumentsAndEditorsState;", "", "editors", "", "", "Lcom/sina/weibo/agent/editor/TextEditorAddData;", "documents", "Lcom/sina/weibo/agent/util/URI;", "Lcom/sina/weibo/agent/editor/ModelAddedData;", "activeEditorId", "<init>", "(Ljava/util/Map;Ljava/util/Map;Ljava/lang/String;)V", "getEditors", "()Ljava/util/Map;", "setEditors", "(Ljava/util/Map;)V", "getDocuments", "setDocuments", "getActiveEditorId", "()Ljava/lang/String;", "setActiveEditorId", "(Ljava/lang/String;)V", "delta", "Lcom/sina/weibo/agent/editor/Delta;", "lastState", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nEditorAndDocManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorAndDocManager.kt\ncom/sina/weibo/agent/editor/DocumentsAndEditorsState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,771:1\n1617#2,9:772\n1869#2:781\n1870#2:783\n1626#2:784\n1#3:782\n216#4,2:785\n216#4,2:787\n*S KotlinDebug\n*F\n+ 1 EditorAndDocManager.kt\ncom/sina/weibo/agent/editor/DocumentsAndEditorsState\n*L\n669#1:772,9\n669#1:781\n669#1:783\n669#1:784\n669#1:782\n681#1:785,2\n713#1:787,2\n*E\n"})
public final class DocumentsAndEditorsState {
    @NotNull
    private Map<String, TextEditorAddData> editors;
    @NotNull
    private Map<URI, ModelAddedData> documents;
    @Nullable
    private String activeEditorId;

    public DocumentsAndEditorsState(@NotNull Map<String, TextEditorAddData> editors, @NotNull Map<URI, ModelAddedData> documents, @Nullable String activeEditorId) {
        Intrinsics.checkNotNullParameter(editors, (String)"editors");
        Intrinsics.checkNotNullParameter(documents, (String)"documents");
        this.editors = editors;
        this.documents = documents;
        this.activeEditorId = activeEditorId;
    }

    public /* synthetic */ DocumentsAndEditorsState(Map map, Map map2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = new ConcurrentHashMap();
        }
        if ((n & 2) != 0) {
            map2 = new ConcurrentHashMap();
        }
        if ((n & 4) != 0) {
            string = null;
        }
        this(map, map2, string);
    }

    @NotNull
    public final Map<String, TextEditorAddData> getEditors() {
        return this.editors;
    }

    public final void setEditors(@NotNull Map<String, TextEditorAddData> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.editors = map;
    }

    @NotNull
    public final Map<URI, ModelAddedData> getDocuments() {
        return this.documents;
    }

    public final void setDocuments(@NotNull Map<URI, ModelAddedData> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.documents = map;
    }

    @Nullable
    public final String getActiveEditorId() {
        return this.activeEditorId;
    }

    public final void setActiveEditorId(@Nullable String string) {
        this.activeEditorId = string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Delta delta(@NotNull DocumentsAndEditorsState lastState) {
        boolean bl;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)lastState, (String)"lastState");
        Set currentDocumentUrls = CollectionsKt.toSet((Iterable)this.documents.keySet());
        Set lastDocumentUrls = CollectionsKt.toSet((Iterable)lastState.documents.keySet());
        Set removedUrls = SetsKt.minus((Set)lastDocumentUrls, (Iterable)currentDocumentUrls);
        Set addedUrls = SetsKt.minus((Set)currentDocumentUrls, (Iterable)lastDocumentUrls);
        Iterable $this$mapNotNull$iv = addedUrls;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        for (Object iterator : $this$forEach$iv$iv$iv) {
            ModelAddedData it$iv$iv;
            element$iv$iv = iterator;
            bl = false;
            URI it = (URI)element$iv$iv;
            boolean bl2 = false;
            if (this.documents.get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List addedDocuments = (List)destination$iv$iv;
        List addedEditors = new ArrayList();
        Map editorDeltas = new LinkedHashMap();
        Set currentEditorIds = CollectionsKt.toSet((Iterable)this.editors.keySet());
        Set lastEditorIds = CollectionsKt.toSet((Iterable)lastState.editors.keySet());
        Set removedIds = SetsKt.minus((Set)lastEditorIds, (Iterable)currentEditorIds);
        Map<String, TextEditorAddData> $this$forEach$iv = this.editors;
        $i$f$forEach = false;
        for (Map.Entry entry : $this$forEach$iv.entrySet()) {
            element$iv$iv = entry;
            bl = false;
            String id = (String)element$iv$iv.getKey();
            TextEditorAddData editor = (TextEditorAddData)element$iv$iv.getValue();
            if (lastState.editors.get(id) != null) {
                boolean visibleRangesChanged;
                TextEditorAddData lastEditor;
                boolean bl4 = false;
                boolean optionsChanged = !Intrinsics.areEqual((Object)editor.getOptions(), (Object)lastEditor.getOptions());
                boolean selectionsChanged = !Intrinsics.areEqual(editor.getSelections(), lastEditor.getSelections());
                boolean bl2 = visibleRangesChanged = !Intrinsics.areEqual(editor.getVisibleRanges(), lastEditor.getVisibleRanges());
                if (!optionsChanged && !selectionsChanged && !visibleRangesChanged) continue;
                editorDeltas.put(id, new EditorPropertiesChangeData(optionsChanged ? editor.getOptions() : null, selectionsChanged ? new SelectionChangeEvent(editor.getSelections(), null) : null, visibleRangesChanged ? editor.getVisibleRanges() : null));
                continue;
            }
            DocumentsAndEditorsState $this$delta_u24lambda_u243_u24lambda_u242 = this;
            boolean bl6 = false;
            addedEditors.add(editor);
        }
        Map documentDeltas = new LinkedHashMap();
        Map<URI, ModelAddedData> $this$forEach$iv2 = this.documents;
        boolean $i$f$forEach2 = false;
        Iterator<Map.Entry<URI, ModelAddedData>> iterator = $this$forEach$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            ModelAddedData lastDocument;
            Map.Entry<URI, ModelAddedData> element$iv;
            Map.Entry<URI, ModelAddedData> entry = element$iv = iterator.next();
            boolean bl3 = false;
            URI uri = entry.getKey();
            ModelAddedData document = entry.getValue();
            if (lastState.documents.get(uri) == null) continue;
            boolean bl7 = false;
            boolean hasChanges = !Intrinsics.areEqual(document.getLines(), lastDocument.getLines()) || !Intrinsics.areEqual((Object)document.getEOL(), (Object)lastDocument.getEOL()) || !Intrinsics.areEqual((Object)document.getLanguageId(), (Object)lastDocument.getLanguageId()) || document.isDirty() != lastDocument.isDirty() || !Intrinsics.areEqual((Object)document.getEncoding(), (Object)lastDocument.getEncoding());
            if (!hasChanges) continue;
            int n = 1;
            String string = (String)CollectionsKt.lastOrNull(lastDocument.getLines());
            int n2 = (string != null ? string.length() : 0) + 1;
            List changes = CollectionsKt.listOf((Object)new ModelContentChange(new Range(1, 1, Math.max(1, lastDocument.getLines().size()), Math.max(n, n2)), 0, CollectionsKt.joinToString$default((Iterable)lastDocument.getLines(), (CharSequence)lastDocument.getEOL(), null, null, (int)0, null, null, (int)62, null).length(), CollectionsKt.joinToString$default((Iterable)document.getLines(), (CharSequence)document.getEOL(), null, null, (int)0, null, null, (int)62, null)));
            documentDeltas.put(uri, new ModelChangedEvent(changes, document.getEOL(), document.getVersionId(), false, false, document.isDirty()));
        }
        DocumentsAndEditorsDelta itemsDelta = new DocumentsAndEditorsDelta(CollectionsKt.toList((Iterable)removedUrls), addedDocuments, CollectionsKt.toList((Iterable)removedIds), addedEditors, !Intrinsics.areEqual((Object)this.activeEditorId, (Object)lastState.activeEditorId) ? this.activeEditorId : null);
        return new Delta(itemsDelta.isEmpty() ? null : itemsDelta, editorDeltas, documentDeltas);
    }

    @NotNull
    public final Map<String, TextEditorAddData> component1() {
        return this.editors;
    }

    @NotNull
    public final Map<URI, ModelAddedData> component2() {
        return this.documents;
    }

    @Nullable
    public final String component3() {
        return this.activeEditorId;
    }

    @NotNull
    public final DocumentsAndEditorsState copy(@NotNull Map<String, TextEditorAddData> editors, @NotNull Map<URI, ModelAddedData> documents, @Nullable String activeEditorId) {
        Intrinsics.checkNotNullParameter(editors, (String)"editors");
        Intrinsics.checkNotNullParameter(documents, (String)"documents");
        return new DocumentsAndEditorsState(editors, documents, activeEditorId);
    }

    public static /* synthetic */ DocumentsAndEditorsState copy$default(DocumentsAndEditorsState documentsAndEditorsState, Map map, Map map2, String string, int n, Object object) {
        if ((n & 1) != 0) {
            map = documentsAndEditorsState.editors;
        }
        if ((n & 2) != 0) {
            map2 = documentsAndEditorsState.documents;
        }
        if ((n & 4) != 0) {
            string = documentsAndEditorsState.activeEditorId;
        }
        return documentsAndEditorsState.copy(map, map2, string);
    }

    @NotNull
    public String toString() {
        return "DocumentsAndEditorsState(editors=" + this.editors + ", documents=" + this.documents + ", activeEditorId=" + this.activeEditorId + ")";
    }

    public int hashCode() {
        int result = ((Object)this.editors).hashCode();
        result = result * 31 + ((Object)this.documents).hashCode();
        result = result * 31 + (this.activeEditorId == null ? 0 : this.activeEditorId.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DocumentsAndEditorsState)) {
            return false;
        }
        DocumentsAndEditorsState documentsAndEditorsState = (DocumentsAndEditorsState)other;
        if (!Intrinsics.areEqual(this.editors, documentsAndEditorsState.editors)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.documents, documentsAndEditorsState.documents)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.activeEditorId, (Object)documentsAndEditorsState.activeEditorId);
    }

    public DocumentsAndEditorsState() {
        this(null, null, null, 7, null);
    }
}

