/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.core;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.SystemInfo;
import com.sina.weibo.agent.core.JtbLoginSync;
import com.sina.weibo.agent.plugin.DEBUG_MODE;
import com.sina.weibo.agent.plugin.WecoderPluginService;
import com.sina.weibo.agent.provider.VSCodeConfigProvider;
import com.sina.weibo.agent.util.ExtensionUtils;
import com.sina.weibo.agent.util.NodeVersion;
import com.sina.weibo.agent.util.NodeVersionUtil;
import com.sina.weibo.agent.util.NotificationUtil;
import com.sina.weibo.agent.util.PluginResourceUtil;
import com.sina.weibo.agent.util.ProxyConfigUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\b\u0005\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0014\u001a\u00020\u0013J\b\u0010\u0015\u001a\u00020\u0013H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\b\u0010\u0019\u001a\u0004\u0018\u00010\u0011J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0011H\u0002J$\u0010\u001b\u001a\u00020\u00112\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u001d2\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\b\u0010\u001f\u001a\u00020\u0011H\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010 \u001a\u00020\u0013H\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/sina/weibo/agent/core/ExtensionProcessManager;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "process", "Ljava/lang/Process;", "monitorThread", "Ljava/lang/Thread;", "isRunning", "", "start", "portOrPath", "", "traceId", "", "monitorProcess", "", "stop", "stopInternal", "findNodeExecutable", "findExecutableInPath", "name", "findExtensionEntryFile", "findNodeModulesPath", "buildEnhancedPath", "envVars", "", "nodePath", "getSystemInfo", "dispose", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nExtensionProcessManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionProcessManager.kt\ncom/sina/weibo/agent/core/ExtensionProcessManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,514:1\n216#2,2:515\n1#3:517\n488#4,7:518\n1869#5,2:525\n*S KotlinDebug\n*F\n+ 1 ExtensionProcessManager.kt\ncom/sina/weibo/agent/core/ExtensionProcessManager\n*L\n205#1:515,2\n434#1:518,7\n466#1:525,2\n*E\n"})
public final class ExtensionProcessManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger LOG;
    @Nullable
    private Process process;
    @Nullable
    private Thread monitorThread;
    private volatile boolean isRunning;
    @NotNull
    private static final String NODE_MODULES_PATH = "node_modules";
    @NotNull
    private static final String EXTENSION_ENTRY_FILE = "extension.js";
    @NotNull
    private static final String RUNTIME_DIR = "runtime";
    @NotNull
    private static final String PLUGIN_ID = "com.gitlab.coderider-kilo";
    @NotNull
    private static final NodeVersion MIN_REQUIRED_NODE_VERSION = new NodeVersion(20, 6, 0, "20.6.0");
    @Nullable
    private static String systemInfoStr;

    public ExtensionProcessManager() {
        Logger logger = Logger.getInstance(ExtensionProcessManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean start(@Nullable Object portOrPath, @Nullable String traceId) {
        if (this.isRunning) {
            this.LOG.info("Extension process is already running");
            return true;
        }
        boolean isUds = portOrPath instanceof String;
        if (!ExtensionUtils.isValidPortOrPath(portOrPath)) {
            this.LOG.info("Invalid socket info: " + portOrPath);
            return false;
        }
        try {
            void $this$start_u24lambda_u244;
            Thread thread;
            String string = traceId;
            if (string == null) {
                String string2 = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                String string3 = string2;
                int n = 0;
                int n2 = 8;
                String string4 = string3.substring(n, n2);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            }
            String sessionTraceId = string;
            long tStart = System.nanoTime();
            Ref.LongRef lastMark = new Ref.LongRef();
            lastMark.element = tStart;
            String nodePath = this.findNodeExecutable();
            ExtensionProcessManager.start$mark(this, sessionTraceId, lastMark, "findNodeExecutable");
            if (nodePath == null) {
                this.LOG.info("Failed to find Node.js executable");
                NotificationUtil.showError$default(NotificationUtil.INSTANCE, "Node.js environment missing", "Node.js environment not detected. Please install Node.js and try again (required: " + MIN_REQUIRED_NODE_VERSION + " or higher). You may also set RUNVSAGENT_NODE_PATH=/absolute/path/to/node and restart the IDE.", null, 4, null);
                return false;
            }
            NodeVersion nodeVersion = NodeVersionUtil.INSTANCE.getNodeVersion(nodePath);
            ExtensionProcessManager.start$mark(this, sessionTraceId, lastMark, "getNodeVersion");
            if (!NodeVersionUtil.INSTANCE.isVersionSupported(nodeVersion, MIN_REQUIRED_NODE_VERSION)) {
                this.LOG.info("Node.js version is not supported: " + nodeVersion + ", required: " + MIN_REQUIRED_NODE_VERSION);
                NotificationUtil.showError$default(NotificationUtil.INSTANCE, "Node.js version too low", "Current Node.js (" + nodePath + ") version is " + nodeVersion + ". Please upgrade to " + MIN_REQUIRED_NODE_VERSION + " or higher, or set RUNVSAGENT_NODE_PATH to a compatible Node binary and restart.", null, 4, null);
                return false;
            }
            String extensionPath = this.findExtensionEntryFile();
            ExtensionProcessManager.start$mark(this, sessionTraceId, lastMark, "findExtensionEntryFile");
            if (extensionPath == null) {
                this.LOG.info("Failed to find extension entry file");
                return false;
            }
            String nodeModulesPath = this.findNodeModulesPath();
            ExtensionProcessManager.start$mark(this, sessionTraceId, lastMark, "findNodeModulesPath");
            if (nodeModulesPath == null) {
                this.LOG.info("Failed to find node_modules directory");
                return false;
            }
            this.LOG.info("[Perf][traceId=" + sessionTraceId + "] Starting extension process with node: " + nodePath + ", entry: " + extensionPath);
            HashMap<String, String> envVars = new HashMap<String, String>(System.getenv());
            ((Map)envVars).put("RUNVSAGENT_TRACE_ID", sessionTraceId);
            JtbLoginSync.INSTANCE.apply((Map<String, String>)envVars, sessionTraceId);
            ((Map)envVars).put("PATH", this.buildEnhancedPath((Map<String, String>)envVars, nodePath));
            ((Map)envVars).put("VSCODE_EXTHOST_SYSTEM_INFO", this.getSystemInfo());
            this.LOG.info("Enhanced PATH for " + SystemInfo.getOsNameAndVersion() + ": " + envVars.get("PATH"));
            if (isUds) {
                ((Map)envVars).put("VSCODE_EXTHOST_IPC_HOOK", ((String)portOrPath).toString());
            } else {
                ((Map)envVars).put("VSCODE_EXTHOST_WILL_SEND_SOCKET", "1");
                ((Map)envVars).put("VSCODE_EXTHOST_SOCKET_HOST", "127.0.0.1");
                ((Map)envVars).put("VSCODE_EXTHOST_SOCKET_PORT", String.valueOf(portOrPath));
            }
            String[] stringArray = new String[]{nodePath, "--experimental-global-webcrypto", "--no-deprecation", extensionPath, "--vscode-socket-port=" + envVars.get("VSCODE_EXTHOST_SOCKET_PORT"), "--vscode-socket-host=" + envVars.get("VSCODE_EXTHOST_SOCKET_HOST"), "--vscode-will-send-socket=" + envVars.get("VSCODE_EXTHOST_WILL_SEND_SOCKET")};
            List commandArgs = CollectionsKt.mutableListOf((Object[])stringArray);
            try {
                stringArray = arg_0 -> ExtensionProcessManager.start$lambda$0(envVars, commandArgs, arg_0);
                VSCodeConfigProvider.Companion.getEP_NAME().forEachExtensionSafe(arg_0 -> ExtensionProcessManager.start$lambda$1((Function1)stringArray, arg_0));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Map<String, String> proxyEnvVars = ProxyConfigUtil.INSTANCE.getProxyEnvVarsForProcessStart();
                envVars.putAll(proxyEnvVars);
                if (!proxyEnvVars.isEmpty()) {
                    this.LOG.info("Applied proxy configuration for process startup");
                }
            }
            catch (Exception e) {
                this.LOG.warn("Failed to configure proxy settings", (Throwable)e);
            }
            ProcessBuilder builder2 = new ProcessBuilder(commandArgs);
            this.LOG.info("Environment variables:");
            Map $this$forEach$iv = envVars;
            boolean $i$f$forEach22 = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                this.LOG.info("  " + key + " = " + value);
            }
            builder2.environment().putAll((Map<String, String>)envVars);
            builder2.redirectErrorStream(true);
            this.process = builder2.start();
            ExtensionProcessManager.start$mark(this, sessionTraceId, lastMark, "ProcessBuilder.start");
            Thread $i$f$forEach22 = thread = new Thread(() -> ExtensionProcessManager.start$lambda$3(this));
            ExtensionProcessManager extensionProcessManager = this;
            boolean bl = false;
            $this$start_u24lambda_u244.setName("ExtensionProcessMonitor");
            $this$start_u24lambda_u244.setDaemon(true);
            $this$start_u24lambda_u244.start();
            extensionProcessManager.monitorThread = thread;
            this.isRunning = true;
            this.LOG.info("[Perf][traceId=" + sessionTraceId + "] Extension process started in " + (System.nanoTime() - tStart) / (long)1000000 + " ms");
            return true;
        }
        catch (Exception e) {
            this.LOG.info("Failed to start extension process", (Throwable)e);
            this.stopInternal();
            return false;
        }
    }

    public static /* synthetic */ boolean start$default(ExtensionProcessManager extensionProcessManager, Object object, String string, int n, Object object2) {
        if ((n & 2) != 0) {
            string = null;
        }
        return extensionProcessManager.start(object, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void monitorProcess() {
        Process process = this.process;
        if (process == null) {
            return;
        }
        Process proc = process;
        try {
            Thread logThread = new Thread(() -> ExtensionProcessManager.monitorProcess$lambda$7(proc, this));
            logThread.setName("ExtensionProcessLogger");
            logThread.setDaemon(true);
            logThread.start();
            try {
                int exitCode = proc.waitFor();
                this.LOG.info("Extension process exited with code: " + exitCode);
            }
            catch (InterruptedException e) {
                this.LOG.info("Process monitor interrupted");
            }
            logThread.interrupt();
            try {
                logThread.join(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        catch (Exception e) {
            this.LOG.info("Error monitoring extension process", (Throwable)e);
        }
        finally {
            ExtensionProcessManager extensionProcessManager = this;
            synchronized (extensionProcessManager) {
                boolean bl = false;
                if (this.process == proc) {
                    this.isRunning = false;
                    this.process = null;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public final void stop() {
        if (!this.isRunning) {
            return;
        }
        this.stopInternal();
    }

    private final void stopInternal() {
        this.LOG.info("Stopping extension process");
        Process proc = this.process;
        if (proc != null) {
            try {
                if (proc.isAlive()) {
                    proc.destroy();
                    if (!proc.waitFor(5L, TimeUnit.SECONDS)) {
                        proc.destroyForcibly();
                        proc.waitFor(2L, TimeUnit.SECONDS);
                    }
                }
            }
            catch (Exception e) {
                this.LOG.info("Error stopping extension process", (Throwable)e);
            }
        }
        Thread thread = this.monitorThread;
        if (thread != null) {
            thread.interrupt();
        }
        try {
            Thread thread2 = this.monitorThread;
            if (thread2 != null) {
                thread2.join(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.process = null;
        this.monitorThread = null;
        this.isRunning = false;
        this.LOG.info("Extension process stopped");
    }

    private final String findNodeExecutable() {
        File resourceDir;
        String resourcesPath;
        String overridePath;
        String string;
        String envOverride;
        String string2;
        String sysProp;
        String it;
        String string3 = System.getProperty("runvsagent.nodePath");
        if (string3 != null && (string3 = ((Object)StringsKt.trim((CharSequence)string3)).toString()) != null) {
            String string4;
            it = string4 = string3;
            boolean bl = false;
            v1 = ((CharSequence)it).length() > 0 ? string4 : null;
        } else {
            v1 = sysProp = null;
        }
        if ((string2 = System.getenv("RUNVSAGENT_NODE_PATH")) != null && (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) != null) {
            String it2 = it = string2;
            boolean bl = false;
            v3 = ((CharSequence)it2).length() > 0 ? it : null;
        } else {
            v3 = envOverride = null;
        }
        if ((string = sysProp) == null) {
            string = envOverride;
        }
        if ((overridePath = string) != null) {
            File f = new File(overridePath);
            if (f.exists() && f.canExecute() && f.isFile()) {
                this.LOG.info("Using Node.js from override: " + overridePath);
                return f.getAbsolutePath();
            }
            this.LOG.warn("Override Node.js path is invalid or not executable: " + overridePath);
        }
        if ((resourcesPath = PluginResourceUtil.INSTANCE.getResourcePath(PLUGIN_ID, NODE_MODULES_PATH)) != null && (resourceDir = new File(resourcesPath)).exists() && resourceDir.isDirectory()) {
            File nodeBin;
            File file = nodeBin = SystemInfo.isWindows ? new File(resourceDir, "node.exe") : new File(resourceDir, ".bin/node");
            if (nodeBin.exists() && nodeBin.canExecute()) {
                return nodeBin.getAbsolutePath();
            }
        }
        return this.findExecutableInPath("node");
    }

    private final String findExecutableInPath(String name) {
        File file = PathEnvironmentVariableUtil.findExecutableInPathOnAnyOS((String)"node");
        String nodePath = file != null ? file.getAbsolutePath() : null;
        this.LOG.info("System Node path: " + nodePath);
        return nodePath;
    }

    @Nullable
    public final String findExtensionEntryFile() {
        File resource;
        String resourcesPath;
        if (WecoderPluginService.Companion.getDebugMode() != DEBUG_MODE.NONE) {
            String[] stringArray = new String[]{RUNTIME_DIR, EXTENSION_ENTRY_FILE};
            File debugEntry = Paths.get(WecoderPluginService.Companion.getDebugResource(), stringArray).normalize().toFile();
            if (debugEntry.exists() && debugEntry.isFile()) {
                this.LOG.info("[DebugMode] Using debug entry file: " + debugEntry.getAbsolutePath());
                return debugEntry.getAbsolutePath();
            }
            this.LOG.warn("[DebugMode] Debug entry file not found: " + debugEntry.getAbsolutePath());
        }
        if ((resourcesPath = PluginResourceUtil.INSTANCE.getResourcePath(PLUGIN_ID, "runtime/extension.js")) != null && (resource = new File(resourcesPath)).exists() && resource.isFile()) {
            return resourcesPath;
        }
        return null;
    }

    private final String findNodeModulesPath() {
        File nodeDir;
        String nodePath = PluginResourceUtil.INSTANCE.getResourcePath(PLUGIN_ID, NODE_MODULES_PATH);
        if (nodePath != null && (nodeDir = new File(nodePath)).exists() && nodeDir.isDirectory()) {
            return nodeDir.getAbsolutePath();
        }
        return null;
    }

    private final String buildEnhancedPath(Map<String, String> envVars, String nodePath) {
        List list;
        String nodeDir;
        Map<String, String> $this$filterKeys$iv = envVars;
        boolean $i$f$filterKeys = false;
        Object[] result$iv = new LinkedHashMap();
        for (Map.Entry<String, String> entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = entry$iv.getKey();
            boolean bl = false;
            if (!StringsKt.equals((String)it, (String)"PATH", (boolean)true)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        String string = (String)CollectionsKt.firstOrNull((Iterable)((Map)result$iv).values());
        if (string == null) {
            string = "";
        }
        String currentPath = string;
        List pathBuilder = new ArrayList();
        File file = new File(nodePath).getParentFile();
        String string2 = nodeDir = file != null ? file.getAbsolutePath() : null;
        if (nodeDir != null && !StringsKt.contains$default((CharSequence)currentPath, (CharSequence)nodeDir, (boolean)false, (int)2, null)) {
            pathBuilder.add(nodeDir);
        }
        if (SystemInfo.isMac) {
            result$iv = new String[]{"/opt/homebrew/bin", "/opt/homebrew/sbin", "/usr/local/bin", "/usr/local/sbin", System.getProperty("user.home") + "/.local/bin"};
            list = CollectionsKt.listOf((Object[])result$iv);
        } else if (SystemInfo.isWindows) {
            result$iv = new String[]{"C:\\Windows\\System32", "C:\\Windows\\SysWOW64", "C:\\Windows", "C:\\Windows\\System32\\WindowsPowerShell\\v1.0", "C:\\Program Files\\PowerShell\\7", "C:\\Program Files (x86)\\PowerShell\\7"};
            list = CollectionsKt.listOf((Object[])result$iv);
        } else {
            list = CollectionsKt.emptyList();
        }
        List commonDevPaths = list;
        Iterable $this$forEach$iv = commonDevPaths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String path = (String)element$iv;
            boolean bl = false;
            if (new File(path).exists() && !StringsKt.contains$default((CharSequence)currentPath, (CharSequence)path, (boolean)false, (int)2, null)) {
                pathBuilder.add(path);
                this.LOG.info("Add path to PATH: " + path);
                continue;
            }
            if (new File(path).exists()) continue;
            this.LOG.warn("Path does not exist, skip: " + path);
        }
        if (((CharSequence)currentPath).length() > 0) {
            pathBuilder.add(currentPath);
        }
        Iterable iterable = pathBuilder;
        String string3 = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"pathSeparator");
        return CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string3, null, null, (int)0, null, null, (int)62, null);
    }

    private final String getSystemInfo() {
        if (systemInfoStr == null) {
            Object pluginVersion;
            int indexOf;
            String string;
            String osName;
            String string2 = System.getProperty("os.name");
            if (string2 == null) {
                string2 = osName = "Unknown OS";
            }
            if ((string = System.getProperty("os.arch")) == null) {
                string = "Unknown Arch";
            }
            String osArch = string;
            String string3 = ApplicationInfo.getInstance().getFullVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFullVersion(...)");
            String jetBrainsVersion = StringsKt.replace$default((String)string3, (String)" ", (String)"-", (boolean)false, (int)4, null);
            String string4 = ApplicationInfo.getInstance().getFullApplicationName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getFullApplicationName(...)");
            String string5 = ApplicationInfo.getInstance().getFullVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getFullVersion(...)");
            String applicationName = StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)StringsKt.removeSuffix((String)string4, (CharSequence)string5))).toString(), (String)" ", (String)"-", (boolean)false, (int)4, null);
            IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)PLUGIN_ID));
            Object object = plugin;
            if (object == null || (object = object.getVersion()) == null) {
                object = "unknown";
            }
            Object version = (indexOf = StringsKt.indexOf$default((CharSequence)((CharSequence)(pluginVersion = object)), (String)"-", (int)0, (boolean)false, (int)6, null)) == -1 ? pluginVersion : StringsKt.take((String)pluginVersion, (int)indexOf);
            systemInfoStr = "coderider-kilo/" + (String)version + " " + applicationName + "/" + jetBrainsVersion + " (" + osName + "; " + osArch + ")";
        }
        String string = systemInfoStr;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isRunning() {
        if (!this.isRunning) return false;
        Process process = this.process;
        if (process == null) return false;
        if (!process.isAlive()) return false;
        return true;
    }

    public void dispose() {
        this.stop();
    }

    private static final void start$mark(ExtensionProcessManager this$0, String sessionTraceId, Ref.LongRef lastMark, String label) {
        long now = System.nanoTime();
        this$0.LOG.info("[Perf][traceId=" + sessionTraceId + "] " + label + " took " + (now - lastMark.element) / (long)1000000 + " ms");
        lastMark.element = now;
    }

    private static final Unit start$lambda$0(HashMap $envVars, List $commandArgs, VSCodeConfigProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        HashMap<String, String> configEnvVars = provider.getEnvVars();
        $envVars.putAll((Map)configEnvVars);
        List<String> configCommandArgs = provider.getCommandArgs();
        $commandArgs.addAll(2, (Collection)configCommandArgs);
        return Unit.INSTANCE;
    }

    private static final void start$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void start$lambda$3(ExtensionProcessManager this$0) {
        this$0.monitorProcess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void monitorProcess$lambda$7(Process $proc, ExtensionProcessManager this$0) {
        InputStream inputStream = $proc.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        Closeable closeable = inputStream;
        Object object = Charsets.UTF_8;
        Reader reader = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
        object = null;
        try {
            BufferedReader reader2 = (BufferedReader)closeable;
            boolean bl = false;
            String line = null;
            while (true) {
                String string;
                String it = string = reader2.readLine();
                boolean bl2 = false;
                line = it;
                if (string == null) break;
                this$0.LOG.info("Extension process: " + line);
            }
            reader = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/sina/weibo/agent/core/ExtensionProcessManager$Companion;", "", "<init>", "()V", "NODE_MODULES_PATH", "", "EXTENSION_ENTRY_FILE", "RUNTIME_DIR", "PLUGIN_ID", "MIN_REQUIRED_NODE_VERSION", "Lcom/sina/weibo/agent/util/NodeVersion;", "systemInfoStr", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

