/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.actors;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sina.weibo.agent.actors.MainThreadTerminalShellIntegrationShape;
import com.sina.weibo.agent.ipc.proxy.RPCContext;
import com.sina.weibo.agent.terminal.TerminalInstance;
import com.sina.weibo.agent.terminal.TerminalInstanceManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J0\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0017H\u0096@\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/sina/weibo/agent/actors/MainThreadTerminalShellIntegration;", "Lcom/sina/weibo/agent/actors/MainThreadTerminalShellIntegrationShape;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "terminalManager", "Lcom/sina/weibo/agent/terminal/TerminalInstanceManager;", "executeCommand", "", "terminalId", "", "commandLine", "", "dispatcher", "", "rpcContext", "Lcom/sina/weibo/agent/ipc/proxy/RPCContext;", "methodName", "args", "", "(Lcom/sina/weibo/agent/ipc/proxy/RPCContext;Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nMainThreadTerminalShellIntegrationShape.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainThreadTerminalShellIntegrationShape.kt\ncom/sina/weibo/agent/actors/MainThreadTerminalShellIntegration\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,73:1\n31#2,2:74\n*S KotlinDebug\n*F\n+ 1 MainThreadTerminalShellIntegrationShape.kt\ncom/sina/weibo/agent/actors/MainThreadTerminalShellIntegration\n*L\n24#1:74,2\n*E\n"})
public final class MainThreadTerminalShellIntegration
implements MainThreadTerminalShellIntegrationShape {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @NotNull
    private final TerminalInstanceManager terminalManager;

    public MainThreadTerminalShellIntegration(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Logger logger = Logger.getInstance(MainThreadTerminalShellIntegration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<TerminalInstanceManager> serviceClass$iv = TerminalInstanceManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.terminalManager = (TerminalInstanceManager)object;
    }

    @Override
    public void executeCommand(int terminalId, @NotNull String commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        this.logger.info("\ud83d\ude80 Executing Shell Integration command: terminalId=" + terminalId + ", commandLine='" + commandLine + "'");
        try {
            TerminalInstance terminalInstance = this.terminalManager.getTerminalInstance(terminalId);
            if (terminalInstance == null) {
                this.logger.warn("\u274c Terminal instance not found: terminalId=" + terminalId);
                return;
            }
            this.logger.info("\u2705 Found terminal instance: " + terminalInstance.getExtHostTerminalId());
            terminalInstance.sendText(commandLine, true);
            this.logger.info("\u2705 Command sent to terminal: terminalId=" + terminalId + ", command='" + commandLine + "'");
        }
        catch (Exception e) {
            this.logger.error("\u274c Failed to execute Shell Integration command: terminalId=" + terminalId + ", command='" + commandLine + "'", (Throwable)e);
        }
    }

    @Override
    @Nullable
    public Object dispatcher(@NotNull RPCContext rpcContext, @NotNull String methodName, @NotNull List<? extends Object> args, @NotNull Continuation<Object> $completion) {
        Unit unit;
        if (Intrinsics.areEqual((Object)methodName, (Object)"executeCommand")) {
            Object[] objectArray = new Class[]{Integer.TYPE, String.class};
            List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])objectArray), args);
            Object object = realArgs.get(0);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
            int terminalId = (Integer)object;
            Object object2 = realArgs.get(1);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
            String commandLine = (String)object2;
            this.executeCommand(terminalId, commandLine);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public void dispose() {
        this.logger.info("\ud83e\uddf9 Destroying MainThreadTerminalShellIntegration");
    }

    @Override
    @NotNull
    public List<Object> resolveTrueParameterTypes(@NotNull List<? extends Class<?>> parameterTypes, @NotNull List<? extends Object> args) {
        return MainThreadTerminalShellIntegrationShape.DefaultImpls.resolveTrueParameterTypes(this, parameterTypes, args);
    }
}

