/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.actors;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.sina.weibo.agent.actors.MainThreadSecretStateShape;
import com.sina.weibo.agent.ipc.proxy.RPCContext;
import com.sina.weibo.agent.service.ExtensionSecretService;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\u000eJ&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\u000eJ0\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000b2\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u001aH\u0096@\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0010H\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/sina/weibo/agent/actors/MainThreadSecretState;", "Lcom/sina/weibo/agent/actors/MainThreadSecretStateShape;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "secretsDir", "Ljava/io/File;", "secretsFile", "getPassword", "", "extensionId", "key", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setPassword", "", "value", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deletePassword", "dispatcher", "", "rpcContext", "Lcom/sina/weibo/agent/ipc/proxy/RPCContext;", "methodName", "args", "", "(Lcom/sina/weibo/agent/ipc/proxy/RPCContext;Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nMainThreadSecretStateShape.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainThreadSecretStateShape.kt\ncom/sina/weibo/agent/actors/MainThreadSecretState\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,130:1\n40#2,3:131\n40#2,3:134\n40#2,3:137\n*S KotlinDebug\n*F\n+ 1 MainThreadSecretStateShape.kt\ncom/sina/weibo/agent/actors/MainThreadSecretState\n*L\n64#1:131,3\n73#1:134,3\n83#1:137,3\n*E\n"})
public final class MainThreadSecretState
implements MainThreadSecretStateShape {
    @NotNull
    private final Logger logger;
    @NotNull
    private final File secretsDir;
    @NotNull
    private final File secretsFile;

    public MainThreadSecretState() {
        Logger logger = Logger.getInstance(MainThreadSecretState.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.secretsDir = new File(System.getProperty("user.home"), ".coderider-kilo-agent");
        this.secretsFile = new File(this.secretsDir, "secrets.json");
        if (!this.secretsDir.exists()) {
            this.secretsDir.mkdirs();
            this.logger.info("Create secret storage directory: " + this.secretsDir.getAbsolutePath());
        }
    }

    @Override
    @Nullable
    public Object getPassword(@NotNull String extensionId, @NotNull String key, @NotNull Continuation<? super String> $completion) {
        try {
            boolean $i$f$service = false;
            Class<ExtensionSecretService> serviceClass$iv = ExtensionSecretService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return ((ExtensionSecretService)object).getValue(extensionId, key);
        }
        catch (Exception e) {
            this.logger.warn("Failed to get secret: extensionId=" + extensionId + ", key=" + key, (Throwable)e);
            return null;
        }
    }

    @Override
    @Nullable
    public Object setPassword(@NotNull String extensionId, @NotNull String key, @NotNull String value, @NotNull Continuation<? super Unit> $completion) {
        try {
            boolean $i$f$service = false;
            Class<ExtensionSecretService> serviceClass$iv = ExtensionSecretService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((ExtensionSecretService)object).setValue(extensionId, key, value);
            this.logger.info("Successfully set secret: extensionId=" + extensionId + ", key=" + key);
        }
        catch (Exception e) {
            this.logger.error("Failed to set secret: extensionId=" + extensionId + ", key=" + key, (Throwable)e);
            throw e;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object deletePassword(@NotNull String extensionId, @NotNull String key, @NotNull Continuation<? super Unit> $completion) {
        try {
            boolean $i$f$service = false;
            Class<ExtensionSecretService> serviceClass$iv = ExtensionSecretService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((ExtensionSecretService)object).removeValue(extensionId, key);
            this.logger.info("Successfully deleted secret: extensionId=" + extensionId + ", key=" + key);
        }
        catch (Exception e) {
            this.logger.error("Failed to delete secret: extensionId=" + extensionId + ", key=" + key, (Throwable)e);
            throw e;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object dispatcher(@NotNull RPCContext rpcContext, @NotNull String methodName, @NotNull List<? extends Object> args, @NotNull Continuation<Object> $completion) {
        Object object;
        switch (methodName) {
            case "getPassword": {
                Object[] objectArray = new Class[]{String.class, String.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])objectArray), args);
                Object object2 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
                String extensionId = (String)object2;
                Object object3 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.String");
                String key = (String)object3;
                object = this.getPassword(extensionId, key, $completion);
                break;
            }
            case "setPassword": {
                Object extensionId = new Class[]{String.class, String.class, String.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])extensionId), args);
                Object object4 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.String");
                extensionId = (String)object4;
                Object object5 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type kotlin.String");
                String key = (String)object5;
                Object object6 = realArgs.get(2);
                Intrinsics.checkNotNull((Object)object6, (String)"null cannot be cast to non-null type kotlin.String");
                String value = (String)object6;
                Object object7 = this.setPassword((String)extensionId, key, value, $completion);
                if (object7 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object7;
                }
                object = Unit.INSTANCE;
                break;
            }
            case "deletePassword": {
                Object extensionId = new Class[]{String.class, String.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])extensionId), args);
                Object object8 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)object8, (String)"null cannot be cast to non-null type kotlin.String");
                extensionId = (String)object8;
                Object object9 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)object9, (String)"null cannot be cast to non-null type kotlin.String");
                String key = (String)object9;
                Object object10 = this.deletePassword((String)extensionId, key, $completion);
                if (object10 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object10;
                }
                object = Unit.INSTANCE;
                break;
            }
            default: {
                object = null;
            }
        }
        return object;
    }

    public void dispose() {
        this.logger.info("Disposing MainThreadSecretState resources");
    }

    @Override
    @NotNull
    public List<Object> resolveTrueParameterTypes(@NotNull List<? extends Class<?>> parameterTypes, @NotNull List<? extends Object> args) {
        return MainThreadSecretStateShape.DefaultImpls.resolveTrueParameterTypes(this, parameterTypes, args);
    }
}

