/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.actors;

import com.intellij.openapi.diagnostic.Logger;
import com.sina.weibo.agent.actors.FileChangeDto;
import com.sina.weibo.agent.actors.FileStat;
import com.sina.weibo.agent.actors.FileType;
import com.sina.weibo.agent.actors.MainThreadFileSystemShape;
import com.sina.weibo.agent.ipc.proxy.RPCContext;
import java.io.File;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00160\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J \u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J,\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00132\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020#0\"H\u0016J,\u0010$\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00132\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020#0\"H\u0016J\u0010\u0010%\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J$\u0010&\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00132\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020#0\"H\u0016J\u0010\u0010'\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u001e\u0010(\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0015H\u0016J\u0010\u0010+\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J0\u0010,\u001a\u0004\u0018\u00010#2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\n2\u000e\u00100\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0\u0015H\u0096@\u00a2\u0006\u0002\u00101J\b\u00102\u001a\u00020\fH\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/sina/weibo/agent/actors/MainThreadFileSystem;", "Lcom/sina/weibo/agent/actors/MainThreadFileSystemShape;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "providers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "registerFileSystemProvider", "", "handle", "scheme", "unregisterProvider", "stat", "Lcom/sina/weibo/agent/actors/FileStat;", "resource", "Ljava/net/URI;", "readdir", "", "Lkotlin/Pair;", "readFile", "", "uri", "writeFile", "content", "overwrite", "", "rename", "source", "target", "options", "", "", "copy", "mkdir", "delete", "ensureActivation", "onFileSystemChange", "resources", "Lcom/sina/weibo/agent/actors/FileChangeDto;", "getPathFromUriComponents", "dispatcher", "rpcContext", "Lcom/sina/weibo/agent/ipc/proxy/RPCContext;", "methodName", "args", "(Lcom/sina/weibo/agent/ipc/proxy/RPCContext;Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nMainThreadFileSystemShape.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainThreadFileSystemShape.kt\ncom/sina/weibo/agent/actors/MainThreadFileSystem\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,711:1\n11228#2:712\n11563#2,3:713\n*S KotlinDebug\n*F\n+ 1 MainThreadFileSystemShape.kt\ncom/sina/weibo/agent/actors/MainThreadFileSystem\n*L\n337#1:712\n337#1:713,3\n*E\n"})
public final class MainThreadFileSystem
implements MainThreadFileSystemShape {
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConcurrentHashMap<Integer, String> providers;

    public MainThreadFileSystem() {
        Logger logger = Logger.getInstance(MainThreadFileSystem.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.providers = new ConcurrentHashMap();
    }

    @Override
    public void registerFileSystemProvider(int handle2, @NotNull String scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        this.logger.info("Registering file system provider: handle=" + handle2 + ", scheme=" + scheme);
        try {
            Integer n = handle2;
            ((Map)this.providers).put(n, scheme);
        }
        catch (Exception e) {
            this.logger.error("Failed to register file system provider: " + e);
            throw e;
        }
    }

    @Override
    public void unregisterProvider(int handle2) {
        this.logger.info("Unregistering file system provider: handle=" + handle2);
        try {
            this.providers.remove(handle2);
        }
        catch (Exception e) {
            this.logger.error("Failed to unregister file system provider: " + e);
            throw e;
        }
    }

    @Override
    @NotNull
    public FileStat stat(@NotNull URI resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        this.logger.info("Getting file status information: " + resource);
        try {
            String path = this.getPathFromUriComponents(resource);
            File file = new File(path);
            if (!file.exists()) {
                throw new Exception("File does not exist: " + path);
            }
            FileType type2 = file.isDirectory() ? FileType.DIRECTORY : (Files.isSymbolicLink(Paths.get(file.toURI())) ? FileType.SYMBOLIC_LINK : FileType.FILE);
            long ctime = file.lastModified();
            long mtime = file.lastModified();
            long size = file.length();
            return new FileStat(type2, ctime, mtime, size);
        }
        catch (Exception e) {
            this.logger.error("Failed to get file status information: " + e);
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<String, String>> readdir(@NotNull URI resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        this.logger.info("Reading directory contents: " + resource);
        try {
            List list;
            String path = this.getPathFromUriComponents(resource);
            File file = new File(path);
            if (!file.exists() || !file.isDirectory()) {
                throw new Exception("Directory does not exist or is not a directory: " + path);
            }
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                void $this$mapTo$iv$iv;
                File[] $this$map$iv = fileArray;
                boolean $i$f$map = false;
                File[] fileArray2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var12_13 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new Pair((Object)it.getName(), (Object)(it.isDirectory() ? String.valueOf(FileType.DIRECTORY.ordinal()) : String.valueOf(FileType.FILE.ordinal()))));
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }
        catch (Exception e) {
            this.logger.error("Failed to read directory contents: " + e);
            throw e;
        }
    }

    @Override
    @NotNull
    public byte[] readFile(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.logger.info("Reading file content: " + uri);
        try {
            String path = this.getPathFromUriComponents(uri);
            File file = new File(path);
            if (!file.exists() || file.isDirectory()) {
                throw new Exception("File does not exist or is a directory: " + path);
            }
            return FilesKt.readBytes((File)file);
        }
        catch (Exception e) {
            this.logger.error("Failed to read file content: " + e);
            throw e;
        }
    }

    @Override
    @NotNull
    public byte[] writeFile(@NotNull URI uri, @NotNull byte[] content, boolean overwrite) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.logger.info("Writing file content: " + uri + ", content size: " + content.length + " bytes");
        try {
            String path = this.getPathFromUriComponents(uri);
            File file = new File(path);
            File file2 = file.getParentFile();
            if (file2 != null) {
                file2.mkdirs();
            }
            FilesKt.writeBytes((File)file, (byte[])content);
            return content;
        }
        catch (Exception e) {
            this.logger.error("Failed to write file content: " + e);
            throw e;
        }
    }

    @Override
    public void rename(@NotNull URI source, @NotNull URI target, @NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this.logger.info("Renaming: " + source + " -> " + target);
        try {
            String sourcePath = this.getPathFromUriComponents(source);
            String targetPath = this.getPathFromUriComponents(target);
            Object object = options.get("overwrite");
            Boolean bl = object instanceof Boolean ? (Boolean)object : null;
            boolean overwrite = bl != null ? bl : false;
            File sourceFile = new File(sourcePath);
            File targetFile = new File(targetPath);
            if (!sourceFile.exists()) {
                throw new Exception("Source file does not exist: " + sourcePath);
            }
            if (targetFile.exists() && !overwrite) {
                throw new Exception("Target file already exists and overwrite is not allowed: " + targetPath);
            }
            File file = targetFile.getParentFile();
            if (file != null) {
                file.mkdirs();
            }
            if (!sourceFile.renameTo(targetFile)) {
                CopyOption[] copyOptionArray = new CopyOption[]{overwrite ? StandardCopyOption.REPLACE_EXISTING : StandardCopyOption.ATOMIC_MOVE};
                Files.move(Paths.get(sourcePath, new String[0]), Paths.get(targetPath, new String[0]), copyOptionArray);
            }
        }
        catch (Exception e) {
            this.logger.error("Rename operation failed: " + e);
            throw e;
        }
    }

    @Override
    public void copy(@NotNull URI source, @NotNull URI target, @NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this.logger.info("Copying: " + source + " -> " + target);
        try {
            String sourcePath = this.getPathFromUriComponents(source);
            String targetPath = this.getPathFromUriComponents(target);
            Object object = options.get("overwrite");
            Boolean bl = object instanceof Boolean ? (Boolean)object : null;
            boolean overwrite = bl != null ? bl : false;
            File sourceFile = new File(sourcePath);
            File targetFile = new File(targetPath);
            if (!sourceFile.exists()) {
                throw new Exception("Source file does not exist: " + sourcePath);
            }
            if (targetFile.exists() && !overwrite) {
                throw new Exception("Target file already exists and overwrite is not allowed: " + targetPath);
            }
            File file = targetFile.getParentFile();
            if (file != null) {
                file.mkdirs();
            }
            if (sourceFile.isDirectory()) {
                v2 = Boolean.valueOf(FilesKt.copyRecursively$default((File)sourceFile, (File)targetFile, (boolean)overwrite, null, (int)4, null));
            } else {
                CopyOption[] copyOptionArray = new CopyOption[]{overwrite ? StandardCopyOption.REPLACE_EXISTING : StandardCopyOption.COPY_ATTRIBUTES};
                v2 = Files.copy(Paths.get(sourcePath, new String[0]), Paths.get(targetPath, new String[0]), copyOptionArray);
            }
        }
        catch (Exception e) {
            this.logger.error("Copy operation failed: " + e);
            throw e;
        }
    }

    @Override
    public void mkdir(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.logger.info("Creating directory: " + uri);
        try {
            String path = this.getPathFromUriComponents(uri);
            File file = new File(path);
            if (file.exists()) {
                throw new Exception("File or directory already exists: " + path);
            }
            if (!file.mkdirs()) {
                throw new Exception("Failed to create directory: " + path);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to create directory: " + e);
            throw e;
        }
    }

    @Override
    public void delete(@NotNull URI uri, @NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this.logger.info("Deleting: " + uri + ", options: " + options);
        try {
            boolean useTrash;
            String path = this.getPathFromUriComponents(uri);
            File file = new File(path);
            Object object = options.get("recursive");
            Boolean bl = object instanceof Boolean ? (Boolean)object : null;
            boolean recursive = bl != null ? bl : false;
            Object object2 = options.get("useTrash");
            Boolean bl2 = object2 instanceof Boolean ? (Boolean)object2 : null;
            boolean bl3 = useTrash = bl2 != null ? bl2 : false;
            if (!file.exists()) {
                return;
            }
            if (useTrash) {
                this.logger.warn("Trash deletion not implemented, performing direct deletion");
            }
            if (file.isDirectory() && recursive) {
                v3 = FilesKt.deleteRecursively((File)file);
            } else {
                if (file.isDirectory() && !recursive) {
                    throw new Exception("Cannot delete non-empty directory unless recursive=true: " + path);
                }
                v3 = file.delete();
            }
        }
        catch (Exception e) {
            this.logger.error("Delete operation failed: " + e);
            throw e;
        }
    }

    @Override
    public void ensureActivation(@NotNull String scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        this.logger.info("Ensuring activation: " + scheme);
        try {
        }
        catch (Exception e) {
            this.logger.error("Failed to ensure activation: " + e);
            throw e;
        }
    }

    @Override
    public void onFileSystemChange(int handle2, @NotNull List<FileChangeDto> resources) {
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        this.logger.info("File system change notification: handle=" + handle2 + ", resources=" + CollectionsKt.joinToString$default((Iterable)resources, null, null, null, (int)0, null, MainThreadFileSystem::onFileSystemChange$lambda$1, (int)31, null));
        try {
        }
        catch (Exception e) {
            this.logger.error("Failed to process file system change notification: " + e);
            throw e;
        }
    }

    private final String getPathFromUriComponents(URI uri) {
        String string = new File(uri).getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    @Override
    @Nullable
    public Object dispatcher(@NotNull RPCContext rpcContext, @NotNull String methodName, @NotNull List<? extends Object> args, @NotNull Continuation<Object> $completion) {
        return switch (methodName) {
            case "registerFileSystemProvider" -> {
                Object[] var7_6 = new Class[]{Integer.TYPE, String.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])var7_6), args);
                Object v0 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type kotlin.Int");
                int handle = (Integer)v0;
                Object v1 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type kotlin.String");
                String scheme = (String)v1;
                this.registerFileSystemProvider(handle, scheme);
                yield Unit.INSTANCE;
            }
            case "unregisterProvider" -> {
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf(Integer.TYPE), args);
                Object v3 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type kotlin.Int");
                int handle = (Integer)v3;
                this.unregisterProvider(handle);
                yield Unit.INSTANCE;
            }
            case "stat" -> {
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf(URI.class), args);
                Object v4 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type java.net.URI");
                URI resource = (URI)v4;
                yield this.stat(resource);
            }
            case "readdir" -> {
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf(URI.class), args);
                Object v5 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v5, (String)"null cannot be cast to non-null type java.net.URI");
                URI resource = (URI)v5;
                yield this.readdir(resource);
            }
            case "readFile" -> {
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf(URI.class), args);
                Object v6 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v6, (String)"null cannot be cast to non-null type java.net.URI");
                URI uri = (URI)v6;
                yield this.readFile(uri);
            }
            case "writeFile" -> {
                Object uri = new Class[]{URI.class, byte[].class, Boolean.TYPE};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])uri), args);
                Object v7 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v7, (String)"null cannot be cast to non-null type java.net.URI");
                uri = (URI)v7;
                Object v8 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)v8, (String)"null cannot be cast to non-null type kotlin.ByteArray");
                byte[] content = (byte[])v8;
                Object v9 = realArgs.get(2);
                Intrinsics.checkNotNull((Object)v9, (String)"null cannot be cast to non-null type kotlin.Boolean");
                boolean overwrite = (Boolean)v9;
                yield this.writeFile((URI)uri, content, overwrite);
            }
            case "rename" -> {
                Object[] uri = new Class[]{URI.class, URI.class, Map.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])uri), args);
                Object v10 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v10, (String)"null cannot be cast to non-null type java.net.URI");
                URI source = (URI)v10;
                Object v11 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)v11, (String)"null cannot be cast to non-null type java.net.URI");
                URI target = (URI)v11;
                Object v12 = realArgs.get(2);
                Intrinsics.checkNotNull((Object)v12, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                Map options = (Map)v12;
                this.rename(source, target, options);
                yield Unit.INSTANCE;
            }
            case "copy" -> {
                Object source = new Class[]{URI.class, URI.class, Map.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])source), args);
                Object v13 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v13, (String)"null cannot be cast to non-null type java.net.URI");
                source = (URI)v13;
                Object v14 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)v14, (String)"null cannot be cast to non-null type java.net.URI");
                URI target = (URI)v14;
                Object v15 = realArgs.get(2);
                Intrinsics.checkNotNull((Object)v15, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                Map options = (Map)v15;
                this.copy((URI)source, target, options);
                yield Unit.INSTANCE;
            }
            case "mkdir" -> {
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf(URI.class), args);
                Object v16 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v16, (String)"null cannot be cast to non-null type java.net.URI");
                URI uri = (URI)v16;
                this.mkdir(uri);
                yield Unit.INSTANCE;
            }
            case "delete" -> {
                Object uri = new Class[]{URI.class, Map.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])uri), args);
                Object v17 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v17, (String)"null cannot be cast to non-null type java.net.URI");
                uri = (URI)v17;
                Object v18 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)v18, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                Map options = (Map)v18;
                this.delete((URI)uri, options);
                yield Unit.INSTANCE;
            }
            case "ensureActivation" -> {
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf(String.class), args);
                Object v19 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v19, (String)"null cannot be cast to non-null type kotlin.String");
                String scheme = (String)v19;
                this.ensureActivation(scheme);
                yield Unit.INSTANCE;
            }
            case "onFileSystemChange" -> {
                Object[] scheme = new Class[]{Integer.TYPE, List.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])scheme), args);
                Object v20 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v20, (String)"null cannot be cast to non-null type kotlin.Int");
                int handle = (Integer)v20;
                Object v21 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)v21, (String)"null cannot be cast to non-null type kotlin.collections.List<com.sina.weibo.agent.actors.FileChangeDto>");
                List resources = (List)v21;
                this.onFileSystemChange(handle, resources);
                yield Unit.INSTANCE;
            }
            default -> null;
        };
    }

    public void dispose() {
        this.logger.info("Disposing MainThreadFileSystem resources");
        this.providers.clear();
    }

    @Override
    @NotNull
    public List<Object> resolveTrueParameterTypes(@NotNull List<? extends Class<?>> parameterTypes, @NotNull List<? extends Object> args) {
        return MainThreadFileSystemShape.DefaultImpls.resolveTrueParameterTypes(this, parameterTypes, args);
    }

    private static final CharSequence onFileSystemChange$lambda$1(FileChangeDto it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getResource().toString();
    }
}

