/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.actors;

import com.intellij.openapi.diagnostic.Logger;
import com.sina.weibo.agent.actors.MainThreadExtensionServiceShape;
import com.sina.weibo.agent.core.ExtensionManager;
import com.sina.weibo.agent.ipc.proxy.IRPCProtocol;
import com.sina.weibo.agent.ipc.proxy.RPCContext;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u001a\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\fH\u0016J2\u0010\u0012\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0016J$\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\u001b\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\fH\u0016J\u0016\u0010\u001c\u001a\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0016J0\u0010\"\u001a\u0004\u0018\u00010\f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u000e\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u001eH\u0096@\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/sina/weibo/agent/actors/MainThreadExtensionService;", "Lcom/sina/weibo/agent/actors/MainThreadExtensionServiceShape;", "extensionManager", "Lcom/sina/weibo/agent/core/ExtensionManager;", "rpcProtocol", "Lcom/sina/weibo/agent/ipc/proxy/IRPCProtocol;", "<init>", "(Lcom/sina/weibo/agent/core/ExtensionManager;Lcom/sina/weibo/agent/ipc/proxy/IRPCProtocol;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getExtension", "", "extensionId", "activateExtension", "reason", "onWillActivateExtension", "", "onDidActivateExtension", "codeLoadingTime", "", "activateCallTime", "activateResolvedTime", "activationReason", "onExtensionActivationError", "error", "missingExtensionDependency", "onExtensionRuntimeError", "setPerformanceMarks", "marks", "", "asBrowserUri", "Ljava/net/URI;", "uri", "dispatcher", "rpcContext", "Lcom/sina/weibo/agent/ipc/proxy/RPCContext;", "methodName", "", "args", "(Lcom/sina/weibo/agent/ipc/proxy/RPCContext;Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "coderider-kilo-jetbrains"})
public final class MainThreadExtensionService
implements MainThreadExtensionServiceShape {
    @NotNull
    private final ExtensionManager extensionManager;
    @NotNull
    private final IRPCProtocol rpcProtocol;
    @NotNull
    private final Logger logger;

    public MainThreadExtensionService(@NotNull ExtensionManager extensionManager, @NotNull IRPCProtocol rpcProtocol) {
        Intrinsics.checkNotNullParameter((Object)extensionManager, (String)"extensionManager");
        Intrinsics.checkNotNullParameter((Object)rpcProtocol, (String)"rpcProtocol");
        this.extensionManager = extensionManager;
        this.rpcProtocol = rpcProtocol;
        Logger logger = Logger.getInstance(MainThreadExtensionService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @Override
    @Nullable
    public Object getExtension(@NotNull Object extensionId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        try {
            Map map = extensionId instanceof Map ? (Map)extensionId : null;
            string = map != null ? map.get("value") : null;
            string = string instanceof String ? string : null;
        }
        catch (Exception e) {
            string = String.valueOf(extensionId);
        }
        String extensionIdStr = string;
        this.logger.info("Retrieving extension: " + extensionIdStr);
        return this.extensionManager.getExtensionDescription(String.valueOf(extensionIdStr));
    }

    @Override
    @NotNull
    public Object activateExtension(@NotNull Object extensionId, @Nullable Object reason) {
        boolean bl;
        String string;
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        try {
            Map map = extensionId instanceof Map ? (Map)extensionId : null;
            string = map != null ? map.get("value") : null;
            string = string instanceof String ? string : null;
        }
        catch (Exception e) {
            string = String.valueOf(extensionId);
        }
        String extensionIdStr = string;
        this.logger.info("Activating extension: " + extensionIdStr + ", reason: " + reason);
        CompletableFuture<Boolean> future = this.extensionManager.activateExtension(String.valueOf(extensionIdStr), this.rpcProtocol);
        try {
            Boolean result = future.get();
            this.logger.info("Extension " + extensionIdStr + " activation " + (result != false ? "successful" : "failed"));
            bl = true;
        }
        catch (Exception e) {
            this.logger.error("Extension " + extensionIdStr + " activation exception", (Throwable)e);
            bl = false;
        }
        return bl;
    }

    @Override
    public void onWillActivateExtension(@NotNull Object extensionId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        try {
            Map map = extensionId instanceof Map ? (Map)extensionId : null;
            string = map != null ? map.get("value") : null;
            string = string instanceof String ? string : null;
        }
        catch (Exception e) {
            string = String.valueOf(extensionId);
        }
        String extensionIdStr = string;
        this.logger.info("Extension " + extensionIdStr + " is about to be activated");
    }

    @Override
    public void onDidActivateExtension(@NotNull Object extensionId, double codeLoadingTime, double activateCallTime, double activateResolvedTime, @Nullable Object activationReason) {
        String string;
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        try {
            Map map = extensionId instanceof Map ? (Map)extensionId : null;
            string = map != null ? map.get("value") : null;
            string = string instanceof String ? string : null;
        }
        catch (Exception e) {
            string = String.valueOf(extensionId);
        }
        String extensionIdStr = string;
        this.logger.info("Extension " + extensionIdStr + " activated, reason: " + activationReason);
    }

    @Override
    @NotNull
    public Object onExtensionActivationError(@NotNull Object extensionId, @Nullable Object error2, @Nullable Object missingExtensionDependency) {
        String string;
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        try {
            Map map = extensionId instanceof Map ? (Map)extensionId : null;
            string = map != null ? map.get("value") : null;
            string = string instanceof String ? string : null;
        }
        catch (Exception e) {
            string = String.valueOf(extensionId);
        }
        String extensionIdStr = string;
        this.logger.error("Extension " + extensionIdStr + " activation error: " + error2 + ", missing dependency: " + missingExtensionDependency);
        return Unit.INSTANCE;
    }

    @Override
    public void onExtensionRuntimeError(@NotNull Object extensionId, @Nullable Object error2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        try {
            Map map = extensionId instanceof Map ? (Map)extensionId : null;
            string = map != null ? map.get("value") : null;
            string = string instanceof String ? string : null;
        }
        catch (Exception e) {
            string = String.valueOf(extensionId);
        }
        String extensionIdStr = string;
        this.logger.warn("Extension " + extensionIdStr + " runtime error: " + error2);
    }

    @Override
    public void setPerformanceMarks(@NotNull List<? extends Object> marks) {
        Intrinsics.checkNotNullParameter(marks, (String)"marks");
        this.logger.info("Setting performance marks: " + marks);
    }

    @Override
    @NotNull
    public URI asBrowserUri(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.logger.info("Converting to browser URI: " + uri);
        return uri;
    }

    @Override
    @Nullable
    public Object dispatcher(@NotNull RPCContext rpcContext, @NotNull String methodName, @NotNull List<? extends Object> args, @NotNull Continuation<Object> $completion) {
        return switch (methodName) {
            case "getExtension" -> {
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf(Object.class), args);
                Object v0 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type kotlin.Any");
                Object extensionId = v0;
                yield this.getExtension(extensionId);
            }
            case "activateExtension" -> {
                Object extensionId = new Class[]{Object.class, Object.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])extensionId), args);
                Object v2 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type kotlin.Any");
                extensionId = v2;
                Object reason = realArgs.get(1);
                yield this.activateExtension(extensionId, reason);
            }
            case "onWillActivateExtension" -> {
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf(Object.class), args);
                Object v3 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type kotlin.Any");
                Object extensionId = v3;
                this.onWillActivateExtension(extensionId);
                yield Unit.INSTANCE;
            }
            case "onDidActivateExtension" -> {
                Object extensionId = new Class[]{Object.class, Double.TYPE, Double.TYPE, Double.TYPE, Object.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])extensionId), args);
                Object v4 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type kotlin.Any");
                extensionId = v4;
                Object v5 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)v5, (String)"null cannot be cast to non-null type kotlin.Double");
                double codeLoadingTime = (Double)v5;
                Object v6 = realArgs.get(2);
                Intrinsics.checkNotNull((Object)v6, (String)"null cannot be cast to non-null type kotlin.Double");
                double activateCallTime = (Double)v6;
                Object v7 = realArgs.get(3);
                Intrinsics.checkNotNull((Object)v7, (String)"null cannot be cast to non-null type kotlin.Double");
                double activateResolvedTime = (Double)v7;
                Object activationReason = realArgs.get(4);
                this.onDidActivateExtension(extensionId, codeLoadingTime, activateCallTime, activateResolvedTime, activationReason);
                yield Unit.INSTANCE;
            }
            case "onExtensionActivationError" -> {
                Object extensionId = new Class[]{Object.class, Object.class, Object.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])extensionId), args);
                Object v8 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v8, (String)"null cannot be cast to non-null type kotlin.Any");
                extensionId = v8;
                Object error = realArgs.get(1);
                Object missingExtensionDependency = realArgs.get(2);
                yield this.onExtensionActivationError(extensionId, error, missingExtensionDependency);
            }
            case "onExtensionRuntimeError" -> {
                Object extensionId = new Class[]{Object.class, Object.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])extensionId), args);
                Object v9 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v9, (String)"null cannot be cast to non-null type kotlin.Any");
                extensionId = v9;
                Object error = realArgs.get(1);
                this.onExtensionRuntimeError(extensionId, error);
                yield Unit.INSTANCE;
            }
            case "setPerformanceMarks" -> {
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf(List.class), args);
                Object v10 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v10, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Any>");
                List marks = (List)v10;
                this.setPerformanceMarks(marks);
                yield Unit.INSTANCE;
            }
            case "asBrowserUri" -> {
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf(URI.class), args);
                Object v11 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v11, (String)"null cannot be cast to non-null type java.net.URI");
                URI uri = (URI)v11;
                yield this.asBrowserUri(uri);
            }
            default -> null;
        };
    }

    public void dispose() {
        this.logger.info("Disposing MainThreadExtensionService");
    }

    @Override
    @NotNull
    public List<Object> resolveTrueParameterTypes(@NotNull List<? extends Class<?>> parameterTypes, @NotNull List<? extends Object> args) {
        return MainThreadExtensionServiceShape.DefaultImpls.resolveTrueParameterTypes(this, parameterTypes, args);
    }
}

