/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.actors;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.sina.weibo.agent.actors.MainThreadDocuments;
import com.sina.weibo.agent.actors.MainThreadDocumentsShape;
import com.sina.weibo.agent.editor.EditorAndDocManager;
import com.sina.weibo.agent.editor.EditorCommandsKt;
import com.sina.weibo.agent.ipc.proxy.RPCContext;
import com.sina.weibo.agent.service.DocumentSyncService;
import com.sina.weibo.agent.util.URI;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J4\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001a2\u0016\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0018\u00010\u001aH\u0096@\u00a2\u0006\u0002\u0010\u001eJJ\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001a2\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001a2\u0016\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0018\u00010\u001aH\u0096@\u00a2\u0006\u0002\u0010!J<\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001a2\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001a2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001bH\u0096@\u00a2\u0006\u0002\u0010\"J$\u0010#\u001a\u00020$2\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001aH\u0096@\u00a2\u0006\u0002\u0010\u001eJ\u0006\u0010%\u001a\u00020\u0015J0\u0010&\u001a\u0004\u0018\u00010\u001c2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001b2\u000e\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0+H\u0096@\u00a2\u0006\u0002\u0010,R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0016\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/sina/weibo/agent/actors/MainThreadDocuments;", "Lcom/sina/weibo/agent/actors/MainThreadDocumentsShape;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "messageBusConnection", "Lcom/intellij/util/messages/MessageBusConnection;", "documentSyncService", "Lcom/sina/weibo/agent/service/DocumentSyncService;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "setupDocumentSaveListener", "", "handleDocumentSaving", "document", "Lcom/intellij/openapi/editor/Document;", "tryCreateDocument", "", "", "", "options", "(Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryOpenDocument", "map", "(Ljava/util/Map;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Ljava/util/Map;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "trySaveDocument", "", "dispose", "dispatcher", "rpcContext", "Lcom/sina/weibo/agent/ipc/proxy/RPCContext;", "methodName", "args", "", "(Lcom/sina/weibo/agent/ipc/proxy/RPCContext;Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "coderider-kilo-jetbrains"})
public final class MainThreadDocuments
implements MainThreadDocumentsShape {
    @NotNull
    private Project project;
    @NotNull
    private final Logger logger;
    @Nullable
    private MessageBusConnection messageBusConnection;
    @NotNull
    private final DocumentSyncService documentSyncService;
    @NotNull
    private final CoroutineScope coroutineScope;

    public MainThreadDocuments(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Logger logger = Logger.getInstance(MainThreadDocuments.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.documentSyncService = new DocumentSyncService(this.project);
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getIO()));
        this.setupDocumentSaveListener();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void setProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<set-?>");
        this.project = project;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    private final void setupDocumentSaveListener() {
        try {
            MessageBusConnection messageBusConnection = this.messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
            if (messageBusConnection != null) {
                Topic topic = FileDocumentManagerListener.TOPIC;
                Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
                messageBusConnection.subscribe(topic, (Object)new FileDocumentManagerListener(this){
                    final /* synthetic */ MainThreadDocuments this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void beforeDocumentSaving(Document document) {
                        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                        MainThreadDocuments.access$handleDocumentSaving(this.this$0, document);
                    }
                });
            }
            this.logger.info("Document save listener registered successfully");
        }
        catch (Exception e) {
            this.logger.error("Failed to setup document save listener", (Throwable)e);
        }
    }

    private final void handleDocumentSaving(Document document) {
        VirtualFile virtualFile;
        VirtualFile virtualFile2 = virtualFile = FileDocumentManager.getInstance().getFile(document);
        this.logger.info("Handle document save event: " + (virtualFile2 != null ? virtualFile2.getPath() : null));
        if (virtualFile != null && this.documentSyncService.shouldHandleFileEvent(virtualFile)) {
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, virtualFile, document, null){
                int label;
                final /* synthetic */ MainThreadDocuments this$0;
                final /* synthetic */ VirtualFile $virtualFile;
                final /* synthetic */ Document $document;
                {
                    this.this$0 = $receiver;
                    this.$virtualFile = $virtualFile;
                    this.$document = $document;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DelayKt.delay((long)50L, (Continuation)((Continuation)this));
                            ** if (v0 != var3_2) goto lbl11
lbl10:
                            // 1 sources

                            return var3_2;
lbl11:
                            // 1 sources

                            ** GOTO lbl17
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            if (this.this$0.getProject().isDisposed()) ** GOTO lbl34
                            this.label = 2;
                            v1 = MainThreadDocuments.access$getDocumentSyncService$p(this.this$0).syncDocumentStateOnSave(this.$virtualFile, this.$document, (Continuation<? super Unit>)((Continuation)this));
                            ** if (v1 != var3_2) goto lbl22
lbl21:
                            // 1 sources

                            return var3_2;
lbl22:
                            // 1 sources

                            ** GOTO lbl34
                        }
                        case 2: {
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
                            }
                            catch (ProcessCanceledException var2_3) {
                                this.this$0.getLogger().debug("Document save cancelled because project is disposed");
                            }
                            catch (Exception e) {
                                this.this$0.getLogger().error("Error handling document save event", (Throwable)e);
                            }
lbl34:
                            // 5 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @Override
    @Nullable
    public Object tryCreateDocument(@Nullable Map<String, ? extends Object> options, @NotNull Continuation<? super Map<String, ? extends Object>> $completion) {
        this.logger.info("tryCreateDocument" + options);
        return MapsKt.emptyMap();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object tryOpenDocument(@NotNull Map<String, ? extends Object> var1_1, @Nullable Map<String, ? extends Object> var2_2, @NotNull Continuation<? super Map<String, ? extends Object>> $completion) {
        if (!($completion instanceof tryOpenDocument.1)) ** GOTO lbl-1000
        var7_4 = $completion;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ MainThreadDocuments this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.tryOpenDocument((Map<String, ? extends Object>)null, (Map<String, ? extends Object>)null, (Continuation<? super Map<String, ? extends Object>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                uri = EditorCommandsKt.createURI(map);
                this.logger.info("tryOpenDocument : " + uri.getPath());
                file = new File(uri.getPath());
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                }
                $continuation.L$0 = map;
                $continuation.L$1 = uri;
                $continuation.label = 1;
                v0 = EditorAndDocManager.openDocument$default((EditorAndDocManager)this.project.getService(EditorAndDocManager.class), uri, false, (Continuation)$continuation, 2, null);
                if (v0 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl32
            }
            case 1: {
                uri = (URI)$continuation.L$1;
                map = (Map)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                this.logger.info("tryOpenDocument : " + uri.getPath() + " execution completed");
                return map;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object tryOpenDocument(@NotNull Map<String, ? extends Object> map, @Nullable String options, @NotNull Continuation<? super Map<String, ? extends Object>> $completion) {
        return this.tryOpenDocument(map, new HashMap(), $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object trySaveDocument(@NotNull Map<String, ? extends Object> var1_1, @NotNull Continuation<? super Boolean> $completion) {
        block7: {
            if (!($completion instanceof trySaveDocument.1)) ** GOTO lbl-1000
            var7_3 = $completion;
            if ((var7_3.label & -2147483648) != 0) {
                var7_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ MainThreadDocuments this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.trySaveDocument(null, (Continuation<? super Boolean>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    uri = EditorCommandsKt.createURI((Map<String, ? extends Object>)map);
                    this.logger.info("trySaveDocument\uff1a " + uri.getPath());
                    v0 = ((EditorAndDocManager)this.project.getService(EditorAndDocManager.class)).getEditorHandleByUri(uri, true);
                    if (v0 == null) break;
                    $continuation.L$0 = uri;
                    $continuation.label = 1;
                    v1 = v0.updateDocumentDirty(false, (Continuation<? super Unit>)$continuation);
                    if (v1 == var8_5) {
                        return var8_5;
                    }
                    break block7;
                }
                case 1: {
                    uri = (URI)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                    break block7;
                }
            }
            $this$trySaveDocument_u24lambda_u240 = this;
            $i$a$-run-MainThreadDocuments$trySaveDocument$2 = false;
            $this$trySaveDocument_u24lambda_u240.logger.info("trySaveDocument\uff1a " + uri.getPath() + " not found");
            return Boxing.boxBoolean((boolean)false);
        }
        this.logger.info("trySaveDocument\uff1a " + uri.getPath() + " execution completed");
        return Boxing.boxBoolean((boolean)true);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void dispose() {
        try {
            MessageBusConnection messageBusConnection = this.messageBusConnection;
            if (messageBusConnection != null) {
                messageBusConnection.disconnect();
            }
            this.messageBusConnection = null;
            this.documentSyncService.dispose();
            CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
            this.logger.info("Document save listener disposed");
        }
        catch (Exception e) {
            this.logger.error("Error disposing document save listener", (Throwable)e);
        }
    }

    @Override
    @Nullable
    public Object dispatcher(@NotNull RPCContext rpcContext, @NotNull String methodName, @NotNull List<? extends Object> args, @NotNull Continuation<Object> $completion) {
        return switch (methodName) {
            case "tryCreateDocument" -> {
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf(Map.class), args);
                Map options = (Map)realArgs.get(0);
                yield this.tryCreateDocument(options, $completion);
            }
            case "tryOpenDocument" -> {
                Object[] options = new Class[]{Map.class, Map.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])options), args);
                Object v1 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                Map map = (Map)v1;
                Map options = (Map)realArgs.get(1);
                yield this.tryOpenDocument((Map<String, ? extends Object>)map, options, $completion);
            }
            case "trySaveDocument" -> {
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf(Map.class), args);
                Object v2 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                Map map = (Map)v2;
                yield this.trySaveDocument(map, $completion);
            }
            default -> null;
        };
    }

    @Override
    @NotNull
    public List<Object> resolveTrueParameterTypes(@NotNull List<? extends Class<?>> parameterTypes, @NotNull List<? extends Object> args) {
        return MainThreadDocumentsShape.DefaultImpls.resolveTrueParameterTypes(this, parameterTypes, args);
    }

    public static final /* synthetic */ void access$handleDocumentSaving(MainThreadDocuments $this, Document document) {
        $this.handleDocumentSaving(document);
    }

    public static final /* synthetic */ DocumentSyncService access$getDocumentSyncService$p(MainThreadDocuments $this) {
        return $this.documentSyncService;
    }
}

