/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.utils;

import cn.gitlab.kilo.jetbrains.common.CustomException;
import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.services.ResponseCallbacks;
import com.google.gson.Gson;
import com.sina.weibo.agent.provider.LoggerAdapter;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.internal.http2.StreamResetException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a'\u0010\u0004\u001a\u00020\u0005\"\u0006\b\u0000\u0010\u0006\u0018\u00012\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\nH\u0086\b\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000b"}, d2={"logger", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "getLogger", "()Lcn/gitlab/kilo/jetbrains/common/Logger;", "processDataFlow", "", "T", "dataFlow", "Ljava/io/InputStream;", "callbacks", "Lcn/gitlab/kilo/jetbrains/services/ResponseCallbacks;", "coderider-kilo-jetbrains"})
public final class StreamUtilsKt {
    @NotNull
    private static final Logger logger = Logger.Companion.getInstance("processDataFlow");

    @NotNull
    public static final Logger getLogger() {
        return logger;
    }

    public static final /* synthetic */ <T> void processDataFlow(InputStream dataFlow, ResponseCallbacks<T> callbacks2) {
        Intrinsics.checkNotNullParameter((Object)dataFlow, (String)"dataFlow");
        Intrinsics.checkNotNullParameter(callbacks2, (String)"callbacks");
        boolean $i$f$processDataFlow = false;
        Gson gson = new Gson();
        try {
            Reader reader = new BufferedReader(new InputStreamReader(dataFlow, StandardCharsets.UTF_8));
            Intrinsics.needClassReification();
            TextStreamsKt.forEachLine((Reader)reader, (Function1)((Function1)new Function1<String, Unit>(gson, callbacks2){
                final /* synthetic */ Gson $gson;
                final /* synthetic */ ResponseCallbacks<T> $callbacks;
                {
                    this.$gson = $gson;
                    this.$callbacks = $callbacks;
                }

                public final void invoke(String line) {
                    block5: {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                        String data = StringsKt.removePrefix((String)line, (CharSequence)"data:");
                        LoggerAdapter.DefaultImpls.debug$default(StreamUtilsKt.getLogger(), "Chat Response line: " + data, null, 2, null);
                        Object object2 = this.$gson;
                        ResponseCallbacks<Object> responseCallbacks = this.$callbacks;
                        try {
                            Unit unit;
                            boolean bl = false;
                            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                            Object object3 = object2.fromJson(data, Object.class);
                            if (object3 != null) {
                                Object p0 = object3;
                                boolean bl2 = false;
                                responseCallbacks.onChange(p0);
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                            object = Result.constructor-impl(unit);
                        }
                        catch (Throwable p0) {
                            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)p0));
                        }
                        object2 = object;
                        responseCallbacks = this.$callbacks;
                        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                        if (throwable == null) break block5;
                        object = throwable;
                        Throwable e = (Throwable)object;
                        boolean bl = false;
                        LoggerAdapter.DefaultImpls.info$default(StreamUtilsKt.getLogger(), "Chat Response line: " + data, null, 2, null);
                        if (e instanceof CustomException) {
                            responseCallbacks.onError(e);
                        }
                    }
                }
            }));
        }
        catch (SocketException e) {
            StreamUtilsKt.getLogger().warn(e);
            callbacks2.onComplete();
        }
        catch (StreamResetException e) {
            callbacks2.onError(e);
        }
        catch (Throwable e) {
            callbacks2.onError(e);
        }
        callbacks2.onComplete();
    }
}

