/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.services.context;

import cn.gitlab.kilo.jetbrains.services.context.CachedRetriever;
import cn.gitlab.kilo.jetbrains.services.context.ContextRetrieverOptions;
import cn.gitlab.kilo.jetbrains.services.context.ContextSnippet;
import cn.gitlab.kilo.jetbrains.services.context.LanguageUtilsKt;
import cn.gitlab.kilo.jetbrains.services.context.RecentCopyRetrieverOptions;
import cn.gitlab.kilo.jetbrains.services.context.TrackedSelection;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\f\u001a\u00020\u0018H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\tH\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001b\u001a\u00020\tH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0010H\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\u0010H\u0002J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u0010H\u0002J\u0010\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020.H\u0016J\u0018\u0010/\u001a\u00020 2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\u0018\u00104\u001a\u00020 2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\u0010\u00105\u001a\u00020)2\u0006\u00106\u001a\u00020\tH\u0016J\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016J\b\u00108\u001a\u00020 H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcn/gitlab/kilo/jetbrains/services/context/RecentCopyRetriever;", "Lcn/gitlab/kilo/jetbrains/services/context/CachedRetriever;", "Lcom/intellij/openapi/editor/event/SelectionListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "identifier", "", "getIdentifier", "()Ljava/lang/String;", "options", "Lcn/gitlab/kilo/jetbrains/services/context/RecentCopyRetrieverOptions;", "trackedSelections", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcn/gitlab/kilo/jetbrains/services/context/TrackedSelection;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "debounceJob", "Lkotlinx/coroutines/Job;", "doRetrieval", "", "Lcn/gitlab/kilo/jetbrains/services/context/ContextSnippet;", "Lcn/gitlab/kilo/jetbrains/services/context/ContextRetrieverOptions;", "getClipboardContent", "findSelectionByContent", "content", "calculateScore", "", "selection", "cleanupOldSelections", "", "addSelectionForTracking", "editor", "Lcom/intellij/openapi/editor/Editor;", "selectionModel", "Lcom/intellij/openapi/editor/SelectionModel;", "updateTrackedSelections", "newSelection", "isOverlapping", "", "existing", "new", "selectionChanged", "e", "Lcom/intellij/openapi/editor/event/SelectionEvent;", "fileOpened", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileClosed", "isSupportedForLanguageId", "languageId", "getTrackedSelections", "dispose", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nRecentCopyRetriever.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentCopyRetriever.kt\ncn/gitlab/kilo/jetbrains/services/context/RecentCopyRetriever\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,233:1\n13472#2,2:234\n1#3:236\n774#4:237\n865#4,2:238\n*S KotlinDebug\n*F\n+ 1 RecentCopyRetriever.kt\ncn/gitlab/kilo/jetbrains/services/context/RecentCopyRetriever\n*L\n51#1:234,2\n160#1:237\n160#1:238,2\n*E\n"})
public final class RecentCopyRetriever
extends CachedRetriever
implements SelectionListener,
FileEditorManagerListener {
    @NotNull
    private final Project project;
    @NotNull
    private final String identifier;
    @NotNull
    private final RecentCopyRetrieverOptions options;
    @NotNull
    private final ConcurrentLinkedQueue<TrackedSelection> trackedSelections;
    @NotNull
    private final CoroutineScope coroutineScope;
    @Nullable
    private Job debounceJob;

    public RecentCopyRetriever(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.identifier = "RecentCopy";
        this.options = new RecentCopyRetrieverOptions(0L, 0, 0L, 7, null);
        this.trackedSelections = new ConcurrentLinkedQueue();
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        MessageBusConnection connection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        connection.subscribe(topic, (Object)this);
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this.project).getAllEditors();
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
        Object[] $this$forEach$iv = fileEditorArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileEditor fileEditor = (FileEditor)element$iv;
            boolean bl = false;
            TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
            if (textEditor == null || (textEditor = textEditor.getEditor()) == null || (textEditor = textEditor.getSelectionModel()) == null) continue;
            textEditor.addSelectionListener((SelectionListener)this);
        }
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @NotNull
    public List<ContextSnippet> doRetrieval(@NotNull ContextRetrieverOptions options) {
        List list;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        String clipboardContent = this.getClipboardContent();
        CharSequence charSequence = clipboardContent;
        if (charSequence == null || charSequence.length() == 0) {
            return CollectionsKt.emptyList();
        }
        this.cleanupOldSelections();
        TrackedSelection matchingSelection = this.findSelectionByContent(clipboardContent);
        if (matchingSelection != null) {
            double score = this.calculateScore(matchingSelection);
            list = CollectionsKt.listOf((Object)new ContextSnippet(matchingSelection.getUri(), matchingSelection.getStartLine(), matchingSelection.getEndLine(), matchingSelection.getContent(), score, null, null, 96, null));
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final String getClipboardContent() {
        String string;
        try {
            Object object;
            Transferable transferable;
            CopyPasteManager clipboard = CopyPasteManager.getInstance();
            Transferable transferable2 = transferable = clipboard.getContents();
            string = (transferable2 != null ? transferable2.isDataFlavorSupported(DataFlavor.stringFlavor) : false) ? ((object = transferable.getTransferData(DataFlavor.stringFlavor)) instanceof String ? (String)object : null) : null;
        }
        catch (Exception e) {
            string = null;
        }
        return string;
    }

    private final TrackedSelection findSelectionByContent(String content) {
        Object v0;
        block1: {
            Iterable iterable = this.trackedSelections;
            for (Object t : iterable) {
                TrackedSelection it = (TrackedSelection)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getContent(), (Object)content)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final double calculateScore(TrackedSelection selection) {
        long currentTime = System.currentTimeMillis();
        long timeSinceSelection = currentTime - selection.getTimestamp();
        double timeScore = Math.max(0.0, 1.0 - (double)timeSinceSelection / (double)this.options.getMaxAgeMs());
        double contentScore = selection.getContent().length() < 10 ? 0.3 : (selection.getContent().length() < 100 ? 0.8 : (selection.getContent().length() < 1000 ? 1.0 : 0.7));
        return timeScore * 0.7 + contentScore * 0.3;
    }

    private final void cleanupOldSelections() {
        long currentTime = System.currentTimeMillis();
        Iterator<TrackedSelection> iterator = this.trackedSelections.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<TrackedSelection> iterator2 = iterator;
        while (iterator2.hasNext()) {
            TrackedSelection selection = iterator2.next();
            if (currentTime - selection.getTimestamp() <= this.options.getMaxAgeMs()) continue;
            iterator2.remove();
        }
    }

    private final void addSelectionForTracking(Editor editor, SelectionModel selectionModel) {
        String selectedText = selectionModel.getSelectedText();
        CharSequence charSequence = selectedText;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document2);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        String string = virtualFile2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String language = LanguageUtilsKt.getLanguageFromPath(string);
        int startOffset = selectionModel.getSelectionStart();
        int endOffset = selectionModel.getSelectionEnd();
        int startLine = document2.getLineNumber(startOffset);
        int endLine = document2.getLineNumber(endOffset);
        long l = System.currentTimeMillis();
        String string2 = virtualFile2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        TrackedSelection newSelection = new TrackedSelection(l, selectedText, language, string2, startLine, endLine, startOffset, endOffset);
        this.updateTrackedSelections(newSelection);
    }

    /*
     * Unable to fully structure code
     */
    private final void updateTrackedSelections(TrackedSelection newSelection) {
        currentTime = System.currentTimeMillis();
        $this$filter$iv = this.trackedSelections;
        $i$f$filter = false;
        var7_5 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            selection = (TrackedSelection)element$iv$iv;
            $i$a$-filter-RecentCopyRetriever$updateTrackedSelections$filteredSelections$1 = false;
            if (currentTime - selection.getTimestamp() >= this.options.getMaxAgeMs()) ** GOTO lbl-1000
            Intrinsics.checkNotNull((Object)selection);
            if (!this.isOverlapping(selection, newSelection)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if (!v0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        filteredSelections = (List)destination$iv$iv;
        this.trackedSelections.clear();
        this.trackedSelections.addAll(filteredSelections);
        this.trackedSelections.add(newSelection);
        while (this.trackedSelections.size() > this.options.getMaxSelections()) {
            this.trackedSelections.poll();
        }
    }

    private final boolean isOverlapping(TrackedSelection existing, TrackedSelection trackedSelection) {
        if (!Intrinsics.areEqual((Object)existing.getUri(), (Object)trackedSelection.getUri())) {
            return false;
        }
        return trackedSelection.getStartOffset() <= existing.getStartOffset() && trackedSelection.getEndOffset() >= existing.getEndOffset();
    }

    public void selectionChanged(@NotNull SelectionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = e.getEditor();
        Job job = this.debounceJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.debounceJob = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, editor, null){
            int label;
            final /* synthetic */ RecentCopyRetriever this$0;
            final /* synthetic */ Editor $editor;
            {
                this.this$0 = $receiver;
                this.$editor = $editor;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay((long)RecentCopyRetriever.access$getOptions$p(this.this$0).getDebounceMs(), (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        ApplicationManager.getApplication().runReadAction((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, invokeSuspend$lambda$0(cn.gitlab.kilo.jetbrains.services.context.RecentCopyRetriever com.intellij.openapi.editor.Editor ), ()V)((RecentCopyRetriever)this.this$0, (Editor)this.$editor));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(RecentCopyRetriever this$0, Editor $editor) {
                try {
                    Intrinsics.checkNotNull((Object)$editor);
                    SelectionModel selectionModel = $editor.getSelectionModel();
                    Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
                    RecentCopyRetriever.access$addSelectionForTracking(this$0, $editor, selectionModel);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }), (int)3, null);
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ApplicationManager.getApplication().invokeLater(() -> RecentCopyRetriever.fileOpened$lambda$3(source, file, this));
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
    }

    @Override
    public boolean isSupportedForLanguageId(@NotNull String languageId) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        return true;
    }

    @NotNull
    public final List<TrackedSelection> getTrackedSelections() {
        return CollectionsKt.toList((Iterable)this.trackedSelections);
    }

    @Override
    public void dispose() {
        super.dispose();
        Job job = this.debounceJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
        this.trackedSelections.clear();
    }

    private static final void fileOpened$lambda$3(FileEditorManager $source, VirtualFile $file, RecentCopyRetriever this$0) {
        block0: {
            FileEditor fileEditor = $source.getSelectedEditor($file);
            TextEditor editor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
            TextEditor textEditor = editor;
            if (textEditor == null || (textEditor = textEditor.getEditor()) == null || (textEditor = textEditor.getSelectionModel()) == null) break block0;
            textEditor.addSelectionListener((SelectionListener)this$0);
        }
    }

    public static final /* synthetic */ RecentCopyRetrieverOptions access$getOptions$p(RecentCopyRetriever $this) {
        return $this.options;
    }

    public static final /* synthetic */ void access$addSelectionForTracking(RecentCopyRetriever $this, Editor editor, SelectionModel selectionModel) {
        $this.addSelectionForTracking(editor, selectionModel);
    }
}

