/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.services.context;

import cn.gitlab.kilo.jetbrains.common.Range;
import cn.gitlab.kilo.jetbrains.services.context.CachedRetriever;
import cn.gitlab.kilo.jetbrains.services.context.ContextRetrieverOptions;
import cn.gitlab.kilo.jetbrains.services.context.ContextSnippet;
import cn.gitlab.kilo.jetbrains.services.context.FileContents;
import cn.gitlab.kilo.jetbrains.services.context.FileIndexer;
import cn.gitlab.kilo.jetbrains.services.context.JaccardMatch;
import cn.gitlab.kilo.jetbrains.services.context.JaccardSimilarityRetrieverKt;
import cn.gitlab.kilo.jetbrains.services.context.LanguageUtilsKt;
import cn.gitlab.kilo.jetbrains.services.context.TrackedFile;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\fH\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcn/gitlab/kilo/jetbrains/services/context/JaccardSimilarityRetriever;", "Lcn/gitlab/kilo/jetbrains/services/context/CachedRetriever;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "snippetWindowSize", "", "maxMatchesPerFile", "identifier", "", "getIdentifier", "()Ljava/lang/String;", "doRetrieval", "", "Lcn/gitlab/kilo/jetbrains/services/context/ContextSnippet;", "options", "Lcn/gitlab/kilo/jetbrains/services/context/ContextRetrieverOptions;", "isSupportedForLanguageId", "", "languageId", "getRelevantFiles", "Lcn/gitlab/kilo/jetbrains/services/context/FileContents;", "currentDocument", "Lcom/intellij/openapi/editor/Document;", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nJaccardSimilarityRetriever.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JaccardSimilarityRetriever.kt\ncn/gitlab/kilo/jetbrains/services/context/JaccardSimilarityRetriever\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,362:1\n774#2:363\n865#2,2:364\n1068#2:367\n774#2:370\n865#2,2:371\n1869#2,2:373\n1#3:366\n31#4,2:368\n*S KotlinDebug\n*F\n+ 1 JaccardSimilarityRetriever.kt\ncn/gitlab/kilo/jetbrains/services/context/JaccardSimilarityRetriever\n*L\n33#1:363\n33#1:364,2\n47#1:367\n65#1:370\n65#1:371,2\n67#1:373,2\n64#1:368,2\n*E\n"})
public final class JaccardSimilarityRetriever
extends CachedRetriever {
    @NotNull
    private final Project project;
    private final int snippetWindowSize;
    private final int maxMatchesPerFile;
    @NotNull
    private final String identifier;

    public JaccardSimilarityRetriever(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.snippetWindowSize = 50;
        this.maxMatchesPerFile = 20;
        this.identifier = "Jaccard";
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ContextSnippet> doRetrieval(@NotNull ContextRetrieverOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        String targetText = JaccardSimilarityRetrieverKt.lastNLines(options.getDocContext().getPrefix(), this.snippetWindowSize);
        Document document = options.getDocument();
        List<FileContents> files = this.getRelevantFiles(document);
        Range contextRange = JaccardSimilarityRetrieverKt.getContextRange(document, options.getDocContext());
        List matches = new ArrayList();
        String filePath = JaccardSimilarityRetrieverKt.getFilePathFromDocument(document);
        for (FileContents fileContents : files) {
            void $this$filterTo$iv$iv;
            String uri = fileContents.component1();
            String contents = fileContents.component2();
            List<JaccardMatch> fileMatches = JaccardSimilarityRetrieverKt.bestJaccardMatches(targetText, contents, this.snippetWindowSize, this.maxMatchesPerFile);
            Iterable $this$filter$iv = fileMatches;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                JaccardMatch it = (JaccardMatch)element$iv$iv;
                boolean bl = false;
                if (!(it.getScore() > 0.0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List relatedMatches = (List)destination$iv$iv;
            for (JaccardMatch match : relatedMatches) {
                if (Intrinsics.areEqual((Object)uri, (Object)filePath) && JaccardSimilarityRetrieverKt.startOrEndOverlapsLineRange(uri, (Pair<Integer, Integer>)TuplesKt.to((Object)match.getStartLine(), (Object)match.getEndLine()), filePath, (Pair<Integer, Integer>)TuplesKt.to((Object)document.getLineStartOffset(contextRange.getStart()), (Object)document.getLineStartOffset(contextRange.getEnd())))) continue;
                ContextSnippet it = new ContextSnippet(uri, match.getStartLine(), match.getEndLine(), match.getContent(), match.getScore(), null, null, 96, null);
                boolean bl = false;
                matches.add(it);
            }
        }
        Iterable $this$sortedByDescending$iv = matches;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ContextSnippet it = (ContextSnippet)b;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getScore());
                it = (ContextSnippet)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getScore()));
            }
        });
    }

    @Override
    public boolean isSupportedForLanguageId(@NotNull String languageId) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FileContents> getRelevantFiles(Document currentDocument) {
        List files = new ArrayList();
        String lang = LanguageUtilsKt.getLanguageFromDocument(currentDocument);
        Object object = lang;
        if (!(object == null || object.length() == 0)) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service22 = false;
            Class<FileIndexer> serviceClass$iv = FileIndexer.class;
            Object object2 = $this$service$iv.getService(serviceClass$iv);
            if (object2 == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            Collection<TrackedFile> collection = ((FileIndexer)object2).getTrackedFiles().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            object = collection;
            boolean $i$f$filter = false;
            void $i$f$service22 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TrackedFile it = (TrackedFile)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getLanguage(), (Object)lang)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)10);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TrackedFile it = (TrackedFile)element$iv;
                boolean bl = false;
                JaccardSimilarityRetriever.getRelevantFiles$addDocument(files, it.getDocument());
            }
        }
        return files;
    }

    private static final void getRelevantFiles$addDocument(List<FileContents> files, Document document) {
        block0: {
            int endLine = Math.min(document.getLineCount(), 10000);
            String content = JaccardSimilarityRetrieverKt.getText(document, 0, document.getLineStartOffset(Math.max(endLine - 1, 0)));
            String string = JaccardSimilarityRetrieverKt.getFilePathFromDocument(document);
            if (string == null) break block0;
            Object it = string;
            boolean bl = false;
            it = new FileContents((String)it, content);
            boolean bl2 = false;
            files.add((FileContents)it);
        }
    }
}

