/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.services.context;

import cn.gitlab.kilo.jetbrains.services.context.ContextSizeHints;
import cn.gitlab.kilo.jetbrains.services.context.ContextSnippet;
import cn.gitlab.kilo.jetbrains.services.context.LanguageConfig;
import cn.gitlab.kilo.jetbrains.services.context.PromptString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\u001aT\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00010\u00042\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00040\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00070\u0006\u001aZ\u0010\t\u001a \u0012\u0004\u0012\u00020\u0007\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\r0\u000b0\n\"\u0004\b\u0000\u0010\u00022\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00010\u00042\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00040\u0006H\u0002\u001an\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\n\"\u0004\b\u0000\u0010\u00022\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00010\u00042\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00040\u00062$\u0010\u0010\u001a \u0012\u0004\u0012\u00020\u0007\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\r0\u000b0\nH\u0002\u001aB\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0004\"\u0004\b\u0000\u0010\u00022\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00040\n2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a#\u0010\u0013\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0015\u001a\u0002H\u00022\u0006\u0010\u0016\u001a\u0002H\u0002H\u0002\u00a2\u0006\u0002\u0010\u0017\u001a7\u0010\u0018\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0019\u001a\u0002H\u00022\u0006\u0010\u001a\u001a\u0002H\u00022\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0002\u0010\u001b\u001a7\u0010\u001c\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0019\u001a\u0002H\u00022\u0006\u0010\u001a\u001a\u0002H\u00022\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0002\u0010\u001b\u001a\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\f\u001a.\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0007\u001a\u0010\u0010*\u001a\u00020\u00072\b\u0010&\u001a\u0004\u0018\u00010\u0007\u001a\u000e\u0010+\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007\u001a&\u0010,\u001a\u00020#2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020#0\u00042\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010'\u001a\u00020\u0007\u001a\u0010\u00101\u001a\u0004\u0018\u00010/2\u0006\u00102\u001a\u00020\u0007\"\u000e\u0010\u001d\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001e\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"fuseResults", "", "T", "retrievedSets", "", "rankingIdentities", "Lkotlin/Function1;", "", "getContent", "buildDocumentIndex", "", "", "", "", "calculateRRFScores", "", "resultsByDocument", "collectAndDeduplicateResults", "resultByDocument", "equalsByFileAndRange", "", "a", "b", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "isSameFileAndContainer", "snippet1", "snippet2", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Z", "isSameFileAndContained", "RRF_K", "CHARACTERS_PER_TOKEN", "standardContextSizeHints", "Lcn/gitlab/kilo/jetbrains/services/context/ContextSizeHints;", "maxContextTokens", "getContextPrompt", "Lcn/gitlab/kilo/jetbrains/services/context/PromptString;", "filename", "content", "language", "modelKey", "provider", "COMMENT_STARTS", "getCommentStart", "fromDisplayPath", "getIntroString", "intro", "languageConfig", "Lcn/gitlab/kilo/jetbrains/services/context/LanguageConfig;", "BRACE_LANGUAGES", "getLanguageConfig", "languageId", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nContextUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextUtils.kt\ncn/gitlab/kilo/jetbrains/services/context/ContextUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,269:1\n1068#2:270\n1563#2:271\n1634#2,3:272\n1374#2:275\n1460#2,5:276\n1878#2,2:281\n1869#2:283\n1869#2:284\n1870#2:299\n1870#2:300\n1880#2:301\n1878#2,2:302\n1878#2,2:304\n1869#2,2:306\n1880#2:308\n1880#2:309\n1374#2:311\n1460#2,2:312\n1617#2,9:314\n1869#2:323\n1870#2:325\n1626#2:326\n1462#2,3:327\n1761#2,3:330\n1761#2,3:333\n1563#2:336\n1634#2,3:337\n382#3,7:285\n382#3,7:292\n1#4:310\n1#4:324\n*S KotlinDebug\n*F\n+ 1 ContextUtils.kt\ncn/gitlab/kilo/jetbrains/services/context/ContextUtilsKt\n*L\n49#1:270\n50#1:271\n50#1:272,3\n52#1:275\n52#1:276,5\n65#1:281,2\n66#1:283\n67#1:284\n67#1:299\n66#1:300\n65#1:301\n84#1:302,2\n85#1:304,2\n86#1:306,2\n85#1:308\n84#1:309\n103#1:311\n103#1:312,2\n104#1:314,9\n104#1:323\n104#1:325\n104#1:326\n103#1:327,3\n111#1:330,3\n122#1:333,3\n223#1:336\n223#1:337,3\n68#1:285,7\n69#1:292,7\n104#1:324\n*E\n"})
public final class ContextUtilsKt {
    private static final double RRF_K = 60.0;
    public static final double CHARACTERS_PER_TOKEN = 3.5;
    @NotNull
    private static final Map<String, String> COMMENT_STARTS;
    @NotNull
    private static final Set<String> BRACE_LANGUAGES;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> Set<T> fuseResults(@NotNull List<? extends Set<? extends T>> retrievedSets, @NotNull Function1<? super T, ? extends List<String>> rankingIdentities, @NotNull Function1<? super T, String> getContent) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$sortedByDescending$iv;
        Intrinsics.checkNotNullParameter(retrievedSets, (String)"retrievedSets");
        Intrinsics.checkNotNullParameter(rankingIdentities, (String)"rankingIdentities");
        Intrinsics.checkNotNullParameter(getContent, (String)"getContent");
        Map<String, Map<Integer, List<T>>> resultsByDocument = ContextUtilsKt.buildDocumentIndex(retrievedSets, rankingIdentities);
        Map<String, Double> documentScores = ContextUtilsKt.calculateRRFScores(retrievedSets, rankingIdentities, resultsByDocument);
        Iterable iterable = documentScores.entrySet();
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Double)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getValue()));
            }
        });
        boolean $i$f$map = false;
        void var8_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getKey());
        }
        List topDocuments = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = topDocuments;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Object object;
            block5: {
                block4: {
                    String id = (String)element$iv$iv;
                    boolean bl = false;
                    object = resultsByDocument.get(id);
                    if (object == null) break block4;
                    Map<Integer, List<? super T>> resultByDocument = object;
                    boolean bl2 = false;
                    List<? super T> list = ContextUtilsKt.collectAndDeduplicateResults(resultByDocument, getContent);
                    object = list;
                    if (list != null) break block5;
                }
                object = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = (Iterable)object;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> Map<String, Map<Integer, List<T>>> buildDocumentIndex(List<? extends Set<? extends T>> retrievedSets, Function1<? super T, ? extends List<String>> rankingIdentities) {
        Map index = new LinkedHashMap();
        Iterable $this$forEachIndexed$iv = retrievedSets;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void results;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Set set2 = (Set)item$iv;
            int retrieverIndex = n;
            boolean bl = false;
            Iterable $this$forEach$iv = (Iterable)results;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object result = element$iv = iterator.next();
                boolean bl2 = false;
                Iterable $this$forEach$iv2 = (Iterable)rankingIdentities.invoke(result);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Object object;
                    void key$iv;
                    Object object2;
                    String id = (String)element$iv2;
                    boolean bl3 = false;
                    Map $this$getOrPut$iv = index;
                    boolean $i$f$getOrPut22 = false;
                    Object value$iv = $this$getOrPut$iv.get(id);
                    if (value$iv == null) {
                        boolean bl4 = false;
                        Map answer$iv = new LinkedHashMap();
                        $this$getOrPut$iv.put(id, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv;
                    }
                    $this$getOrPut$iv = (Map)object2;
                    Integer $i$f$getOrPut22 = retrieverIndex;
                    boolean $i$f$getOrPut = false;
                    Object value$iv2 = $this$getOrPut$iv.get(key$iv);
                    if (value$iv2 == null) {
                        boolean bl5 = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv2;
                    }
                    ((List)object).add(result);
                }
            }
        }
        return index;
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> Map<String, Double> calculateRRFScores(List<? extends Set<? extends T>> retrievedSets, Function1<? super T, ? extends List<String>> rankingIdentities, Map<String, ? extends Map<Integer, List<T>>> resultsByDocument) {
        Map scores = new LinkedHashMap();
        Iterable $this$forEachIndexed$iv = retrievedSets;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void results;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Set set2 = (Set)item$iv;
            int retrieverIndex = n;
            boolean bl = false;
            Iterable $this$forEachIndexed$iv2 = (Iterable)results;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                void result;
                int n2;
                if ((n2 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv2;
                int rank = n2;
                boolean bl2 = false;
                Iterable $this$forEach$iv = (Iterable)rankingIdentities.invoke((Object)result);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String id = (String)element$iv;
                    boolean bl3 = false;
                    Map<Integer, List<T>> map = resultsByDocument.get(id);
                    boolean isBestRank = Intrinsics.areEqual(map != null && (map = map.get(retrieverIndex)) != null ? CollectionsKt.firstOrNull((List)((Object)map)) : null, (Object)result);
                    if (!isBestRank) continue;
                    double reciprocalRank = 1.0 / (60.0 + (double)rank);
                    Map map2 = scores;
                    Double d = (Double)scores.get(id);
                    Double d2 = (d != null ? d : 0.0) + reciprocalRank;
                    map2.put(id, d2);
                }
            }
        }
        return scores;
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> List<T> collectAndDeduplicateResults(Map<Integer, ? extends List<? extends T>> resultByDocument, Function1<? super T, String> getContent) {
        void $this$flatMapTo$iv$iv;
        Object it;
        Object object;
        Iterator iterator = ((Iterable)resultByDocument.values()).iterator();
        if (!iterator.hasNext()) {
            object = null;
        } else {
            it = (List)iterator.next();
            boolean bl = false;
            it = it.size();
            while (iterator.hasNext()) {
                Object it2 = (List)iterator.next();
                $i$a$-maxOfOrNull-ContextUtilsKt$collectAndDeduplicateResults$maxMatches$1 = false;
                if (it.compareTo(it2 = (Comparable)Integer.valueOf(it2.size())) >= 0) continue;
                it = it2;
            }
            object = it;
        }
        Integer n = (Integer)object;
        int maxMatches = n != null ? n : 0;
        Iterable $this$flatMap$iv = (Iterable)RangesKt.until((int)0, (int)maxMatches);
        boolean $i$f$flatMap = false;
        it = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void $this$mapNotNullTo$iv$iv;
            int element$iv$iv;
            int i = element$iv$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            Iterable $this$mapNotNull$iv = resultByDocument.values();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Object it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator3.next();
                boolean bl2 = false;
                List snippets = (List)element$iv$iv2;
                boolean bl3 = false;
                if (CollectionsKt.getOrNull((List)snippets, (int)i) == null) continue;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List allSnippets = (List)destination$iv$iv;
        List dedup = new ArrayList();
        for (Object snippet : allSnippets) {
            boolean isExactDuplicate;
            boolean bl;
            block13: {
                boolean containedByExisting;
                boolean bl5;
                block12: {
                    Iterable $this$any$iv = dedup;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl5 = false;
                    } else {
                        Iterator element$iv$iv = $this$any$iv.iterator();
                        while (element$iv$iv.hasNext()) {
                            Object element$iv;
                            Object existing = element$iv = element$iv$iv.next();
                            boolean bl6 = false;
                            if (!ContextUtilsKt.isSameFileAndContainer(existing, snippet, getContent)) continue;
                            bl5 = true;
                            break block12;
                        }
                        bl5 = false;
                    }
                }
                if (containedByExisting = bl5) continue;
                CollectionsKt.removeAll((List)dedup, arg_0 -> ContextUtilsKt.collectAndDeduplicateResults$lambda$16(snippet, getContent, arg_0));
                Iterable $this$any$iv = dedup;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator4 = $this$any$iv.iterator();
                    while (iterator4.hasNext()) {
                        Object element$iv;
                        Object existing = element$iv = iterator4.next();
                        boolean bl7 = false;
                        if (!(ContextUtilsKt.equalsByFileAndRange(snippet, existing) || Intrinsics.areEqual((Object)getContent.invoke(existing), (Object)getContent.invoke(snippet)))) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (isExactDuplicate = bl) continue;
            dedup.add(snippet);
        }
        return dedup;
    }

    private static final <T> boolean equalsByFileAndRange(T a, T b) {
        return a instanceof ContextSnippet && b instanceof ContextSnippet ? Intrinsics.areEqual((Object)((ContextSnippet)a).getUri(), (Object)((ContextSnippet)b).getUri()) && ((ContextSnippet)a).getStartLine() == ((ContextSnippet)b).getStartLine() && ((ContextSnippet)a).getEndLine() == ((ContextSnippet)b).getEndLine() : false;
    }

    private static final <T> boolean isSameFileAndContainer(T snippet1, T snippet2, Function1<? super T, String> getContent) {
        if (snippet1 instanceof ContextSnippet && snippet2 instanceof ContextSnippet) {
            return Intrinsics.areEqual((Object)((ContextSnippet)snippet1).getUri(), (Object)((ContextSnippet)snippet2).getUri()) && ((ContextSnippet)snippet1).getStartLine() <= ((ContextSnippet)snippet2).getStartLine() && ((ContextSnippet)snippet1).getEndLine() >= ((ContextSnippet)snippet2).getEndLine();
        }
        return StringsKt.contains$default((CharSequence)((CharSequence)getContent.invoke(snippet1)), (CharSequence)((CharSequence)getContent.invoke(snippet2)), (boolean)false, (int)2, null);
    }

    private static final <T> boolean isSameFileAndContained(T snippet1, T snippet2, Function1<? super T, String> getContent) {
        if (snippet1 instanceof ContextSnippet && snippet2 instanceof ContextSnippet) {
            return Intrinsics.areEqual((Object)((ContextSnippet)snippet1).getUri(), (Object)((ContextSnippet)snippet2).getUri()) && ((ContextSnippet)snippet1).getStartLine() >= ((ContextSnippet)snippet2).getStartLine() && ((ContextSnippet)snippet1).getEndLine() <= ((ContextSnippet)snippet2).getEndLine();
        }
        return StringsKt.contains$default((CharSequence)((CharSequence)getContent.invoke(snippet2)), (CharSequence)((CharSequence)getContent.invoke(snippet1)), (boolean)false, (int)2, null);
    }

    @NotNull
    public static final ContextSizeHints standardContextSizeHints(int maxContextTokens) {
        int totalChars = (int)((double)maxContextTokens * 3.5 * 0.9);
        return new ContextSizeHints(totalChars, (int)((double)totalChars * 0.4), (int)((double)totalChars * 0.4), (int)((double)totalChars * 0.2));
    }

    @NotNull
    public static final PromptString getContextPrompt(@NotNull String filename, @NotNull String content, @NotNull String language, @NotNull String modelKey, @NotNull String provider) {
        PromptString promptString;
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)modelKey, (String)"modelKey");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        if (StringsKt.contains$default((CharSequence)provider, (CharSequence)"qwen", (boolean)false, (int)2, null)) {
            promptString = new PromptString("<|file_sep|>" + ContextUtilsKt.fromDisplayPath(filename) + "\n" + content);
        } else if (StringsKt.contains((CharSequence)modelKey, (CharSequence)"server", (boolean)true) || StringsKt.contains((CharSequence)modelKey, (CharSequence)"deepseek", (boolean)true)) {
            promptString = new PromptString("#" + ContextUtilsKt.fromDisplayPath(filename) + "\n" + content);
        } else {
            String commentStart = ContextUtilsKt.getCommentStart(language);
            promptString = new PromptString(commentStart + " Here is a reference snippet of code from " + ContextUtilsKt.fromDisplayPath(filename) + ":\n\n" + content);
        }
        return promptString;
    }

    @NotNull
    public static final String getCommentStart(@Nullable String language) {
        String string;
        String string2;
        String string3 = language;
        if (string3 != null) {
            String string4 = string3.toLowerCase(Locale.ROOT);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string2 = null;
        }
        if ((string = COMMENT_STARTS.get(string2)) == null) {
            string = "// ";
        }
        return string;
    }

    @NotNull
    public static final String fromDisplayPath(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return filename;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PromptString getIntroString(@NotNull List<PromptString> intro, @Nullable LanguageConfig languageConfig, @NotNull String modelKey) {
        PromptString promptString;
        Intrinsics.checkNotNullParameter(intro, (String)"intro");
        Intrinsics.checkNotNullParameter((Object)modelKey, (String)"modelKey");
        if (StringsKt.contains$default((CharSequence)modelKey, (CharSequence)"deepseek", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)modelKey, (CharSequence)"server", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)modelKey, (CharSequence)"maas", (boolean)false, (int)2, null)) {
            promptString = new PromptString(PromptString.Companion.join(intro, new PromptString("\n\n")).getValue() + "\n");
        } else {
            void $this$mapTo$iv$iv;
            Object object = languageConfig;
            if (object == null || (object = ((LanguageConfig)object).getCommentStart()) == null) {
                object = "// ";
            }
            Object commentStart = object;
            String[] stringArray = new String[]{"\n"};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)PromptString.Companion.join(intro, new PromptString("\n\n")).getValue(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void line;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new PromptString((String)commentStart + (String)line));
            }
            List commented = (List)destination$iv$iv;
            promptString = new PromptString(PromptString.Companion.join(commented, new PromptString("\n")).getValue() + "\n");
        }
        return promptString;
    }

    @Nullable
    public static final LanguageConfig getLanguageConfig(@NotNull String languageId) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        String string = languageId;
        return BRACE_LANGUAGES.contains(string) ? new LanguageConfig("{", new Regex("^[\\t ]*} else"), "}", "// ") : (Intrinsics.areEqual((Object)string, (Object)"python") ? new LanguageConfig(":", new Regex("^[\\t ]*(elif |else:)"), null, "# ") : (Intrinsics.areEqual((Object)string, (Object)"elixir") ? new LanguageConfig("do", new Regex("^[\\t ]*(else|else do)"), "end", "# ") : null));
    }

    private static final boolean collectAndDeduplicateResults$lambda$16(Object $snippet, Function1 $getContent, Object existing) {
        return ContextUtilsKt.isSameFileAndContainer($snippet, existing, $getContent);
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"kotlin", (Object)"// "), TuplesKt.to((Object)"java", (Object)"// "), TuplesKt.to((Object)"python", (Object)"# "), TuplesKt.to((Object)"javascript", (Object)"// "), TuplesKt.to((Object)"typescript", (Object)"// "), TuplesKt.to((Object)"html", (Object)"<!-- "), TuplesKt.to((Object)"css", (Object)"/* "), TuplesKt.to((Object)"xml", (Object)"<!-- "), TuplesKt.to((Object)"json", (Object)"// ")};
        COMMENT_STARTS = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{"astro", "c", "cpp", "csharp", "dart", "go", "java", "javascript", "javascriptreact", "kotlin", "php", "rust", "svelte", "typescript", "typescriptreact", "vue"};
        BRACE_LANGUAGES = SetsKt.setOf((Object[])objectArray);
    }
}

