/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.services.context;

import cn.gitlab.kilo.jetbrains.services.context.ContextRetriever;
import cn.gitlab.kilo.jetbrains.services.context.ContextRetrieverOptions;
import cn.gitlab.kilo.jetbrains.services.context.ContextSnippet;
import cn.gitlab.kilo.jetbrains.services.context.JaccardSimilarityRetrieverKt;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.application.ActionsKt;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006H&J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016Rf\u0010\u0004\u001aZ\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t \u0007*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\b \u0007*,\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t \u0007*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\b\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcn/gitlab/kilo/jetbrains/services/context/CachedRetriever;", "Lcn/gitlab/kilo/jetbrains/services/context/ContextRetriever;", "<init>", "()V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "kotlin.jvm.PlatformType", "", "Lcn/gitlab/kilo/jetbrains/services/context/ContextSnippet;", "currentKey", "Ljava/util/concurrent/atomic/AtomicReference;", "identifier", "getIdentifier", "()Ljava/lang/String;", "doRetrieval", "options", "Lcn/gitlab/kilo/jetbrains/services/context/ContextRetrieverOptions;", "isSupportedForLanguageId", "", "languageId", "toCacheKey", "retrieve", "dispose", "", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nCachedRetriever.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachedRetriever.kt\ncn/gitlab/kilo/jetbrains/services/context/CachedRetriever\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,36:1\n1#2:37\n*E\n"})
public abstract class CachedRetriever
extends ContextRetriever {
    private final Cache<String, List<ContextSnippet>> cache = Caffeine.newBuilder().maximumSize(500L).build();
    @NotNull
    private final AtomicReference<String> currentKey = new AtomicReference<Object>(null);

    @Override
    @NotNull
    public abstract String getIdentifier();

    @NotNull
    public abstract List<ContextSnippet> doRetrieval(@NotNull ContextRetrieverOptions var1);

    @Override
    public abstract boolean isSupportedForLanguageId(@NotNull String var1);

    @Override
    @NotNull
    protected String toCacheKey(@NotNull ContextRetrieverOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        String string = (String)ActionsKt.runReadAction(() -> CachedRetriever.toCacheKey$lambda$0(options));
        if (string == null) {
            string = "unknown";
        }
        String filePath = string;
        int contentHash = options.getDocContext().getPrefix().hashCode() + options.getDocContext().getSuffix().hashCode();
        return this.getIdentifier() + ":" + filePath + ":" + options.getPosition().getOffset() + ":" + contentHash;
    }

    @Override
    @NotNull
    public List<ContextSnippet> retrieve(@NotNull ContextRetrieverOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        String key = this.toCacheKey(options);
        List list = (List)this.cache.getIfPresent((Object)key);
        if (list != null) {
            List it = list;
            boolean bl = false;
            return it;
        }
        this.currentKey.set(key);
        List<ContextSnippet> results = this.doRetrieval(options);
        this.currentKey.set(null);
        this.cache.put((Object)key, results);
        return results;
    }

    public void dispose() {
        this.cache.invalidateAll();
    }

    private static final String toCacheKey$lambda$0(ContextRetrieverOptions $options) {
        return JaccardSimilarityRetrieverKt.getFilePathFromDocument($options.getDocument());
    }
}

