/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.psi;

import cn.gitlab.kilo.jetbrains.psi.CallReference;
import cn.gitlab.kilo.jetbrains.psi.PsiUtilInterface;
import cn.gitlab.kilo.jetbrains.psi.PsiUtilsKt;
import cn.gitlab.kilo.jetbrains.psi.RankUtilKt;
import cn.gitlab.kilo.jetbrains.psi.ReferenceType;
import cn.gitlab.kilo.jetbrains.psi.SignatureUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J \u0010\u0010\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a8\u0006\u0011"}, d2={"Lcn/gitlab/kilo/jetbrains/psi/JsPsiUtil;", "Lcn/gitlab/kilo/jetbrains/psi/PsiUtilInterface;", "<init>", "()V", "type", "", "findMethodCallsInCurrentFile", "", "Lcn/gitlab/kilo/jetbrains/psi/CallReference;", "psiFile", "Lcom/intellij/psi/PsiFile;", "findClassReferencesInCurrentFile", "findAllReferencesInCurrentFileSortedByDistance", "beginOffset", "", "endOffset", "findAllReferencesStr", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nJsPsiUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsPsiUtil.kt\ncn/gitlab/kilo/jetbrains/psi/JsPsiUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1563#2:101\n1634#2,3:102\n1617#2,9:105\n1869#2:114\n1870#2:116\n1626#2:117\n1669#2,8:118\n1617#2,9:126\n1869#2:135\n1870#2:137\n1626#2:138\n1669#2,8:139\n1#3:115\n1#3:136\n*S KotlinDebug\n*F\n+ 1 JsPsiUtil.kt\ncn/gitlab/kilo/jetbrains/psi/JsPsiUtil\n*L\n83#1:101\n83#1:102,3\n21#1:105,9\n21#1:114\n21#1:116\n21#1:117\n40#1:118,8\n50#1:126,9\n50#1:135\n50#1:137\n50#1:138\n69#1:139,8\n21#1:115\n50#1:136\n*E\n"})
public final class JsPsiUtil
implements PsiUtilInterface {
    @NotNull
    public static final JsPsiUtil INSTANCE = new JsPsiUtil();

    private JsPsiUtil() {
    }

    @Override
    @NotNull
    public String type() {
        return "javascript";
    }

    @NotNull
    public final List<CallReference> findMethodCallsInCurrentFile(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Object object = ReadAction.compute(() -> JsPsiUtil.findMethodCallsInCurrentFile$lambda$2(psiFile));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (List)object;
    }

    @NotNull
    public final List<CallReference> findClassReferencesInCurrentFile(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Object object = ReadAction.compute(() -> JsPsiUtil.findClassReferencesInCurrentFile$lambda$5(psiFile));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<CallReference> findAllReferencesInCurrentFileSortedByDistance(@NotNull PsiFile psiFile, int beginOffset, int endOffset) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        List<CallReference> classReferences = this.findClassReferencesInCurrentFile(psiFile);
        List<CallReference> methodCalls = this.findMethodCallsInCurrentFile(psiFile);
        VirtualFile virtualFile = psiFile.getVirtualFile();
        String string = virtualFile != null ? virtualFile.getPath() : null;
        if (string == null) {
            string = "";
        }
        String currentPath = string;
        Iterable iterable = CollectionsKt.plus((Collection)classReferences, (Iterable)methodCalls);
        boolean $i$f$map = false;
        void var10_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void reference;
            CallReference callReference = (CallReference)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int n = reference.getCallOffset();
            int distance = (beginOffset <= n ? n <= endOffset : false) ? 0 : RangesKt.coerceAtMost((int)Math.abs(reference.getCallOffset() - beginOffset), (int)Math.abs(reference.getCallOffset() - endOffset));
            Integer n2 = distance;
            String string2 = reference.getDefinitionFilePath();
            if (string2 == null) {
                string2 = "";
            }
            collection.add(new Triple((Object)reference, (Object)n2, (Object)PsiUtilsKt.pathSimilarityScore(currentPath, string2)));
        }
        List allReferences = (List)destination$iv$iv;
        return RankUtilKt.sortReferences(allReferences, beginOffset, endOffset);
    }

    @Override
    @NotNull
    public String findAllReferencesStr(@NotNull PsiFile psiFile, int beginOffset, int endOffset) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        List<CallReference> allReferences = this.findAllReferencesInCurrentFileSortedByDistance(psiFile, beginOffset, endOffset);
        return CollectionsKt.joinToString$default((Iterable)allReferences, (CharSequence)"\n", null, null, (int)0, null, JsPsiUtil::findAllReferencesStr$lambda$7, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List findMethodCallsInCurrentFile$lambda$2(PsiFile $psiFile) {
        void $this$mapNotNullTo$iv$iv;
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)$psiFile), JSCallExpression.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
        List methodCalls = CollectionsKt.toList((Iterable)collection);
        Iterable $this$mapNotNull$iv = methodCalls;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            CallReference callReference;
            PsiElement resolved;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            JSCallExpression callExpr = (JSCallExpression)element$iv$iv;
            boolean bl2 = false;
            JSExpression jSExpression = callExpr.getMethodExpression();
            JSReferenceExpression jSReferenceExpression = jSExpression instanceof JSReferenceExpression ? (JSReferenceExpression)jSExpression : null;
            Object object = resolved = jSReferenceExpression != null ? jSReferenceExpression.resolve() : null;
            if (resolved != null && !Intrinsics.areEqual((Object)resolved.getContainingFile(), (Object)$psiFile)) {
                Document document;
                Intrinsics.checkNotNullExpressionValue((Object)resolved.getContainingFile().getFileDocument(), (String)"getFileDocument(...)");
                int startLine = document.getLineNumber(resolved.getTextRange().getStartOffset());
                int endLine = document.getLineNumber(resolved.getTextRange().getEndOffset());
                String string = callExpr.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String string2 = $psiFile.getVirtualFile().getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                int n = callExpr.getTextOffset();
                String string3 = SignatureUtil.INSTANCE.formatJsFunctionSignature(resolved);
                VirtualFile virtualFile = resolved.getContainingFile().getVirtualFile();
                String string4 = virtualFile != null ? virtualFile.getPath() : null;
                Object object2 = callExpr.getMethodExpression();
                if (object2 == null || (object2 = object2.getText()) == null) {
                    object2 = callExpr.getText();
                }
                Object object3 = object2;
                Intrinsics.checkNotNull((Object)object3);
                callReference = new CallReference(string, string2, n, string3, string4, ReferenceType.METHOD, startLine, endLine, (String)object3);
            } else {
                callReference = null;
            }
            if (callReference == null) continue;
            CallReference it$iv$iv = callReference;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            CallReference it = (CallReference)e$iv;
            boolean bl = false;
            String key$iv = it.getKey();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List findClassReferencesInCurrentFile$lambda$5(PsiFile $psiFile) {
        void $this$mapNotNullTo$iv$iv;
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)$psiFile), JSReferenceExpression.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
        List references = CollectionsKt.toList((Iterable)collection);
        Iterable $this$mapNotNull$iv = references;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            CallReference callReference;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            JSReferenceExpression ref = (JSReferenceExpression)element$iv$iv;
            boolean bl2 = false;
            PsiElement resolved = ref.resolve();
            if (resolved instanceof TypeScriptClass && !Intrinsics.areEqual((Object)((TypeScriptClass)resolved).getContainingFile(), (Object)$psiFile)) {
                Document document;
                Intrinsics.checkNotNullExpressionValue((Object)$psiFile.getFileDocument(), (String)"getFileDocument(...)");
                Document document2 = document;
                int startLine = document2 != null ? document2.getLineNumber(ref.getTextRange().getStartOffset()) : -1;
                Document document3 = document;
                int endLine = document3 != null ? document3.getLineNumber(ref.getTextRange().getEndOffset()) : -1;
                String string = ref.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String string2 = $psiFile.getVirtualFile().getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                int n = ref.getTextOffset();
                String string3 = SignatureUtil.INSTANCE.formatTsClassWithMethods((TypeScriptClass)resolved);
                VirtualFile virtualFile = ((TypeScriptClass)resolved).getContainingFile().getVirtualFile();
                String string4 = virtualFile != null ? virtualFile.getPath() : null;
                String string5 = ref.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
                callReference = new CallReference(string, string2, n, string3, string4, ReferenceType.CLASS, startLine, endLine, string5);
            } else {
                callReference = null;
            }
            if (callReference == null) continue;
            CallReference it$iv$iv = callReference;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            CallReference it = (CallReference)e$iv;
            boolean bl = false;
            String key$iv = it.getKey();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    private static final CharSequence findAllReferencesStr$lambda$7(CallReference it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDefinitionStr();
    }
}

