/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.prompt;

import cn.gitlab.kilo.jetbrains.common.I18nKt;
import com.intellij.openapi.vcs.changes.Change;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u00052\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0005J'\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000e\"\u00020\u0001\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcn/gitlab/kilo/jetbrains/prompt/CommitPrompter;", "", "<init>", "()V", "generateSummaryPrompt", "", "filesChanges", "", "Lcn/gitlab/kilo/jetbrains/prompt/CommitPrompter$FileChange;", "commitMsgLanguage", "previousCommitMessages", "getPromptMsg", "key", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "FileChange", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nCommitPrompter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommitPrompter.kt\ncn/gitlab/kilo/jetbrains/prompt/CommitPrompter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1788#2,4:136\n1788#2,4:140\n1788#2,4:144\n1878#2,3:148\n*S KotlinDebug\n*F\n+ 1 CommitPrompter.kt\ncn/gitlab/kilo/jetbrains/prompt/CommitPrompter\n*L\n32#1:136,4\n33#1:140,4\n34#1:144,4\n46#1:148,3\n*E\n"})
public final class CommitPrompter {
    @NotNull
    public static final CommitPrompter INSTANCE = new CommitPrompter();

    private CommitPrompter() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String generateSummaryPrompt(@NotNull List<FileChange> filesChanges, @NotNull String commitMsgLanguage, @Nullable String previousCommitMessages) {
        int n;
        int n2;
        FileChange it;
        int count$iv;
        int n3;
        Iterable $this$count$iv;
        Intrinsics.checkNotNullParameter(filesChanges, (String)"filesChanges");
        Intrinsics.checkNotNullParameter((Object)commitMsgLanguage, (String)"commitMsgLanguage");
        int MAX_CHANGES_PER_FILE = 50;
        int MAX_FILES_DETAILS = 100;
        StringBuilder promptBuilder = new StringBuilder(previousCommitMessages + "\n\n");
        String commitTypes = "feat|fix|docs|style|refactor|perf|test|build|ci|revert";
        Object[] objectArray = new Object[]{commitTypes, commitMsgLanguage};
        promptBuilder.append(this.getPromptMsg("generate.commit.message", objectArray));
        Object[] objectArray2 = new Pair[3];
        Iterable iterable = filesChanges;
        String string = "modified";
        int n4 = 0;
        Pair[] pairArray = objectArray2;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n3 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (FileChange)element$iv;
                boolean bl = false;
                if (!(it.getType() == Change.Type.MODIFICATION) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n3 = count$iv;
        }
        int n5 = n3;
        pairArray[n4] = TuplesKt.to((Object)string, (Object)n5);
        $this$count$iv = filesChanges;
        string = "added";
        n4 = 1;
        pairArray = objectArray2;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (FileChange)element$iv;
                boolean bl = false;
                if (!(it.getType() == Change.Type.NEW) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        n5 = n2;
        pairArray[n4] = TuplesKt.to((Object)string, (Object)n5);
        $this$count$iv = filesChanges;
        string = "deleted";
        n4 = 2;
        pairArray = objectArray2;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (FileChange)element$iv;
                boolean bl = false;
                if (!(it.getType() == Change.Type.DELETED) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        n5 = n;
        pairArray[n4] = TuplesKt.to((Object)string, (Object)n5);
        Map stats = MapsKt.mapOf((Pair[])objectArray2);
        objectArray2 = new Object[4];
        objectArray2[0] = Integer.valueOf(filesChanges.size());
        Integer n6 = (Integer)stats.get("modified");
        objectArray2[1] = Integer.valueOf(n6 != null ? n6 : 0);
        Integer n7 = (Integer)stats.get("added");
        objectArray2[2] = Integer.valueOf(n7 != null ? n7 : 0);
        Integer n8 = (Integer)stats.get("deleted");
        objectArray2[3] = Integer.valueOf(n8 != null ? n8 : 0);
        promptBuilder.append(this.getPromptMsg("total.files", objectArray2));
        Iterable $this$forEachIndexed$iv = CollectionsKt.take((Iterable)filesChanges, (int)MAX_FILES_DETAILS);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        block9: for (Object item$iv : $this$forEachIndexed$iv) {
            void fileChange;
            int n9;
            if ((n9 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            it = (FileChange)item$iv;
            int index = n9;
            boolean bl = false;
            String filePath = fileChange.getFile();
            Change.Type changeType = fileChange.getType();
            List<String> fileChanges = fileChange.getChanges();
            String ext = StringsKt.substringAfterLast((String)filePath, (char)'.', (String)"");
            switch (WhenMappings.$EnumSwitchMapping$0[changeType.ordinal()]) {
                case 1: {
                    Object[] objectArray3;
                    Object[] objectArray4 = new Object[]{index + 1, ext, filePath};
                    promptBuilder.append(INSTANCE.getPromptMsg("new.file", objectArray4));
                    if (!(!((Collection)fileChanges).isEmpty())) continue block9;
                    Object truncatedChanges = CollectionsKt.take((Iterable)fileChanges, (int)MAX_CHANGES_PER_FILE);
                    if (fileChanges.size() > MAX_CHANGES_PER_FILE) {
                        objectArray3 = new Object[]{MAX_CHANGES_PER_FILE, fileChanges.size()};
                        promptBuilder.append(INSTANCE.getPromptMsg("show.first.lines", objectArray3));
                    }
                    promptBuilder.append("\n   " + CollectionsKt.joinToString$default((Iterable)((Iterable)truncatedChanges), (CharSequence)"\n   ", null, null, (int)0, null, null, (int)62, null));
                    break;
                }
                case 2: {
                    Object truncatedChanges = new Object[]{index + 1, ext, filePath};
                    promptBuilder.append(INSTANCE.getPromptMsg("deleted.file", truncatedChanges));
                    break;
                }
                case 3: {
                    Object truncatedChanges = CollectionsKt.take((Iterable)fileChanges, (int)MAX_CHANGES_PER_FILE);
                    Object[] objectArray3 = new Object[]{index + 1, ext, filePath};
                    promptBuilder.append(INSTANCE.getPromptMsg("modified.file", objectArray3));
                    if (fileChanges.size() > MAX_CHANGES_PER_FILE) {
                        objectArray3 = new Object[]{MAX_CHANGES_PER_FILE, fileChanges.size()};
                        promptBuilder.append(INSTANCE.getPromptMsg("show.first.lines", objectArray3));
                    }
                    promptBuilder.append("\n   " + CollectionsKt.joinToString$default((Iterable)((Iterable)truncatedChanges), (CharSequence)"\n   ", null, null, (int)0, null, null, (int)62, null));
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        if (filesChanges.size() > MAX_FILES_DETAILS) {
            objectArray2 = new Object[]{filesChanges.size() - MAX_FILES_DETAILS};
            promptBuilder.append(this.getPromptMsg("other.files", objectArray2));
        }
        String string2 = promptBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    public static /* synthetic */ String generateSummaryPrompt$default(CommitPrompter commitPrompter, List list, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = I18nKt.getPrompt("commit.example");
        }
        return commitPrompter.generateSummaryPrompt(list, string, string2);
    }

    @NotNull
    public final String getPromptMsg(@NotNull String key, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object[] objectArray = Arrays.copyOf(args, args.length);
        String string = String.format(I18nKt.getCommitPrompt(key), Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        String string2 = string;
        if (string == null) {
            string2 = "";
        }
        return string2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcn/gitlab/kilo/jetbrains/prompt/CommitPrompter$FileChange;", "", "file", "", "type", "Lcom/intellij/openapi/vcs/changes/Change$Type;", "changes", "", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/vcs/changes/Change$Type;Ljava/util/List;)V", "getFile", "()Ljava/lang/String;", "getType", "()Lcom/intellij/openapi/vcs/changes/Change$Type;", "getChanges", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "coderider-kilo-jetbrains"})
    public static final class FileChange {
        @NotNull
        private final String file;
        @NotNull
        private final Change.Type type;
        @NotNull
        private final List<String> changes;

        public FileChange(@NotNull String file, @NotNull Change.Type type2, @NotNull List<String> changes) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            this.file = file;
            this.type = type2;
            this.changes = changes;
        }

        @NotNull
        public final String getFile() {
            return this.file;
        }

        @NotNull
        public final Change.Type getType() {
            return this.type;
        }

        @NotNull
        public final List<String> getChanges() {
            return this.changes;
        }

        @NotNull
        public final String component1() {
            return this.file;
        }

        @NotNull
        public final Change.Type component2() {
            return this.type;
        }

        @NotNull
        public final List<String> component3() {
            return this.changes;
        }

        @NotNull
        public final FileChange copy(@NotNull String file, @NotNull Change.Type type2, @NotNull List<String> changes) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            return new FileChange(file, type2, changes);
        }

        public static /* synthetic */ FileChange copy$default(FileChange fileChange, String string, Change.Type type2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = fileChange.file;
            }
            if ((n & 2) != 0) {
                type2 = fileChange.type;
            }
            if ((n & 4) != 0) {
                list = fileChange.changes;
            }
            return fileChange.copy(string, type2, list);
        }

        @NotNull
        public String toString() {
            return "FileChange(file=" + this.file + ", type=" + this.type + ", changes=" + this.changes + ")";
        }

        public int hashCode() {
            int result = this.file.hashCode();
            result = result * 31 + this.type.hashCode();
            result = result * 31 + ((Object)this.changes).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileChange)) {
                return false;
            }
            FileChange fileChange = (FileChange)other;
            if (!Intrinsics.areEqual((Object)this.file, (Object)fileChange.file)) {
                return false;
            }
            if (this.type != fileChange.type) {
                return false;
            }
            return Intrinsics.areEqual(this.changes, fileChange.changes);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Change.Type.values().length];
            try {
                nArray[Change.Type.NEW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Change.Type.DELETED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Change.Type.MODIFICATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Change.Type.MOVED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

