/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.llmClient;

import cn.gitlab.kilo.jetbrains.client.CoderiderClientKt;
import cn.gitlab.kilo.jetbrains.common.ChatRequest;
import cn.gitlab.kilo.jetbrains.common.ContentLengthExceededException;
import cn.gitlab.kilo.jetbrains.common.CustomException;
import cn.gitlab.kilo.jetbrains.common.ExtraParameters;
import cn.gitlab.kilo.jetbrains.common.GenerateMetrics;
import cn.gitlab.kilo.jetbrains.common.GenerateParameters;
import cn.gitlab.kilo.jetbrains.common.GenerateResult;
import cn.gitlab.kilo.jetbrains.common.LLMParam;
import cn.gitlab.kilo.jetbrains.common.PromptResult;
import cn.gitlab.kilo.jetbrains.common.PrompterOpts;
import cn.gitlab.kilo.jetbrains.common.StreamOptions;
import cn.gitlab.kilo.jetbrains.config.ModelsConfiguration;
import cn.gitlab.kilo.jetbrains.llmClient.ChatClient;
import cn.gitlab.kilo.jetbrains.llmClient.Delta;
import cn.gitlab.kilo.jetbrains.llmClient.OpenAiChoice;
import cn.gitlab.kilo.jetbrains.llmClient.OpenAiClientKt;
import cn.gitlab.kilo.jetbrains.llmClient.OpenAiErrorDetails;
import cn.gitlab.kilo.jetbrains.llmClient.OpenAiResp;
import cn.gitlab.kilo.jetbrains.llmClient.UnexpectedCodeException;
import cn.gitlab.kilo.jetbrains.llmClient.Usage;
import cn.gitlab.kilo.jetbrains.prompt.CodeCompletionPrompter;
import cn.gitlab.kilo.jetbrains.services.GenerationCallbacks;
import cn.gitlab.kilo.jetbrains.services.ResponseCallbacks;
import cn.gitlab.kilo.jetbrains.services.TrackService;
import cn.gitlab.kilo.jetbrains.services.context.ContextSnippet;
import cn.gitlab.kilo.jetbrains.utils.ChatParameters;
import cn.gitlab.kilo.jetbrains.utils.ClientUtilsKt;
import cn.gitlab.kilo.jetbrains.utils.StreamUtilsKt;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.sina.weibo.agent.provider.LoggerAdapter;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http2.StreamResetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001bH\u0016JH\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001e2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#2\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020*H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcn/gitlab/kilo/jetbrains/llmClient/OpenAiClient;", "Lcn/gitlab/kilo/jetbrains/llmClient/ChatClient;", "<init>", "()V", "logger", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "client", "Lokhttp3/OkHttpClient;", "currentGenerateCall", "Lokhttp3/Call;", "streamingChat", "Lkotlin/Function0;", "", "param", "Lcn/gitlab/kilo/jetbrains/utils/ChatParameters;", "cb", "Lcn/gitlab/kilo/jetbrains/services/ResponseCallbacks;", "Lcn/gitlab/kilo/jetbrains/llmClient/OpenAiResp;", "generate", "Lcn/gitlab/kilo/jetbrains/common/GenerateResult;", "Lcn/gitlab/kilo/jetbrains/common/GenerateParameters;", "timeoutMs", "", "processGenerateResponse", "openAiResp", "startTime", "chat", "Lcn/gitlab/kilo/jetbrains/services/GenerationCallbacks;", "codeCompletion", "modelKey", "", "languageId", "prefix", "suffix", "context", "", "Lcn/gitlab/kilo/jetbrains/services/context/ContextSnippet;", "filePath", "shouldDoMultiline", "", "parseError", "error", "Lcn/gitlab/kilo/jetbrains/llmClient/OpenAiErrorDetails;", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nOpenAiClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenAiClient.kt\ncn/gitlab/kilo/jetbrains/llmClient/OpenAiClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,382:1\n1#2:383\n*E\n"})
public final class OpenAiClient
implements ChatClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final cn.gitlab.kilo.jetbrains.common.Logger logger = cn.gitlab.kilo.jetbrains.common.Logger.Companion.getInstance("ChatStream");
    @NotNull
    private final OkHttpClient client = ClientUtilsKt.generateOkHttpClientBuilder().callTimeout(600000L, TimeUnit.MILLISECONDS).connectTimeout(200000L, TimeUnit.MILLISECONDS).readTimeout(200000L, TimeUnit.MILLISECONDS).build();
    @Nullable
    private volatile Call currentGenerateCall;
    private static final long DEFAULT_TIMEOUT_MS = 200000L;
    private static final long DEFAULT_CALL_TIMEOUT_MS = 600000L;
    @NotNull
    private static final MediaType JSON_MEDIA_TYPE = MediaType.Companion.get("application/json; charset=utf-8");

    public OpenAiClient() {
        Logger.getLogger(OkHttpClient.class.getName()).setLevel(Level.FINE);
    }

    @NotNull
    public final Function0<Unit> streamingChat(@NotNull ChatParameters param, @NotNull ResponseCallbacks<OpenAiResp> cb) {
        Object $this$streamingChat_u24lambda_u243;
        Object object;
        Object v8;
        Object object2;
        Object object3;
        Object it;
        String string;
        Gson gson;
        LLMParam llmParam;
        ModelsConfiguration.ModelConfig model;
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter((Object)param, (String)"param");
                Intrinsics.checkNotNullParameter(cb, (String)"cb");
                ModelsConfiguration.ModelConfig modelConfig = ModelsConfiguration.Companion.getInstance().getLoomModels().get(param.getModelId());
                Intrinsics.checkNotNull((Object)modelConfig);
                model = modelConfig;
                llmParam = model.getParams(param.getThinkingEnabled());
                Type mapType2 = new TypeToken<Map<String, Object>>(){}.getType();
                gson = new Gson();
                string = model.getExtra();
                it = string;
                boolean bl = false;
                object3 = !StringsKt.isBlank((CharSequence)((CharSequence)it)) ? string : null;
                if (object3 == null) break block10;
                String it2 = object3;
                boolean bl2 = false;
                Object object4 = gson.fromJson(it2, mapType2);
                Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any?>");
                Map map = TypeIntrinsics.asMutableMap((Object)object4);
                object3 = map;
                if (map != null) break block11;
            }
            object3 = new LinkedHashMap();
        }
        Object req = object3;
        req.put("model", model.getSimpleKey(param.getThinkingEnabled()));
        req.put("messages", param.getMessages());
        req.put("stream", param.getStream());
        Object object5 = req;
        string = "stream_options";
        Object object6 = req.get("stream_options");
        if (object6 == null) {
            object6 = new StreamOptions(null, 1, null);
        }
        it = object6;
        object5.put(string, it);
        object5 = req;
        string = "temperature";
        Object object7 = req.get("temperature");
        if (object7 == null && ((object2 = llmParam) != null && (object2 = ((LLMParam)object2).getTemperature()) != null ? Double.valueOf(Double.parseDouble((String)object2)) : (object7 = null)) == null) {
            object7 = 1.0;
        }
        it = object7;
        object5.put(string, it);
        object5 = req;
        string = "max_tokens";
        Object v = req.get("max_tokens");
        if (v != null) {
            Object v2;
            Object it3 = v2 = v;
            boolean bl = false;
            v8 = model.isCustomModel() ? v2 : null;
        } else {
            v8 = null;
        }
        Object it2 = v8;
        Double d = it2 instanceof Double ? (Double)it2 : null;
        it = d != null ? (int)d.doubleValue() : ((object = llmParam) != null && (object = ((LLMParam)object).getContextWindow()) != null && (object = (String)object.get("output")) != null ? Integer.parseInt((String)object) : 8192);
        object5.put(string, it);
        req.put("enable_thinking", param.getThinkingEnabled());
        String jsonStr = gson.toJson(req);
        Intrinsics.checkNotNull((Object)jsonStr);
        RequestBody requestBody = RequestBody.Companion.create(jsonStr, JSON_MEDIA_TYPE);
        String apiToken = model.isCustomModel() ? model.getApiKey() : CoderiderClientKt.getCoderiderAuthToken();
        Object bl2 = this;
        try {
            $this$streamingChat_u24lambda_u243 = bl2;
            boolean bl = false;
            $this$streamingChat_u24lambda_u243 = Result.constructor-impl((Object)OpenAiClientKt.access$addServerTraceHeader(new Request.Builder().url(model.getChatUrl()).header("Authorization", "Bearer " + apiToken), param).post(requestBody).build());
        }
        catch (Throwable bl) {
            $this$streamingChat_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        bl2 = $this$streamingChat_u24lambda_u243;
        Throwable throwable = Result.exceptionOrNull-impl((Object)bl2);
        if (throwable != null) {
            Throwable it4 = throwable;
            boolean bl = false;
            throw new IllegalArgumentException("Invalid api key or url");
        }
        Request request = (Request)bl2;
        LoggerAdapter.DefaultImpls.debug$default(this.logger, "chatStream onCall at " + System.currentTimeMillis(), null, 2, null);
        Call newCall = this.client.newCall(request);
        newCall.enqueue(new Callback(cb, this, jsonStr){
            final /* synthetic */ ResponseCallbacks<OpenAiResp> $cb;
            final /* synthetic */ OpenAiClient this$0;
            final /* synthetic */ String $jsonStr;
            {
                this.$cb = $cb;
                this.this$0 = $receiver;
                this.$jsonStr = $jsonStr;
            }

            public void onFailure(Call call, IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$cb.onError(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (!response.isSuccessful()) {
                    this.$cb.onError(new Exception("OpenAiClient: failed to request server"));
                    return;
                }
                ResponseBody responseBody = response.body();
                if (responseBody != null) {
                    Closeable closeable = (Closeable)responseBody;
                    ResponseCallbacks<OpenAiResp> responseCallbacks = this.$cb;
                    OpenAiClient openAiClient = this.this$0;
                    String string = this.$jsonStr;
                    Throwable throwable = null;
                    try {
                        ResponseBody responseBody2 = (ResponseBody)closeable;
                        boolean bl = false;
                        InputStream inputStream = responseBody2.byteStream();
                        boolean $i$f$processDataFlow = false;
                        Gson gson$iv = new Gson();
                        try {
                            TextStreamsKt.forEachLine((Reader)new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)), (Function1)((Function1)new Function1<String, Unit>(gson$iv, responseCallbacks){
                                final /* synthetic */ Gson $gson;
                                final /* synthetic */ ResponseCallbacks $callbacks;
                                {
                                    this.$gson = $gson;
                                    this.$callbacks = $callbacks;
                                }

                                public final void invoke(String line) {
                                    block5: {
                                        Object object;
                                        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                                        String data = StringsKt.removePrefix((String)line, (CharSequence)"data:");
                                        LoggerAdapter.DefaultImpls.debug$default(StreamUtilsKt.getLogger(), "Chat Response line: " + data, null, 2, null);
                                        Object object2 = this.$gson;
                                        ResponseCallbacks responseCallbacks = this.$callbacks;
                                        try {
                                            Unit unit;
                                            boolean bl = false;
                                            Object object3 = object2.fromJson(data, OpenAiResp.class);
                                            if (object3 != null) {
                                                Object p0 = object3;
                                                boolean bl2 = false;
                                                responseCallbacks.onChange(p0);
                                                unit = Unit.INSTANCE;
                                            } else {
                                                unit = null;
                                            }
                                            object = Result.constructor-impl(unit);
                                        }
                                        catch (Throwable p0) {
                                            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)p0));
                                        }
                                        object2 = object;
                                        responseCallbacks = this.$callbacks;
                                        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                                        if (throwable == null) break block5;
                                        Throwable e = throwable;
                                        boolean bl = false;
                                        LoggerAdapter.DefaultImpls.info$default(StreamUtilsKt.getLogger(), "Chat Response line: " + data, null, 2, null);
                                        if (e instanceof CustomException) {
                                            responseCallbacks.onError(e);
                                        }
                                    }
                                }
                            }));
                        }
                        catch (SocketException e$iv) {
                            StreamUtilsKt.getLogger().warn(e$iv);
                            responseCallbacks.onComplete();
                        }
                        catch (StreamResetException e$iv) {
                            responseCallbacks.onError(e$iv);
                        }
                        catch (Throwable e$iv) {
                            responseCallbacks.onError(e$iv);
                        }
                        responseCallbacks.onComplete();
                        LoggerAdapter.DefaultImpls.debug$default(OpenAiClient.access$getLogger$p(openAiClient), "Chat Request:" + string + ",Response:" + responseBody2, null, 2, null);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }
        });
        return () -> OpenAiClient.streamingChat$lambda$5(newCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public GenerateResult generate(@NotNull GenerateParameters param, long timeoutMs) {
        Object object;
        Call call;
        String string;
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        Call call2 = this.currentGenerateCall;
        boolean bl = call2 != null ? !call2.isCanceled() : false;
        if (bl) {
            Call call3 = this.currentGenerateCall;
            if (call3 != null) {
                call3.cancel();
            }
        }
        String string2 = StringsKt.substringAfter$default((String)param.getModel(), (String)"/", null, (int)2, null);
        String string3 = param.getPrompt();
        ExtraParameters extraParameters = param.getExtra();
        Integer n = param.getOutputMaxToken();
        List<String> list = param.getStop();
        Double d = param.getTemperature();
        ChatRequest req = new ChatRequest(string2, null, string3, null, false, d, null, extraParameters, null, n, list, null, null, 6218, null);
        ModelsConfiguration.ModelConfig modelConfig = ModelsConfiguration.Companion.getInstance().getCodeModels().get(param.getModel());
        Intrinsics.checkNotNull((Object)modelConfig);
        ModelsConfiguration.ModelConfig model = modelConfig;
        long startTime = System.currentTimeMillis();
        String jsonStr = new Gson().toJson((Object)req);
        Intrinsics.checkNotNull((Object)jsonStr);
        RequestBody requestBody = RequestBody.Companion.create(jsonStr, JSON_MEDIA_TYPE);
        String it = string = model.getApiKey();
        boolean bl2 = false;
        String string4 = ((CharSequence)it).length() > 0 ? string : null;
        if (string4 == null) {
            string4 = CoderiderClientKt.getCoderiderAuthToken();
        }
        String apiToken = string4;
        String $this$generate_u24lambda_u247 = string = new Request.Builder();
        boolean bl32 = false;
        $this$generate_u24lambda_u247.url(model.getCompletionUrl());
        $this$generate_u24lambda_u247.header("Authorization", "Bearer " + apiToken);
        $this$generate_u24lambda_u247.post(requestBody);
        Request request = string.build();
        this.currentGenerateCall = call = this.client.newCall(request);
        try {
            GenerateResult generateResult;
            object = (Closeable)call.execute();
            Throwable bl32 = null;
            try {
                Response response = (Response)object;
                boolean bl4 = false;
                if (!response.isSuccessful()) {
                    throw new CustomException("Request failed with status: " + response.code());
                }
                ResponseBody responseBody = response.body();
                String responseBody2 = responseBody != null ? responseBody.string() : null;
                OpenAiResp openAiResp = (OpenAiResp)new Gson().fromJson(responseBody2, OpenAiResp.class);
                LoggerAdapter.DefaultImpls.debug$default(this.logger, "Code Completion Request:" + jsonStr + ",Response:" + responseBody2, null, 2, null);
                generateResult = this.processGenerateResponse(openAiResp, startTime);
            }
            catch (Throwable throwable) {
                bl32 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)bl32);
            }
            object = generateResult;
        }
        catch (Exception e) {
            this.logger.debug("Error in generate function", e);
            object = new GenerateResult("", null);
        }
        return object;
    }

    private final GenerateResult processGenerateResponse(OpenAiResp openAiResp, long startTime) {
        String string;
        long endTime = System.currentTimeMillis();
        long totalDuration = endTime - startTime;
        Object object = openAiResp;
        if ((object != null && (object = ((OpenAiResp)object).getChoices()) != null && (object = (OpenAiChoice)CollectionsKt.firstOrNull((List)object)) != null ? ((OpenAiChoice)object).getText() : (string = null)) == null) {
            string = "";
        }
        String choiceText = string;
        OpenAiResp openAiResp2 = openAiResp;
        Usage usage = openAiResp2 != null ? openAiResp2.getUsage() : null;
        Usage usage2 = usage;
        Usage usage3 = usage;
        return new GenerateResult(choiceText, new GenerateMetrics(totalDuration, null, null, null, usage2 != null ? Integer.valueOf(usage2.getPromptTokens()) : null, usage3 != null ? Integer.valueOf(usage3.getCompletionTokens()) : null, 14, null));
    }

    @Override
    @NotNull
    public Function0<Unit> chat(@NotNull ChatParameters param, @NotNull GenerationCallbacks cb) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        Intrinsics.checkNotNullParameter((Object)cb, (String)"cb");
        try {
            param.validate();
            ModelsConfiguration.ModelConfig modelConfig = ModelsConfiguration.Companion.getInstance().getLoomModels().get(param.getModelId());
            Intrinsics.checkNotNull((Object)modelConfig);
            ModelsConfiguration.ModelConfig model = modelConfig;
            long time = System.currentTimeMillis();
            LoggerAdapter.DefaultImpls.debug$default(this.logger, "chatStream onStart at " + System.currentTimeMillis() + ",duration:" + (System.currentTimeMillis() - time), null, 2, null);
            LoggerAdapter.DefaultImpls.debug$default(this.logger, "message cnts:" + param.getMessages().size(), null, 2, null);
            Ref.ObjectRef accumulated = new Ref.ObjectRef();
            accumulated.element = "";
            Ref.ObjectRef reasonAccumulated = new Ref.ObjectRef();
            reasonAccumulated.element = "";
            ResponseCallbacks callbacks2 = new ResponseCallbacks<OpenAiResp>(this, time, cb, (Ref.ObjectRef<String>)accumulated, (Ref.ObjectRef<String>)reasonAccumulated, param, model){
                private Usage usage;
                final /* synthetic */ OpenAiClient this$0;
                final /* synthetic */ long $time;
                final /* synthetic */ GenerationCallbacks $cb;
                final /* synthetic */ Ref.ObjectRef<String> $accumulated;
                final /* synthetic */ Ref.ObjectRef<String> $reasonAccumulated;
                final /* synthetic */ ChatParameters $param;
                final /* synthetic */ ModelsConfiguration.ModelConfig $model;
                {
                    this.this$0 = $receiver;
                    this.$time = $time;
                    this.$cb = $cb;
                    this.$accumulated = $accumulated;
                    this.$reasonAccumulated = $reasonAccumulated;
                    this.$param = $param;
                    this.$model = $model;
                }

                public final Usage getUsage() {
                    return this.usage;
                }

                public final void setUsage(Usage usage) {
                    this.usage = usage;
                }

                public void onChange(OpenAiResp resp) {
                    Collection collection;
                    Intrinsics.checkNotNullParameter((Object)resp, (String)"resp");
                    LoggerAdapter.DefaultImpls.debug$default(OpenAiClient.access$getLogger$p(this.this$0), "chatStream onChange at " + System.currentTimeMillis() + ",duration:" + (System.currentTimeMillis() - this.$time), null, 2, null);
                    if (resp.getError() != null) {
                        OpenAiClient.access$parseError(this.this$0, resp.getError());
                    }
                    if (!((collection = (Collection)resp.getChoices()) == null || collection.isEmpty())) {
                        OpenAiChoice openAiChoice = resp.getChoices().get(0);
                        if (Intrinsics.areEqual((Object)openAiChoice.getFinishReason(), (Object)"sensitive")) {
                            this.$cb.onSensitive();
                        } else {
                            Object object = this.$accumulated.element;
                            Object object2 = openAiChoice.getDelta();
                            if (object2 == null || (object2 = ((Delta)object2).getContent()) == null) {
                                object2 = "";
                            }
                            this.$accumulated.element = object + (String)object2;
                            Object object3 = this.$reasonAccumulated.element;
                            Object object4 = openAiChoice.getDelta();
                            if (object4 == null || (object4 = ((Delta)object4).getReasoningContent()) == null) {
                                object4 = "";
                            }
                            this.$reasonAccumulated.element = object3 + (String)object4;
                            Delta delta = openAiChoice.getDelta();
                            this.$cb.onChange((String)this.$accumulated.element, (delta != null ? delta.getReasoningContent() : null) != null ? (String)this.$reasonAccumulated.element : null);
                        }
                    }
                    if (resp.getUsage() != null) {
                        this.usage = resp.getUsage();
                    }
                }

                public void onComplete() {
                    LoggerAdapter.DefaultImpls.debug$default(OpenAiClient.access$getLogger$p(this.this$0), "chatStream onComplete at " + System.currentTimeMillis() + ",duration:" + (System.currentTimeMillis() - this.$time), null, 2, null);
                    try {
                        Usage usage = this.usage;
                        if (usage != null) {
                            Usage usage2 = usage;
                            GenerationCallbacks generationCallbacks = this.$cb;
                            ModelsConfiguration.ModelConfig modelConfig = this.$model;
                            Usage it = usage2;
                            boolean bl = false;
                            generationCallbacks.metric(Long.valueOf(it.getPromptTokens()), Long.valueOf(it.getCompletionTokens()));
                            TrackService.INSTANCE.tokenUsage(it.getPromptTokens(), it.getCompletionTokens(), 0L, 0L, 0L, 0L, System.currentTimeMillis(), modelConfig.getKey());
                        }
                    }
                    catch (Throwable e) {
                        LoggerAdapter.DefaultImpls.error$default(OpenAiClient.access$getLogger$p(this.this$0), e.getMessage(), null, 2, null);
                    }
                    if (!this.$param.getThinkingEnabled()) {
                        GenerationCallbacks.DefaultImpls.onComplete$default(this.$cb, StringsKt.substringAfter$default((String)((String)this.$accumulated.element), (String)"</think>", null, (int)2, null), null, 2, null);
                    } else {
                        GenerationCallbacks.DefaultImpls.onComplete$default(this.$cb, (String)this.$accumulated.element, null, 2, null);
                    }
                }

                public void onError(Throwable error2) {
                    Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
                    OpenAiClient.access$getLogger$p(this.this$0).debug("chatStream onError at " + System.currentTimeMillis() + ",duration:" + (System.currentTimeMillis() - this.$time), error2);
                    this.$cb.onError((String)this.$accumulated.element, error2);
                }
            };
            return this.streamingChat(param, callbacks2);
        }
        catch (Throwable e) {
            cb.onError(null, e);
            return OpenAiClient::chat$lambda$9;
        }
    }

    @Override
    @NotNull
    public GenerateResult codeCompletion(@NotNull String modelKey, @NotNull String languageId, @NotNull String prefix, @NotNull String suffix, @Nullable List<ContextSnippet> context, @NotNull String filePath, boolean shouldDoMultiline) {
        Intrinsics.checkNotNullParameter((Object)modelKey, (String)"modelKey");
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        PromptResult prompt = CodeCompletionPrompter.INSTANCE.prompt(new PrompterOpts(modelKey, shouldDoMultiline, filePath, prefix, suffix, 0, context, languageId, null, 288, null));
        String string = prompt.getText();
        int n = prompt.getMaxTokensToSample();
        List<String> list = prompt.getStopWords();
        String string2 = prompt.getIntroString();
        Object object = string2 != null ? string2 + "\n\n" : null;
        if (object == null) {
            object = "";
        }
        ExtraParameters extraParameters = new ExtraParameters(languageId, (String)object + prompt.getPrefix(), prompt.getSuffix());
        Integer n2 = prompt.getOutputMaxToken();
        Double d = prompt.getTemperature();
        return this.generate(new GenerateParameters(modelKey, string, n, d, list, null, null, extraParameters, n2, 96, null), prompt.getTimeoutMs());
    }

    private final void parseError(OpenAiErrorDetails error2) {
        throw OpenAiClientKt.checkIsOpenAIContextWindowError(error2) || OpenAiClientKt.checkIsInternalContextWindowError(error2) ? (Throwable)new ContentLengthExceededException(error2.getMessage()) : (Throwable)new UnexpectedCodeException(error2, 0, 2, null);
    }

    private static final Unit streamingChat$lambda$5(Call $newCall) {
        $newCall.cancel();
        return Unit.INSTANCE;
    }

    private static final Unit chat$lambda$9() {
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ cn.gitlab.kilo.jetbrains.common.Logger access$getLogger$p(OpenAiClient $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$parseError(OpenAiClient $this, OpenAiErrorDetails error2) {
        $this.parseError(error2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcn/gitlab/kilo/jetbrains/llmClient/OpenAiClient$Companion;", "", "<init>", "()V", "DEFAULT_TIMEOUT_MS", "", "DEFAULT_CALL_TIMEOUT_MS", "JSON_MEDIA_TYPE", "Lokhttp3/MediaType;", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

