/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.editor.settings;

import cn.gitlab.kilo.jetbrains.client.CoderiderClientKt;
import cn.gitlab.kilo.jetbrains.common.I18nKt;
import cn.gitlab.kilo.jetbrains.composer.prompts.RulesServiceKt;
import cn.gitlab.kilo.jetbrains.editor.settings.RulesManagerKt;
import cn.gitlab.kilo.jetbrains.utils.ThemeUtilKt;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.jcef.JBCefBrowser;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0010J \u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00102\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u001fH\u0002J\"\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0010\b\u0002\u0010#\u001a\n\u0018\u00010$j\u0004\u0018\u0001`%H\u0002J)\u0010&\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010(\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010)J\u0018\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020-H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006."}, d2={"Lcn/gitlab/kilo/jetbrains/editor/settings/RulesManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "browser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ui/jcef/JBCefBrowser;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getBrowser", "()Lcom/intellij/ui/jcef/JBCefBrowser;", "props", "Lcom/intellij/ide/util/PropertiesComponent;", "kotlin.jvm.PlatformType", "rulesRoot", "Ljava/nio/file/Path;", "getRulesRoot", "()Ljava/nio/file/Path;", "sendRulesFiles", "", "addRule", "cfg", "Lcom/google/gson/JsonObject;", "editRule", "deleteRule", "downloadRuleTemplate", "tryOpenFile", "file", "openFileInEditor", "onNotFound", "Lkotlin/Function0;", "showErrorBalloon", "messageKey", "", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "showInfoBalloon", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "getRuleFilePath", "ruleName", "ruleType", "", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nRulesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RulesManager.kt\ncn/gitlab/kilo/jetbrains/editor/settings/RulesManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n1#2:207\n*E\n"})
public final class RulesManager {
    @NotNull
    private final Project project;
    @NotNull
    private final JBCefBrowser browser;
    private final PropertiesComponent props;

    public RulesManager(@NotNull Project project, @NotNull JBCefBrowser browser) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        this.project = project;
        this.browser = browser;
        this.props = PropertiesComponent.getInstance();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final JBCefBrowser getBrowser() {
        return this.browser;
    }

    @NotNull
    public final Path getRulesRoot() {
        String string = this.project.getBasePath();
        if (string == null) {
            throw new IllegalStateException("No project".toString());
        }
        String base = string;
        String[] stringArray = new String[]{".coderider", "rules"};
        Path root = Path.of(base, stringArray);
        Intrinsics.checkNotNull((Object)root);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(root, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(root, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendRulesFiles() {
        List nonManualList = new ArrayList();
        List manualList = new ArrayList();
        try {
            JsonObject jsonObject2;
            Comparator<String> comparator = Files.list(this.getRulesRoot());
            Throwable throwable = null;
            try {
                Stream paths = (Stream)((Object)comparator);
                boolean bl = false;
                paths.filter(arg_0 -> RulesManager.sendRulesFiles$lambda$5$lambda$1(RulesManager::sendRulesFiles$lambda$5$lambda$0, arg_0)).forEach(arg_0 -> RulesManager.sendRulesFiles$lambda$5$lambda$4(arg_0 -> RulesManager.sendRulesFiles$lambda$5$lambda$3(manualList, nonManualList, arg_0), arg_0));
                paths = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)((Object)comparator), (Throwable)throwable);
            }
            comparator = RulesServiceKt.getNaturalCmp();
            CollectionsKt.sortWith((List)nonManualList, (Comparator)new Comparator(comparator){
                final /* synthetic */ Comparator $comparator;
                {
                    this.$comparator = $comparator;
                }

                public final int compare(T a, T b) {
                    JsonObject it;
                    JsonObject jsonObject2 = (JsonObject)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    String string = it.get("rule_name").getAsString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
                    String string2 = string.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    it = (JsonObject)b;
                    String string3 = string2;
                    bl = false;
                    String string4 = it.get("rule_name").getAsString();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAsString(...)");
                    String string5 = string4.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                    String string6 = string5;
                    return comparator.compare(string3, string6);
                }
            });
            comparator = RulesServiceKt.getNaturalCmp();
            CollectionsKt.sortWith((List)manualList, (Comparator)new Comparator(comparator){
                final /* synthetic */ Comparator $comparator;
                {
                    this.$comparator = $comparator;
                }

                public final int compare(T a, T b) {
                    JsonObject it;
                    JsonObject jsonObject2 = (JsonObject)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    String string = it.get("rule_name").getAsString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
                    String string2 = string.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    it = (JsonObject)b;
                    String string3 = string2;
                    bl = false;
                    String string4 = it.get("rule_name").getAsString();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAsString(...)");
                    String string5 = string4.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                    String string6 = string5;
                    return comparator.compare(string3, string6);
                }
            });
            List truncatedNonManual = CollectionsKt.take((Iterable)nonManualList, (int)5);
            List finalList = CollectionsKt.plus((Collection)truncatedNonManual, (Iterable)manualList);
            String userRule = CoderiderClientKt.getCoderiderClient().getRulePersonal();
            this.props.setValue("UserRule", userRule, "");
            JsonObject $this$sendRulesFiles_u24lambda_u248 = jsonObject2 = new JsonObject();
            boolean bl = false;
            $this$sendRulesFiles_u24lambda_u248.addProperty("type", "rulesFiles");
            $this$sendRulesFiles_u24lambda_u248.add("file", JsonParser.parseString((String)new Gson().toJson((Object)finalList)));
            $this$sendRulesFiles_u24lambda_u248.addProperty("userRule", userRule);
            ThemeUtilKt.sendToWebview(jsonObject2, this.browser);
        }
        catch (Throwable e) {
            Intrinsics.checkNotNull((Object)e, (String)"null cannot be cast to non-null type java.lang.Exception");
            this.showErrorBalloon("rules.open.file.failed", (Exception)e);
            e.printStackTrace();
        }
    }

    public final void addRule(@NotNull JsonObject cfg) {
        Intrinsics.checkNotNullParameter((Object)cfg, (String)"cfg");
        String ruleName = cfg.get("ruleName").getAsString();
        int ruleActiveType = cfg.get("ruleActiveType").getAsInt();
        Object object = cfg.get("ruleContent");
        if (object == null || (object = object.getAsString()) == null) {
            object = "";
        }
        Object ruleContent = object;
        Intrinsics.checkNotNull((Object)ruleName);
        Path file = this.getRuleFilePath(ruleName, ruleActiveType);
        CharSequence charSequence = (CharSequence)ruleContent;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        PathsKt.writeText((Path)file, (CharSequence)charSequence, (Charset)charset, (OpenOption[])new OpenOption[0]);
    }

    public final void editRule(@NotNull JsonObject cfg) {
        Intrinsics.checkNotNullParameter((Object)cfg, (String)"cfg");
        String oldName = cfg.get("ruleName").getAsString();
        int oldType = cfg.get("ruleActiveType").getAsInt();
        String newName = cfg.get("newRuleName").getAsString();
        int newType = cfg.get("newRuleActiveType").getAsInt();
        JsonElement jsonElement = cfg.get("ruleContent");
        String content = jsonElement != null ? jsonElement.getAsString() : null;
        Intrinsics.checkNotNull((Object)oldName);
        Path oldFile = this.getRuleFilePath(oldName, oldType);
        Intrinsics.checkNotNull((Object)newName);
        Path newFile = this.getRuleFilePath(newName, newType);
        try {
            String string = content;
            if (string == null) {
                string = PathsKt.readText$default((Path)oldFile, null, (int)1, null);
            }
            String data = string;
            CharSequence charSequence = data;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            PathsKt.writeText((Path)newFile, (CharSequence)charSequence, (Charset)charset, (OpenOption[])new OpenOption[0]);
            if (!Intrinsics.areEqual((Object)oldFile, (Object)newFile)) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.exists(oldFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    try {
                        Files.deleteIfExists(oldFile);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            Object[] objectArray = new Object[]{newName};
            this.showInfoBalloon("rules.edit.success", objectArray);
            JsonElement jsonElement2 = cfg.get("isOpenFile");
            boolean bl = jsonElement2 != null ? jsonElement2.getAsBoolean() : false;
            if (bl) {
                RulesManager.openFileInEditor$default(this, newFile, null, 2, null);
            }
        }
        catch (Exception e) {
            this.showErrorBalloon("rules.edit.failed", e);
        }
    }

    public final void deleteRule(@NotNull JsonObject cfg) {
        Intrinsics.checkNotNullParameter((Object)cfg, (String)"cfg");
        String ruleName = cfg.get("ruleName").getAsString();
        int ruleActiveType = cfg.get("ruleActiveType").getAsInt();
        Intrinsics.checkNotNull((Object)ruleName);
        Path file = this.getRuleFilePath(ruleName, ruleActiveType);
        if (!Files.deleteIfExists(file)) {
            Path path = this.getRulesRoot().resolve(ruleName + ".md");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Files.deleteIfExists(path);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void downloadRuleTemplate(@NotNull JsonObject cfg) {
        Intrinsics.checkNotNullParameter((Object)cfg, (String)"cfg");
        try {
            Path path;
            Object ruleActiveType;
            Object object;
            Object path2;
            Object object2;
            Object template;
            Object object3;
            Object ruleName;
            Object object4 = cfg.get("ruleName");
            if (object4 == null || (object4 = object4.getAsString()) == null) {
                object4 = ruleName = "rule";
            }
            if ((object3 = cfg.get("ruleContent")) == null || (object3 = object3.getAsString()) == null) {
                object3 = template = "{}";
            }
            if ((object2 = cfg.get("rulePath")) == null || (object2 = object2.getAsString()) == null) {
                object2 = path2 = "";
            }
            if ((object = cfg.get("ruleActiveType")) == null || (object = object.getAsString()) == null) {
                object = ruleActiveType = "";
            }
            if (StringsKt.isBlank((CharSequence)((CharSequence)path2))) {
                path = this.getRulesRoot();
            } else {
                Path path3 = this.getRulesRoot().resolve((String)path2);
                path = path3;
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            }
            Path dir = path;
            try {
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(dir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
            }
            catch (Exception e) {
                this.showErrorBalloon("rules.download.create.dir.failed", e);
                return;
            }
            try {
                String fileName = (String)ruleName + ".md";
                Path path4 = dir.resolve(fileName);
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
                Path file = path4;
                try {
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        void $this$downloadRuleTemplate_u24lambda_u2410_u24lambda_u249;
                        JsonObject jsonObject2;
                        JsonObject jsonObject3;
                        JsonObject $this$downloadRuleTemplate_u24lambda_u2410 = jsonObject3 = new JsonObject();
                        boolean bl = false;
                        $this$downloadRuleTemplate_u24lambda_u2410.addProperty("type", "ruleFileConflict");
                        JsonObject jsonObject4 = jsonObject2 = new JsonObject();
                        String string = "config";
                        JsonObject jsonObject5 = $this$downloadRuleTemplate_u24lambda_u2410;
                        boolean bl2 = false;
                        $this$downloadRuleTemplate_u24lambda_u2410_u24lambda_u249.addProperty("ruleName", (String)ruleName);
                        $this$downloadRuleTemplate_u24lambda_u2410_u24lambda_u249.addProperty("ruleContent", (String)template);
                        $this$downloadRuleTemplate_u24lambda_u2410_u24lambda_u249.addProperty("rulePath", (String)path2);
                        $this$downloadRuleTemplate_u24lambda_u2410_u24lambda_u249.addProperty("existingFileName", fileName);
                        $this$downloadRuleTemplate_u24lambda_u2410_u24lambda_u249.addProperty("ruleActiveType", (String)ruleActiveType);
                        Unit unit = Unit.INSTANCE;
                        jsonObject5.add(string, (JsonElement)jsonObject2);
                        ThemeUtilKt.sendToWebview(jsonObject3, this.browser);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                CharSequence charSequence = (CharSequence)template;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                PathsKt.writeText((Path)file, (CharSequence)charSequence, (Charset)charset, (OpenOption[])new OpenOption[0]);
                Object[] objectArray = new Object[]{PathsKt.getName((Path)file)};
                this.showInfoBalloon("rules.download.success", objectArray);
                ApplicationManager.getApplication().invokeLater(() -> RulesManager.downloadRuleTemplate$lambda$11(this));
                this.tryOpenFile(file);
            }
            catch (Exception e) {
                this.showErrorBalloon("rules.download.save.file.failed", e);
            }
        }
        catch (Exception e) {
            this.showErrorBalloon("rules.download.process.failed", e);
        }
    }

    public final void tryOpenFile(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.openFileInEditor(file, (Function0<Unit>)((Function0)() -> RulesManager.tryOpenFile$lambda$12(this)));
    }

    private final void openFileInEditor(Path file, Function0<Unit> onNotFound) {
        ApplicationManager.getApplication().invokeLater(() -> RulesManager.openFileInEditor$lambda$17(file, onNotFound, this));
    }

    static /* synthetic */ void openFileInEditor$default(RulesManager rulesManager, Path path, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = RulesManager::openFileInEditor$lambda$13;
        }
        rulesManager.openFileInEditor(path, (Function0<Unit>)function0);
    }

    private final void showErrorBalloon(String messageKey, Exception error2) {
        String string;
        if (error2 != null) {
            String string2 = I18nKt.getMessage(messageKey);
            Object[] objectArray = new Object[1];
            String string3 = error2.getMessage();
            if (string3 == null) {
                string3 = "Unknown error";
            }
            objectArray[0] = string3;
            String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        } else {
            string = I18nKt.getMessage(messageKey);
        }
        String message = string;
        ThemeUtilKt.showErrorBalloon(this.browser, message);
    }

    static /* synthetic */ void showErrorBalloon$default(RulesManager rulesManager, String string, Exception exception, int n, Object object) {
        if ((n & 2) != 0) {
            exception = null;
        }
        rulesManager.showErrorBalloon(string, exception);
    }

    private final void showInfoBalloon(String messageKey, Object ... args) {
        Object[] objectArray = Arrays.copyOf(args, args.length);
        String string = String.format(I18nKt.getMessage(messageKey), Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        ThemeUtilKt.showInfoBalloon(this.browser, string);
    }

    private final Path getRuleFilePath(String ruleName, int ruleType) {
        Path path = this.getRulesRoot().resolve(ruleName + "_" + RulesServiceKt.getRULE_TYPE_TO_FILE().get(ruleType) + ".md");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private static final boolean sendRulesFiles$lambda$5$lambda$0(Path it) {
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final boolean sendRulesFiles$lambda$5$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit sendRulesFiles$lambda$5$lambda$3(List $manualList, List $nonManualList, Path p) {
        JsonObject jsonObject2;
        Intrinsics.checkNotNull((Object)p);
        String nameWithoutExt = StringsKt.removeSuffix((String)PathsKt.getName((Path)p), (CharSequence)".md");
        String ruleName = StringsKt.substringBeforeLast$default((String)nameWithoutExt, (String)"_", null, (int)2, null);
        String typeKey = StringsKt.substringAfterLast$default((String)nameWithoutExt, (String)"_", null, (int)2, null);
        Integer n = (Integer)RulesManagerKt.access$getFILE_TO_RULE_TYPE$p().get(typeKey);
        if (n == null) {
            return Unit.INSTANCE;
        }
        int typeId = n;
        String content = PathsKt.readText$default((Path)p, null, (int)1, null);
        JsonObject $this$sendRulesFiles_u24lambda_u245_u24lambda_u243_u24lambda_u242 = jsonObject2 = new JsonObject();
        boolean bl = false;
        $this$sendRulesFiles_u24lambda_u245_u24lambda_u243_u24lambda_u242.addProperty("name", nameWithoutExt);
        $this$sendRulesFiles_u24lambda_u245_u24lambda_u243_u24lambda_u242.addProperty("rule_content", content);
        $this$sendRulesFiles_u24lambda_u245_u24lambda_u243_u24lambda_u242.addProperty("rule_name", ruleName);
        $this$sendRulesFiles_u24lambda_u245_u24lambda_u243_u24lambda_u242.addProperty("rule_active_type", (Number)typeId);
        JsonObject json = jsonObject2;
        if (typeId == 4) {
            ((Collection)$manualList).add(json);
        } else {
            ((Collection)$nonManualList).add(json);
        }
        return Unit.INSTANCE;
    }

    private static final void sendRulesFiles$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void downloadRuleTemplate$lambda$11(RulesManager this$0) {
        this$0.sendRulesFiles();
    }

    private static final Unit tryOpenFile$lambda$12(RulesManager this$0) {
        RulesManager.showErrorBalloon$default(this$0, "rules.open.file.failed", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit openFileInEditor$lambda$13() {
        return Unit.INSTANCE;
    }

    private static final void openFileInEditor$lambda$17$lambda$16(Path $file, Function0 $onNotFound, RulesManager this$0) {
        try {
            File it = $file.toFile();
            boolean bl = false;
            VirtualFile virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByNioPath(it.toPath());
            if (virtualFile != null) {
                VirtualFile it2 = virtualFile;
                boolean bl2 = false;
                new OpenFileDescriptor(this$0.project, it2).navigate(true);
            } else {
                $onNotFound.invoke();
            }
        }
        catch (Exception e) {
            this$0.showErrorBalloon("rules.open.file.failed", e);
        }
    }

    private static final void openFileInEditor$lambda$17(Path $file, Function0 $onNotFound, RulesManager this$0) {
        ApplicationManager.getApplication().runWriteAction(() -> RulesManager.openFileInEditor$lambda$17$lambda$16($file, $onNotFound, this$0));
    }
}

