/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.editor.settings;

import cn.gitlab.kilo.jetbrains.common.I18nKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.Arrays;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcn/gitlab/kilo/jetbrains/editor/settings/RuleFilePreCloseCheck;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener$Before;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "beforeFileClosed", "", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isRuleFile", "", "coderider-kilo-jetbrains"})
public final class RuleFilePreCloseCheck
implements FileEditorManagerListener.Before {
    @NotNull
    private final Project project;

    public RuleFilePreCloseCheck(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public void beforeFileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this.isRuleFile(file)) {
            return;
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager fdm = fileDocumentManager;
        Document document = fdm.getDocument(file);
        if (document == null) {
            return;
        }
        Document document2 = document;
        if (fdm.isFileModified(file)) {
            String string = I18nKt.getMessage("rules.file.unsaved.message");
            Object[] objectArray = new Object[]{file.getName()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            int result = Messages.showYesNoDialog((Project)this.project, (String)string2, (String)I18nKt.getMessage("rules.file.unsaved.title"), (String)I18nKt.getMessage("rules.file.save"), (String)I18nKt.getMessage("rules.file.discard"), (Icon)Messages.getWarningIcon());
            switch (result) {
                case 0: {
                    fdm.saveDocument(document2);
                    break;
                }
                case 1: {
                    fdm.reloadFromDisk(document2);
                }
            }
        }
    }

    private final boolean isRuleFile(VirtualFile file) {
        String string = this.project.getBasePath();
        if (string == null) {
            string = "";
        }
        String base = string;
        String[] stringArray = new String[]{".coderider", "rules"};
        String rulesRoot = StringsKt.replace$default((String)((Object)Path.of(base, stringArray)).toString(), (String)"\\", (String)"/", (boolean)false, (int)4, null);
        String string2 = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        return StringsKt.startsWith$default((String)string2, (String)rulesRoot, (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)file.getExtension(), (Object)"md");
    }
}

