/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.editor;

import cn.gitlab.kilo.jetbrains.chat.ChatHandler;
import cn.gitlab.kilo.jetbrains.common.ExtensionMessage;
import cn.gitlab.kilo.jetbrains.common.GetDiscussionsOptions;
import cn.gitlab.kilo.jetbrains.common.I18nKt;
import cn.gitlab.kilo.jetbrains.common.IssuableFetch;
import cn.gitlab.kilo.jetbrains.common.Message;
import cn.gitlab.kilo.jetbrains.common.ModelConfigReq;
import cn.gitlab.kilo.jetbrains.common.Role;
import cn.gitlab.kilo.jetbrains.config.ModelsConfiguration;
import cn.gitlab.kilo.jetbrains.constants.ConstantsKt;
import cn.gitlab.kilo.jetbrains.editor.CodeDiffMessage;
import cn.gitlab.kilo.jetbrains.editor.GitlabBrowserEditorKt;
import cn.gitlab.kilo.jetbrains.editor.MyVirtualFile;
import cn.gitlab.kilo.jetbrains.editor.SystemCommandOpt;
import cn.gitlab.kilo.jetbrains.factories.CustomLifeSpanHandler;
import cn.gitlab.kilo.jetbrains.factories.CustomerRequestHandler;
import cn.gitlab.kilo.jetbrains.factories.SchemeHandlerRegistrar;
import cn.gitlab.kilo.jetbrains.llmClient.ChatClient;
import cn.gitlab.kilo.jetbrains.services.AiCodeReviewForSingleFileHandler;
import cn.gitlab.kilo.jetbrains.services.BrowserServiceKt;
import cn.gitlab.kilo.jetbrains.services.GenerationCallbacks;
import cn.gitlab.kilo.jetbrains.services.GitlabService;
import cn.gitlab.kilo.jetbrains.services.TrackService;
import cn.gitlab.kilo.jetbrains.services.UtilsKt;
import cn.gitlab.kilo.jetbrains.utils.ChatParameters;
import cn.gitlab.kilo.jetbrains.utils.GitlabUtilsKt;
import cn.gitlab.kilo.jetbrains.utils.ThemeUtilKt;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.ui.jcef.JBCefJSQuery;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefRequestHandler;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\rJ\b\u0010\u001c\u001a\u00020\u0017H\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u00020\u00172\b\u0010!\u001a\u0004\u0018\u00010\rH\u0002J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J\b\u0010%\u001a\u00020\rH\u0016J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0005H\u0016J\b\u0010*\u001a\u00020\u0011H\u0016J\b\u0010+\u001a\u00020\u0011H\u0016J\u0010\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u00172\u0006\u0010-\u001a\u00020.H\u0016J)\u00100\u001a\u0004\u0018\u0001H1\"\n\b\u0000\u00101*\u0004\u0018\u0001022\f\u00103\u001a\b\u0012\u0004\u0012\u0002H104H\u0016\u00a2\u0006\u0002\u00105J1\u00106\u001a\u00020\u0017\"\n\b\u0000\u00101*\u0004\u0018\u0001022\f\u00103\u001a\b\u0012\u0004\u0012\u0002H1042\b\u00107\u001a\u0004\u0018\u0001H1H\u0016\u00a2\u0006\u0002\u00108J\b\u00109\u001a\u00020\u0017H\u0016J\f\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;J\f\u0010=\u001a\b\u0012\u0004\u0012\u00020<0\u0013J\u0006\u0010>\u001a\u00020<J\f\u0010?\u001a\b\u0012\u0004\u0012\u00020<0\u0013J\u0006\u0010@\u001a\u00020\rJ\u0006\u0010\u0012\u001a\u00020\rJ\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013J\u000e\u0010B\u001a\u00020\u00112\u0006\u0010C\u001a\u00020\u000fJ$\u0010D\u001a\b\u0012\u0004\u0012\u00020<0;2\u0016\b\u0002\u0010E\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010FJ\u0012\u0010G\u001a\u00020<2\n\b\u0002\u0010H\u001a\u0004\u0018\u00010IJ\u0006\u0010J\u001a\u00020\rJ \u0010K\u001a\b\u0012\u0004\u0012\u00020<0\u00132\n\b\u0002\u0010L\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010M\u001a\u00020\rJ\u000e\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcn/gitlab/kilo/jetbrains/editor/GitlabBrowserEditor;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "browser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "mainPanel", "Ljavax/swing/JPanel;", "issueIid", "", "issuable", "Lcom/google/gson/JsonObject;", "isMr", "", "discussions", "", "aiCodeReviewForSingleFileHandler", "Lcn/gitlab/kilo/jetbrains/services/AiCodeReviewForSingleFileHandler;", "registerAppSchemeHandler", "", "onThemeChanged", "generateAiActionsCallbacks", "Lcn/gitlab/kilo/jetbrains/services/GenerationCallbacks;", "responseType", "setupBrowser", "addHandler", "jsQuery", "Lcom/intellij/ui/jcef/JBCefJSQuery;", "handleJSCommand", "message", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "getName", "setState", "state", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "getFile", "isModified", "isValid", "addPropertyChangeListener", "listener", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "getUserData", "T", "", "key", "Lcom/intellij/openapi/util/Key;", "(Lcom/intellij/openapi/util/Key;)Ljava/lang/Object;", "putUserData", "value", "(Lcom/intellij/openapi/util/Key;Ljava/lang/Object;)V", "dispose", "getMrSummarizeChatMessages", "", "Lcn/gitlab/kilo/jetbrains/common/Message;", "discussionsMessages", "commandMessage", "descriptionMessages", "description", "discussionNodes", "isGqlDiscussion", "note", "getChatMessages", "options", "", "systemMessage", "opt", "Lcn/gitlab/kilo/jetbrains/editor/SystemCommandOpt;", "typeName", "titleMessages", "assistantMsg", "title", "getCodeDiffMessage", "Lcn/gitlab/kilo/jetbrains/editor/CodeDiffMessage;", "path", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nGitlabBrowserEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitlabBrowserEditor.kt\ncn/gitlab/kilo/jetbrains/editor/GitlabBrowserEditor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,711:1\n1#2:712\n37#3:713\n36#3,3:714\n37#3:717\n36#3,3:718\n37#3:721\n36#3,3:722\n37#3:738\n36#3,3:739\n1374#4:725\n1460#4,2:726\n774#4:728\n865#4,2:729\n1563#4:731\n1634#4,3:732\n1462#4,3:735\n*S KotlinDebug\n*F\n+ 1 GitlabBrowserEditor.kt\ncn/gitlab/kilo/jetbrains/editor/GitlabBrowserEditor\n*L\n325#1:713\n325#1:714,3\n326#1:717\n326#1:718,3\n327#1:721\n327#1:722,3\n437#1:738\n437#1:739,3\n381#1:725\n381#1:726,2\n388#1:728\n388#1:729,2\n392#1:731\n392#1:732,3\n381#1:735,3\n*E\n"})
public final class GitlabBrowserEditor
implements FileEditor {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private JBCefBrowser browser;
    @NotNull
    private final JPanel mainPanel;
    @Nullable
    private String issueIid;
    @Nullable
    private JsonObject issuable;
    private boolean isMr;
    @NotNull
    private List<JsonObject> discussions;
    @Nullable
    private AiCodeReviewForSingleFileHandler aiCodeReviewForSingleFileHandler;

    public GitlabBrowserEditor(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.project = project;
        this.file = file;
        JBCefBrowser jBCefBrowser = JBCefBrowser.createBuilder().setOffScreenRendering(false).setEnableOpenDevToolsMenuItem(true).setUrl(ConstantsKt.getWorkFlowWebViewUrl()).build();
        Intrinsics.checkNotNullExpressionValue((Object)jBCefBrowser, (String)"build(...)");
        this.browser = jBCefBrowser;
        this.mainPanel = new JPanel(new BorderLayout());
        this.discussions = new ArrayList();
        this.registerAppSchemeHandler();
        this.setupBrowser();
        this.browser.getComponent().setFocusable(false);
        Application app = ApplicationManager.getApplication();
        MessageBusConnection connection = app.getMessageBus().connect();
        Topic topic = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, arg_0 -> GitlabBrowserEditor._init_$lambda$0(this, arg_0));
    }

    private final void registerAppSchemeHandler() {
        SchemeHandlerRegistrar.INSTANCE.ensureRegistered();
    }

    private final void onThemeChanged() {
        ThemeUtilKt.updateThemeToBrowser(this.browser);
    }

    @NotNull
    public final GenerationCallbacks generateAiActionsCallbacks(@NotNull String responseType) {
        Intrinsics.checkNotNullParameter((Object)responseType, (String)"responseType");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)responseType), TuplesKt.to((Object)"aiResultText", null), TuplesKt.to((Object)"status", (Object)"streaming")};
        Map response = MapsKt.mutableMapOf((Pair[])pairArray);
        return new GenerationCallbacks(response, this){
            final /* synthetic */ Map<String, String> $response;
            final /* synthetic */ GitlabBrowserEditor this$0;
            {
                this.$response = $response;
                this.this$0 = $receiver;
            }

            public void onChange(String text, String reasonText) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)MapsKt.plus(this.$response, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"aiResultText", (Object)("**" + I18nKt.getMessage("content.generated.ai") + "**\n\n" + text)))), GitlabBrowserEditor.access$getBrowser$p(this.this$0));
            }

            public void onComplete(String text, String reasonText) {
                ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)MapsKt.plus(this.$response, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"status", (Object)"completed"))), GitlabBrowserEditor.access$getBrowser$p(this.this$0));
            }

            public void onError(String text, Throwable error2) {
                Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
                ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)MapsKt.plus(this.$response, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"status", (Object)"failed"))), GitlabBrowserEditor.access$getBrowser$p(this.this$0));
            }

            public void onSensitive() {
                ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)MapsKt.plus(this.$response, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"status", (Object)"sensitive"))), GitlabBrowserEditor.access$getBrowser$p(this.this$0));
            }

            public void metric(Long tokensIn, Long tokensOut) {
                GenerationCallbacks.DefaultImpls.metric(this, tokensIn, tokensOut);
            }
        };
    }

    private final void setupBrowser() {
        this.mainPanel.add((Component)this.browser.getComponent(), "Center");
        JBCefClient jBCefClient = this.browser.getJBCefClient();
        Intrinsics.checkNotNullExpressionValue((Object)jBCefClient, (String)"getJBCefClient(...)");
        JBCefClient jbCefClient = jBCefClient;
        JBCefBrowser jBCefBrowser = this.browser;
        Intrinsics.checkNotNull((Object)jBCefBrowser, (String)"null cannot be cast to non-null type com.intellij.ui.jcef.JBCefBrowserBase");
        JBCefJSQuery jBCefJSQuery = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)jBCefBrowser));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery, (String)"create(...)");
        JBCefJSQuery jsQuery = jBCefJSQuery;
        this.addHandler(jsQuery);
        jbCefClient.addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(jsQuery){
            final /* synthetic */ JBCefJSQuery $jsQuery;
            {
                this.$jsQuery = $jsQuery;
            }

            public void onLoadStart(CefBrowser browser, CefFrame frame, CefRequest.TransitionType transitionType) {
                BrowserServiceKt.executeInitJavaScript(browser, this.$jsQuery);
                super.onLoadStart(browser, frame, transitionType);
            }

            public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                super.onLoadingStateChange(browser, isLoading, canGoBack, canGoForward);
            }

            public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                super.onLoadEnd(browser, frame, httpStatusCode);
            }
        }, this.browser.getCefBrowser());
        jbCefClient.addLifeSpanHandler((CefLifeSpanHandler)new CustomLifeSpanHandler(), this.browser.getCefBrowser());
        jbCefClient.addRequestHandler((CefRequestHandler)new CustomerRequestHandler(), this.browser.getCefBrowser());
    }

    private final void addHandler(JBCefJSQuery jsQuery) {
        jsQuery.addHandler(arg_0 -> GitlabBrowserEditor.addHandler$lambda$3(arg_0 -> GitlabBrowserEditor.addHandler$lambda$2(this, arg_0), arg_0));
    }

    private final void handleJSCommand(String message) {
        CharSequence charSequence = message;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        JsonObject jsonObject2 = JsonParser.parseString((String)message).getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"getAsJsonObject(...)");
        JsonObject msgJsonObject = jsonObject2;
        Object object = msgJsonObject.get("command");
        if (object == null || (object = object.getAsString()) == null) {
            return;
        }
        Object command = object;
        ThemeUtilKt.updateThemeToBrowser(this.browser);
        try {
            switch (command) {
                case "appReady": {
                    VirtualFile virtualFile = this.file;
                    MyVirtualFile myVirtualFile = virtualFile instanceof MyVirtualFile ? (MyVirtualFile)virtualFile : null;
                    if (myVirtualFile == null || (myVirtualFile = myVirtualFile.getIssuable()) == null) {
                        return;
                    }
                    JsonObject jsonObject3 = this.issuable = myVirtualFile;
                    Intrinsics.checkNotNull((Object)jsonObject3);
                    this.isMr = GitlabBrowserEditorKt.isMr(jsonObject3);
                    JsonObject jsonObject4 = this.issuable;
                    Intrinsics.checkNotNull((Object)jsonObject4);
                    this.issueIid = jsonObject4.get("iid").getAsString();
                    JsonObject jsonObject5 = this.issuable;
                    Intrinsics.checkNotNull((Object)jsonObject5);
                    this.discussions = GitlabService.INSTANCE.getDiscussions(new GetDiscussionsOptions(jsonObject5, null, 2, null), this.isMr);
                    JsonObject jsonObject6 = this.issuable;
                    Intrinsics.checkNotNull((Object)jsonObject6);
                    IssuableFetch issuableFetch = new IssuableFetch(null, jsonObject6, this.discussions, 1, null);
                    ThemeUtilKt.sendToWebview((ExtensionMessage)issuableFetch, this.browser);
                    this.aiCodeReviewForSingleFileHandler = new AiCodeReviewForSingleFileHandler(this.browser);
                    ModelConfigReq chatConfig = UtilsKt.getModelConfigReq();
                    ThemeUtilKt.sendToWebview((ExtensionMessage)chatConfig, this.browser);
                    break;
                }
                case "aiSummarizeRequest": {
                    JsonElement jsonElement = msgJsonObject.get("issuable");
                    JsonObject issuable = jsonElement != null ? jsonElement.getAsJsonObject() : null;
                    ChatClient llmClient = ChatHandler.getLLMClient$default(ChatHandler.INSTANCE, null, 1, null);
                    GenerationCallbacks callbacks2 = this.generateAiActionsCallbacks("aiSummarizeResponse");
                    ChatParameters chatParameters = new ChatParameters(this.getMrSummarizeChatMessages(), 0, null, null, null, null, ModelsConfiguration.Companion.getInstance().getDefaultLoomModelId(), null, false, false, null, null, 3518, null);
                    if (issuable != null) {
                        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                            int label;
                            final /* synthetic */ GitlabBrowserEditor this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        try {
                                            if (GitlabBrowserEditor.access$isMr$p(this.this$0)) {
                                                TrackService.commandUsage$default(TrackService.INSTANCE, null, "mr-summary", 1, null);
                                            } else {
                                                TrackService.commandUsage$default(TrackService.INSTANCE, null, "issue-summary", 1, null);
                                            }
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        llmClient.chat(chatParameters, callbacks2);
                    }
                    break;
                }
                case "saveNote": {
                    try {
                        Object object2 = msgJsonObject.get("note");
                        if (object2 == null || (object2 = object2.getAsString()) == null) {
                            throw new IllegalArgumentException("Note content is missing");
                        }
                        Object noteContent = object2;
                        JsonElement jsonElement = msgJsonObject.get("replyId");
                        String replyId = jsonElement != null ? jsonElement.getAsString() : null;
                        JsonObject jsonObject7 = this.issuable;
                        Intrinsics.checkNotNull((Object)jsonObject7);
                        GitlabService.INSTANCE.createNote(jsonObject7, (String)noteContent, replyId);
                        JsonObject jsonObject8 = this.issuable;
                        Intrinsics.checkNotNull((Object)jsonObject8);
                        List<JsonObject> discussionsStr = GitlabService.INSTANCE.getDiscussions(new GetDiscussionsOptions(jsonObject8, null, 2, null), this.isMr);
                        JsonObject jsonObject9 = this.issuable;
                        Intrinsics.checkNotNull((Object)jsonObject9);
                        IssuableFetch issuableFetch = new IssuableFetch(null, jsonObject9, discussionsStr, 1, null);
                        ThemeUtilKt.sendToWebview((ExtensionMessage)issuableFetch, this.browser);
                        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"noteSaved"), TuplesKt.to((Object)"status", (Object)true)};
                        ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)MapsKt.mapOf((Pair[])pairArray), this.browser);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Pair[] replyId = new Pair[]{TuplesKt.to((Object)"type", (Object)"noteSaved"), TuplesKt.to((Object)"status", (Object)false)};
                        ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)MapsKt.mapOf((Pair[])replyId), this.browser);
                    }
                    break;
                }
                case "getCurrentMrInfo": {
                    JsonObject issuable;
                    JsonElement jsonElement = msgJsonObject.get("issuable");
                    Object object3 = issuable = jsonElement != null ? jsonElement.getAsJsonObject() : null;
                    if (issuable != null && this.isMr) {
                        String key = GitlabUtilsKt.restMrKey(issuable);
                        JsonObject mrVersion = GitlabService.INSTANCE.getVersionCache().get(key);
                        Pair[] issuableFetch = new Pair[]{TuplesKt.to((Object)"type", (Object)"currentMrInfo"), TuplesKt.to((Object)"mrVersion", (Object)mrVersion)};
                        ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)MapsKt.mapOf((Pair[])issuableFetch), this.browser);
                        TrackService.commandUsage$default(TrackService.INSTANCE, null, "file-codereview", 1, null);
                    }
                    break;
                }
                case "aiCodeReviewForSingleFile": {
                    if (this.isMr) {
                        Object object4 = msgJsonObject.get("path");
                        if (object4 == null || (object4 = object4.getAsString()) == null) {
                            object4 = "";
                        }
                        Object path = object4;
                        List<Message> mrVersion = this.getChatMessages(MapsKt.mapOf((Pair)TuplesKt.to((Object)"path", (Object)path)));
                        String issuableFetch = ModelsConfiguration.Companion.getInstance().getDefaultLoomModelId();
                        ChatParameters chatParameters = new ChatParameters(mrVersion, 4000, null, null, null, null, issuableFetch, null, false, false, null, null, 3516, null);
                        if (this.issuable != null) {
                            if (!this.isMr) {
                                // empty if block
                            }
                            AiCodeReviewForSingleFileHandler aiCodeReviewForSingleFileHandler = this.aiCodeReviewForSingleFileHandler;
                            if (aiCodeReviewForSingleFileHandler != null) {
                                aiCodeReviewForSingleFileHandler.addTask(chatParameters, (String)path);
                            }
                        }
                    }
                    break;
                }
                case "toCodeReviewQueueHeader": {
                    Object object5 = msgJsonObject.get("path");
                    if (object5 == null || (object5 = object5.getAsString()) == null) {
                        object5 = "";
                    }
                    Object path = object5;
                    AiCodeReviewForSingleFileHandler aiCodeReviewForSingleFileHandler = this.aiCodeReviewForSingleFileHandler;
                    if (aiCodeReviewForSingleFileHandler != null) {
                        aiCodeReviewForSingleFileHandler.setHeader((String)path);
                    }
                    break;
                }
                case "sendNotesForSingleFileCodeReview": {
                    JsonObject jsonObject10 = this.issuable;
                    if (jsonObject10 != null) {
                        JsonObject it = jsonObject10;
                        boolean bl = false;
                        GitlabBrowserEditorKt.handleSendNotesForSingleFileCodeReview(msgJsonObject, this.browser, it);
                    }
                    break;
                }
                case "sendCodeReviewNotesForAllFile": {
                    JsonObject jsonObject11 = this.issuable;
                    if (jsonObject11 != null) {
                        JsonObject it = jsonObject11;
                        boolean bl = false;
                        GitlabBrowserEditorKt.handleSendNotesForMultipleFileCodeReviews(msgJsonObject, this.browser, it);
                        break;
                    } else {
                        break;
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @NotNull
    public JComponent getComponent() {
        return this.mainPanel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.browser.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @NotNull
    public String getName() {
        return "CEF Browser";
    }

    public void setState(@NotNull FileEditorState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    @NotNull
    public VirtualFile getFile() {
        return this.file;
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return null;
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
    }

    public void dispose() {
        this.browser.dispose();
    }

    @NotNull
    public final List<Message> getMrSummarizeChatMessages() {
        SpreadBuilder spreadBuilder = new SpreadBuilder(5);
        spreadBuilder.add((Object)this.systemMessage(new SystemCommandOpt(null, null, null, 7, null)));
        Collection $this$toTypedArray$iv = GitlabBrowserEditor.titleMessages$default(this, null, this.isMr, 1, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new Message[0]));
        $this$toTypedArray$iv = this.descriptionMessages();
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new Message[0]));
        $this$toTypedArray$iv = this.discussionsMessages();
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new Message[0]));
        spreadBuilder.add((Object)this.commandMessage());
        return CollectionsKt.mutableListOf((Object[])spreadBuilder.toArray((Object[])new Message[spreadBuilder.size()]));
    }

    @NotNull
    public final List<Message> discussionsMessages() {
        Object[] objectArray = new Message[]{new Message(Role.user, this.typeName() + " has the following discussion dialog: " + GitlabUtilsKt.packCode$default(this.discussions(), null, 2, null), null, 0L, false, 28, null), new Message(Role.assistant, "I will summarize the discussion and draw the final conclusion.", null, 0L, false, 28, null)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final Message commandMessage() {
        return new Message(Role.user, "Please analyze these titles, descriptions, discussion dialogues, and summarize them into four categories so that I can quickly grasp their content. Use ## to mark each category title. Ensure the output is in Markdown format and presented in bullet points. Do not enclose the output in `markdown` type code block.", null, 0L, false, 28, null);
    }

    @NotNull
    public final List<Message> descriptionMessages() {
        Object[] objectArray = new Message[]{new Message(Role.user, this.typeName() + " is described as: " + GitlabUtilsKt.packCode$default(this.description(), null, 2, null), null, 0L, false, 28, null), new Message(Role.user, "I will summarize the content.", null, 0L, false, 28, null)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final String description() {
        Object object = this.issuable;
        if (object == null || (object = object.get("description")) == null || (object = object.getAsString()) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public final String discussions() {
        return CollectionsKt.joinToString$default((Iterable)this.discussionNodes(), (CharSequence)"\n\n", null, null, (int)0, null, GitlabBrowserEditor::discussions$lambda$7, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JsonObject> discussionNodes() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.discussions;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable iterable2;
            JsonObject note = (JsonObject)element$iv$iv;
            boolean bl = false;
            if (!this.isGqlDiscussion(note)) {
                iterable2 = CollectionsKt.emptyList();
            } else {
                List list;
                JsonArray jsonArray;
                JsonObject jsonObject2 = note.getAsJsonObject("notes");
                if (jsonObject2 != null && (jsonArray = jsonObject2.getAsJsonArray("nodes")) != null) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Iterable iterable3 = (Iterable)jsonArray;
                    boolean $i$f$filter22 = false;
                    void var14_16 = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                        JsonElement node = (JsonElement)element$iv$iv2;
                        boolean bl2 = false;
                        JsonObject nodeObj = node.getAsJsonObject();
                        if (!(!nodeObj.get("system").getAsBoolean() && nodeObj.has("body"))) continue;
                        destination$iv$iv2.add(element$iv$iv2);
                    }
                    Iterable $i$f$filter22 = (List)destination$iv$iv2;
                    boolean $i$f$map = false;
                    destination$iv$iv2 = $this$map$iv;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        JsonElement bl2 = (JsonElement)item$iv$iv;
                        Collection collection = destination$iv$iv3;
                        boolean bl3 = false;
                        collection.add(it.getAsJsonObject());
                    }
                    list = (List)destination$iv$iv3;
                } else {
                    list = CollectionsKt.emptyList();
                }
                List notes = list;
                iterable2 = notes;
            }
            Iterable list$iv$iv = iterable2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean isGqlDiscussion(@NotNull JsonObject note) {
        Intrinsics.checkNotNullParameter((Object)note, (String)"note");
        return note.has("notes");
    }

    @NotNull
    public final List<Message> getChatMessages(@Nullable Map<String, String> options) {
        Object object;
        String assistantMsg;
        String systemMsg;
        block3: {
            block2: {
                Map<String, String> map = options;
                String path = map != null ? map.get("path") : null;
                systemMsg = "You are MR-Reviewer, a language model that specializes in suggesting improvements to a Merge Request (MR) code.\nYour task is to provide meaningful and actionable code suggestions, to improve the new code presented in a MR code diff (lines starting with '+')\nThe format we will use to present the MR code diff:\n@@ ... @@ def func1():\n  unchanged code line0 in the MR\n  unchanged code line1 in the MR\n +new code line2 added in the MR\n  unchanged code line3 in the MR\n -old code line2 removed in the MR\n\n In this format, code lines are prefixed with symbols ('+', '-', ' '). The '+' symbol indicates new code added in the MR, the '-' symbol indicates code removed in the MR, and the ' ' symbol indicates unchanged code.\n\n Specific instructions for generating code suggestions:\n  - The suggestions should be diverse and insightful. They should focus on improving only the new code introduced in the MR, meaning lines starting with '+' (after the line numbers)\n  - In addition to the exact code lines mentioned in each suggestion, review the code around them, to ensure that the suggestions are contextually accurate.\n  - Focus on important suggestions like fixing code problems, issues, performance and bugs. As a second priority, provide suggestions for meaningful code improvements, like performance, vulnerability, modularity, and best practices.\n  - Provide up to 4 code suggestions, allowing less than 4 suggestions and 0 suggestions if there are no optimization item. \n  - Avoid making suggestions that have already been implemented in the MR code. For example, if you want to add logs, or change a variable to const, or anything else, make sure it isn't already in the MR code.\n  - Don't suggest to add docstring, type hints, or comments.\n  - Don't suggest based on assumptions.\n  - Every time you cite variables or names from the code, use backticks ('`'). For example: 'ensure that `variable_name` is ...\n  - Please use chinese to answer, item by item.\n";
                assistantMsg = "If the title contains specific information, I will use it as an important reference.";
                object = path;
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                Message message = this.getCodeDiffMessage(it).getMessage();
                object = message;
                if (message != null) break block3;
            }
            return new ArrayList();
        }
        Object diffMessage = object;
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.add((Object)this.systemMessage(new SystemCommandOpt(systemMsg, null, null, 6, null)));
        Collection $this$toTypedArray$iv = this.titleMessages(assistantMsg, this.isMr);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new Message[0]));
        spreadBuilder.add(diffMessage);
        return CollectionsKt.mutableListOf((Object[])spreadBuilder.toArray((Object[])new Message[spreadBuilder.size()]));
    }

    public static /* synthetic */ List getChatMessages$default(GitlabBrowserEditor gitlabBrowserEditor, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            map = null;
        }
        return gitlabBrowserEditor.getChatMessages(map);
    }

    @NotNull
    public final Message systemMessage(@Nullable SystemCommandOpt opt) {
        Object object = opt;
        if (object == null || (object = ((SystemCommandOpt)object).getMain()) == null) {
            object = "You are an advanced software development engineer. \nYou are proficient in various programming languages, you can understand product requirements, and you can read code changes. \nYou can analyze and summarize based on the title, description, and discussion dialog content. \nYou will prioritize Chinese. \nYou will respond in Markdown format and always start a new line with a code block.";
        }
        Object main = object;
        Object[] objectArray = new String[3];
        SystemCommandOpt systemCommandOpt = opt;
        objectArray[0] = systemCommandOpt != null ? systemCommandOpt.getPrefix() : null;
        objectArray[1] = main;
        SystemCommandOpt systemCommandOpt2 = opt;
        objectArray[2] = systemCommandOpt2 != null ? systemCommandOpt2.getSuffix() : null;
        String text = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return new Message(Role.system, text, null, 0L, false, 28, null);
    }

    public static /* synthetic */ Message systemMessage$default(GitlabBrowserEditor gitlabBrowserEditor, SystemCommandOpt systemCommandOpt, int n, Object object) {
        if ((n & 1) != 0) {
            systemCommandOpt = null;
        }
        return gitlabBrowserEditor.systemMessage(systemCommandOpt);
    }

    @NotNull
    public final String typeName() {
        return this.isMr ? "Merge request" : "Issue";
    }

    @NotNull
    public final List<Message> titleMessages(@Nullable String assistantMsg, boolean isMr) {
        Object[] objectArray = new Message[2];
        objectArray[0] = new Message(Role.user, this.typeName() + " title is : " + GitlabUtilsKt.packCode$default(this.title(), null, 2, null), null, 0L, false, 28, null);
        String string = assistantMsg;
        if (string == null) {
            string = "I will summarize the title.";
        }
        objectArray[1] = new Message(Role.assistant, string, null, 0L, false, 28, null);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public static /* synthetic */ List titleMessages$default(GitlabBrowserEditor gitlabBrowserEditor, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return gitlabBrowserEditor.titleMessages(string, bl);
    }

    @NotNull
    public final String title() {
        Object object = this.issuable;
        if (object == null || (object = object.get("title")) == null || (object = object.getAsString()) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public final CodeDiffMessage getCodeDiffMessage(@NotNull String path) {
        Object object;
        JsonObject diffFile;
        Object v3;
        Object object2;
        JsonElement jsonElement;
        block7: {
            Object object3;
            String string;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            jsonElement = GitlabService.INSTANCE.getVersionCache();
            JsonObject jsonObject2 = this.issuable;
            if (jsonObject2 != null) {
                JsonObject it = jsonObject2;
                boolean bl = false;
                string = GitlabUtilsKt.restMrKey(it);
            } else {
                string = null;
            }
            if ((object3 = jsonElement.get(string)) == null || (object3 = object3.get("diffs")) == null || (object3 = object3.getAsJsonArray()) == null || (object3 = object3.asList()) == null) {
                object3 = CollectionsKt.emptyList();
            }
            Object codeDiffs = object3;
            object2 = (Iterable)codeDiffs;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                JsonElement diff = (JsonElement)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)diff.getAsJsonObject().get("new_path").getAsString(), (Object)path) || Intrinsics.areEqual((Object)diff.getAsJsonObject().get("old_path").getAsString(), (Object)path))) continue;
                v3 = t;
                break block7;
            }
            v3 = null;
        }
        jsonElement = v3;
        JsonObject jsonObject3 = diffFile = jsonElement != null ? jsonElement.getAsJsonObject() : null;
        if (diffFile == null) {
            return new CodeDiffMessage(path, null);
        }
        String filePathDesc = diffFile.get("new_file").getAsBoolean() ? "Added the new file: \"" + diffFile.get("new_path").getAsString() + "\"" : (diffFile.get("deleted_file").getAsBoolean() ? "Deleted the old file: \"" + diffFile.get("old_path").getAsString() + "\"" : (diffFile.get("renamed_file").getAsBoolean() ? "Renamed file \"" + diffFile.get("old_path").getAsString() + "\" to \"" + diffFile.get("new_path").getAsString() + "\"" : "Changed file \"" + diffFile.get("new_path").getAsString() + "\""));
        object2 = diffFile.get("diff").getAsString();
        if (!(object2 == null || StringsKt.isBlank((CharSequence)object2))) {
            String string = diffFile.get("diff").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            object = "Code Diff Content:\n" + GitlabUtilsKt.packCode(string, "diff");
        } else {
            object = "No content changes in the file.";
        }
        String diffContentDesc = object;
        String text = StringsKt.trimIndent((String)("\n" + filePathDesc + "\n\n" + diffContentDesc + "\n\nPlease codeReview on the code above.\n"));
        return new CodeDiffMessage(path, new Message(Role.user, text, null, 0L, false, 28, null));
    }

    private static final void _init_$lambda$0(GitlabBrowserEditor this$0, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.onThemeChanged();
    }

    private static final Unit addHandler$lambda$2$lambda$1(GitlabBrowserEditor this$0, String $message) {
        this$0.handleJSCommand($message);
        return Unit.INSTANCE;
    }

    private static final JBCefJSQuery.Response addHandler$lambda$2(GitlabBrowserEditor this$0, String message) {
        ActionsKt.invokeLater$default(null, () -> GitlabBrowserEditor.addHandler$lambda$2$lambda$1(this$0, message), (int)1, null);
        return null;
    }

    private static final JBCefJSQuery.Response addHandler$lambda$3(Function1 $tmp0, Object p0) {
        return (JBCefJSQuery.Response)$tmp0.invoke(p0);
    }

    private static final CharSequence discussions$lambda$7(JsonObject node) {
        Object object;
        Object authorName;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Object object2 = node.getAsJsonObject("author");
                if (object2 == null || (object2 = object2.get("name")) == null || (object2 = object2.getAsString()) == null) {
                    object2 = authorName = "Unknown";
                }
                if ((object = node.get("body")) == null || (object = object.getAsString()) == null) break block4;
                Object it = object;
                boolean bl = false;
                String string = Jsoup.parse((String)it).text();
                object = string;
                if (string != null) break block5;
            }
            object = "No content";
        }
        Object body = object;
        return (String)authorName + ": " + (String)body;
    }

    public static final /* synthetic */ JBCefBrowser access$getBrowser$p(GitlabBrowserEditor $this) {
        return $this.browser;
    }

    public static final /* synthetic */ boolean access$isMr$p(GitlabBrowserEditor $this) {
        return $this.isMr;
    }
}

