/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.edit.widget;

import cn.gitlab.kilo.jetbrains.edit.widget.LabelHighlight;
import cn.gitlab.kilo.jetbrains.edit.widget.LensLabel;
import cn.gitlab.kilo.jetbrains.edit.widget.LensWidgetGroup;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcn/gitlab/kilo/jetbrains/edit/widget/LensHotkey;", "Lcn/gitlab/kilo/jetbrains/edit/widget/LensLabel;", "group", "Lcn/gitlab/kilo/jetbrains/edit/widget/LensWidgetGroup;", "text", "", "<init>", "(Lcn/gitlab/kilo/jetbrains/edit/widget/LensWidgetGroup;Ljava/lang/String;)V", "hotkeyHighlightColor", "Lcom/intellij/ui/JBColor;", "highlight", "Lcn/gitlab/kilo/jetbrains/edit/widget/LabelHighlight;", "calcWidthInPixels", "", "fontMetrics", "Ljava/awt/FontMetrics;", "paint", "", "g", "Ljava/awt/Graphics2D;", "x", "", "y", "toString", "coderider-kilo-jetbrains"})
public final class LensHotkey
extends LensLabel {
    @NotNull
    private final JBColor hotkeyHighlightColor;
    @NotNull
    private final LabelHighlight highlight;

    public LensHotkey(@NotNull LensWidgetGroup group, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(group, text);
        this.hotkeyHighlightColor = new JBColor(0xDDDDDD, 2434601);
        this.highlight = new LabelHighlight((Color)this.hotkeyHighlightColor);
    }

    @Override
    public int calcWidthInPixels(@NotNull FontMetrics fontMetrics) {
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        return fontMetrics.stringWidth(this.getText()) + 8;
    }

    @Override
    public void paint(@NotNull Graphics2D g, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Font originalFont = g.getFont();
        Font resizedFont = originalFont.deriveFont(1, (float)originalFont.getSize() * 0.8f);
        g.setFont(resizedFont);
        FontMetrics fontMetrics = g.getFontMetrics();
        int width = fontMetrics.stringWidth(this.getText()) + 10;
        int height = fontMetrics.getHeight() + 3;
        this.highlight.drawHighlight(g, x + (float)2, y + 1.0f, width, height - 2);
        g.setColor((Color)new JBColor(7304058, 7304058));
        g.drawString(this.getText(), x + (float)7, y + (float)fontMetrics.getAscent() + 1.0f);
        g.setFont(originalFont);
    }

    @Override
    @NotNull
    public String toString() {
        return "LensHotkey(text=" + this.getText() + ")";
    }
}

