/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.edit.action;

import cn.gitlab.kilo.jetbrains.common.Range;
import cn.gitlab.kilo.jetbrains.edit.EditStreamHandler;
import cn.gitlab.kilo.jetbrains.edit.LensesService;
import cn.gitlab.kilo.jetbrains.edit.common.ProtocolCodeLens;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"generateDiffStreamHandler", "Lcn/gitlab/kilo/jetbrains/edit/EditStreamHandler;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "newEditor", "targetStartLine", "", "coderider-kilo-jetbrains"})
public final class DiffStreamUtilsKt {
    @NotNull
    public static final EditStreamHandler generateDiffStreamHandler(@NotNull Editor editor, @NotNull Project project, @Nullable Editor newEditor, int targetStartLine) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LensesService lensesService = LensesService.Companion.getInstance(project);
        Editor editor2 = newEditor;
        if (editor2 == null) {
            editor2 = editor;
        }
        Editor targetEditor = editor2;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String taskId = string;
        String string2 = editor.getVirtualFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        String path = string2;
        SelectionModel selectionModel = editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selectionModel2 = selectionModel;
        int startOffset = selectionModel2.getSelectionStart();
        int endOffset = selectionModel2.getSelectionEnd();
        int startLine = editor.offsetToLogicalPosition((int)startOffset).line;
        int endLine = editor.offsetToLogicalPosition((int)endOffset).line;
        int expandedStartOffset = editor.getDocument().getLineStartOffset(startLine);
        int expandedEndOffset = editor.getDocument().getLineEndOffset(endLine);
        String string3 = editor.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        String originFileText = string3;
        return new EditStreamHandler(() -> DiffStreamUtilsKt.generateDiffStreamHandler$lambda$1(lensesService, targetEditor), () -> DiffStreamUtilsKt.generateDiffStreamHandler$lambda$2(lensesService, targetEditor, taskId, expandedStartOffset, expandedEndOffset, targetStartLine), project, targetEditor, startLine, endLine, DiffStreamUtilsKt::generateDiffStreamHandler$lambda$3, () -> DiffStreamUtilsKt.generateDiffStreamHandler$lambda$4(lensesService, targetEditor, taskId, expandedStartOffset, expandedEndOffset, targetStartLine), path, originFileText, expandedStartOffset, expandedEndOffset, editor, targetStartLine, null, null, 49152, null);
    }

    public static /* synthetic */ EditStreamHandler generateDiffStreamHandler$default(Editor editor, Project project, Editor editor2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            editor2 = null;
        }
        return DiffStreamUtilsKt.generateDiffStreamHandler(editor, project, editor2, n);
    }

    private static final Range generateDiffStreamHandler$buildRange(int expandedStartOffset, int expandedEndOffset, int $targetStartLine) {
        Range range;
        Range $this$generateDiffStreamHandler_u24buildRange_u24lambda_u240 = range = new Range(expandedStartOffset, expandedEndOffset);
        boolean bl = false;
        if ($targetStartLine == 0) {
            $this$generateDiffStreamHandler_u24buildRange_u24lambda_u240.setStart(0);
            $this$generateDiffStreamHandler_u24buildRange_u24lambda_u240.setEnd(0);
        }
        return range;
    }

    private static final void generateDiffStreamHandler$updateLensesWithLense(Editor targetEditor, String taskId, LensesService lensesService, int expandedStartOffset, int expandedEndOffset, int $targetStartLine, Function2<? super Range, ? super String, ? extends List<ProtocolCodeLens>> generate) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(targetEditor.getDocument());
        if (virtualFile != null) {
            Range range = DiffStreamUtilsKt.generateDiffStreamHandler$buildRange(expandedStartOffset, expandedEndOffset, $targetStartLine);
            List lens = (List)generate.invoke((Object)range, (Object)taskId);
            String string = virtualFile.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            lensesService.updateLenses(targetEditor, string, virtualFile, lens);
        }
    }

    private static final Unit generateDiffStreamHandler$lambda$1(LensesService $lensesService, Editor $targetEditor) {
        $lensesService.clearLenses($targetEditor);
        return Unit.INSTANCE;
    }

    private static final Unit generateDiffStreamHandler$lambda$2(LensesService $lensesService, Editor $targetEditor, String $taskId, int $expandedStartOffset, int $expandedEndOffset, int $targetStartLine) {
        DiffStreamUtilsKt.generateDiffStreamHandler$updateLensesWithLense($targetEditor, $taskId, $lensesService, $expandedStartOffset, $expandedEndOffset, $targetStartLine, (Function2<? super Range, ? super String, ? extends List<ProtocolCodeLens>>)((Function2)new Function2<Range, String, List<? extends ProtocolCodeLens>>((Object)$lensesService){

            public final List<ProtocolCodeLens> invoke(Range p0, String p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((LensesService)this.receiver).generateInlineEditStartLense(p0, p1);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit generateDiffStreamHandler$lambda$3() {
        return Unit.INSTANCE;
    }

    private static final Unit generateDiffStreamHandler$lambda$4(LensesService $lensesService, Editor $targetEditor, String $taskId, int $expandedStartOffset, int $expandedEndOffset, int $targetStartLine) {
        DiffStreamUtilsKt.generateDiffStreamHandler$updateLensesWithLense($targetEditor, $taskId, $lensesService, $expandedStartOffset, $expandedEndOffset, $targetStartLine, (Function2<? super Range, ? super String, ? extends List<ProtocolCodeLens>>)((Function2)new Function2<Range, String, List<? extends ProtocolCodeLens>>((Object)$lensesService){

            public final List<ProtocolCodeLens> invoke(Range p0, String p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((LensesService)this.receiver).generateInlineEditEndLense(p0, p1);
            }
        }));
        return Unit.INSTANCE;
    }
}

