/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.edit;

import cn.gitlab.kilo.jetbrains.edit.PromptHistory;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.JTextArea;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcn/gitlab/kilo/jetbrains/edit/TextAreaHistoryManager;", "", "textArea", "Ljavax/swing/JTextArea;", "promptHistory", "Lcn/gitlab/kilo/jetbrains/edit/PromptHistory;", "<init>", "(Ljavax/swing/JTextArea;Lcn/gitlab/kilo/jetbrains/edit/PromptHistory;)V", "getPromptHistory", "()Lcn/gitlab/kilo/jetbrains/edit/PromptHistory;", "isInHistoryMode", "", "addPrompt", "", "prompt", "", "isHistoryAvailable", "coderider-kilo-jetbrains"})
public final class TextAreaHistoryManager {
    @NotNull
    private final PromptHistory promptHistory;
    private boolean isInHistoryMode;

    public TextAreaHistoryManager(final @NotNull JTextArea textArea, @NotNull PromptHistory promptHistory) {
        Intrinsics.checkNotNullParameter((Object)textArea, (String)"textArea");
        Intrinsics.checkNotNullParameter((Object)promptHistory, (String)"promptHistory");
        this.promptHistory = promptHistory;
        this.isInHistoryMode = true;
        textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                boolean shouldEnterHistoryMode;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String string = textArea.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                boolean bl = shouldEnterHistoryMode = ((CharSequence)string).length() == 0;
                if (e.getKeyCode() != 38 && e.getKeyCode() != 40 || shouldEnterHistoryMode) {
                    if (!isInHistoryMode && shouldEnterHistoryMode) {
                        this.getPromptHistory().resetHistory();
                    }
                    isInHistoryMode = shouldEnterHistoryMode;
                }
                if (e.getKeyCode() == 38) {
                    if (isInHistoryMode) {
                        String string2 = this.getPromptHistory().getPrevious();
                        if (string2 == null) {
                            return;
                        }
                        String previous = string2;
                        textArea.setText(previous);
                        textArea.moveCaretPosition(textArea.getText().length());
                        e.consume();
                    } else {
                        Action defaultAction = textArea.getActionMap().get("caret-up");
                        defaultAction.actionPerformed(null);
                    }
                } else if (e.getKeyCode() == 40) {
                    if (isInHistoryMode) {
                        String next = this.getPromptHistory().getNext();
                        CharSequence charSequence = next;
                        if (charSequence == null || charSequence.length() == 0) {
                            this.getPromptHistory().resetHistory();
                        }
                        textArea.setText(next);
                        textArea.moveCaretPosition(textArea.getText().length());
                        e.consume();
                    } else {
                        Action defaultAction = textArea.getActionMap().get("caret-down");
                        defaultAction.actionPerformed(null);
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() != 38 && e.getKeyCode() != 40) {
                    String string = textArea.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    isInHistoryMode = ((CharSequence)string).length() == 0;
                    this.getPromptHistory().resetHistory();
                }
            }
        });
    }

    @NotNull
    public final PromptHistory getPromptHistory() {
        return this.promptHistory;
    }

    public final void addPrompt(@NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        this.promptHistory.add(prompt);
        this.isInHistoryMode = true;
    }

    public final boolean isHistoryAvailable() {
        return this.isInHistoryMode && this.promptHistory.isNotEmpty();
    }
}

