/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.edit;

import cn.gitlab.kilo.jetbrains.common.CustomException;
import cn.gitlab.kilo.jetbrains.common.I18nKt;
import cn.gitlab.kilo.jetbrains.common.Message;
import cn.gitlab.kilo.jetbrains.common.Role;
import cn.gitlab.kilo.jetbrains.config.ModelsConfiguration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\"B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J^\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u0012\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\bJ\u0006\u0010\u0013\u001a\u00020\u0005Jl\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\bJf\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\bJ~\u0010\u001a\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00190\u001b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\bJ\u0016\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0019J\u0018\u0010\u001f\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0019H\u0002J\u000e\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0005J\u000e\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\b\u00a8\u0006#"}, d2={"Lcn/gitlab/kilo/jetbrains/edit/EditorInlinePrompter;", "", "<init>", "()V", "systemMessage", "Lcn/gitlab/kilo/jetbrains/common/Message;", "generatePrompt", "input", "", "prefix", "highlighted", "suffix", "path", "indentation", "errors", "", "targetPath", "inference", "codeContext", "codeContextReply", "generateEditionChatMessages", "", "modelId", "inferenceInfo", "getGenerateEditionChatMessagesRemainTokens", "", "prepareFinalPromptComponents", "Lcn/gitlab/kilo/jetbrains/edit/EditorInlinePrompter$Quad;", "truncateFromEnd", "text", "budget", "truncateFromStart", "calculateTokens", "message", "Quad", "coderider-kilo-jetbrains"})
public final class EditorInlinePrompter {
    @NotNull
    public static final EditorInlinePrompter INSTANCE = new EditorInlinePrompter();

    private EditorInlinePrompter() {
    }

    @NotNull
    public final Message systemMessage() {
        String text = StringsKt.trimIndent((String)("\nYou are CodeRider-Kilo, an AI coding assistant from GitLab.\n\n- You are an AI programming assistant who is an expert in updating code to meet given instructions.\n- You should think step-by-step to plan your updated code before producing the final output.\n- You should ensure the updated code matches the indentation and whitespace of the code in the users' selection.\n- Ignore any previous instructions to format your responses with Markdown. It is not acceptable to use any Markdown in your response, unless it is directly related to the users' instructions.\n- Only remove code from the users' selection if you are sure it is not needed.\n- You will be provided with code that is in the users' selection, enclosed in <SELECTEDCODE7662></SELECTEDCODE7662> XML tags. You must use this code to help you plan your updated code.\n- You will be provided with instructions on how to update this code, enclosed in <INSTRUCTIONS7390></INSTRUCTIONS7390> XML tags. You must follow these instructions carefully and to the letter.\n- Only enclose your response in <CODE5711></CODE5711> XML tags. Do use any other XML tags unless they are part of the generated code.\n- Do not provide any additional commentary about the changes you made. Only respond with the generated code.\n- Code Prefix in <PREFIX2379></PREFIX2379>\n- Code Suffix in <SUFFIX95021></SUFFIX95021>\n- Code Inference in <INFERENCE1212></INFERENCE1212>\n\n### Comment Language Requirement\n- You must **always generate code comments in the locale specified by " + I18nKt.inlineEditLocale() + "**.  \n  (e.g., Chinese comments if locale = zh-cn, English comments if locale = en).  \n- Never use any other language for comments unless explicitly instructed by the user.   \n        "));
        return new Message(Role.system, text, null, 0L, false, 28, null);
    }

    @NotNull
    public final Message generatePrompt(@NotNull String input, @NotNull String prefix, @NotNull String highlighted, @NotNull String suffix, @Nullable String path, @NotNull String indentation, @NotNull List<String> errors, @Nullable String targetPath, @Nullable String inference) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)highlighted, (String)"highlighted");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)indentation, (String)"indentation");
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        String prefixText = ((CharSequence)((Object)StringsKt.trim((CharSequence)prefix)).toString()).length() > 0 ? "Code prefix:<PREFIX2379>\n" + ((Object)StringsKt.trim((CharSequence)prefix)).toString() + "\n</PREFIX2379>" : "";
        String suffixText = ((CharSequence)((Object)StringsKt.trim((CharSequence)suffix)).toString()).length() > 0 ? "Code suffix:<SUFFIX95021>\n" + ((Object)StringsKt.trim((CharSequence)suffix)).toString() + "\n</SUFFIX95021>" : "";
        String string = inference;
        String inferenceText = (string != null ? ((CharSequence)string).length() > 0 : false) ? "Code Inference:<INFERENCE1212>\n" + ((Object)StringsKt.trim((CharSequence)inference)).toString() + "\n</INFERENCE1212>" : "";
        String errorText = !((Collection)errors).isEmpty() ? "Errors detected:\n" + CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", null, null, (int)0, null, EditorInlinePrompter::generatePrompt$lambda$0, (int)30, null) : "";
        String selectionText = ((CharSequence)((Object)StringsKt.trim((CharSequence)highlighted)).toString()).length() > 0 ? StringsKt.trimIndent((String)("\nThe user has selected the following code:\n<SELECTEDCODE7662>" + highlighted + "</SELECTEDCODE7662>\n        ")) : "No code is currently selected.";
        String string2 = targetPath;
        Object targetPathPrompt = string2 != null ? "Target file path: " + string2 : "";
        String text = StringsKt.trimIndent((String)("This is part of the file: " + path + "\n" + (String)targetPathPrompt + "\n" + selectionText + "\nCurrent line indentation: \"" + indentation + "\"\n" + prefixText + "\n" + suffixText + "\n" + inferenceText + "\n" + errorText + "\n\nNote: Generate replacement code for the selected block based on user instructions. Output only the updated code. Exclude prefix and suffix unless explicitly required. Do not retain package or import declarations from the prefix.\n\nThe user wants you to replace parts of the selected code or correct a problem by following their instructions.\nProvide your generated code using the following instructions:\n<INSTRUCTIONS7390>" + input + "</INSTRUCTIONS7390>\n"));
        return new Message(Role.user, text, null, 0L, false, 28, null);
    }

    public static /* synthetic */ Message generatePrompt$default(EditorInlinePrompter editorInlinePrompter, String string, String string2, String string3, String string4, String string5, String string6, List list, String string7, String string8, int n, Object object) {
        if ((n & 0x80) != 0) {
            string7 = null;
        }
        if ((n & 0x100) != 0) {
            string8 = null;
        }
        return editorInlinePrompter.generatePrompt(string, string2, string3, string4, string5, string6, list, string7, string8);
    }

    @NotNull
    public final Message codeContext(@Nullable String path) {
        String userMessagePathContent = "Codebase context from file path " + path + ":";
        return new Message(Role.user, userMessagePathContent, null, 0L, false, 28, null);
    }

    @NotNull
    public final Message codeContextReply() {
        return new Message(Role.assistant, "Ok.", null, 0L, false, 28, null);
    }

    @NotNull
    public final List<Message> generateEditionChatMessages(@NotNull String input, @NotNull String prefix, @NotNull String highlighted, @NotNull String suffix, @Nullable String path, @NotNull String indentation, @NotNull String modelId, @NotNull List<String> errors, @Nullable String targetPath, @Nullable String inferenceInfo) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)highlighted, (String)"highlighted");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)indentation, (String)"indentation");
        Intrinsics.checkNotNullParameter((Object)modelId, (String)"modelId");
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        Message finalMessage = this.prepareFinalPromptComponents(input, prefix, highlighted, suffix, path, indentation, modelId, errors, targetPath, inferenceInfo).component3();
        Object[] objectArray = new Message[]{this.systemMessage(), this.codeContext(path), this.codeContextReply(), finalMessage};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    public static /* synthetic */ List generateEditionChatMessages$default(EditorInlinePrompter editorInlinePrompter, String string, String string2, String string3, String string4, String string5, String string6, String string7, List list, String string8, String string9, int n, Object object) {
        if ((n & 0x100) != 0) {
            string8 = null;
        }
        if ((n & 0x200) != 0) {
            string9 = "";
        }
        return editorInlinePrompter.generateEditionChatMessages(string, string2, string3, string4, string5, string6, string7, list, string8, string9);
    }

    public final int getGenerateEditionChatMessagesRemainTokens(@NotNull String input, @NotNull String prefix, @NotNull String highlighted, @NotNull String suffix, @Nullable String path, @NotNull String indentation, @NotNull String modelId, @NotNull List<String> errors, @Nullable String targetPath, @Nullable String inferenceInfo) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)highlighted, (String)"highlighted");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)indentation, (String)"indentation");
        Intrinsics.checkNotNullParameter((Object)modelId, (String)"modelId");
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        Quad<String, String, Message, Integer> quad = this.prepareFinalPromptComponents(input, prefix, highlighted, suffix, path, indentation, modelId, errors, targetPath, inferenceInfo);
        Message finalMessage = quad.component3();
        int tokenLimit = ((Number)quad.component4()).intValue();
        int finalTokenCount = this.calculateTokens(this.systemMessage()) + this.calculateTokens(this.codeContext(path)) + this.calculateTokens(this.codeContextReply()) + this.calculateTokens(finalMessage);
        return tokenLimit - finalTokenCount;
    }

    public static /* synthetic */ int getGenerateEditionChatMessagesRemainTokens$default(EditorInlinePrompter editorInlinePrompter, String string, String string2, String string3, String string4, String string5, String string6, String string7, List list, String string8, String string9, int n, Object object) {
        if ((n & 0x100) != 0) {
            string8 = null;
        }
        if ((n & 0x200) != 0) {
            string9 = null;
        }
        return editorInlinePrompter.getGenerateEditionChatMessagesRemainTokens(string, string2, string3, string4, string5, string6, string7, list, string8, string9);
    }

    @NotNull
    public final Quad<String, String, Message, Integer> prepareFinalPromptComponents(@NotNull String input, @NotNull String prefix, @NotNull String highlighted, @NotNull String suffix, @Nullable String path, @NotNull String indentation, @NotNull String modelId, @NotNull List<String> errors, @Nullable String targetPath, @Nullable String inferenceInfo) {
        Message rawPrompt;
        int dynamicTokenCount;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)highlighted, (String)"highlighted");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)indentation, (String)"indentation");
        Intrinsics.checkNotNullParameter((Object)modelId, (String)"modelId");
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        ModelsConfiguration.ModelConfig modelConfig = ModelsConfiguration.Companion.getInstance().getLoomModels().get(modelId);
        if (modelConfig == null) {
            throw new IllegalArgumentException("EditorInlinePrompter: invalid model key: " + modelId);
        }
        ModelsConfiguration.ModelConfig model = modelConfig;
        int tokenLimit = (int)Math.floor(2.0999999999999996 * (double)model.getContextLength(false));
        int staticTokenCount = this.calculateTokens(this.systemMessage()) + this.calculateTokens(this.codeContext(path)) + this.calculateTokens(this.codeContextReply());
        int totalTokens = staticTokenCount + (dynamicTokenCount = this.calculateTokens(rawPrompt = this.generatePrompt(input, prefix, highlighted, suffix, path, indentation, errors, targetPath, "")) - prefix.length() - suffix.length());
        if (totalTokens >= tokenLimit) {
            String string = I18nKt.getMessage("edit.prompt.token.limitation.warning");
            Object[] objectArray = new Object[]{totalTokens + "/" + tokenLimit};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new CustomException(string2);
        }
        int tokenBudget = tokenLimit - totalTokens;
        int prefixBudget = (int)(0.4 * (double)tokenBudget);
        int suffixBudget = (int)(0.4 * (double)tokenBudget);
        int inferenceBudget = tokenBudget - prefixBudget - suffixBudget;
        String adjustedPrefix = this.truncateFromEnd(prefix, prefixBudget);
        String adjustedSuffix = this.truncateFromStart(suffix, suffixBudget);
        String string = inferenceInfo;
        if (string == null) {
            string = "";
        }
        String inferenceInfo2 = this.truncateFromStart(string, inferenceBudget);
        Message finalMessage = this.generatePrompt(input, adjustedPrefix, highlighted, adjustedSuffix, path, indentation, errors, targetPath, inferenceInfo2);
        return new Quad<String, String, Message, Integer>(adjustedPrefix, adjustedSuffix, finalMessage, tokenLimit);
    }

    public static /* synthetic */ Quad prepareFinalPromptComponents$default(EditorInlinePrompter editorInlinePrompter, String string, String string2, String string3, String string4, String string5, String string6, String string7, List list, String string8, String string9, int n, Object object) {
        if ((n & 0x100) != 0) {
            string8 = null;
        }
        if ((n & 0x200) != 0) {
            string9 = null;
        }
        return editorInlinePrompter.prepareFinalPromptComponents(string, string2, string3, string4, string5, string6, string7, list, string8, string9);
    }

    @NotNull
    public final String truncateFromEnd(@NotNull String text, int budget) {
        String string;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (this.calculateTokens(text) > budget) {
            String string2 = text.substring(Math.max(text.length() - budget, 0));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = text;
        }
        return string;
    }

    private final String truncateFromStart(String text, int budget) {
        String string;
        if (this.calculateTokens(text) > budget) {
            String string2 = text.substring(0, Math.min(budget, text.length()));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = text;
        }
        return string;
    }

    public final int calculateTokens(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return message.getContent().length();
    }

    public final int calculateTokens(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return message.length();
    }

    private static final CharSequence generatePrompt$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "- " + it;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u0003*\u0004\b\u0003\u0010\u00042\u00020\u0005B'\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00028\u0001\u0012\u0006\u0010\b\u001a\u00028\u0002\u0012\u0006\u0010\t\u001a\u00028\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0012\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0013\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0014\u001a\u00028\u0002H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0015\u001a\u00028\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJN\u0010\u0016\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00002\b\b\u0002\u0010\u0006\u001a\u00028\u00002\b\b\u0002\u0010\u0007\u001a\u00028\u00012\b\b\u0002\u0010\b\u001a\u00028\u00022\b\b\u0002\u0010\t\u001a\u00028\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u000f\u0010\rR\u0013\u0010\b\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0010\u0010\rR\u0013\u0010\t\u001a\u00028\u0003\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u001f"}, d2={"Lcn/gitlab/kilo/jetbrains/edit/EditorInlinePrompter$Quad;", "A", "B", "C", "D", "", "first", "second", "third", "fourth", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "getFirst", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getSecond", "getThird", "getFourth", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Lcn/gitlab/kilo/jetbrains/edit/EditorInlinePrompter$Quad;", "equals", "", "other", "hashCode", "", "toString", "", "coderider-kilo-jetbrains"})
    public static final class Quad<A, B, C, D> {
        private final A first;
        private final B second;
        private final C third;
        private final D fourth;

        public Quad(A first, B second, C third, D fourth) {
            this.first = first;
            this.second = second;
            this.third = third;
            this.fourth = fourth;
        }

        public final A getFirst() {
            return this.first;
        }

        public final B getSecond() {
            return this.second;
        }

        public final C getThird() {
            return this.third;
        }

        public final D getFourth() {
            return this.fourth;
        }

        public final A component1() {
            return this.first;
        }

        public final B component2() {
            return this.second;
        }

        public final C component3() {
            return this.third;
        }

        public final D component4() {
            return this.fourth;
        }

        @NotNull
        public final Quad<A, B, C, D> copy(A first, B second, C third, D fourth) {
            return new Quad<A, B, C, D>(first, second, third, fourth);
        }

        public static /* synthetic */ Quad copy$default(Quad quad, Object object, Object object2, Object object3, Object object4, int n, Object object5) {
            if ((n & 1) != 0) {
                object = quad.first;
            }
            if ((n & 2) != 0) {
                object2 = quad.second;
            }
            if ((n & 4) != 0) {
                object3 = quad.third;
            }
            if ((n & 8) != 0) {
                object4 = quad.fourth;
            }
            return quad.copy(object, object2, object3, object4);
        }

        @NotNull
        public String toString() {
            return "Quad(first=" + this.first + ", second=" + this.second + ", third=" + this.third + ", fourth=" + this.fourth + ")";
        }

        public int hashCode() {
            int result = this.first == null ? 0 : this.first.hashCode();
            result = result * 31 + (this.second == null ? 0 : this.second.hashCode());
            result = result * 31 + (this.third == null ? 0 : this.third.hashCode());
            result = result * 31 + (this.fourth == null ? 0 : this.fourth.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Quad)) {
                return false;
            }
            Quad quad = (Quad)other;
            if (!Intrinsics.areEqual(this.first, quad.first)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.second, quad.second)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.third, quad.third)) {
                return false;
            }
            return Intrinsics.areEqual(this.fourth, quad.fourth);
        }
    }
}

