/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.edit;

import cn.gitlab.kilo.jetbrains.edit.EditStreamHandler;
import cn.gitlab.kilo.jetbrains.edit.LensesService;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0006J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcn/gitlab/kilo/jetbrains/edit/EditInlineStreamService;", "", "<init>", "()V", "handlers", "", "Lcom/intellij/openapi/editor/Editor;", "Lcn/gitlab/kilo/jetbrains/edit/EditStreamHandler;", "editorBusyLocks", "", "register", "", "handler", "editor", "reject", "accept", "retry", "getOriginFile", "", "isOnBusy", "busy", "release", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nEditInlineStreamService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditInlineStreamService.kt\ncn/gitlab/kilo/jetbrains/edit/EditInlineStreamService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,53:1\n31#2,2:54\n31#2,2:56\n31#2,2:58\n*S KotlinDebug\n*F\n+ 1 EditInlineStreamService.kt\ncn/gitlab/kilo/jetbrains/edit/EditInlineStreamService\n*L\n21#1:54,2\n27#1:56,2\n32#1:58,2\n*E\n"})
public final class EditInlineStreamService {
    @NotNull
    private final Map<Editor, EditStreamHandler> handlers = new LinkedHashMap();
    @NotNull
    private final Map<Editor, Boolean> editorBusyLocks = new LinkedHashMap();

    public final void register(@NotNull EditStreamHandler handler, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.handlers.put(editor, handler);
    }

    public final void reject(@NotNull Editor editor) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            EditStreamHandler editStreamHandler = this.handlers.get(editor);
            if (editStreamHandler != null) {
                editStreamHandler.rejectAll();
            }
            this.handlers.remove(editor);
            Object object = editor.getProject();
            if (object == null) break block3;
            ComponentManager $this$service$iv = (ComponentManager)object;
            boolean $i$f$service = false;
            Class<LensesService> serviceClass$iv = LensesService.class;
            Object object2 = $this$service$iv.getService(serviceClass$iv);
            if (object2 == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            object = (LensesService)object2;
            if (object != null) {
                ((LensesService)object).clearLenses(editor);
            }
        }
    }

    public final void accept(@NotNull Editor editor) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            EditStreamHandler editStreamHandler = this.handlers.get(editor);
            if (editStreamHandler != null) {
                editStreamHandler.acceptAll();
            }
            this.handlers.remove(editor);
            Object object = editor.getProject();
            if (object == null) break block3;
            ComponentManager $this$service$iv = (ComponentManager)object;
            boolean $i$f$service = false;
            Class<LensesService> serviceClass$iv = LensesService.class;
            Object object2 = $this$service$iv.getService(serviceClass$iv);
            if (object2 == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            object = (LensesService)object2;
            if (object != null) {
                ((LensesService)object).clearLenses(editor);
            }
        }
    }

    public final void retry(@NotNull Editor editor) {
        block4: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            EditStreamHandler editStreamHandler = this.handlers.get(editor);
            if (editStreamHandler != null) {
                editStreamHandler.rejectAll();
            }
            if ((object = editor.getProject()) != null) {
                ComponentManager $this$service$iv = (ComponentManager)object;
                boolean $i$f$service = false;
                Class<LensesService> serviceClass$iv = LensesService.class;
                Object object2 = $this$service$iv.getService(serviceClass$iv);
                if (object2 == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                object = (LensesService)object2;
                if (object != null) {
                    ((LensesService)object).clearLenses(editor);
                }
            }
            EditStreamHandler editStreamHandler2 = this.handlers.get(editor);
            if (editStreamHandler2 == null) break block4;
            editStreamHandler2.retry();
        }
    }

    @Nullable
    public final String getOriginFile(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        EditStreamHandler editStreamHandler = this.handlers.get(editor);
        return editStreamHandler != null ? editStreamHandler.getOriginFile() : null;
    }

    public final boolean isOnBusy(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Boolean bl = this.editorBusyLocks.get(editor);
        return bl != null ? bl : false;
    }

    public final void busy(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editorBusyLocks.put(editor, true);
    }

    public final void release(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editorBusyLocks.put(editor, false);
    }
}

