/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.constants;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001\u001a\u0006\u0010\n\u001a\u00020\u0001\u001a\u000e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001\u001a\u0006\u0010\r\u001a\u00020\u0001\u001a\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"DEFAULT_CONFIG", "", "DEFAULT_CONFIG_JS", "getContinueGlobalPath", "getConfigJsonPath", "getConfigJsPath", "getSessionsDir", "getSessionsListPath", "getSessionFilePath", "sessionId", "devDataPath", "getDevDataFilepath", "filename", "getMigrationsFolderPath", "migrate", "", "id", "callback", "Lkotlin/Function0;", "coderider-kilo-jetbrains"})
public final class ServerConstantsKt {
    @NotNull
    public static final String DEFAULT_CONFIG = "\n{\n  \"models\": [\n    {\n      \"title\": \"GPT-4\",\n      \"provider\": \"free-trial\",\n      \"model\": \"gpt-4\"\n    },\n    {\n      \"title\": \"GPT-3.5-Turbo\",\n      \"provider\": \"free-trial\",\n      \"model\": \"gpt-3.5-turbo\"\n    },\n    {\n      \"title\": \"Phind CodeLlama\",\n      \"provider\": \"free-trial\",\n      \"model\": \"phind-codellama-34b\"\n    },\n    {\n      \"title\": \"Gemini Pro\",\n      \"provider\": \"free-trial\",\n      \"model\": \"gemini-pro\"\n    }\n  ],\n  \"slashCommands\": [\n    {\n      \"name\": \"edit\",\n      \"description\": \"Edit highlighted code\",\n      \"step\": \"EditHighlightedCodeStep\"\n    },\n    {\n      \"name\": \"comment\",\n      \"description\": \"Write comments for the highlighted code\",\n      \"step\": \"CommentCodeStep\"\n    },\n    {\n      \"name\": \"share\",\n      \"description\": \"Download and share this session\",\n      \"step\": \"ShareSessionStep\"\n    },\n    {\n      \"name\": \"cmd\",\n      \"description\": \"Generate a shell command\",\n      \"step\": \"GenerateShellCommandStep\"\n    }\n  ],\n  \"customCommands\": [\n    {\n      \"name\": \"test\",\n      \"prompt\": \"Write a comprehensive set of unit tests for the selected code. It should setup, run tests that check for correctness including important edge cases, and teardown. Ensure that the tests are complete and sophisticated. Give the tests just as chat output, don't edit any file.\",\n      \"description\": \"Write unit tests for highlighted code\"\n    }\n  ],\n  \"contextProviders\": [\n    { \"name\": \"diff\", \"params\": {} },\n    {\n      \"name\": \"open\",\n      \"params\": {}\n    },\n    { \"name\": \"terminal\", \"params\": {} }\n  ]\n}\n";
    @NotNull
    public static final String DEFAULT_CONFIG_JS = "\nfunction modifyConfig(config) {\n  return config;\n}\nexport {\n  modifyConfig\n};\n";

    @NotNull
    public static final String getContinueGlobalPath() {
        String[] stringArray = new String[]{".coderider"};
        Path continuePath = Paths.get(System.getProperty("user.home"), stringArray);
        if (Files.notExists(continuePath, new LinkOption[0])) {
            Files.createDirectories(continuePath, new FileAttribute[0]);
        }
        return ((Object)continuePath).toString();
    }

    @NotNull
    public static final String getConfigJsonPath() {
        String[] stringArray = new String[]{"config.json"};
        Path path = Paths.get(ServerConstantsKt.getContinueGlobalPath(), stringArray);
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
            Files.writeString(path, (CharSequence)DEFAULT_CONFIG, new OpenOption[0]);
        }
        return ((Object)path).toString();
    }

    @NotNull
    public static final String getConfigJsPath() {
        String[] stringArray = new String[]{"config.js"};
        Path path = Paths.get(ServerConstantsKt.getContinueGlobalPath(), stringArray);
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
            Files.writeString(path, (CharSequence)DEFAULT_CONFIG_JS, new OpenOption[0]);
        }
        return ((Object)path).toString();
    }

    @NotNull
    public static final String getSessionsDir() {
        String[] stringArray = new String[]{"sessions"};
        Path path = Paths.get(ServerConstantsKt.getContinueGlobalPath(), stringArray);
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        return ((Object)path).toString();
    }

    @NotNull
    public static final String getSessionsListPath() {
        String[] stringArray = new String[]{"sessions.json"};
        Path path = Paths.get(ServerConstantsKt.getSessionsDir(), stringArray);
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
            Files.writeString(path, (CharSequence)"[]", new OpenOption[0]);
        }
        return ((Object)path).toString();
    }

    @NotNull
    public static final String getSessionFilePath(@NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        String[] stringArray = new String[]{sessionId + ".json"};
        Path path = Paths.get(ServerConstantsKt.getSessionsDir(), stringArray);
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
            Files.writeString(path, (CharSequence)"{}", new OpenOption[0]);
        }
        return ((Object)path).toString();
    }

    @NotNull
    public static final String devDataPath() {
        String[] stringArray = new String[]{"dev_data"};
        Path path = Paths.get(ServerConstantsKt.getContinueGlobalPath(), stringArray);
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        return ((Object)path).toString();
    }

    @NotNull
    public static final String getDevDataFilepath(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        String[] stringArray = new String[]{filename};
        Path path = Paths.get(ServerConstantsKt.devDataPath(), stringArray);
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
        }
        return ((Object)path).toString();
    }

    @NotNull
    public static final String getMigrationsFolderPath() {
        String[] stringArray = new String[]{".migrations"};
        Path path = Paths.get(ServerConstantsKt.getContinueGlobalPath(), stringArray);
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        return ((Object)path).toString();
    }

    public static final void migrate(@NotNull String id, @NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        String migrationsPath = ServerConstantsKt.getMigrationsFolderPath();
        String[] stringArray = new String[]{id};
        String migrationPath = ((Object)Paths.get(migrationsPath, stringArray)).toString();
        File migrationFile = new File(migrationPath);
        if (!migrationFile.exists()) {
            FilesKt.writeText$default((File)migrationFile, (String)"", null, (int)2, null);
            callback.invoke();
        }
    }
}

