/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.autocomplete;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u0014\u0010\u0014\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J,\u0010\u0015\u001a\u00020\u00162\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcn/gitlab/kilo/jetbrains/autocomplete/CockpitMultilineCustomElementRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "text", "", "<init>", "(Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;)V", "font", "Ljava/awt/Font;", "getFont", "()Ljava/awt/Font;", "font$delegate", "Lkotlin/Lazy;", "lines", "", "calcWidthInPixels", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "calcHeightInPixels", "paint", "", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nCockpitMultilineCustomElementRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CockpitMultilineCustomElementRenderer.kt\ncn/gitlab/kilo/jetbrains/autocomplete/CockpitMultilineCustomElementRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1#2:49\n1869#3,2:50\n*S KotlinDebug\n*F\n+ 1 CockpitMultilineCustomElementRenderer.kt\ncn/gitlab/kilo/jetbrains/autocomplete/CockpitMultilineCustomElementRenderer\n*L\n39#1:50,2\n*E\n"})
public final class CockpitMultilineCustomElementRenderer
implements EditorCustomElementRenderer {
    @NotNull
    private final Editor editor;
    @NotNull
    private final String text;
    @NotNull
    private final Lazy font$delegate;
    @NotNull
    private final List<String> lines;

    public CockpitMultilineCustomElementRenderer(@NotNull Editor editor, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.editor = editor;
        this.text = text;
        this.font$delegate = LazyKt.lazy(() -> CockpitMultilineCustomElementRenderer.font_delegate$lambda$0(this));
        this.lines = StringsKt.lines((CharSequence)this.text);
    }

    private final Font getFont() {
        Lazy lazy = this.font$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Font)object;
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Comparable comparable;
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Iterator iterator = ((Iterable)this.lines).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            String it = (String)iterator.next();
            boolean bl = false;
            Editor editor = inlay.getEditor();
            Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
            Comparable comparable2 = Integer.valueOf(((EditorImpl)editor).getFontMetrics(0).stringWidth(it));
            while (iterator.hasNext()) {
                String it2 = (String)iterator.next();
                $i$a$-maxOfOrNull-CockpitMultilineCustomElementRenderer$calcWidthInPixels$1 = false;
                Editor editor2 = inlay.getEditor();
                Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
                Comparable comparable3 = Integer.valueOf(((EditorImpl)editor2).getFontMetrics(0).stringWidth(it2));
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        return n != null ? n : 0;
    }

    public int calcHeightInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Editor editor = inlay.getEditor();
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        return ((EditorImpl)editor).getLineHeight() * this.lines.size();
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        g.setColor((Color)JBColor.GRAY);
        g.setFont(this.getFont());
        int yOffset = 0;
        Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)this.lines, (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            g.drawString(line, targetRegion.x, targetRegion.y + inlay.getEditor().getAscent() + yOffset);
            yOffset += this.editor.getLineHeight();
        }
    }

    private static final Font font_delegate$lambda$0(CockpitMultilineCustomElementRenderer this$0) {
        Font font = this$0.editor.getColorsScheme().getFont(EditorFontType.PLAIN);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        Font editorFont = font;
        return UIUtil.getFontWithFallbackIfNeeded((Font)editorFont, (String)this$0.text).deriveFont(0, this$0.editor.getColorsScheme().getEditorFontSize());
    }
}

