/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.autocomplete;

import cn.gitlab.kilo.jetbrains.autocomplete.AutocompleteEditorListenerKt;
import cn.gitlab.kilo.jetbrains.autocomplete.AutocompleteService;
import cn.gitlab.kilo.jetbrains.autocomplete.AutocompleteServiceKt;
import cn.gitlab.kilo.jetbrains.autocomplete.AutocompleteTrigger;
import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import cn.gitlab.kilo.jetbrains.config.ModelsConfiguration;
import cn.gitlab.kilo.jetbrains.services.CoderiderTrackClient;
import cn.gitlab.kilo.jetbrains.utils.UpdateFileSilentUtilsKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.lang.invoke.LambdaMetafactory;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcn/gitlab/kilo/jetbrains/autocomplete/AutocompleteDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "editorManager", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/fileEditor/FileEditorManager;Lcom/intellij/openapi/editor/Editor;)V", "logger", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "recordHumanChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "documentChanged", "coderider-kilo-jetbrains"})
public final class AutocompleteDocumentListener
implements DocumentListener {
    @NotNull
    private final FileEditorManager editorManager;
    @NotNull
    private final Editor editor;
    @NotNull
    private final Logger logger;

    public AutocompleteDocumentListener(@NotNull FileEditorManager editorManager, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editorManager, (String)"editorManager");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editorManager = editorManager;
        this.editor = editor;
        this.logger = Logger.Companion.getInstance(AutocompleteDocumentListener.class);
    }

    private final void recordHumanChanged(DocumentEvent event2) {
        block3: {
            block5: {
                block4: {
                    if (!CockpitConfiguration.Companion.getInstance().isLogin() || this.editor.getVirtualFile() == null) break block3;
                    if (UpdateFileSilentUtilsKt.isProgrammaticChange().booleanValue()) break block4;
                    Document document = event2.getDocument();
                    DocumentEx documentEx = document instanceof DocumentEx ? (DocumentEx)document : null;
                    boolean bl = documentEx != null ? documentEx.isInBulkUpdate() : false;
                    if (!bl) break block5;
                }
                return;
            }
            AutocompleteEditorListenerKt.updateTotalBytesChanged(((Object)event2.getNewFragment()).toString(), true);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void documentChanged(@NotNull DocumentEvent event) {
        block15: {
            block17: {
                block19: {
                    block18: {
                        block16: {
                            block14: {
                                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                                this.recordHumanChanged(event);
                                if (!Intrinsics.areEqual((Object)this.editor, (Object)this.editorManager.getSelectedTextEditor())) {
                                    return;
                                }
                                v0 = this.editor.getProject();
                                if (v0 == null) {
                                    return;
                                }
                                project = v0;
                                v1 = AutocompleteServiceKt.getAutocompleteService(this.editor);
                                if (v1 == null) {
                                    return;
                                }
                                autocompleteService = v1;
                                if (autocompleteService.getLastChangeWasPartialAccept()) {
                                    return;
                                }
                                v2 = (PsiFile)ActionsKt.runReadAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, documentChanged$lambda$0(com.intellij.openapi.project.Project cn.gitlab.kilo.jetbrains.autocomplete.AutocompleteDocumentListener ), ()Lcom/intellij/psi/PsiFile;)((Project)project, (AutocompleteDocumentListener)this));
                                if (v2 == null) {
                                    return;
                                }
                                psiFile = v2;
                                pending = autocompleteService.getPendingCompletion();
                                line = this.editor.getDocument().getLineNumber(this.editor.getCaretModel().getOffset());
                                v3 = event.getNewFragment();
                                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getNewFragment(...)");
                                newFragment = v3;
                                bracketRegex = new Regex("[(\\[{\"')\\]}]");
                                if (UpdateFileSilentUtilsKt.isProgrammaticChange().booleanValue()) ** GOTO lbl-1000
                                var11_9 = event.getDocument();
                                v4 = var11_9 instanceof DocumentEx != false ? (DocumentEx)var11_9 : null;
                                if (!(v4 != null ? v4.isInBulkUpdate() : false)) {
                                    v5 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v5 = false;
                                }
                                isUserChange = v5;
                                if (pending != null) break block14;
                                if (isUserChange) {
                                    AutocompleteTrigger.launchAutoCompletion$default(AutocompleteTrigger.INSTANCE, this.editor, false, 2, null);
                                }
                                break block15;
                            }
                            if (pending.getCaretLineNumber() == line && !bracketRegex.containsMatchIn(newFragment)) break block16;
                            ApplicationManager.getApplication().runWriteAction((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, documentChanged$lambda$1(cn.gitlab.kilo.jetbrains.autocomplete.AutocompleteService cn.gitlab.kilo.jetbrains.autocomplete.AutocompleteDocumentListener ), ()V)((AutocompleteService)autocompleteService, (AutocompleteDocumentListener)this));
                            break block15;
                        }
                        if (!(newFragment.length() > 0)) break block17;
                        v6 = pending.getText();
                        v7 = v6 != null ? StringsKt.startsWith$default((CharSequence)v6, (CharSequence)newFragment, (boolean)false, (int)2, null) : false;
                        if (!v7 || Intrinsics.areEqual((Object)pending.getText(), (Object)newFragment.toString())) break block17;
                        pending.setOffset(pending.getOffset() + newFragment.length());
                        pendingText = pending.getText();
                        v8 = pending.getText();
                        if (v8 == null) break block18;
                        v9 = v8.substring(newFragment.length());
                        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"substring(...)");
                        v8 = v9;
                        if (v9 != null) break block19;
                    }
                    v8 = "";
                }
                pending.setText(v8);
                autocompleteService.refreshPending();
                if (!pending.getAdopted()) {
                    v10 = pendingText;
                    CoderiderTrackClient.INSTANCE.recordCodeCompletionAdopted(pending.getCompletionLines(), ModelsConfiguration.Companion.getInstance().getCurrentCodeModel(), pending.getLanguage(), v10 != null ? Integer.valueOf(v10.length()) : null);
                    pending.setAdopted(true);
                }
                break block15;
            }
            if (isUserChange) {
                AutocompleteTrigger.launchAutoCompletion$default(AutocompleteTrigger.INSTANCE, this.editor, false, 2, null);
            }
        }
    }

    private static final PsiFile documentChanged$lambda$0(Project $project, AutocompleteDocumentListener this$0) {
        return PsiDocumentManager.getInstance((Project)$project).getPsiFile(this$0.editor.getDocument());
    }

    private static final void documentChanged$lambda$1(AutocompleteService $autocompleteService, AutocompleteDocumentListener this$0) {
        $autocompleteService.cleanCompletions(this$0.editor);
    }
}

